/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts;

import com.sas.codepolicy.SASScope;
import com.sas.prompts.AttributeDependencyInterface;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.el.ELEvaluator;
import com.sas.prompts.simplesqlmodel.PromptValueOperand;
import com.sas.prompts.util.CDATA;
import com.sas.storage.simplesqlmodel.ValueOperandV2Interface;
import com.sas.util.transforms.BooleanNotTransform;
import com.sas.util.transforms.NumberToBooleanTransform;
import com.sas.util.transforms.StringToIntegerTransform;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.RelatedObjectListsHolder;
import com.sas.util.xmlpersist.XmlUtil;
import com.sas.util.xmlpersist.impl.AbstractPersistence;
import java.util.ArrayList;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@SASScope
public class AttributeDependency
extends AbstractPersistence
implements AttributeDependencyInterface {
    public static String TRANSFORM_SEPARATOR = ":";
    public static String TRANSFORM_INTEGER_TO_BOOLEAN = "INT_TO_BOOL";
    public static String TRANSFORM_STRING_TO_INTEGER = "STRING_TO_INT";
    public static String TRANSFORM_BOOLEAN_NOT = "BOOL_NOT";
    private static final long serialVersionUID = -5247695840496569996L;
    private PromptDefinitionInterface prompt;
    private String attributeName;
    private String transformName;
    private String condition;
    private ValueOperandV2Interface valueOperandOrExpression;
    private ValueOperandV2Interface elseValueOperandOrExpression;
    private ELEvaluator elEvaluator;

    public AttributeDependency() {
    }

    public AttributeDependency(PromptDefinitionInterface prompt, String attributeName) {
        this(prompt, attributeName, null);
    }

    public AttributeDependency(PromptDefinitionInterface prompt, String attributeName, String transformName) {
        this.prompt = prompt;
        this.attributeName = attributeName;
        this.transformName = transformName;
    }

    @Override
    public PromptDefinitionInterface getPromptAttributeIsDependentOn() {
        return this.prompt;
    }

    @Override
    public String getPromptAttributeName() {
        return this.attributeName;
    }

    public String getTransformName() {
        return this.transformName;
    }

    @Override
    public Object transformAttributeValue(Object value) {
        if (this.transformName != null) {
            String[] temp = this.transformName.split(TRANSFORM_SEPARATOR);
            for (int i = 0; i < temp.length; ++i) {
                String currentTransform = temp[i];
                if (currentTransform.equals(TRANSFORM_INTEGER_TO_BOOLEAN)) {
                    value = NumberToBooleanTransform.defaultInstance.transform(value);
                    continue;
                }
                if (currentTransform.equals(TRANSFORM_STRING_TO_INTEGER)) {
                    value = StringToIntegerTransform.defaultInstance.transform(value);
                    continue;
                }
                if (!currentTransform.equals(TRANSFORM_BOOLEAN_NOT)) continue;
                value = BooleanNotTransform.defaultInstance.transform(value);
            }
        }
        return value;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    @Override
    public boolean isConditionMet(PromptValuesInterface promptValues) {
        if (this.condition == null) {
            return true;
        }
        if (this.elEvaluator == null) {
            this.elEvaluator = new ELEvaluator();
        }
        boolean retVal = this.elEvaluator.evaluateBooleanExpression(promptValues, this.condition.trim());
        return retVal;
    }

    @Override
    public ValueOperandV2Interface getValueOperand() {
        if (this.valueOperandOrExpression != null) {
            return this.valueOperandOrExpression;
        }
        return new PromptValueOperand(this.prompt);
    }

    public void setValueOperand(ValueOperandV2Interface operand) {
        this.valueOperandOrExpression = operand;
    }

    @Override
    public ValueOperandV2Interface getElseValueOperand() {
        if (this.elseValueOperandOrExpression != null) {
            return this.elseValueOperandOrExpression;
        }
        return null;
    }

    public void setElseValueOperand(ValueOperandV2Interface operand) {
        this.elseValueOperandOrExpression = operand;
    }

    public void consumeAttributes(AttributesProvider provider) {
        super.consumeAttributes(provider);
        this.attributeName = provider.consumeAttr("name");
        this.transformName = provider.consumeAttr("transformName");
    }

    public void consumeRelatedObjects(RelatedObjectListsHolder roHolder) throws SAXException {
        super.consumeRelatedObjects(roHolder);
        ArrayList list = roHolder.consumeObjects("PromptAttributeIsDependentOn");
        if (list != null && list.size() > 0) {
            this.prompt = (PromptDefinitionInterface)list.get(0);
        }
        if ((list = roHolder.consumeObjects("Condition")) != null && list.size() > 0) {
            CDATA cdata = (CDATA)list.get(0);
            this.setCondition(cdata.getText());
        }
        if ((list = roHolder.consumeObjects("ValueOperand")) != null && list.size() > 0) {
            this.setValueOperand((ValueOperandV2Interface)list.get(0));
        }
        if ((list = roHolder.consumeObjects("ElseValueOperand")) != null && list.size() > 0) {
            this.setElseValueOperand((ValueOperandV2Interface)list.get(0));
        }
    }

    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        ArrayList<PromptDefinitionInterface> relatedObjects;
        super.writeDefinition(element, writingContext);
        XmlUtil.setAttr((Element)element, (String)"name", (String)this.attributeName);
        XmlUtil.setAttr((Element)element, (String)"transformName", (String)this.transformName);
        if (this.getPromptAttributeIsDependentOn() != null) {
            relatedObjects = new ArrayList<PromptDefinitionInterface>(1);
            relatedObjects.add(this.getPromptAttributeIsDependentOn());
            AttributeDependency.writeRelatedObjects(relatedObjects, (Node)element, (PromptsWritingContext)writingContext, (String)"PromptAttributeIsDependentOn");
        }
        if (this.getCondition() != null && this.getCondition().length() > 0) {
            relatedObjects = new ArrayList(1);
            CDATA cdata = new CDATA();
            cdata.setText(this.getCondition());
            relatedObjects.add((PromptDefinitionInterface)cdata);
            AttributeDependency.writeRelatedObjects(relatedObjects, (Node)element, (PromptsWritingContext)writingContext, (String)"Condition");
        }
        if (!(this.valueOperandOrExpression == null || this.valueOperandOrExpression instanceof PromptValueOperand && ((PromptValueOperand)this.valueOperandOrExpression).getPromptDefinition() == this.prompt)) {
            relatedObjects = new ArrayList(1);
            relatedObjects.add((PromptDefinitionInterface)this.valueOperandOrExpression);
            AttributeDependency.writeRelatedObjects(relatedObjects, (Node)element, (PromptsWritingContext)writingContext, (String)"ValueOperand");
        }
        if (this.elseValueOperandOrExpression != null) {
            relatedObjects = new ArrayList(1);
            relatedObjects.add((PromptDefinitionInterface)this.elseValueOperandOrExpression);
            AttributeDependency.writeRelatedObjects(relatedObjects, (Node)element, (PromptsWritingContext)writingContext, (String)"ElseValueOperand");
        }
    }

    public String getDefinitionElementName() {
        return "AttributeDependency";
    }
}

