/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.axiom;

import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.springframework.ws.soap.SoapHeader;
import org.springframework.ws.soap.SoapHeaderElement;
import org.springframework.ws.soap.SoapHeaderException;
import org.springframework.ws.soap.axiom.AxiomSoapElement;
import org.springframework.ws.soap.axiom.AxiomSoapHeaderElement;
import org.springframework.ws.soap.axiom.AxiomSoapHeaderException;

abstract class AxiomSoapHeader
extends AxiomSoapElement
implements SoapHeader {
    AxiomSoapHeader(SOAPHeader axiomHeader, SOAPFactory axiomFactory) {
        super((OMElement)axiomHeader, axiomFactory);
    }

    public Result getResult() {
        return this.getAxiomHeader().getSAXResult();
    }

    public SoapHeaderElement addHeaderElement(QName name) {
        try {
            OMNamespace namespace = this.getAxiomFactory().createOMNamespace(name.getNamespaceURI(), name.getPrefix());
            SOAPHeaderBlock axiomHeaderBlock = this.getAxiomHeader().addHeaderBlock(name.getLocalPart(), namespace);
            return new AxiomSoapHeaderElement((OMElement)axiomHeaderBlock, this.getAxiomFactory());
        }
        catch (OMException ex) {
            throw new AxiomSoapHeaderException(ex);
        }
    }

    public void removeHeaderElement(QName name) throws SoapHeaderException {
        try {
            OMElement element = this.getAxiomHeader().getFirstChildWithName(name);
            if (element != null) {
                element.detach();
            }
        }
        catch (OMException ex) {
            throw new AxiomSoapHeaderException(ex);
        }
    }

    public Iterator<SoapHeaderElement> examineMustUnderstandHeaderElements(String role) {
        try {
            return new AxiomSoapHeaderElementIterator(this.getAxiomHeader().examineMustUnderstandHeaderBlocks(role));
        }
        catch (OMException ex) {
            throw new AxiomSoapHeaderException(ex);
        }
    }

    public Iterator<SoapHeaderElement> examineAllHeaderElements() {
        try {
            return new AxiomSoapHeaderElementIterator(this.getAxiomHeader().examineAllHeaderBlocks());
        }
        catch (OMException ex) {
            throw new AxiomSoapHeaderException(ex);
        }
    }

    public Iterator<SoapHeaderElement> examineHeaderElements(QName name) throws SoapHeaderException {
        try {
            return new AxiomSoapHeaderElementIterator(this.getAxiomHeader().getChildrenWithName(name));
        }
        catch (OMException ex) {
            throw new AxiomSoapHeaderException(ex);
        }
    }

    protected SOAPHeader getAxiomHeader() {
        return (SOAPHeader)this.getAxiomElement();
    }

    protected class AxiomSoapHeaderElementIterator
    implements Iterator<SoapHeaderElement> {
        private final Iterator<? extends OMElement> axiomIterator;

        protected AxiomSoapHeaderElementIterator(Iterator<? extends OMElement> axiomIterator) {
            this.axiomIterator = axiomIterator;
        }

        @Override
        public boolean hasNext() {
            return this.axiomIterator.hasNext();
        }

        @Override
        public SoapHeaderElement next() {
            try {
                OMElement axiomHeaderBlock = this.axiomIterator.next();
                return new AxiomSoapHeaderElement(axiomHeaderBlock, AxiomSoapHeader.this.getAxiomFactory());
            }
            catch (OMException ex) {
                throw new AxiomSoapHeaderException(ex);
            }
        }

        @Override
        public void remove() {
            this.axiomIterator.remove();
        }
    }
}

