/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.axiom;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.om.ds.ByteArrayDataSource;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPFactory;
import org.springframework.util.xml.StaxUtils;
import org.springframework.ws.soap.axiom.AxiomAbstractPayload;

class Axiom12NonCachingPayload
extends AxiomAbstractPayload {
    private static final int BUF_SIZE = 1024;

    Axiom12NonCachingPayload(SOAPBody axiomBody, SOAPFactory axiomFactory) {
        super(axiomBody, axiomFactory);
    }

    @Override
    public Result getResultInternal() {
        return StaxUtils.createCustomStaxResult((XMLStreamWriter)new DelegatingStreamWriter());
    }

    @Override
    protected XMLStreamReader getStreamReader(OMElement payloadElement) {
        return payloadElement.getXMLStreamReaderWithoutCaching();
    }

    private class DelegatingStreamWriter
    implements XMLStreamWriter {
        private final ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        private final XMLStreamWriter delegate;
        private QName name;
        private String encoding = "UTF-8";
        private int elementDepth = 0;
        private boolean payloadAdded = false;

        private DelegatingStreamWriter() {
            try {
                this.delegate = StAXUtils.createXMLStreamWriter((OutputStream)this.baos);
            }
            catch (XMLStreamException ex) {
                throw new RuntimeException("Could not determine payload root element", ex);
            }
        }

        @Override
        public void writeStartDocument() throws XMLStreamException {
        }

        @Override
        public void writeStartDocument(String version) throws XMLStreamException {
        }

        @Override
        public void writeStartDocument(String encoding, String version) throws XMLStreamException {
            this.encoding = encoding;
        }

        @Override
        public void writeStartElement(String localName) throws XMLStreamException {
            if (this.name == null) {
                this.name = new QName(localName);
            }
            ++this.elementDepth;
            this.delegate.writeStartElement(localName);
        }

        @Override
        public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
            if (this.name == null) {
                this.name = new QName(namespaceURI, localName);
            }
            ++this.elementDepth;
            this.delegate.writeStartElement(namespaceURI, localName);
        }

        @Override
        public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
            if (this.name == null) {
                this.name = new QName(namespaceURI, localName, prefix);
            }
            ++this.elementDepth;
            this.delegate.writeStartElement(prefix, localName, namespaceURI);
        }

        @Override
        public void writeEndElement() throws XMLStreamException {
            --this.elementDepth;
            this.delegate.writeEndElement();
            this.addPayload();
        }

        private void addPayload() throws XMLStreamException {
            if (this.elementDepth <= 0 && !this.payloadAdded) {
                this.delegate.flush();
                if (this.baos.size() > 0) {
                    byte[] buf = this.baos.toByteArray();
                    ByteArrayDataSource dataSource = new ByteArrayDataSource(buf, this.encoding);
                    OMNamespace namespace = Axiom12NonCachingPayload.this.getAxiomFactory().createOMNamespace(this.name.getNamespaceURI(), this.name.getPrefix());
                    OMSourcedElement payloadElement = Axiom12NonCachingPayload.this.getAxiomFactory().createOMElement((OMDataSource)dataSource, this.name.getLocalPart(), namespace);
                    Axiom12NonCachingPayload.this.getAxiomBody().addChild((OMNode)payloadElement);
                    this.payloadAdded = true;
                }
            }
        }

        @Override
        public void writeEmptyElement(String localName) throws XMLStreamException {
            if (this.name == null) {
                this.name = new QName(localName);
            }
            this.delegate.writeEmptyElement(localName);
            this.addPayload();
        }

        @Override
        public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
            if (this.name == null) {
                this.name = new QName(namespaceURI, localName);
            }
            this.delegate.writeEmptyElement(namespaceURI, localName);
            this.addPayload();
        }

        @Override
        public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
            if (this.name == null) {
                this.name = new QName(namespaceURI, localName, prefix);
            }
            this.delegate.writeEmptyElement(prefix, localName, namespaceURI);
            this.addPayload();
        }

        @Override
        public void writeEndDocument() throws XMLStreamException {
            this.elementDepth = 0;
            this.delegate.writeEndDocument();
            this.addPayload();
        }

        @Override
        public void close() throws XMLStreamException {
            this.addPayload();
            this.delegate.close();
        }

        @Override
        public void flush() throws XMLStreamException {
            this.delegate.flush();
        }

        @Override
        public NamespaceContext getNamespaceContext() {
            return this.delegate.getNamespaceContext();
        }

        @Override
        public String getPrefix(String uri) throws XMLStreamException {
            return this.delegate.getPrefix(uri);
        }

        @Override
        public Object getProperty(String name) throws IllegalArgumentException {
            return this.delegate.getProperty(name);
        }

        @Override
        public void setDefaultNamespace(String uri) throws XMLStreamException {
            this.delegate.setDefaultNamespace(uri);
        }

        @Override
        public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
            this.delegate.setNamespaceContext(context);
        }

        @Override
        public void setPrefix(String prefix, String uri) throws XMLStreamException {
            this.delegate.setPrefix(prefix, uri);
        }

        @Override
        public void writeAttribute(String localName, String value) throws XMLStreamException {
            this.delegate.writeAttribute(localName, value);
        }

        @Override
        public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
            this.delegate.writeAttribute(namespaceURI, localName, value);
        }

        @Override
        public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
            this.delegate.writeAttribute(prefix, namespaceURI, localName, value);
        }

        @Override
        public void writeCData(String data) throws XMLStreamException {
            this.delegate.writeCData(data);
        }

        @Override
        public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
            this.delegate.writeCharacters(text, start, len);
        }

        @Override
        public void writeCharacters(String text) throws XMLStreamException {
            this.delegate.writeCharacters(text);
        }

        @Override
        public void writeComment(String data) throws XMLStreamException {
            this.delegate.writeComment(data);
        }

        @Override
        public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
            this.delegate.writeDefaultNamespace(namespaceURI);
        }

        @Override
        public void writeDTD(String dtd) throws XMLStreamException {
            this.delegate.writeDTD(dtd);
        }

        @Override
        public void writeEntityRef(String name) throws XMLStreamException {
            this.delegate.writeEntityRef(name);
        }

        @Override
        public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
            this.delegate.writeNamespace(prefix, namespaceURI);
        }

        @Override
        public void writeProcessingInstruction(String target) throws XMLStreamException {
            this.delegate.writeProcessingInstruction(target);
        }

        @Override
        public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
            this.delegate.writeProcessingInstruction(target, data);
        }
    }
}

