/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.webdav.tools;

import com.sas.services.webdav.tools.RB;
import com.sas.text.Message;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.TextAttribute;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.AttributedString;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DOMTree
extends JTree {
    private static final long serialVersionUID = 3616728283719481398L;
    private ImageIcon plusImage = new ImageIcon(this.getClass().getClassLoader().getResource("com/sas/services/webdav/tools/treeplus.gif"));
    private ImageIcon minusImage = new ImageIcon(this.getClass().getClassLoader().getResource("com/sas/services/webdav/tools/treeminus.gif"));
    private static JFrame frame;
    private Hashtable prefixes = new Hashtable();
    private boolean _showDetails = false;
    static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    static final String outputEncoding = "UTF-8";
    private static final int FRAME_WIDTH = 720;
    private static final int FRAME_HEIGHT = 580;
    private static int treeIndent;
    private static final Color COLOR_FRAME_BACKGROUND;
    private static final Color COLOR_DELIMITER;
    private static final Color COLOR_TEXT;
    private static final Color COLOR_NAME;
    private static final Color COLOR_DEFAULT;
    private static final Color COLOR_NS;
    private static final Font FONT_DEFAULT;
    private static final Font FONT_DEFAULT_BOLD;

    public DOMTree() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.getSelectionModel().setSelectionMode(1);
        this.setShowsRootHandles(false);
        this.putClientProperty("JTree.lineStyle", "None");
        CustomBasicRenderer btcr = new CustomBasicRenderer();
        this.setCellRenderer(btcr);
        BasicTreeUI basicTreeUI = (BasicTreeUI)this.getUI();
        basicTreeUI.setLeftChildIndent(15);
        basicTreeUI.setRightChildIndent(0);
        basicTreeUI.setExpandedIcon(this.minusImage);
        basicTreeUI.setCollapsedIcon(this.plusImage);
        treeIndent = basicTreeUI.getRightChildIndent() + basicTreeUI.getLeftChildIndent();
        treeIndent = 15;
        this.setEditable(false);
    }

    public DOMTree(Node root, boolean showDetails) {
        this();
        this._showDetails = showDetails;
        this.setRoot(root);
    }

    public DOMTree(InputStream is) {
        this();
        this._showDetails = false;
        this.setRoot(this.parseXML(is));
    }

    public void setRoot(Node root) {
        this.prefixes.clear();
        DefaultMutableTreeNode top = this.createTreeNode(root, this._showDetails);
        Iterator items = this.prefixes.entrySet().iterator();
        String nsString = "";
        while (items.hasNext()) {
            Map.Entry me = items.next();
            nsString = " xmlns:" + me.getKey() + "=\"" + me.getValue() + "\" " + nsString;
        }
        AttributedText at = new AttributedText(FONT_DEFAULT, COLOR_DEFAULT);
        at.setText(this.getNodeType(root) + ": " + nsString);
        top.setUserObject(at);
        DefaultTreeModel dtModel = new DefaultTreeModel(top);
        this.setModel(dtModel);
    }

    protected DefaultMutableTreeNode createTreeNode(Node root, boolean showDetails) {
        NodeList childNodes;
        DefaultMutableTreeNode dmtNode = null;
        String type = this.getNodeType(root);
        String name = root.getNodeName();
        String value = root.getNodeValue();
        boolean elementFinished = false;
        AttributedText at = new AttributedText(FONT_DEFAULT, COLOR_DEFAULT);
        if (showDetails) {
            at.setText('[' + type + "] --> " + name + " = " + value);
        } else {
            if (root instanceof Element) {
                String prefix = root.getPrefix();
                String ns = root.getNamespaceURI();
                String localName = root.getLocalName();
                if (prefix != null && ns != null) {
                    String usedNS = (String)this.prefixes.get(prefix);
                    if (usedNS == null) {
                        this.prefixes.put(prefix, ns);
                        at.setText("<", COLOR_DELIMITER);
                        at.addText(name, COLOR_NAME);
                    } else {
                        at.setText("<", COLOR_DELIMITER);
                        at.addText(prefix + ':' + localName, COLOR_NAME);
                    }
                } else {
                    at.setText("<", COLOR_DELIMITER);
                    at.addText(name, COLOR_NAME);
                }
            } else {
                at.setText(root.getNodeType() == 3 ? value : name, COLOR_NAME);
            }
            if (root instanceof Document) {
                at.setText("<?xml version=\"1.0\" ?>");
            }
            if (root instanceof Comment) {
                at.setText("<!--" + ((Comment)root).getData() + "-->");
            }
        }
        NamedNodeMap attribs = root.getAttributes();
        if (attribs != null) {
            for (int i = 0; i < attribs.getLength(); ++i) {
                Node attNode = attribs.item(i);
                String attName = attNode.getNodeName().trim();
                String attValue = attNode.getNodeValue().trim();
                if (attValue == null || attValue.length() <= 0) continue;
                if (attName.startsWith("xmlns")) {
                    at.addText(' ' + attName, COLOR_NS);
                } else {
                    at.addText(' ' + attName, COLOR_NAME);
                }
                at.addText("=\"", COLOR_DELIMITER);
                if (attName.startsWith("xmlns")) {
                    at.addText(attValue, COLOR_NS, FONT_DEFAULT_BOLD);
                } else {
                    at.addText(attValue, COLOR_TEXT, FONT_DEFAULT_BOLD);
                }
                at.addText("\"", COLOR_DELIMITER);
            }
        }
        elementFinished = false;
        if (root instanceof Element) {
            if (root.hasChildNodes()) {
                at.addText(">", COLOR_DELIMITER);
                if (root.getFirstChild() == root.getLastChild() && root.getFirstChild() instanceof Text) {
                    at.addText(root.getFirstChild().getNodeValue(), COLOR_TEXT, FONT_DEFAULT_BOLD);
                    at.addText("</", COLOR_DELIMITER);
                    at.addText(name, COLOR_NAME);
                    at.addText(">", COLOR_DELIMITER);
                    elementFinished = true;
                }
            } else {
                at.addText("/>", COLOR_DELIMITER);
                elementFinished = true;
            }
        }
        dmtNode = new DefaultMutableTreeNode();
        dmtNode.setUserObject(at);
        if (!elementFinished && root.hasChildNodes() && (childNodes = root.getChildNodes()) != null) {
            for (int k = 0; k < childNodes.getLength(); ++k) {
                String data;
                Node nd = childNodes.item(k);
                if (nd == null) continue;
                if (nd.getNodeType() == 1) {
                    dmtNode.add(this.createTreeNode(nd, showDetails));
                }
                if (nd.getNodeType() == 8 || (data = nd.getNodeValue()) == null || (data = data.trim()).equals("\n") || data.equals("\r\n") || data.length() <= 0) continue;
                dmtNode.add(this.createTreeNode(nd, showDetails));
            }
            if (root.getNodeType() == 1) {
                at = new AttributedText(FONT_DEFAULT, COLOR_DEFAULT);
                at.setText("</", COLOR_DELIMITER);
                at.addText(root.getNodeName(), COLOR_NAME);
                at.addText(">", COLOR_DELIMITER);
                dmtNode.add(new DefaultMutableTreeNode(at));
            }
        }
        return dmtNode;
    }

    public String getNodeType(Node node) {
        String type;
        switch (node.getNodeType()) {
            case 1: {
                type = "Element";
                break;
            }
            case 2: {
                type = "Attribute";
                break;
            }
            case 3: {
                type = "Text";
                break;
            }
            case 4: {
                type = "CData section";
                break;
            }
            case 5: {
                type = "Entity reference";
                break;
            }
            case 6: {
                type = "Entity";
                break;
            }
            case 7: {
                type = "Processing instruction";
                break;
            }
            case 8: {
                type = "Comment";
                break;
            }
            case 9: {
                type = "Document";
                break;
            }
            case 10: {
                type = "Document type";
                break;
            }
            case 11: {
                type = "Document fragment";
                break;
            }
            case 12: {
                type = "Notation";
                break;
            }
            default: {
                type = "Unknown, contact Sun!";
            }
        }
        return type;
    }

    private static void exit() {
        System.exit(0);
    }

    public static void helpInfo() {
        System.out.println(RB.getStringResource("DOMTree.cmd1.txt"));
        System.out.println(RB.getStringResource("DOMTree.cmd2.txt"));
        System.out.println(RB.getStringResource("DOMTree.cmd3.txt"));
        System.out.println(RB.getStringResource("DOMTree.cmd4.txt"));
        System.exit(8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        String schemaFile = null;
        String xmlFile = null;
        DOMTree tree = null;
        boolean validate = false;
        if (args.length < 1) {
            DOMTree.helpInfo();
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-xsd")) {
                validate = true;
                continue;
            }
            if (args[i].equals("-xsdf")) {
                if (i == args.length - 1) {
                    DOMTree.helpInfo();
                }
                validate = true;
                schemaFile = args[++i];
                continue;
            }
            xmlFile = args[i];
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        if (validate) {
            dbf.setValidating(true);
            try {
                dbf.setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
            }
            catch (IllegalArgumentException x) {
                System.err.println(Message.format((ResourceBundle)RB.getResources(), (String)"DOMTree.dbattrerr1.fmt.txt", (Object)JAXP_SCHEMA_LANGUAGE));
                System.err.println(RB.getStringResource("DOMTree.dbattrerr2.txt"));
                System.exit(1);
            }
        }
        if (schemaFile != null) {
            dbf.setAttribute(JAXP_SCHEMA_SOURCE, new File(schemaFile));
        }
        DocumentBuilder db = dbf.newDocumentBuilder();
        OutputStreamWriter errorWriter = new OutputStreamWriter((OutputStream)System.err, outputEncoding);
        db.setErrorHandler(new MyErrorHandler(new PrintWriter((Writer)errorWriter, true)));
        try {
            if (xmlFile != null) {
                Document doc = db.parse(new FileInputStream(xmlFile));
                tree = new DOMTree(doc, false);
            } else {
                System.out.println(RB.getStringResource("DOMTree.filenotexist.txt"));
            }
        }
        finally {
            if (errorWriter != null) {
                try {
                    errorWriter.close();
                }
                catch (IOException doc) {}
            }
        }
        frame = new JFrame(RB.getStringResource("DOMTree.application.txt"));
        JScrollPane jScroll = new JScrollPane(tree){
            private static final long serialVersionUID = 3762534533580403249L;

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(frame.getWidth() - 20, frame.getHeight() - 40);
            }
        };
        frame.getContentPane().add(jScroll);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dim = toolkit.getScreenSize();
        int screenHeight = dim.height;
        int screenWidth = dim.width;
        frame.setBounds((screenWidth - 720) / 2, (screenHeight - 580) / 2, 720, 580);
        WindowAdapter wndCloser = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DOMTree.exit();
            }
        };
        frame.addWindowListener(wndCloser);
        frame.validate();
        frame.setVisible(true);
    }

    private Document parseXML(InputStream is) {
        Document document = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.parse(is);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return document;
    }

    static {
        COLOR_FRAME_BACKGROUND = new Color(220, 240, 255);
        COLOR_DELIMITER = Color.BLUE;
        COLOR_TEXT = Color.BLACK;
        COLOR_NAME = new Color(153, 0, 0);
        COLOR_DEFAULT = Color.BLUE;
        COLOR_NS = Color.RED;
        FONT_DEFAULT = new Font("SanSerif", 0, 11);
        FONT_DEFAULT_BOLD = new Font("SanSerif", 1, 11);
    }

    protected class CustomBasicRenderer
    implements TreeCellRenderer {
        protected CustomBasicRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            AttributedText at = null;
            Object o = ((DefaultMutableTreeNode)value).getUserObject();
            if (!(o instanceof AttributedText)) {
                at = new AttributedText(FONT_DEFAULT, COLOR_DEFAULT);
                at.setText(o.toString());
            } else {
                at = (AttributedText)o;
            }
            at.setIsLeaf(leaf);
            MyTreeLabel c = new MyTreeLabel(at);
            ((Component)c).setBackground(COLOR_FRAME_BACKGROUND);
            if (c instanceof JLabel) {
                JLabel l = c;
                l.setHorizontalAlignment(2);
                l.setVerticalAlignment(0);
                l.setVerticalTextPosition(0);
                l.setHorizontalTextPosition(2);
                int type = 0;
                l.setFont(new Font("SanSerif", type, 11));
            }
            return c;
        }
    }

    public class AttributedText {
        private Font defaultFont = null;
        private Color defaultColor = null;
        private StringBuffer text = new StringBuffer();
        private Vector colorAttr = new Vector(40);
        private Vector fontAttr = new Vector(40);
        private boolean isLeaf = false;

        public AttributedText() {
        }

        public AttributedText(Font font, Color color) {
            this.defaultFont = font;
            this.defaultColor = color;
        }

        public void addText(String str) {
            this.text.append(str);
            for (int i = 0; i < str.length(); ++i) {
                this.colorAttr.add(null);
                this.fontAttr.add(null);
            }
        }

        public void addText(String str, Color color) {
            this.text.append(str);
            for (int i = 0; i < str.length(); ++i) {
                this.colorAttr.add(color);
                this.fontAttr.add(null);
            }
        }

        public void addText(String str, Color color, Font font) {
            this.text.append(str);
            for (int i = 0; i < str.length(); ++i) {
                this.colorAttr.add(color);
                this.fontAttr.add(font);
            }
        }

        public void setText(String str) {
            this.text.setLength(0);
            this.colorAttr.setSize(0);
            this.text.append(str);
            for (int i = 0; i < str.length(); ++i) {
                this.colorAttr.add(null);
                this.fontAttr.add(null);
            }
        }

        public void setText(String str, Color color) {
            this.text.setLength(0);
            this.colorAttr.setSize(0);
            this.text.append(str);
            for (int i = 0; i < str.length(); ++i) {
                this.colorAttr.add(color);
                this.fontAttr.add(null);
            }
        }

        public void setText(String str, Color color, Font font) {
            this.text.setLength(0);
            this.colorAttr.setSize(0);
            this.text.append(str);
            for (int i = 0; i < str.length(); ++i) {
                this.colorAttr.add(color);
                this.fontAttr.add(font);
            }
        }

        public boolean isClosingElement() {
            String s = this.text.toString();
            return s.startsWith("</");
        }

        public void setIsLeaf(boolean isLeaf) {
            this.isLeaf = isLeaf;
        }

        public boolean isLeaf() {
            return this.isLeaf;
        }

        public AttributedString getAttributedString() {
            AttributedString as = new AttributedString(this.text.toString());
            as.addAttribute(TextAttribute.FONT, this.defaultFont);
            as.addAttribute(TextAttribute.FOREGROUND, this.defaultColor);
            Color lastColor = null;
            Font lastFont = null;
            int lastColorIndex = 0;
            int lastFontIndex = 0;
            for (int i = 0; i < this.text.length(); ++i) {
                if (this.colorAttr.get(i) != lastColor) {
                    if (i > 0 && lastColor != null) {
                        as.addAttribute(TextAttribute.FOREGROUND, lastColor, lastColorIndex, i);
                    }
                    lastColorIndex = i;
                    lastColor = (Color)this.colorAttr.get(i);
                }
                if (this.fontAttr.get(i) == lastFont) continue;
                if (i > 0 && lastFont != null) {
                    as.addAttribute(TextAttribute.FONT, lastFont, lastFontIndex, i);
                }
                lastFontIndex = i;
                lastFont = (Font)this.fontAttr.get(i);
            }
            if (lastColor != null && lastColorIndex < this.text.length()) {
                as.addAttribute(TextAttribute.FOREGROUND, lastColor, lastColorIndex, this.text.length());
            }
            if (lastFont != null && lastFontIndex < this.text.length()) {
                as.addAttribute(TextAttribute.FONT, lastFont, lastFontIndex, this.text.length());
            }
            return as;
        }
    }

    private static class MyErrorHandler
    implements ErrorHandler {
        private PrintWriter out;

        MyErrorHandler(PrintWriter out) {
            this.out = out;
        }

        private String getParseExceptionInfo(SAXParseException spe) {
            String systemId = spe.getSystemId();
            if (systemId == null) {
                systemId = "null";
            }
            String info = Message.format((ResourceBundle)RB.getResources(), (String)"DOMTree.parsererr.fmt.txt", (Object)systemId, (Object)spe.getLineNumber(), (Object)spe.getMessage());
            return info;
        }

        @Override
        public void warning(SAXParseException spe) throws SAXException {
            this.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"DOMTree.warning.fmt.txt", (Object)this.getParseExceptionInfo(spe)));
        }

        @Override
        public void error(SAXParseException spe) throws SAXException {
            String message = Message.format((ResourceBundle)RB.getResources(), (String)"DOMTree.error.fmt.txt", (Object)this.getParseExceptionInfo(spe));
            throw new SAXException(message);
        }

        @Override
        public void fatalError(SAXParseException spe) throws SAXException {
            String message = Message.format((ResourceBundle)RB.getResources(), (String)"DOMTree.fatalerror.fmt.txt", (Object)this.getParseExceptionInfo(spe));
            throw new SAXException(message);
        }
    }

    protected class MyTreeLabel
    extends JLabel {
        private static final long serialVersionUID = 3689916162842571318L;
        private AttributedText attributedLabel;

        public MyTreeLabel() {
        }

        public MyTreeLabel(AttributedText attributedLabel) {
            this.attributedLabel = attributedLabel;
            this.setBackground(Color.WHITE);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this.attributedLabel.getAttributedString().getIterator().getEndIndex() * 9, 15);
        }

        @Override
        public void paintComponent(Graphics g) {
            int offset2;
            super.paintComponent(g);
            int offset1 = 0;
            int offset = offset2 = treeIndent;
            if (this.attributedLabel.isClosingElement()) {
                offset = offset1;
            }
            g.drawString(this.attributedLabel.getAttributedString().getIterator(), offset, 10);
        }
    }
}

