/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.webdav.tools;

import com.sas.nls.collator.SASCollatorFactory;
import com.sas.nls.collator.SASStringComparator;
import com.sas.services.webdav.ConnectionInfo;
import com.sas.services.webdav.DAVException;
import com.sas.services.webdav.DAVResource;
import com.sas.services.webdav.DavPropertyItem;
import com.sas.services.webdav.DavPropertyResult;
import com.sas.services.webdav.PropertyName;
import com.sas.services.webdav.Utils;
import com.sas.services.webdav.XMLUtil;
import com.sas.services.webdav.tools.DAVTreeNode;
import com.sas.services.webdav.tools.DOMTree;
import com.sas.services.webdav.tools.RB;
import com.sas.services.webdav.tools.Splash;
import com.sas.services.webdav.tools.VHDialog;
import com.sas.swing.visuals.util.Util;
import com.sas.text.Message;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.jackrabbit.webdav.lock.LockDiscovery;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.version.report.ReportInfo;
import org.apache.jackrabbit.webdav.version.report.ReportType;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class DAVTree
extends JFrame
implements TreeSelectionListener,
ClipboardOwner {
    private static final Logger LOGGER = LogManager.getLogger(DAVTree.class);
    private static final String version = "9.4.004";
    private static final long serialVersionUID = 3257853194444026935L;
    private static final boolean traceEnabled = false;
    private static final SASStringComparator sascomparator = SASCollatorFactory.createComparatorIgnoreCase();
    protected static final TimeZone gmtZone = TimeZone.getTimeZone("GMT");
    private JTree jTree;
    private JTable jTable;
    private JSplitPane sp;
    private JLabel status;
    private JLabel logonInfo;
    private Vector resNameVector = new Vector();
    private Vector<String> resValueVector = new Vector();
    private static Vector<String> resNSVector = new Vector();
    private TableModel tbModel;
    private String urlLoc;
    private String _userid;
    private String _password;
    private DAVTreeNode top;
    private DOMTree domTree = new DOMTree();
    private DefaultTreeModel dtModel;
    private JPopupMenu treeMenu;
    private JMenuItem miCopyClipboard;
    private DAVResource _r;
    private boolean supportsACL;
    private boolean supportsVC;
    private int screenHeight;
    private int screenWidth;
    private static Properties properties = new Properties();
    private static int FRAME_WIDTH = 850;
    private static int FRAME_HEIGHT = 700;
    private static String proxyHost;
    private static String proxyPort;
    private static Color COLOR_TABLE_BACKGROUND;
    private static Color COLOR_TREE_BACKGROUND;
    private static Color COLOR_TREE_SELECTION;
    private static Color COLOR_TABLE_FOREGROUND;
    private static Color COLOR_TREE_FOREGROUND;
    private static Color COLOR_TABLE_BACKGROUND_COLUMN1;
    private static Color COLOR_TABLE_FOREGROUND_COLUMN1;
    private static final Font treeFont;
    private static final Font tableFont;
    private static final Font tableFontBold;
    private static final Font DIALOG_FONT;
    private static final String XMLHEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static boolean DEBUG;
    private static final String P_WINDOWHEIGHT = "window.height";
    private static final String P_WINDOWWIDTH = "window.width";
    private static final String P_TBBC = "table.background.color";
    private static final String P_TBFC = "table.foreground.color";
    private static final String P_TRBC = "tree.background.color";
    private static final String P_TRFC = "tree.foreground.color";
    private static final String P_TBBCC1 = "table.background.color.column1";
    private static final String P_TBFCC1 = "table.foreground.color.column1";
    private static final String PROXYHOST = "httpProxy.host";
    private static final String PROXYPORT = "httpProxy.port";
    private static final String tmpdir;
    private ImageIcon lockedColImage = new ImageIcon(this.getClass().getClassLoader().getResource("com/sas/services/webdav/tools/lockedcollection.gif"));
    private ImageIcon resImage = new ImageIcon(this.getClass().getClassLoader().getResource("com/sas/services/webdav/tools/resource.gif"));
    private ImageIcon lockedResImage = new ImageIcon(this.getClass().getClassLoader().getResource("com/sas/services/webdav/tools/lockedresource.gif"));
    private ImageIcon checkedOutResImage = new ImageIcon(this.getClass().getClassLoader().getResource("com/sas/services/webdav/tools/checkedoutresource.gif"));
    private ImageIcon lockedCheckedOutResImage = new ImageIcon(this.getClass().getClassLoader().getResource("com/sas/services/webdav/tools/lcoresource.gif"));
    HistoryComboBox hCombo = new HistoryComboBox();
    public String historyFileName = "history.dat";
    JMenuBar mainMenuBar;
    JMenu menu1;
    JMenu menu2;
    JMenu menu3;
    JMenu vmenu;
    JMenu aclmenu;
    JMenuItem miOpen;
    JMenuItem miTest1;
    JMenuItem miExit;
    JMenuItem miDelete;
    JMenuItem miAdd;
    JMenuItem miModify;
    JMenuItem miClone;
    JMenuItem miRefresh1;
    JMenuItem miRefresh2;
    JMenuItem miSearch;
    JMenuItem miContents;
    JMenuItem miEdit;
    JMenuItem miVersion;
    JMenuItem miCheckout;
    JMenuItem miCheckin;
    JMenuItem miUncheckout;
    JMenuItem miVHReport;
    JMenuItem miUserPriv;
    JMenuItem miPCS;
    JMenuItem miSPS;
    JMenuItem miLock;
    JMenuItem miUnlock;
    JCheckBoxMenuItem miDetails;
    JOptionPane chk = new JOptionPane();
    DocumentBuilderFactory factory;
    DocumentBuilder builder;
    Document doc;
    boolean inDragDrop;
    boolean allProp;
    File dndFile;
    String dndString;
    private static final Namespace NAMESPACE_DAV;

    private static Color ColorFromRGB(String RGBString) {
        int r = 0;
        int g = 0;
        int b = 0;
        try {
            String colval = null;
            int p1 = 0;
            int p2 = RGBString.indexOf(44, p1);
            colval = RGBString.substring(p1, p2);
            r = Integer.parseInt(colval);
            p1 = p2 + 1;
            p2 = RGBString.indexOf(44, p1);
            colval = RGBString.substring(p1, p2);
            g = Integer.parseInt(colval);
            p1 = p2 + 1;
            p2 = RGBString.indexOf(44, p1);
            colval = RGBString.substring(p1);
            b = Integer.parseInt(colval);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return new Color(r, g, b);
    }

    public DAVTree(String url) {
        this.urlLoc = this.getURI(url).toASCIIString();
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.setTitle(Message.format((ResourceBundle)RB.getResources(), (String)"DAVTree.application.fmt.txt", (Object)version));
        Splash splashWin = new Splash(this, 15000);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dim = toolkit.getScreenSize();
        this.screenHeight = dim.height;
        this.screenWidth = dim.width;
        this.setBounds((this.screenWidth - FRAME_WIDTH) / 2, (this.screenHeight - FRAME_HEIGHT) / 2, FRAME_WIDTH, FRAME_HEIGHT);
        this.getContentPane().setLayout(new BorderLayout());
        try {
            this.factory = DocumentBuilderFactory.newInstance();
            this.factory.setValidating(false);
            this.factory.setNamespaceAware(true);
            this.builder = this.factory.newDocumentBuilder();
            this.doc = this.builder.newDocument();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        if (url.length() > 0) {
            this.top = new DAVTreeNode(this.urlLoc, true, false, false);
            this.top.resName = this.top.fullName;
            this.dtModel = new DAVTreeModel(this.top);
        } else {
            this.dtModel = new DAVTreeModel(new DefaultMutableTreeNode());
            this.dtModel.setRoot(null);
        }
        this.jTree = new DNDTree(this.dtModel, true, true){
            private static final long serialVersionUID = 3256719593677862960L;

            public String getPathName(TreePath path) {
                Object o = path.getLastPathComponent();
                if (o instanceof DAVTreeNode) {
                    return ((DAVTreeNode)o).fullName;
                }
                return null;
            }
        };
        this.jTree.addTreeSelectionListener(this);
        this.jTree.addTreeExpansionListener(new TreeExpansionHandler());
        this.jTree.getModel().addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent evt) {
                Object[] children = evt.getChildren();
                if (children == null) {
                    return;
                }
                DAVTreeNode dtNode = (DAVTreeNode)children[0];
                if (dtNode.newName != null) {
                    String dest = dtNode.fullName;
                    if (dest.length() > 1 && dest.endsWith("/")) {
                        dest = dest.substring(0, dest.length() - 1);
                        if (!dtNode.newName.endsWith("/")) {
                            dtNode.newName = dtNode.newName + "/";
                        }
                    }
                    dest = dest.substring(0, dest.lastIndexOf(47));
                    dest = dest + '/' + dtNode.newName;
                    DAVResource r = DAVTree.this.getDAVResource(dtNode.fullName);
                    try {
                        String destPath = new URL(dest).getPath();
                        r.move(destPath);
                        dtNode.fullName = dest;
                        dtNode.name = dtNode.newName;
                        dtNode.resName = dtNode.newName;
                        dtNode.setProperties(DAVTree.this.getProperties(dtNode.fullName));
                        DAVTree.this.setupVectors(dtNode.getProperties());
                        ((AbstractTableModel)DAVTree.this.tbModel).fireTableDataChanged();
                    }
                    catch (MalformedURLException e) {
                        e.printStackTrace();
                    }
                    catch (DAVException e) {
                        DAVTree.this.status.setText(e.getMessage());
                        e.printStackTrace();
                    }
                    catch (RemoteException e) {
                        e.printStackTrace();
                    }
                } else {
                    dtNode.setProperties(DAVTree.this.getProperties(dtNode.fullName));
                    DAVTree.this.setupVectors(dtNode.getProperties());
                    ((AbstractTableModel)DAVTree.this.tbModel).fireTableDataChanged();
                }
            }

            @Override
            public void treeStructureChanged(TreeModelEvent evt) {
            }

            @Override
            public void treeNodesInserted(TreeModelEvent evt) {
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent evt) {
            }
        });
        this.jTree.setBackground(COLOR_TREE_BACKGROUND);
        this.tbModel = new AbstractTableModel(){
            private static final long serialVersionUID = 3257846575916267059L;
            private final String[] colNames = new String[]{RB.getStringResource("DAVTree.namecolumnlabel.txt"), RB.getStringResource("DAVTree.valuecolumnlabel.txt")};

            @Override
            public String getColumnName(int col) {
                return this.colNames[col].toString();
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public int getRowCount() {
                return DAVTree.this.resNameVector.size();
            }

            @Override
            public Object getValueAt(int row, int col) {
                if (col == 0) {
                    return DAVTree.this.resNameVector.elementAt(row);
                }
                return DAVTree.this.resValueVector.elementAt(row);
            }
        };
        this.jTable = new JTable(this.tbModel);
        this.jTable.setGridColor(COLOR_TREE_SELECTION);
        this.jTable.setForeground(COLOR_TABLE_FOREGROUND);
        this.jTable.setBackground(COLOR_TABLE_BACKGROUND);
        this.jTable.setFont(tableFont);
        this.domTree.setBackground(COLOR_TABLE_BACKGROUND);
        CustomTableCellRenderer renderer = new CustomTableCellRenderer();
        renderer.setBackground(COLOR_TABLE_BACKGROUND_COLUMN1);
        renderer.setForeground(COLOR_TABLE_FOREGROUND_COLUMN1);
        renderer.setFont(tableFontBold);
        this.jTable.getColumnModel().getColumn(0).setCellRenderer(renderer);
        for (int i = 0; i < 2; ++i) {
            TableColumn col;
            if (i == 0) {
                col = this.jTable.getColumnModel().getColumn(0);
                col.setWidth(75);
                col.setPreferredWidth(75);
                col.sizeWidthToFit();
                continue;
            }
            col = this.jTable.getColumnModel().getColumn(1);
            col.setWidth(375);
            col.setPreferredWidth(375);
        }
        this.jTable.setAutoResizeMode(3);
        this.jTable.setShowGrid(false);
        this.jTable.setIntercellSpacing(new Dimension(0, 0));
        this.jTable.getColumnModel().setColumnMargin(2);
        JScrollPane treePane = new JScrollPane(this.jTree);
        JScrollPane tablePane = new JScrollPane(this.jTable);
        JScrollPane domTreePane = new JScrollPane(this.domTree);
        tablePane.setBackground(COLOR_TABLE_BACKGROUND);
        tablePane.getViewport().setBackground(COLOR_TABLE_BACKGROUND);
        domTreePane.setBackground(COLOR_TABLE_BACKGROUND);
        domTreePane.getViewport().setBackground(COLOR_TABLE_BACKGROUND);
        treePane.setMinimumSize(new Dimension(190, treePane.getPreferredSize().height));
        this.sp = new JSplitPane();
        this.sp.setDividerLocation(0.33);
        JTabbedPane tabbedPane = new JTabbedPane();
        String tabLabel = RB.getStringResource("DAVTree.tabletab.label.txt");
        String tabDesc = RB.getStringResource("DAVTree.tabletab.desc.txt");
        tabbedPane.addTab(tabLabel, null, tablePane, tabDesc);
        tabLabel = RB.getStringResource("DAVTree.xmltab.label.txt");
        tabDesc = RB.getStringResource("DAVTree.xmltab.desc.txt");
        tabbedPane.addTab(tabLabel, null, domTreePane, tabDesc);
        tabbedPane.setSelectedIndex(0);
        this.sp.setLeftComponent(treePane);
        this.sp.setRightComponent(tabbedPane);
        this.jTree.getSelectionModel().setSelectionMode(4);
        this.jTree.setShowsRootHandles(true);
        CustomBasicRenderer btcr = new CustomBasicRenderer();
        btcr.setBackgroundNonSelectionColor(COLOR_TREE_BACKGROUND);
        btcr.setBackgroundSelectionColor(COLOR_TREE_SELECTION);
        btcr.setTextSelectionColor(Color.WHITE);
        btcr.setFont(treeFont);
        this.jTree.setCellRenderer(btcr);
        this.jTree.setEditable(true);
        this.jTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int selectedRow = DAVTree.this.jTree.getRowForLocation(e.getX(), e.getY());
                if (selectedRow != -1 && SwingUtilities.isRightMouseButton(e)) {
                    DAVTree.this.jTree.setSelectionRow(selectedRow);
                    TreePath[] selpaths = DAVTree.this.jTree.getSelectionPaths();
                    if (selpaths.length == 1) {
                        DAVTreeNode node = (DAVTreeNode)selpaths[0].getLastPathComponent();
                        DAVTree.this.miEdit.setEnabled(!node.isCollection);
                    }
                    DAVTree.this.treeMenu.show(DAVTree.this.jTree, e.getX(), e.getY());
                }
            }
        });
        ProcessActions processAction = new ProcessActions();
        this.mainMenuBar = new JMenuBar();
        this.menu1 = new JMenu(RB.getStringResource("DAVTree.menu.file.txt"));
        this.menu2 = new JMenu(RB.getStringResource("DAVTree.menu.edit.txt"));
        this.menu3 = new JMenu(RB.getStringResource("DAVTree.menu.view.txt"));
        this.vmenu = new JMenu(RB.getStringResource("DAVTree.menu.versioning.txt"));
        this.aclmenu = new JMenu(RB.getStringResource("DAVTree.menu.acl.txt"));
        this.miOpen = new JMenuItem(RB.getStringResource("DAVTree.menu.file.open.txt"));
        this.miOpen.addActionListener(processAction);
        this.menu1.add(this.miOpen);
        this.menu1.addSeparator();
        this.miExit = new JMenuItem(RB.getStringResource("DAVTree.menu.file.exit.txt"));
        this.menu1.add(this.miExit);
        this.miExit.addActionListener(processAction);
        this.mainMenuBar.add(this.menu1);
        this.miDelete = new JMenuItem(RB.getStringResource("DAVTree.menu.edit.delete.txt"));
        this.miDelete.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        this.menu2.add(this.miDelete);
        this.miDelete.addActionListener(processAction);
        this.miAdd = new JMenuItem(RB.getStringResource("DAVTree.menu.edit.add.txt"));
        this.menu2.add(this.miAdd);
        this.miAdd.addActionListener(processAction);
        this.miEdit = new JMenuItem(RB.getStringResource("DAVTree.menu.edit.edit.txt"));
        this.miModify = new JMenuItem(RB.getStringResource("DAVTree.menu.edit.modify.txt"));
        this.menu2.add(this.miModify);
        this.miModify.addActionListener(processAction);
        this.miClone = new JMenuItem(RB.getStringResource("DAVTree.menu.edit.clone.txt"));
        this.miClone.setEnabled(false);
        this.menu2.add(this.miClone);
        this.mainMenuBar.add(this.menu2);
        this.miRefresh1 = new JMenuItem(RB.getStringResource("DAVTree.menu.view.refresh.txt"));
        this.miRefresh2 = new JMenuItem(RB.getStringResource("DAVTree.menu.view.refresh.txt"));
        this.miSearch = new JMenuItem(RB.getStringResource("DAVTree.menu.view.search.txt"));
        this.miSearch.setEnabled(false);
        this.miDetails = new JCheckBoxMenuItem(RB.getStringResource("DAVTree.menu.view.details.txt"), false);
        this.miDetails.addActionListener(processAction);
        this.menu3.add(this.miDetails);
        this.miContents = new JMenuItem(RB.getStringResource("DAVTree.menu.view.contents.txt"));
        this.menu3.add(this.miRefresh1);
        this.miRefresh1.addActionListener(processAction);
        this.menu3.add(this.miSearch);
        this.menu3.add(this.miContents);
        this.miContents.addActionListener(processAction);
        this.mainMenuBar.add(this.menu3);
        this.miVersion = new JMenuItem(RB.getStringResource("DAVTree.menu.view.version.txt"));
        this.vmenu.add(this.miVersion);
        this.miVersion.addActionListener(processAction);
        this.miCheckin = new JMenuItem(RB.getStringResource("DAVTree.menu.view.checkin.txt"));
        this.vmenu.add(this.miCheckin);
        this.miCheckin.addActionListener(processAction);
        this.miCheckout = new JMenuItem(RB.getStringResource("DAVTree.menu.view.checkout.txt"));
        this.vmenu.add(this.miCheckout);
        this.miCheckout.addActionListener(processAction);
        this.miUncheckout = new JMenuItem(RB.getStringResource("DAVTree.menu.view.uncheckout.txt"));
        this.vmenu.add(this.miUncheckout);
        this.miUncheckout.addActionListener(processAction);
        this.mainMenuBar.add(this.vmenu);
        this.miVHReport = new JMenuItem(RB.getStringResource("DAVTree.menu.view.vhreport.txt"));
        this.vmenu.add(this.miVHReport);
        this.miVHReport.addActionListener(processAction);
        this.mainMenuBar.add(this.vmenu);
        this.miLock = new JMenuItem(RB.getStringResource("DAVTree.menu.view.lock.txt"));
        this.menu3.add(this.miLock);
        this.miLock.addActionListener(processAction);
        this.miUnlock = new JMenuItem(RB.getStringResource("DAVTree.menu.view.unlock.txt"));
        this.menu3.add(this.miUnlock);
        this.miUnlock.addActionListener(processAction);
        this.miUserPriv = new JMenuItem(RB.getStringResource("DAVTree.menu.userpriv.txt"));
        this.aclmenu.add(this.miUserPriv);
        this.miUserPriv.addActionListener(processAction);
        this.miPCS = new JMenuItem(RB.getStringResource("DAVTree.menu.pcs.txt"));
        this.aclmenu.add(this.miPCS);
        this.miPCS.addActionListener(processAction);
        this.mainMenuBar.add(this.aclmenu);
        this.miSPS = new JMenuItem(RB.getStringResource("DAVTree.menu.supppriv.txt"));
        this.aclmenu.add(this.miSPS);
        this.miSPS.addActionListener(processAction);
        this.mainMenuBar.add(this.aclmenu);
        this.vmenu.setEnabled(false);
        this.aclmenu.setEnabled(false);
        this.setJMenuBar(this.mainMenuBar);
        this.treeMenu = new JPopupMenu();
        this.treeMenu.setInvoker(this.jTree);
        this.treeMenu.setVisible(false);
        this.miCopyClipboard = new JMenuItem(RB.getStringResource("DAVTree.menu.copyuri.txt"));
        this.treeMenu.add(this.miCopyClipboard);
        this.miCopyClipboard.addActionListener(processAction);
        this.treeMenu.add(this.miRefresh2);
        this.miRefresh2.addActionListener(processAction);
        this.treeMenu.add(this.miEdit);
        this.miEdit.addActionListener(processAction);
        this.treeMenu.add(this.miLock);
        this.treeMenu.add(this.miUnlock);
        String userHome = System.getProperty("user.home");
        String fileSeparator = System.getProperty("file.separator");
        if (userHome != null) {
            this.historyFileName = userHome + fileSeparator + this.historyFileName;
        }
        this.hCombo.load(this.historyFileName);
        this.hCombo.setPreferredSize(new Dimension(280, this.hCombo.getPreferredSize().height));
        WindowAdapter wndCloser = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DAVTree.this.hCombo.save(DAVTree.this.historyFileName);
                DAVTree.exit();
            }
        };
        this.addWindowListener(wndCloser);
        this.getContentPane().add((Component)this.sp, "Center");
        this.status = new JLabel(">", 0);
        this.logonInfo = new JLabel();
        this.status.setHorizontalAlignment(2);
        this.status.setBorder(BorderFactory.createBevelBorder(1));
        this.logonInfo.setBorder(BorderFactory.createBevelBorder(1));
        JPanel statusPanel = new JPanel();
        statusPanel.setLayout(new GridLayout(1, 2));
        statusPanel.add(this.status);
        statusPanel.add(this.logonInfo);
        this.getContentPane().add((Component)statusPanel, "South");
        this.validate();
        try {
            Thread.sleep(1500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
        splashWin.dispose();
        this.setVisible(true);
    }

    protected DAVResource getDAVResource(String url) {
        if (this._r == null) {
            ConnectionInfo connectionInfo = new ConnectionInfo(url);
            if (proxyHost != null && proxyPort != null) {
                connectionInfo.setProxyHost(proxyHost);
                connectionInfo.setProxyPort(Integer.parseInt(proxyPort));
            }
            AuthScope authScope = AuthScope.ANY;
            connectionInfo.setAuthScope(authScope);
            if (null != this._userid) {
                UsernamePasswordCredentials usernamePasswordCredentials = new UsernamePasswordCredentials(this._userid, this._password);
                BasicCredentialsProvider basicCredentialsProvider = new BasicCredentialsProvider();
                basicCredentialsProvider.setCredentials(authScope, (Credentials)usernamePasswordCredentials);
                connectionInfo.setCredentialsProvider((CredentialsProvider)basicCredentialsProvider);
            }
            try {
                try {
                    this._r = new DAVResource(connectionInfo);
                }
                catch (DAVException e) {
                    if (e.getStatusCode() == 401) {
                        CredentialsDlg dlg = new CredentialsDlg(this, true);
                        dlg.pack();
                        dlg.setVisible(true);
                        if (null == this._userid) {
                            throw e;
                        }
                        UsernamePasswordCredentials usernamePasswordCredentials = new UsernamePasswordCredentials(this._userid, this._password);
                        BasicCredentialsProvider basicCredentialsProvider = new BasicCredentialsProvider();
                        basicCredentialsProvider.setCredentials(authScope, (Credentials)usernamePasswordCredentials);
                        connectionInfo.setCredentialsProvider((CredentialsProvider)basicCredentialsProvider);
                        this._r = new DAVResource(connectionInfo);
                    }
                    throw e;
                }
                if (this._r == null) {
                    System.out.println(RB.getStringResource("DAVTree.errcreate.txt"));
                } else if (DEBUG) {
                    this._r.setDebug(Integer.MAX_VALUE);
                }
            }
            catch (DAVException e) {
                System.out.println("DAVException: " + e.getMessage() + '\n' + e.toString());
                this.status.setText(e.getMessage());
                this.logonInfo.setText("");
                return null;
            }
            this.logonInfo.setText(Message.format((ResourceBundle)RB.getResources(), (String)"DAVTree.loggedin.fmt.txt", (Object)this._userid));
            try {
                this._r.doOptions();
                String[] caps = this._r.getDavCapabilities();
                this.supportsACL = false;
                this.supportsVC = false;
                for (int i = 0; i < caps.length; ++i) {
                    if ("access-control".equals(caps[i])) {
                        this.supportsACL = true;
                    }
                    if (!"version-control".equals(caps[i])) continue;
                    this.supportsVC = true;
                }
                this.vmenu.setEnabled(this.supportsVC);
                this.aclmenu.setEnabled(this.supportsACL);
            }
            catch (DAVException e) {
                this.status.setText(e.getMessage());
            }
            catch (RemoteException remoteException) {}
        } else {
            try {
                URL _url = new URL(url);
                String path = _url.getPath();
                if (_url.getQuery() != null) {
                    path = path + '?' + _url.getQuery();
                }
                if (_url.getRef() != null) {
                    path = path + '#' + _url.getRef();
                }
                this._r.setPath(path);
            }
            catch (MalformedURLException e) {
                System.out.println("MalformedURLException: " + e.getMessage() + '\n' + e.toString());
                this.status.setText(e.getMessage());
            }
        }
        return this._r;
    }

    protected Map getChildrenList(String fullName) {
        TreeMap children = new TreeMap((Comparator<String>)sascomparator);
        try {
            DAVResource resource = this.getDAVResource(fullName);
            if (resource != null) {
                DavPropertyNameSet davPropertyNameSet = new DavPropertyNameSet();
                davPropertyNameSet.add(DavPropertyName.create((String)"checked-out", (Namespace)NAMESPACE_DAV));
                davPropertyNameSet.add(DavPropertyName.LOCKDISCOVERY);
                davPropertyNameSet.add(DavPropertyName.RESOURCETYPE);
                DavPropertyResult davPropertyResult = resource.getDavProperties(davPropertyNameSet, 1);
                URL u = resource.getURL();
                String resourceURL = u == null ? "" : u.toString();
                for (DavPropertyItem davPropertyItem : davPropertyResult.getDavProperties()) {
                    DavPropertyName davPropertyName;
                    DavProperty<?> davProperty = davPropertyItem.getDavProperty();
                    String newurl = Utils.transformURL(resourceURL, davPropertyItem.getDavResourceHref());
                    if (this.isSameUrl(u.toString(), newurl)) continue;
                    if (!children.containsKey(newurl)) {
                        children.put(newurl, new HashMap());
                    }
                    if (null == (davPropertyName = davProperty.getName())) continue;
                    Map m = (Map)children.get(newurl);
                    String localName = davPropertyName.getName();
                    if ("checked-out".equals(localName)) {
                        boolean isCheckedOut = davPropertyItem.getStatusCode() == 200;
                        m.put(localName, Boolean.toString(isCheckedOut));
                        continue;
                    }
                    if ("lockdiscovery".equals(localName)) {
                        boolean isLocked = false;
                        Object davPropertyValue = davProperty.getValue();
                        if (davPropertyValue instanceof Element) {
                            Element element = davProperty.toXml(this.builder.newDocument());
                            LockDiscovery lockDiscovery = LockDiscovery.createFromXml((Element)element);
                            List activeLocks = lockDiscovery.getValue();
                            isLocked = !activeLocks.isEmpty();
                        }
                        m.put("locked", Boolean.toString(isLocked));
                        continue;
                    }
                    if ("resourcetype".equals(localName)) {
                        int i = 0;
                        Element element = davProperty.toXml(this.builder.newDocument());
                        NodeList nodeList = element.getChildNodes();
                        int numNodes = nodeList.getLength();
                        if (i >= numNodes) continue;
                        Node node = nodeList.item(i);
                        String nodeLocalName = node.getLocalName();
                        String valueCollection = "collection".equals(nodeLocalName) && NAMESPACE_DAV.getURI().equals(node.getNamespaceURI()) ? "COLLECTION" : "";
                        m.put(localName, valueCollection);
                        continue;
                    }
                    Object davPropertyValue = davProperty.getValue();
                    String value = null == davPropertyValue ? "" : davPropertyValue.toString();
                    m.put(localName, value);
                }
            }
        }
        catch (DAVException e) {
            this.status.setText(e.getMessage());
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return children;
    }

    protected TreeMap<String, Element> getProperties(String fullName) {
        TreeMap<String, Element> ht = new TreeMap<String, Element>();
        DAVResource resource = this.getDAVResource(fullName);
        boolean depth = false;
        try {
            List<Object> davPropertyItems = new ArrayList(0);
            if (this.allProp) {
                DavPropertyResult davPropertyNamesResult = resource.getDavPropertyNames(0);
                List<DavPropertyItem> list = davPropertyNamesResult.getDavProperties();
                ArrayList<PropertyName> propNames = new ArrayList<PropertyName>(davPropertyItems.size());
                for (DavPropertyItem davPropertyItem : list) {
                    String propertyName;
                    DavProperty<?> davProperty = davPropertyItem.getDavProperty();
                    DavPropertyName davPropertyName = davProperty.getName();
                    if (null == davPropertyName || "supported-live-property-set".equals(propertyName = davPropertyName.getName())) continue;
                    propNames.add(new PropertyName(davProperty));
                }
                DavPropertyResult davPropertyResult = resource.getDavProperties(propNames.toArray(new PropertyName[0]), 0);
                davPropertyItems = davPropertyResult.getDavProperties();
            } else {
                DavPropertyResult davPropertyResult = resource.getDavProperties(0);
                davPropertyItems = davPropertyResult.getDavProperties();
            }
            for (DavPropertyItem davPropertyItem : davPropertyItems) {
                DavProperty<?> davProperty;
                DavPropertyName davPropertyName;
                if (200 != davPropertyItem.getStatusCode() || null == (davPropertyName = (davProperty = davPropertyItem.getDavProperty()).getName())) continue;
                Element element = davProperty.toXml(this.builder.newDocument());
                ht.put(davPropertyName.getName(), element);
            }
        }
        catch (DAVException e) {
            this.status.setText(e.getMessage());
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        catch (RemoteException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return ht;
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    private boolean isSameUrl(String url1, String url2) {
        String _url1 = this.stripTrailingSlashes(url1.trim());
        String _url2 = this.stripTrailingSlashes(url2.trim());
        if (_url1.charAt(_url1.length() - 1) == '/') {
            _url1 = _url1.substring(0, _url1.length() - 1);
        }
        if (_url2.charAt(_url2.length() - 1) == '/') {
            _url2 = _url2.substring(0, _url2.length() - 1);
        }
        return _url1.equals(_url2);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        DAVTreeNode node = (DAVTreeNode)this.jTree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        if (node.getProperties() == null) {
            node.setProperties(this.getProperties(node.fullName));
        }
        this.setupVectors(node.getProperties());
        ((AbstractTableModel)this.tbModel).fireTableDataChanged();
        DocumentFragment docfrg = this.doc.createDocumentFragment();
        Iterator<Element> props = node.getProperties().values().iterator();
        while (props.hasNext()) {
            Node n = this.doc.importNode(props.next(), true);
            docfrg.appendChild(n);
        }
        this.domTree.setRoot(docfrg);
        this.status.setText(">");
    }

    private void setupVectors(TreeMap DAVprops) {
        Iterator keys = null;
        Iterator values = null;
        this.resNameVector.clear();
        this.resValueVector.clear();
        resNSVector.clear();
        if (DAVprops != null) {
            keys = DAVprops.keySet().iterator();
            values = DAVprops.values().iterator();
            while (keys.hasNext()) {
                this.resNameVector.add(keys.next());
            }
            while (values.hasNext()) {
                Element pVal = (Element)values.next();
                String nodeText = "";
                if (pVal.hasChildNodes() && pVal.getFirstChild() == pVal.getLastChild() && pVal.getFirstChild() instanceof Text) {
                    nodeText = pVal.getFirstChild().getNodeValue();
                }
                if (nodeText.equals("")) {
                    nodeText = XMLUtil.node2String(pVal);
                }
                this.resValueVector.add(nodeText);
                resNSVector.add(pVal.getNamespaceURI());
            }
        }
    }

    private static void exit() {
        System.exit(0);
    }

    public static void main(String[] args) {
        String priority = System.getProperty("logLevel");
        boolean bl = DEBUG = priority != null && priority.equals("DEBUG");
        if (args.length == 0) {
            new DAVTree("");
        } else {
            new DAVTree(args[0]);
        }
    }

    public void miUserPriv_Action(ActionEvent event) {
        DAVTreeNode node = (DAVTreeNode)this.jTree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        try {
            Object davPropertyValue;
            DavProperty<?> davProperty;
            DavPropertyName davPropertyName;
            StringBuilder stringBuilder = new StringBuilder();
            DAVResource r = this.getDAVResource(node.fullName);
            DavPropertyNameSet davPropertyNameSet = new DavPropertyNameSet();
            davPropertyNameSet.add(DavPropertyName.create((String)"current-user-privilege-set", (Namespace)NAMESPACE_DAV));
            DavPropertyResult davPropertyResult = r.getDavProperties(davPropertyNameSet, r.getDepth());
            this.status.setText(Integer.toString(r.getStatusCode()));
            List<DavPropertyItem> davPropertyItems = davPropertyResult.getDavProperties();
            if (1 == davPropertyItems.size() && null != (davPropertyName = (davProperty = davPropertyItems.get(0).getDavProperty()).getName()) && (davPropertyValue = davProperty.getValue()) instanceof ArrayList) {
                ArrayList list = (ArrayList)davPropertyValue;
                for (Object item : list) {
                    if (!(item instanceof Element)) continue;
                    Element element = (Element)item;
                    NodeList childNodes = element.getChildNodes();
                    for (int x = 0; x < childNodes.getLength(); ++x) {
                        Node childNode = childNodes.item(x);
                        stringBuilder.append('{').append(childNode.getNamespaceURI()).append('}').append(childNode.getLocalName()).append(System.lineSeparator());
                    }
                }
            }
            ResponseDlg resp = new ResponseDlg(this, RB.getStringResource("DAVTree.dialog.user.privileges.title"), stringBuilder.toString(), true);
            resp.setVisible(true);
        }
        catch (DAVException e) {
            this.status.setText(e.getMessage());
            e.printStackTrace();
        }
        catch (RemoteException e) {
            System.out.println("RemoteException: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void miSupportedPriv_Action(ActionEvent event) {
        DAVTreeNode node = (DAVTreeNode)this.jTree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        try {
            Object davPropertyValue;
            DavProperty<?> davProperty;
            DavPropertyName davPropertyName;
            StringBuilder stringBuilder = new StringBuilder();
            DAVResource r = this.getDAVResource(node.fullName);
            DavPropertyNameSet davPropertyNameSet = new DavPropertyNameSet();
            davPropertyNameSet.add(DavPropertyName.create((String)"supported-privilege-set", (Namespace)NAMESPACE_DAV));
            DavPropertyResult davPropertyResult = r.getDavProperties(davPropertyNameSet, r.getDepth());
            this.status.setText(Integer.toString(r.getStatusCode()));
            List<DavPropertyItem> davPropertyItems = davPropertyResult.getDavProperties();
            if (1 == davPropertyItems.size() && null != (davPropertyName = (davProperty = davPropertyItems.get(0).getDavProperty()).getName()) && (davPropertyValue = davProperty.getValue()) instanceof ArrayList) {
                ArrayList list = (ArrayList)davPropertyValue;
                for (Object item : list) {
                    if (!(item instanceof Element)) continue;
                    DAVTree.doSupportedPrivilege((Element)item, 0, stringBuilder);
                }
            }
            ResponseDlg resp = new ResponseDlg(this, RB.getStringResource("DAVTree.dialog.supported.privileges.title"), stringBuilder.toString(), true);
            resp.setVisible(true);
        }
        catch (DAVException e) {
            this.status.setText(e.getMessage());
            e.printStackTrace();
        }
        catch (RemoteException e) {
            System.out.println("RemoteException: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static void doSupportedPrivilege(Element sp, int level, StringBuilder stringBuilder) {
        NodeList nl = sp.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if ("privilege".equals(n.getLocalName())) {
                stringBuilder.append(DAVTree.indent(level)).append('{').append(n.getFirstChild().getNamespaceURI()).append('}').append(n.getFirstChild().getLocalName()).append(System.lineSeparator());
                continue;
            }
            if ("description".equals(n.getLocalName())) {
                stringBuilder.append(DAVTree.indent(level)).append(n.getFirstChild().getNodeValue()).append(System.lineSeparator());
                continue;
            }
            if (!"supported-privilege".equals(n.getLocalName())) continue;
            DAVTree.doSupportedPrivilege((Element)n, level + 3, stringBuilder);
        }
    }

    private static String indent(int level) {
        StringBuilder sb = new StringBuilder(level);
        for (int i = 0; i < level; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }

    public void miPCS_Action(ActionEvent event) {
        DAVTreeNode node = (DAVTreeNode)this.jTree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        try {
            Object davPropertyValue;
            DavProperty<?> davProperty;
            DavPropertyName davPropertyName;
            StringBuilder stringBuilder = new StringBuilder();
            DAVResource r = this.getDAVResource(node.fullName);
            DavPropertyNameSet davPropertyNameSet = new DavPropertyNameSet();
            davPropertyNameSet.add(DavPropertyName.create((String)"principal-collection-set", (Namespace)NAMESPACE_DAV));
            DavPropertyResult davPropertyResult = r.getDavProperties(davPropertyNameSet, r.getDepth());
            this.status.setText(Integer.toString(r.getStatusCode()));
            List<DavPropertyItem> davPropertyItems = davPropertyResult.getDavProperties();
            if (1 == davPropertyItems.size() && null != (davPropertyName = (davProperty = davPropertyItems.get(0).getDavProperty()).getName()) && (davPropertyValue = davProperty.getValue()) instanceof Element) {
                Element p = (Element)davPropertyValue;
                NodeList nl = p.getChildNodes();
                for (int j = 0; j < nl.getLength(); ++j) {
                    if (!(nl.item(j) instanceof Element) || !nl.item(j).hasChildNodes()) continue;
                    stringBuilder.append(nl.item(j).getFirstChild().getNodeValue()).append(System.lineSeparator());
                }
            }
            ResponseDlg resp = new ResponseDlg(this, RB.getStringResource("DAVTree.dialog.principal.collection.set.title"), stringBuilder.toString(), true);
            resp.setVisible(true);
        }
        catch (DAVException e) {
            this.status.setText(e.getMessage());
            e.printStackTrace();
        }
        catch (RemoteException e) {
            System.out.println("RemoteException: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void miVHReport_Action(ActionEvent actionEvent) {
        DAVTreeNode node = (DAVTreeNode)this.jTree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        try {
            DAVResource r = this.getDAVResource(node.fullName);
            DavPropertyNameSet davPropertyNameSet = new DavPropertyNameSet();
            davPropertyNameSet.add(DavPropertyName.create((String)"version-name", (Namespace)NAMESPACE_DAV));
            davPropertyNameSet.add(DavPropertyName.create((String)"creator-displayname", (Namespace)NAMESPACE_DAV));
            davPropertyNameSet.add(DavPropertyName.CREATIONDATE);
            davPropertyNameSet.add(DavPropertyName.GETCONTENTLENGTH);
            davPropertyNameSet.add(DavPropertyName.create((String)"comment", (Namespace)NAMESPACE_DAV));
            ReportInfo reportInfo = new ReportInfo(ReportType.VERSION_TREE, r.getDepth(), davPropertyNameSet);
            DavPropertyResult davPropertyResult = r.doReport(reportInfo);
            int statusCode = r.getStatusCode();
            this.status.setText(Integer.toString(statusCode));
            if (207 == statusCode) {
                ArrayList resultList = new ArrayList();
                String oldURL = "";
                HashMap<String, String> m = null;
                for (DavPropertyItem davPropertyItem : davPropertyResult.getDavProperties()) {
                    DavProperty<?> davProperty;
                    DavPropertyName davPropertyName;
                    String owningURL = davPropertyItem.getDavResourceHref();
                    String rurl = Utils.transformURL(r.getURL().toString(), owningURL);
                    if (!rurl.equals(oldURL)) {
                        if (null != m) {
                            resultList.add(m);
                        }
                        m = new HashMap<String, String>();
                        m.put("owning-URL", rurl);
                        oldURL = rurl;
                    }
                    if (null == (davPropertyName = (davProperty = davPropertyItem.getDavProperty()).getName())) continue;
                    Object value = davProperty.getValue();
                    String davPropertyValue = null == value ? "" : value.toString();
                    m.put(davPropertyName.getName(), davPropertyValue);
                }
                resultList.add(m);
                VHDialog vhdlg = new VHDialog((Frame)this, resultList, true);
                vhdlg.setVisible(true);
            }
        }
        catch (DAVException e) {
            this.status.setText(e.getMessage());
            e.printStackTrace();
        }
        catch (RemoteException e) {
            System.out.println("RemoteException: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void miVersion_Action(ActionEvent e) {
        DAVTreeNode node = (DAVTreeNode)this.jTree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        try {
            DAVResource r = this.getDAVResource(node.fullName);
            r.doControl();
            this.status.setText(this.scformat(r.getStatusCode()));
        }
        catch (DAVException de) {
            this.status.setText(de.getMessage());
            de.printStackTrace();
        }
        catch (RemoteException re) {
            System.out.println("RemoteException: " + re.getMessage());
            re.printStackTrace();
        }
    }

    private String scformat(int sc) {
        return Integer.toString(sc);
    }

    public void miCheckout_Action(ActionEvent e) {
        DAVTreeNode node = (DAVTreeNode)this.jTree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        try {
            DAVResource r = this.getDAVResource(node.fullName);
            r.doCheckout();
            if (r.getStatusCode() == 200) {
                node.setCheckedOut(true);
                ((DefaultTreeModel)this.jTree.getModel()).nodeChanged(node);
            }
            this.status.setText(this.scformat(r.getStatusCode()));
        }
        catch (DAVException de) {
            this.status.setText(de.getMessage());
            de.printStackTrace();
        }
        catch (RemoteException re) {
            System.out.println("RemoteException: " + re.getMessage());
            re.printStackTrace();
        }
    }

    public void miCheckin_Action(ActionEvent e) {
        DAVTreeNode node = (DAVTreeNode)this.jTree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        try {
            DAVResource r = this.getDAVResource(node.fullName);
            r.doCheckin();
            if (r.getStatusCode() == 201) {
                node.setCheckedOut(false);
                ((DefaultTreeModel)this.jTree.getModel()).nodeChanged(node);
            }
            this.status.setText(this.scformat(r.getStatusCode()));
        }
        catch (DAVException de) {
            this.status.setText(de.getMessage());
            de.printStackTrace();
        }
        catch (RemoteException re) {
            System.out.println("RemoteException: " + re.getMessage());
            re.printStackTrace();
        }
    }

    public void miUncheckout_Action(ActionEvent e) {
        DAVTreeNode node = (DAVTreeNode)this.jTree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        try {
            DAVResource r = this.getDAVResource(node.fullName);
            r.doUncheckout();
            if (r.getStatusCode() == 200 || r.getStatusCode() == 204) {
                node.setCheckedOut(false);
                ((DefaultTreeModel)this.jTree.getModel()).nodeChanged(node);
            }
            this.status.setText(this.scformat(r.getStatusCode()));
        }
        catch (DAVException de) {
            this.status.setText(de.getMessage());
            de.printStackTrace();
        }
        catch (RemoteException re) {
            System.out.println("RemoteException: " + re.getMessage());
            re.printStackTrace();
        }
    }

    public void miCopyClipboard_Action(ActionEvent e) {
        DAVTreeNode node = (DAVTreeNode)this.jTree.getLastSelectedPathComponent();
        String uri = this.getURI(node.fullName).toASCIIString();
        StringSelection stringSelection = new StringSelection(uri);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, this);
    }

    public void miDetails_Action(ActionEvent e) {
        JCheckBoxMenuItem item = (JCheckBoxMenuItem)e.getSource();
        this.allProp = item.isSelected();
    }

    public void miExit_Action(ActionEvent e) {
        if (this._r != null) {
            try {
                this._r.close();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            this._r = null;
        }
        Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new WindowEvent(this, 201));
    }

    public void miOpen_Action(ActionEvent e) {
        OpenDlg opendlg = new OpenDlg(this, RB.getStringResource("DAVTree.openhdr.title"), RB.getStringResource("DAVTree.opendesc.txt"));
        opendlg.setVisible(true);
        this._userid = null;
        this._password = null;
        this.status.setText(" ");
        if (this._r != null) {
            try {
                this._r.close();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            this._r = null;
        }
        this.top = new DAVTreeNode(this.urlLoc, true, false, false);
        boolean addedNodes = this.top.populateCollections(this, true);
        if (addedNodes) {
            this.top.resName = this.top.fullName;
            this.dtModel.setRoot(this.top);
        }
    }

    public void miContents_Action(ActionEvent e) {
        DAVTreeNode node = (DAVTreeNode)this.jTree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        try {
            URL _url = new URL(node.fullName);
            this._r.setPath(_url.getPath());
            this.status.setText(this.scformat(this._r.getStatusCode()));
            HexDisplayDlg hexdlg = new HexDisplayDlg(this, node.fullName, this._r.getContents());
            hexdlg.setVisible(true);
        }
        catch (MalformedURLException mue) {
            mue.printStackTrace();
        }
        catch (DAVException de) {
            this.status.setText(de.getMessage());
            System.out.println(de.getMessage());
            de.printStackTrace();
        }
        catch (RemoteException re) {
            System.out.println("RemoteException: " + re.getMessage());
            re.printStackTrace();
        }
    }

    public void miRefresh1_Action(ActionEvent e) {
        this.top = new DAVTreeNode(this.urlLoc, true, false, false);
        boolean addedNodes = this.top.populateCollections(this, true);
        if (addedNodes) {
            this.top.resName = this.top.fullName;
            this.dtModel.setRoot(this.top);
        }
    }

    public void miRefresh2_Action(ActionEvent e) {
        DAVTreeNode node = (DAVTreeNode)this.jTree.getLastSelectedPathComponent();
        TreePath selPath = this.jTree.getLeadSelectionPath();
        if (node == null) {
            this.top = new DAVTreeNode(this.urlLoc, true, false, false);
            boolean addedNodes = this.top.populateCollections(this, true);
            if (addedNodes) {
                this.top.resName = this.top.fullName;
                this.dtModel.setRoot(this.top);
            }
        } else {
            String loc = node.fullName;
            System.out.println(loc);
            node.setProperties(null);
            node.populated = false;
            node.interim = false;
            node.removeAllChildren();
            ((DefaultTreeModel)this.jTree.getModel()).nodeStructureChanged(node);
            ((DefaultTreeModel)this.jTree.getModel()).nodeChanged(node);
            this.valueChanged(null);
            node.populateCollections(this, false);
            this.jTree.collapsePath(selPath);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void miDelete_Action(ActionEvent e) {
        boolean doAll = false;
        boolean jumpOut = false;
        Object[] options = new Object[]{RB.getStringResource("DAVTree.yes.txt"), RB.getStringResource("DAVTree.yesall.txt"), RB.getStringResource("DAVTree.no.txt"), RB.getStringResource("DAVTree.cancel.txt")};
        TreePath[] selpaths = this.jTree.getSelectionPaths();
        int i = 0;
        while (i < selpaths.length) {
            if (jumpOut) {
                return;
            }
            DAVTreeNode node = (DAVTreeNode)selpaths[i].getLastPathComponent();
            try {
                DAVResource _resource = this.getDAVResource(node.fullName);
                int selval = !doAll ? JOptionPane.showOptionDialog(this, Message.format((ResourceBundle)RB.getResources(), (String)"DAVTree.delcheck.fmt.txt", (Object)_resource.getURL()), RB.getStringResource("DAVTree.confirmation.txt"), -1, 1, null, options, options[0]) : 1;
                doAll = selval == 1;
                switch (selval) {
                    case 0: 
                    case 1: {
                        _resource.delete();
                        System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"DAVTree.delstatus.fmt.txt", (Object)_resource.getURL(), (Object)_resource.getStatusCode()));
                        if (_resource.getStatusCode() != 204 && _resource.getStatusCode() != 200) break;
                        this.dtModel.removeNodeFromParent(node);
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        jumpOut = true;
                        break;
                    }
                }
            }
            catch (DAVException de) {
                this.status.setText(de.getMessage());
                System.out.println(de.getMessage());
                de.printStackTrace();
            }
            catch (RemoteException re) {
                System.out.println("RemoteException: " + re.getMessage());
                re.printStackTrace();
            }
            ++i;
        }
    }

    public void miLock_Action(ActionEvent e) {
        TreePath[] selpaths = this.jTree.getSelectionPaths();
        for (int i = 0; i < selpaths.length; ++i) {
            DAVTreeNode node = (DAVTreeNode)selpaths[i].getLastPathComponent();
            try {
                DAVResource r = this.getDAVResource(node.fullName);
                r.lock();
                if (r.getStatusCode() == 200) {
                    node.setLocked(true);
                    ((DefaultTreeModel)this.jTree.getModel()).nodeChanged(node);
                }
                this.status.setText(this.scformat(r.getStatusCode()));
                continue;
            }
            catch (DAVException de) {
                this.status.setText(de.getMessage());
                System.out.println(de.getMessage());
                de.printStackTrace();
                continue;
            }
            catch (RemoteException re) {
                System.out.println("RemoteException: " + re.getMessage());
                re.printStackTrace();
            }
        }
    }

    public void miUnlock_Action(ActionEvent e) {
        TreePath[] selpaths = this.jTree.getSelectionPaths();
        for (int i = 0; i < selpaths.length; ++i) {
            DAVTreeNode node = (DAVTreeNode)selpaths[i].getLastPathComponent();
            try {
                DAVResource r = this.getDAVResource(node.fullName);
                r.unlock();
                if (r.getStatusCode() == 200 || r.getStatusCode() == 204) {
                    node.setLocked(false);
                    ((DefaultTreeModel)this.jTree.getModel()).nodeChanged(node);
                }
                this.status.setText(this.scformat(r.getStatusCode()));
                continue;
            }
            catch (DAVException de) {
                this.status.setText(de.getMessage());
                System.out.println(de.getMessage());
                de.printStackTrace();
                continue;
            }
            catch (RemoteException re) {
                System.out.println("RemoteException: " + re.getMessage());
                re.printStackTrace();
            }
        }
    }

    public void miAdd_Action(ActionEvent e) {
        block18: {
            DAVTreeNode node = (DAVTreeNode)this.jTree.getLastSelectedPathComponent();
            if (node == null) {
                return;
            }
            try {
                DAVResource resource = this.getDAVResource(node.fullName);
                if (resource.isCollection()) {
                    Map setUpdates;
                    int selval = JOptionPane.showConfirmDialog(this, Message.format((ResourceBundle)RB.getResources(), (String)"DAVTree.addcheck.fmt.txt", (Object)resource.getURL()), RB.getStringResource("DAVTree.confirmation.txt"), 0, 1);
                    if (selval != 0) break block18;
                    AddDlg add_dlg = new AddDlg(this, true);
                    add_dlg.setVisible(true);
                    boolean isCollection = add_dlg.resourceType.equals("collection");
                    String newName = add_dlg.name.getText();
                    resource.setPath(Utils.addSegment(resource.getPath(), newName));
                    if (isCollection) {
                        resource.makeCollection();
                        if (resource.getStatusCode() != 201) {
                            this.status.setText(this.scformat(resource.getStatusCode()));
                        }
                    } else {
                        String content = add_dlg.content.getText();
                        if (content.length() == 0) {
                            content = "No content";
                        }
                        resource.setContents(content.getBytes());
                        if (resource.getStatusCode() != 201) {
                            this.status.setText(this.scformat(resource.getStatusCode()));
                        }
                    }
                    if (!(setUpdates = add_dlg.getSetUpdates()).isEmpty()) {
                        try {
                            for (Map.Entry me : setUpdates.entrySet()) {
                                PropName p = new PropName((String)me.getKey());
                                Element el = this.doc.createElementNS(p.getNS(), p.getName());
                                String propVal = (String)me.getValue();
                                if (!propVal.startsWith("<")) {
                                    Text t = this.doc.createTextNode(propVal);
                                    el.appendChild(t);
                                    resource.setProperty(el);
                                    continue;
                                }
                                boolean parseSuccessful = true;
                                Document _doc = null;
                                try {
                                    _doc = this.builder.parse(new ByteArrayInputStream((XMLHEADER + propVal).getBytes()));
                                }
                                catch (SAXException sex) {
                                    System.out.println(RB.getStringResource("DAVTree.invalidXMLprop.txt"));
                                    parseSuccessful = false;
                                }
                                if (!parseSuccessful) continue;
                                resource.setProperty(_doc.getDocumentElement());
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    node.populated = false;
                    node.removeAllChildren();
                    if (node.populateCollections(this, true)) {
                        ((DefaultTreeModel)this.jTree.getModel()).nodeStructureChanged(node);
                    }
                    break block18;
                }
                JOptionPane.showMessageDialog(this, Message.format((ResourceBundle)RB.getResources(), (String)"DAVTree.noaddhere.fmt.txt", (Object)resource.getURL()), RB.getStringResource("DAVTree.addresource.txt"), 0);
            }
            catch (DAVException de) {
                this.status.setText(de.getMessage());
                System.out.println(de.getMessage());
                de.printStackTrace();
            }
            catch (RemoteException re) {
                System.out.println("RemoteException: " + re.getMessage());
                re.printStackTrace();
            }
        }
    }

    public void miModify_Action(ActionEvent e) {
        DAVTreeNode node = (DAVTreeNode)this.jTree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        int selval = JOptionPane.showConfirmDialog(this, Message.format((ResourceBundle)RB.getResources(), (String)"DAVTree.modcheck.fmt.txt", (Object)node.fullName), RB.getStringResource("DAVTree.confirmation.txt"), 0, 1);
        if (selval == 0) {
            ModDlg moddlg = new ModDlg(this, node.getProperties(), true);
            moddlg.setVisible(true);
            Map setUpdates = moddlg.getSetUpdates();
            Vector delUpdates = moddlg.getDelUpdates();
            if (!setUpdates.isEmpty() || !delUpdates.isEmpty()) {
                try {
                    Element el;
                    PropName p;
                    DAVResource _resource = this.getDAVResource(node.fullName);
                    for (Map.Entry me : setUpdates.entrySet()) {
                        p = new PropName((String)me.getKey());
                        el = this.doc.createElementNS(p.getNS(), p.getName());
                        String propVal = (String)me.getValue();
                        if (!propVal.startsWith("<")) {
                            Text t = this.doc.createTextNode(propVal);
                            el.appendChild(t);
                            _resource.setProperty(el);
                            continue;
                        }
                        boolean parseSuccessful = true;
                        Document _doc = null;
                        try {
                            _doc = this.builder.parse(new ByteArrayInputStream((XMLHEADER + propVal).getBytes()));
                        }
                        catch (SAXException sex) {
                            System.out.println(RB.getStringResource("DAVTree.invalidXMLprop.txt"));
                            parseSuccessful = false;
                        }
                        if (!parseSuccessful) continue;
                        _resource.setProperty(_doc.getDocumentElement());
                    }
                    for (int i = 0; i < delUpdates.size(); ++i) {
                        p = new PropName((String)delUpdates.get(i));
                        el = this.doc.createElementNS(p.getNS(), p.getName());
                        _resource.removeProperty(el);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                node.setProperties(this.getProperties(node.fullName));
                this.setupVectors(node.getProperties());
                ((AbstractTableModel)this.tbModel).fireTableDataChanged();
                DocumentFragment docfrg = this.doc.createDocumentFragment();
                Iterator<Element> props = node.getProperties().values().iterator();
                while (props.hasNext()) {
                    Node n = this.doc.importNode(props.next(), true);
                    docfrg.appendChild(n);
                }
                this.domTree.setRoot(docfrg);
            }
        }
    }

    private void copySubTree(File dir, DAVResource target) {
        try {
            String subdirPath = target.getPath();
            target.makeCollection();
            File[] ff = dir.listFiles();
            for (int i = 0; i < ff.length; ++i) {
                String newPath = Utils.addSegment(subdirPath, ff[i].getName());
                target.setPath(newPath);
                if (ff[i].isDirectory()) {
                    this.copySubTree(ff[i], target);
                    continue;
                }
                try {
                    target.setContents(new FileInputStream(ff[i]));
                    continue;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
        }
        catch (DAVException e) {
            this.status.setText(e.getMessage());
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    private String stripTrailingSlashes(String s) {
        StringBuilder buffer = new StringBuilder(s);
        int len = buffer.length();
        for (int i = len - 1; i >= 0 && buffer.charAt(i) == '/'; --i) {
            buffer.setLength(i);
        }
        return buffer.toString();
    }

    private URI getURI(String uri) {
        String scheme = null;
        String hostport = null;
        String host = null;
        String path = null;
        int port = -1;
        int p1 = uri.indexOf("://");
        if (p1 > -1) {
            scheme = uri.substring(0, p1);
            int p2 = uri.indexOf("/", p1 + 3);
            if (p2 > -1) {
                hostport = uri.substring(p1 + 3, p2);
                if ((p1 = hostport.indexOf(":")) > -1) {
                    host = hostport.substring(0, p1);
                    port = Integer.parseInt(hostport.substring(p1 + 1));
                } else {
                    host = hostport;
                    port = scheme.equalsIgnoreCase("http") ? 80 : (scheme.equalsIgnoreCase("https") ? 443 : -1);
                }
                path = uri.substring(p2);
            }
        }
        try {
            return new URI(scheme, null, host, port, path, null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URI - uri");
        }
    }

    public void miEdit_Action(ActionEvent e) {
        TreePath[] selpaths = this.jTree.getSelectionPaths();
        for (int i = 0; i < selpaths.length; ++i) {
            DAVTreeNode node = (DAVTreeNode)selpaths[i].getLastPathComponent();
            DAVResource _resource = this.getDAVResource(node.fullName);
            Element element = node.getProperties().get("D:getcontenttype");
            String mimeType = null;
            if (element != null) {
                mimeType = element.getFirstChild().getNodeValue();
            }
            EditDlg edit_dlg = new EditDlg(this, true, _resource, mimeType);
            edit_dlg.setVisible(true);
        }
    }

    private static JButton newButtonCancel() {
        return DAVTree.newButton(RB.getStringResource("DAVTree.cancel.label"));
    }

    private static JButton newButtonOK() {
        return DAVTree.newButton(RB.getStringResource("DAVTree.ok.label"));
    }

    private static JButton newButton(String label) {
        int index = Util.getDisplayedMnemonicIndex((String)label);
        JButton button = new JButton(Util.getLabelWithoutMnemonic((String)label));
        if (-1 < index) {
            button.setMnemonic(Util.getDisplayedMnemonic((String)label));
            button.setDisplayedMnemonicIndex(index);
        }
        return button;
    }

    static {
        COLOR_TABLE_BACKGROUND = Color.WHITE;
        COLOR_TREE_BACKGROUND = Color.WHITE;
        COLOR_TREE_SELECTION = COLOR_TREE_BACKGROUND.darker();
        COLOR_TABLE_FOREGROUND = Color.BLUE;
        COLOR_TREE_FOREGROUND = Color.BLUE;
        COLOR_TABLE_BACKGROUND_COLUMN1 = new Color(248, 248, 248);
        COLOR_TABLE_FOREGROUND_COLUMN1 = Color.BLUE;
        treeFont = new Font("SanSerif", 0, 11);
        tableFont = new Font("SanSerif", 0, 11);
        tableFontBold = new Font("SanSerif", 1, 11);
        DIALOG_FONT = new Font("SanSerif", 0, 11);
        DEBUG = false;
        tmpdir = System.getProperty("java.io.tmpdir");
        NAMESPACE_DAV = Namespace.getNamespace((String)"D", (String)"DAV:");
        try {
            FileInputStream fin = new FileInputStream("DAVTree.properties");
            properties.load(fin);
            String p = null;
            p = (String)properties.get(P_WINDOWHEIGHT);
            if (p != null) {
                FRAME_WIDTH = Integer.parseInt((String)properties.get(P_WINDOWHEIGHT));
            }
            if ((p = (String)properties.get(P_WINDOWWIDTH)) != null) {
                FRAME_WIDTH = Integer.parseInt((String)properties.get(P_WINDOWWIDTH));
            }
            if ((p = (String)properties.get(P_WINDOWHEIGHT)) != null) {
                FRAME_HEIGHT = Integer.parseInt((String)properties.get(P_WINDOWHEIGHT));
            }
            if ((p = (String)properties.get(P_TBBC)) != null) {
                COLOR_TABLE_BACKGROUND = DAVTree.ColorFromRGB((String)properties.get(P_TBBC));
            }
            if ((p = (String)properties.get(P_TBFC)) != null) {
                COLOR_TABLE_FOREGROUND = DAVTree.ColorFromRGB((String)properties.get(P_TBFC));
            }
            if ((p = (String)properties.get(P_TRBC)) != null) {
                COLOR_TREE_BACKGROUND = DAVTree.ColorFromRGB((String)properties.get(P_TRBC));
            }
            if ((p = (String)properties.get(P_TRFC)) != null) {
                COLOR_TREE_FOREGROUND = DAVTree.ColorFromRGB((String)properties.get(P_TRFC));
            }
            if ((p = (String)properties.get(P_TBBCC1)) != null) {
                COLOR_TABLE_BACKGROUND_COLUMN1 = DAVTree.ColorFromRGB((String)properties.get(P_TBBCC1));
            }
            if ((p = (String)properties.get(P_TBFCC1)) != null) {
                COLOR_TABLE_FOREGROUND_COLUMN1 = DAVTree.ColorFromRGB((String)properties.get(P_TBFCC1));
            }
            proxyHost = (String)properties.get(PROXYHOST);
            proxyPort = (String)properties.get(PROXYPORT);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public class HistoryComboBox
    extends JComboBox<String> {
        private static final long serialVersionUID = 3616726084629114935L;
        public static final int MAX_MEM_LEN = 10;

        public HistoryComboBox() {
            this.setEditable(true);
            this.setFont(DIALOG_FONT);
            this.setMinimumSize(new Dimension(500, 10));
        }

        public void add(String item) {
            this.removeItem(item);
            this.insertItemAt(item, 0);
            this.setSelectedItem(item);
            if (this.getItemCount() > 10) {
                this.removeItemAt(this.getItemCount() - 1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void load(String fName) {
            BufferedReader fRdr = null;
            try {
                String urlEntry;
                File f;
                if (this.getItemCount() > 0) {
                    this.removeAllItems();
                }
                if (!(f = new File(fName)).exists()) {
                    return;
                }
                fRdr = new BufferedReader(new FileReader(fName));
                while ((urlEntry = fRdr.readLine()) != null) {
                    this.addItem(urlEntry);
                }
            }
            catch (IOException iOException) {
            }
            finally {
                if (fRdr != null) {
                    try {
                        fRdr.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void save(String fName) {
            BufferedWriter fWtr = null;
            try {
                fWtr = new BufferedWriter(new FileWriter(fName));
                for (int i = 0; i < this.getItemCount(); ++i) {
                    fWtr.write((String)this.getItemAt(i));
                    fWtr.newLine();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println(Message.format((ResourceBundle)RB.getResources(), (String)"DAVResource.serialerr.fmt.txt", (Object)e.toString()));
            }
            finally {
                if (fWtr != null) {
                    try {
                        fWtr.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    class DAVTreeModel
    extends DefaultTreeModel {
        private static final long serialVersionUID = -6524438859108119734L;

        public DAVTreeModel(TreeNode node) {
            super(node);
        }

        public DAVTreeModel(TreeNode node, boolean asksAllowsChildren) {
            super(node, asksAllowsChildren);
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
            DAVTreeNode node = (DAVTreeNode)path.getLastPathComponent();
            node.setNewName((String)newValue);
            super.valueForPathChanged(path, newValue);
        }
    }

    protected class TreeExpansionHandler
    implements TreeExpansionListener {
        protected TreeExpansionHandler() {
        }

        @Override
        public void treeExpanded(TreeExpansionEvent evt) {
            TreePath path = evt.getPath();
            JTree tree = (JTree)evt.getSource();
            DAVTreeNode node = (DAVTreeNode)path.getLastPathComponent();
            if (node.populateCollections(DAVTree.this, true)) {
                ((DefaultTreeModel)tree.getModel()).nodeStructureChanged(node);
            }
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent evt) {
        }
    }

    protected class CustomTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 3256720671764983860L;

        protected CustomTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            this.setToolTipText((String)resNSVector.elementAt(row));
            return c;
        }
    }

    protected class CustomBasicRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 3256725099926009398L;
        Font fontPlain = new Font("SanSerif", 0, 11);
        Font fontBold = new Font("SanSerif", 1, 11);

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component c = super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (c instanceof JLabel) {
                JLabel l = (JLabel)c;
                l.setBackground(COLOR_TREE_BACKGROUND);
                l.setForeground(COLOR_TREE_FOREGROUND);
            }
            if (value instanceof DAVTreeNode) {
                boolean isLocked = ((DAVTreeNode)value).isLocked;
                if (((DAVTreeNode)value).isCollection) {
                    if (isLocked) {
                        this.setIcon(DAVTree.this.lockedColImage);
                    }
                    this.setFont(this.fontBold);
                } else {
                    boolean isCheckedOut = ((DAVTreeNode)value).isCheckedOut;
                    this.setIcon(DAVTree.this.resImage);
                    if (isCheckedOut) {
                        if (isLocked) {
                            this.setIcon(DAVTree.this.lockedCheckedOutResImage);
                        } else {
                            this.setIcon(DAVTree.this.checkedOutResImage);
                        }
                    } else if (isLocked) {
                        this.setIcon(DAVTree.this.lockedResImage);
                    }
                    this.setFont(this.fontPlain);
                }
            }
            return c;
        }
    }

    private class ProcessActions
    implements ActionListener {
        private ProcessActions() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DAVTree.this.status.setText(">");
            Object object = e.getSource();
            if (object == DAVTree.this.miOpen) {
                DAVTree.this.miOpen_Action(e);
            } else if (object == DAVTree.this.miContents) {
                DAVTree.this.miContents_Action(e);
            } else if (object == DAVTree.this.miExit) {
                DAVTree.this.miExit_Action(e);
            } else if (object == DAVTree.this.miDelete) {
                DAVTree.this.miDelete_Action(e);
            } else if (object == DAVTree.this.miAdd) {
                DAVTree.this.miAdd_Action(e);
            } else if (object == DAVTree.this.miModify) {
                DAVTree.this.miModify_Action(e);
            } else if (object == DAVTree.this.miEdit) {
                DAVTree.this.miEdit_Action(e);
            } else if (object == DAVTree.this.miRefresh1) {
                DAVTree.this.miRefresh1_Action(e);
            } else if (object == DAVTree.this.miRefresh2) {
                DAVTree.this.miRefresh2_Action(e);
            } else if (object == DAVTree.this.miCopyClipboard) {
                DAVTree.this.miCopyClipboard_Action(e);
            } else if (object == DAVTree.this.miDetails) {
                DAVTree.this.miDetails_Action(e);
            } else if (object == DAVTree.this.miVersion) {
                DAVTree.this.miVersion_Action(e);
            } else if (object == DAVTree.this.miCheckout) {
                DAVTree.this.miCheckout_Action(e);
            } else if (object == DAVTree.this.miCheckin) {
                DAVTree.this.miCheckin_Action(e);
            } else if (object == DAVTree.this.miUncheckout) {
                DAVTree.this.miUncheckout_Action(e);
            } else if (object == DAVTree.this.miVHReport) {
                DAVTree.this.miVHReport_Action(e);
            } else if (object == DAVTree.this.miLock) {
                DAVTree.this.miLock_Action(e);
            } else if (object == DAVTree.this.miUnlock) {
                DAVTree.this.miUnlock_Action(e);
            } else if (object == DAVTree.this.miUserPriv) {
                DAVTree.this.miUserPriv_Action(e);
            } else if (object == DAVTree.this.miPCS) {
                DAVTree.this.miPCS_Action(e);
            } else if (object == DAVTree.this.miSPS) {
                DAVTree.this.miSupportedPriv_Action(e);
            }
        }
    }

    public class CredentialsDlg
    extends JDialog {
        private static final long serialVersionUID = 3904960871745466423L;
        private JTextField _userIdTextField;
        private JPasswordField _passwordTextField;

        public CredentialsDlg(Frame owner, boolean modal) {
            super(owner, modal);
            this._userIdTextField = new JTextField(20);
            this._passwordTextField = new JPasswordField(20);
            this.setTitle(RB.getStringResource("DAVTree.crendentials.title"));
            String usrLabelWithMnemonic = RB.getStringResource("DAVTree.user.field.label");
            JLabel usrLabel = new JLabel(Util.getLabelWithoutMnemonic((String)usrLabelWithMnemonic));
            int index = Util.getDisplayedMnemonicIndex((String)usrLabelWithMnemonic);
            if (-1 < index) {
                int mnemonic = Util.getDisplayedMnemonic((String)usrLabelWithMnemonic);
                usrLabel.setDisplayedMnemonic(mnemonic);
                usrLabel.setDisplayedMnemonicIndex(index);
            }
            usrLabel.setLabelFor(this._userIdTextField);
            String pwLabelWithMnemonic = RB.getStringResource("DAVTree.pw.field.label");
            JLabel pwdLabel = new JLabel(Util.getLabelWithoutMnemonic((String)pwLabelWithMnemonic));
            int indexPw = Util.getDisplayedMnemonicIndex((String)pwLabelWithMnemonic);
            if (-1 < indexPw) {
                int mnemonic = Util.getDisplayedMnemonic((String)pwLabelWithMnemonic);
                pwdLabel.setDisplayedMnemonic(mnemonic);
                pwdLabel.setDisplayedMnemonicIndex(indexPw);
            }
            pwdLabel.setLabelFor(this._passwordTextField);
            Point topLeft = owner.getLocation();
            this.setLocation(topLeft.x + 20, topLeft.y + 50);
            this.getContentPane().setLayout(new BorderLayout());
            JPanel fieldsPanel = new JPanel();
            GridBagLayout gbl = new GridBagLayout();
            fieldsPanel.setLayout(gbl);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = new Insets(5, 5, 5, 5);
            gbc.fill = 2;
            gbc.weightx = 0.0;
            gbc.anchor = 17;
            gbc.gridwidth = -1;
            gbl.setConstraints(usrLabel, gbc);
            fieldsPanel.add(usrLabel);
            gbc.gridwidth = 0;
            gbc.weightx = 1.0;
            gbl.setConstraints(this._userIdTextField, gbc);
            fieldsPanel.add(this._userIdTextField);
            gbc.gridwidth = -1;
            gbc.weightx = 0.0;
            gbc.weighty = 1.0;
            gbl.setConstraints(pwdLabel, gbc);
            fieldsPanel.add(pwdLabel);
            gbc.gridwidth = 0;
            gbc.weightx = 1.0;
            gbl.setConstraints(this._passwordTextField, gbc);
            fieldsPanel.add(this._passwordTextField);
            this.getContentPane().add((Component)fieldsPanel, "Center");
            JPanel buttonsPanel = new JPanel();
            final JButton okButton = DAVTree.newButtonOK();
            JButton cancelButton = DAVTree.newButtonCancel();
            buttonsPanel.add(okButton);
            buttonsPanel.add(cancelButton);
            this.getContentPane().add((Component)buttonsPanel, "South");
            this.getRootPane().setDefaultButton(okButton);
            okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String userId = CredentialsDlg.this._userIdTextField.getText();
                    if (null != userId && !userId.isEmpty()) {
                        DAVTree.this._userid = userId;
                        DAVTree.this._password = new String(CredentialsDlg.this._passwordTextField.getPassword());
                        CredentialsDlg.this.dispose();
                    }
                }
            });
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CredentialsDlg.this.dispose();
                }
            });
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent evt) {
                    okButton.requestFocus();
                }
            });
        }
    }

    public class ResponseDlg
    extends JDialog {
        private static final long serialVersionUID = 5158395990248870192L;
        private JButton okButton;
        private JButton cancelButton;
        PropertyPanel pPanel;
        JTextArea txt;

        public ResponseDlg(Frame owner, String title, String text, boolean modal) {
            super(owner, title, modal);
            this.okButton = DAVTree.newButtonOK();
            this.cancelButton = DAVTree.newButtonCancel();
            this.txt = new JTextArea();
            this.txt.setText(text);
            JScrollPane sp = new JScrollPane(this.txt);
            JPanel buttonsPanel = new JPanel();
            buttonsPanel.setLayout(new FlowLayout());
            buttonsPanel.add(this.okButton);
            buttonsPanel.add(this.cancelButton);
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)sp, "Center");
            this.getContentPane().add((Component)buttonsPanel, "South");
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ResponseDlg.this.dispose();
                }
            });
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ResponseDlg.this.dispose();
                }
            });
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent evt) {
                    ResponseDlg.this.okButton.requestFocus();
                }
            });
            this.pack();
            int centredX = owner.getX() + (owner.getWidth() - this.getWidth()) / 2;
            int centredY = owner.getY() + (owner.getHeight() - this.getHeight()) / 2;
            this.setLocation(centredX, centredY);
        }

        public Map getSetUpdates() {
            return this.pPanel.getSetUpdates();
        }

        public Vector getDelUpdates() {
            return this.pPanel.getDelUpdates();
        }
    }

    public class OpenDlg
    extends JDialog {
        private static final long serialVersionUID = 3257572810405524280L;
        private JTextField _proxyHostTextField;
        private JTextField _proxyPortTextField;

        public OpenDlg(Frame owner, String title, String message) {
            super(owner, title, true);
            this._proxyHostTextField = new JTextField();
            this._proxyPortTextField = new JTextField();
            Point topLeft = owner.getLocation();
            this.setLocation(topLeft.x + 20, topLeft.y + 50);
            JButton okButton = DAVTree.newButtonOK();
            JButton cancelButton = DAVTree.newButtonCancel();
            this.getContentPane().setLayout(new BorderLayout());
            if (proxyHost != null && proxyPort != null) {
                this._proxyHostTextField.setText(proxyHost);
                this._proxyPortTextField.setText(proxyPort);
            }
            JPanel fieldsPanel = new JPanel();
            GridBagLayout gbl = new GridBagLayout();
            fieldsPanel.setLayout(gbl);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = new Insets(5, 5, 5, 5);
            gbc.fill = 2;
            gbc.weightx = 0.0;
            gbc.anchor = 17;
            gbc.gridwidth = -1;
            String urlLabelWithMnemonic = RB.getStringResource("DAVTree.url.field.label");
            JLabel urlLabel = new JLabel(Util.getLabelWithoutMnemonic((String)urlLabelWithMnemonic));
            int index = Util.getDisplayedMnemonicIndex((String)urlLabelWithMnemonic);
            if (-1 < index) {
                int mnemonic = Util.getDisplayedMnemonic((String)urlLabelWithMnemonic);
                urlLabel.setDisplayedMnemonic(mnemonic);
                urlLabel.setDisplayedMnemonicIndex(index);
            }
            urlLabel.setLabelFor(DAVTree.this.hCombo);
            gbl.setConstraints(urlLabel, gbc);
            fieldsPanel.add(urlLabel);
            gbc.gridwidth = 0;
            gbc.weightx = 1.0;
            gbl.setConstraints(DAVTree.this.hCombo, gbc);
            fieldsPanel.add(DAVTree.this.hCombo);
            gbc.gridwidth = -1;
            gbc.weightx = 0.0;
            String proxyHostLabelWithMnemonic = RB.getStringResource("DAVTree.proxyhost.field.label");
            JLabel proxyHostLabel = new JLabel(Util.getLabelWithoutMnemonic((String)proxyHostLabelWithMnemonic));
            index = Util.getDisplayedMnemonicIndex((String)proxyHostLabelWithMnemonic);
            if (-1 < index) {
                int mnemonic = Util.getDisplayedMnemonic((String)proxyHostLabelWithMnemonic);
                proxyHostLabel.setDisplayedMnemonic(mnemonic);
                proxyHostLabel.setDisplayedMnemonicIndex(index);
            }
            proxyHostLabel.setLabelFor(this._proxyHostTextField);
            gbl.setConstraints(proxyHostLabel, gbc);
            fieldsPanel.add(proxyHostLabel);
            gbc.gridwidth = 0;
            gbc.weightx = 1.0;
            gbl.setConstraints(this._proxyHostTextField, gbc);
            fieldsPanel.add(this._proxyHostTextField);
            gbc.gridwidth = -1;
            gbc.weightx = 0.0;
            String portLabelWithMnemonic = RB.getStringResource("DAVTree.proxyport.field.label");
            JLabel proxyPortLabel = new JLabel(Util.getLabelWithoutMnemonic((String)portLabelWithMnemonic));
            index = Util.getDisplayedMnemonicIndex((String)portLabelWithMnemonic);
            if (-1 < index) {
                int mnemonic = Util.getDisplayedMnemonic((String)portLabelWithMnemonic);
                proxyPortLabel.setDisplayedMnemonic(mnemonic);
                proxyPortLabel.setDisplayedMnemonicIndex(index);
            }
            proxyPortLabel.setLabelFor(this._proxyPortTextField);
            gbl.setConstraints(proxyPortLabel, gbc);
            fieldsPanel.add(proxyPortLabel);
            gbc.gridwidth = 0;
            gbc.weightx = 1.0;
            gbl.setConstraints(this._proxyPortTextField, gbc);
            fieldsPanel.add(this._proxyPortTextField);
            this.getContentPane().add((Component)fieldsPanel, "Center");
            JPanel buttonsPanel = new JPanel();
            buttonsPanel.add(okButton);
            buttonsPanel.add(cancelButton);
            this.getContentPane().add((Component)buttonsPanel, "South");
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OpenDlg.this.dispose();
                }
            });
            okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String pp;
                    String newUrl = (String)DAVTree.this.hCombo.getSelectedItem();
                    String ph = OpenDlg.this._proxyHostTextField.getText().trim();
                    if (!ph.isEmpty()) {
                        proxyHost = ph;
                    }
                    if (!(pp = OpenDlg.this._proxyPortTextField.getText().trim()).isEmpty()) {
                        proxyPort = pp;
                    }
                    try {
                        new URL(newUrl);
                    }
                    catch (MalformedURLException ex) {
                        JOptionPane.showMessageDialog(null, ex.getLocalizedMessage(), RB.getStringResource("DAVTree.errortitle.txt"), 0);
                        DAVTree.this.status.setText(Message.format((ResourceBundle)RB.getResources(), (String)"DAVTree.badurl.fmt.txt", (Object)newUrl, (Object)ex.getMessage()));
                        return;
                    }
                    DAVTree.this.hCombo.add(newUrl);
                    DAVTree.this.urlLoc = newUrl;
                    OpenDlg.this.dispose();
                }
            });
            this.pack();
        }
    }

    public class HexDisplayDlg
    extends JDialog {
        private static final long serialVersionUID = 3616732694617536056L;

        public HexDisplayDlg(Frame owner, String title, byte[] message) {
            super(owner, title, true);
            int DIALOG_WIDTH = 500;
            Font font = new Font("Monospaced", 0, 12);
            JTextArea txt = message != null ? new JTextArea(Utils.bytesToHex(message)) : new JTextArea(RB.getStringResource("DAVTree.nocontent.txt"));
            txt.setFont(font);
            JScrollPane txtpane = new JScrollPane(txt);
            this.getContentPane().add(txtpane);
            this.setSize(500, 600);
            this.setLocation((DAVTree.this.screenWidth - DIALOG_WIDTH) / 2, this.getLocation().y);
            txt.setCaretPosition(0);
            txt.setEditable(false);
        }
    }

    public class AddDlg
    extends JDialog {
        private static final long serialVersionUID = 3256719593694049846L;
        private JButton okButton;
        private JButton cancelButton;
        String resourceType;
        Map origNV;
        PropertyPanel pPanel;
        JTextField name;
        JTextArea content;
        ButtonGroup rescollRadio;
        JRadioButton resButton;
        JRadioButton collButton;
        JPanel hdrPanel;

        public AddDlg(Frame owner, boolean modal) {
            super(owner, modal);
            this.okButton = DAVTree.newButtonOK();
            this.cancelButton = DAVTree.newButtonCancel();
            this.resourceType = "collection";
            this.origNV = new HashMap();
            this.name = new JTextField(20);
            this.content = new JTextArea();
            this.rescollRadio = new ButtonGroup();
            this.resButton = new JRadioButton(RB.getStringResource("DAVTree.resource.txt"));
            this.collButton = new JRadioButton(RB.getStringResource("DAVTree.collection.txt"));
            this.resButton.setActionCommand("resource");
            this.collButton.setActionCommand("collection");
            this.collButton.setSelected(true);
            this.rescollRadio.add(this.resButton);
            this.rescollRadio.add(this.collButton);
            this.hdrPanel = new JPanel();
            JPanel radioPanel = new JPanel();
            this.hdrPanel.setLayout(new BorderLayout());
            this.hdrPanel.add((Component)this.name, "Center");
            radioPanel.setLayout(new GridLayout(2, 1));
            radioPanel.add(this.resButton);
            radioPanel.add(this.collButton);
            RadioListener myListener = new RadioListener();
            this.resButton.addActionListener(myListener);
            this.collButton.addActionListener(myListener);
            this.hdrPanel.add((Component)radioPanel, "East");
            this.hdrPanel.add((Component)this.content, "South");
            JPanel buttonsPanel = new JPanel();
            this.pPanel = new PropertyPanel(this.origNV);
            buttonsPanel.setLayout(new FlowLayout());
            buttonsPanel.add(this.okButton);
            buttonsPanel.add(this.cancelButton);
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)this.hdrPanel, "North");
            this.getContentPane().add((Component)this.pPanel, "Center");
            this.getContentPane().add((Component)buttonsPanel, "South");
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AddDlg.this.dispose();
                }
            });
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AddDlg.this.dispose();
                }
            });
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent evt) {
                    AddDlg.this.okButton.requestFocus();
                }
            });
            this.pack();
            int centredX = owner.getX() + (owner.getWidth() - this.getWidth()) / 2;
            this.setLocation(centredX, owner.getY() + 50);
        }

        public Map getSetUpdates() {
            return this.pPanel.getSetUpdates();
        }

        class RadioListener
        implements ActionListener {
            RadioListener() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == AddDlg.this.resButton) {
                    AddDlg.this.content.setEnabled(true);
                    AddDlg.this.resourceType = "resource";
                }
            }
        }
    }

    public class PropName {
        String ns;
        String name;

        public PropName(String pname) {
            int p2 = pname.indexOf(125);
            if (p2 > 0) {
                this.name = pname.substring(p2 + 1);
                this.ns = pname.substring(1, p2);
            } else {
                this.name = pname;
                this.ns = "";
            }
        }

        public String getName() {
            return this.name;
        }

        public String getNS() {
            return this.ns;
        }
    }

    public class ModDlg
    extends JDialog {
        private static final long serialVersionUID = 3689065140692005687L;
        private JButton okButton;
        private JButton cancelButton;
        PropertyPanel pPanel;
        Map origNV;

        public ModDlg(Frame owner, TreeMap propsMap, boolean modal) {
            super(owner, modal);
            this.okButton = DAVTree.newButtonOK();
            this.cancelButton = DAVTree.newButtonCancel();
            this.origNV = new HashMap();
            for (Map.Entry me : propsMap.entrySet()) {
                Node n;
                Element element = (Element)me.getValue();
                String aname = element.getLocalName();
                String ns = element.getNamespaceURI();
                String avalue = null;
                if (element.hasChildNodes() && (n = element.getFirstChild()).getNodeType() == 3 && n == element.getLastChild()) {
                    avalue = n.getNodeValue();
                }
                if (avalue == null) {
                    avalue = XMLUtil.convertNodeToString((Node)element, true);
                }
                avalue = avalue.replace('\r', ' ');
                avalue = avalue.replace('\n', ' ');
                if (ns == null) {
                    this.origNV.put(aname, avalue);
                    continue;
                }
                this.origNV.put('{' + ns + '}' + aname, avalue);
            }
            JPanel buttonsPanel = new JPanel();
            this.pPanel = new PropertyPanel(this.origNV);
            buttonsPanel.setLayout(new FlowLayout());
            buttonsPanel.add(this.okButton);
            buttonsPanel.add(this.cancelButton);
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)this.pPanel, "Center");
            this.getContentPane().add((Component)buttonsPanel, "South");
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ModDlg.this.dispose();
                }
            });
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ModDlg.this.dispose();
                }
            });
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent evt) {
                    ModDlg.this.okButton.requestFocus();
                }
            });
            this.pack();
            int centredX = owner.getX() + (owner.getWidth() - this.getWidth()) / 2;
            this.setLocation(centredX, owner.getY() + 50);
        }

        public Map getSetUpdates() {
            return this.pPanel.getSetUpdates();
        }

        public Vector getDelUpdates() {
            return this.pPanel.getDelUpdates();
        }
    }

    public class EditDlg
    extends JDialog {
        private static final long serialVersionUID = 3256719593694049846L;
        private JButton saveButton;
        private JButton cancelButton;
        private JTextArea editorArea;

        public EditDlg(Frame owner, boolean modal, final DAVResource resource, final String mimeType) {
            super(owner, modal);
            this.saveButton = DAVTree.newButtonOK();
            this.cancelButton = DAVTree.newButtonCancel();
            this.editorArea = new JTextArea();
            this.getContentPane().setLayout(new BorderLayout());
            JPanel buttonPanel = new JPanel();
            buttonPanel.add(this.saveButton);
            buttonPanel.add(this.cancelButton);
            this.saveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        resource.setContentType(mimeType);
                        resource.setContents(EditDlg.this.editorArea.getText());
                    }
                    catch (RemoteException e1) {
                        e1.printStackTrace();
                    }
                    catch (DAVException e1) {
                        DAVTree.this.status.setText(e1.getMessage());
                        e1.printStackTrace();
                    }
                    EditDlg.this.dispose();
                }
            });
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditDlg.this.dispose();
                }
            });
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent evt) {
                    EditDlg.this.saveButton.requestFocus();
                }
            });
            try {
                this.editorArea.setText(resource.getContentsAsString());
            }
            catch (RemoteException e1) {
                e1.printStackTrace();
            }
            catch (DAVException e1) {
                DAVTree.this.status.setText(e1.getMessage());
                e1.printStackTrace();
            }
            JScrollPane editorScrollPane = new JScrollPane(this.editorArea);
            this.getContentPane().add((Component)buttonPanel, "South");
            this.getContentPane().add((Component)editorScrollPane, "Center");
            this.pack();
            this.setSize(owner.getSize());
            int centredX = owner.getX() + (owner.getWidth() - this.getWidth()) / 2;
            this.setLocation(centredX + 20, owner.getY() - 20);
            this.setTitle(RB.getStringResource("DAVTree.editfile.txt"));
        }
    }

    private class WebDAVTransferable
    implements Transferable,
    ClipboardOwner {
        private DataFlavor resourceFlavor = new DataFlavor(DAVTreeNode.class, "DAVTree.Resource");
        private DataFlavor[] flavors = new DataFlavor[]{this.resourceFlavor, DataFlavor.javaFileListFlavor};
        private List flavorList = Arrays.asList(this.flavors);
        transient Object m_obj;

        public WebDAVTransferable(DAVTreeNode node) {
            this.m_obj = node;
        }

        @Override
        public synchronized DataFlavor[] getTransferDataFlavors() {
            return this.flavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor df) {
            boolean isOK = false;
            isOK = this.flavorList.contains(df);
            return isOK;
        }

        @Override
        public void lostOwnership(Clipboard c, Transferable t) {
            this.m_obj = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized Object getTransferData(DataFlavor df) throws UnsupportedFlavorException, IOException {
            if (df.equals(this.resourceFlavor)) {
                return this.m_obj;
            }
            if (df.equals(DataFlavor.javaFileListFlavor)) {
                if (DAVTree.this.dndFile == null) {
                    byte[] buffer = new byte[8192];
                    DAVTree.this.dndFile = new File(tmpdir + File.separator + ((DAVTreeNode)this.m_obj).resName);
                    DAVTree.this.dndFile.deleteOnExit();
                    OutputStream os = null;
                    InputStream is = null;
                    try {
                        int len;
                        DAVResource r = DAVTree.this.getDAVResource(((DAVTreeNode)this.m_obj).fullName);
                        os = new FileOutputStream(DAVTree.this.dndFile);
                        is = r.getContentsInputStream();
                        while ((len = is.read(buffer, 0, buffer.length)) != -1) {
                            os.write(buffer, 0, len);
                        }
                    }
                    catch (DAVException e) {
                        Object var6_10 = null;
                        return var6_10;
                    }
                    finally {
                        if (os != null) {
                            try {
                                os.close();
                            }
                            catch (IOException iOException) {}
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (IOException iOException) {}
                            }
                        }
                    }
                    DAVTree.this.inDragDrop = true;
                }
                ArrayList<File> l = new ArrayList<File>();
                l.add(DAVTree.this.dndFile);
                return l;
            }
            return null;
        }
    }

    private class DNDTree
    extends JTree
    implements DropTargetListener,
    DragSourceListener,
    DragGestureListener {
        private static final long serialVersionUID = 3689916149890430517L;
        protected DragSource m_dragSource;
        protected DropTarget m_dropTarget;
        protected boolean m_drag;
        protected boolean m_drop;

        public DNDTree(TreeModel model, boolean drag, boolean drop) {
            super(model);
            this.Init(drag, drop);
        }

        private final void Init(boolean drag, boolean drop) {
            this.m_drag = drag;
            this.m_drop = drop;
            if (this.m_drag) {
                this.m_dragSource = new DragSource();
                this.m_dragSource.createDefaultDragGestureRecognizer(this, 3, this);
            }
            this.m_dropTarget = new DropTarget(this, this);
        }

        @Override
        public void dragEnter(DropTargetDragEvent event) {
            if (this.m_drop) {
                event.acceptDrag(event.getDropAction());
            } else {
                event.rejectDrag();
            }
        }

        @Override
        public void dragExit(DropTargetEvent event) {
        }

        @Override
        public void dragOver(DropTargetDragEvent event) {
            int x = event.getLocation().x;
            int y = event.getLocation().y;
            TreePath path = this.getPathForLocation(x, y);
            if (path != null) {
                DAVTreeNode xx = (DAVTreeNode)path.getLastPathComponent();
                if (xx.isCollection) {
                    event.acceptDrag(event.getDropAction());
                } else {
                    event.rejectDrag();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void drop(DropTargetDropEvent event) {
            if ((event.getSourceActions() & 3) == 0) {
                event.rejectDrop();
                return;
            }
            event.acceptDrop(event.getDropAction());
            Transferable transferable = event.getTransferable();
            DataFlavor[] flavors = event.getCurrentDataFlavors();
            for (int i = 0; i < flavors.length; ++i) {
                DataFlavor dataFlavor = flavors[i];
                try {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    if (dataFlavor.equals(DataFlavor.javaFileListFlavor)) {
                        int x = event.getLocation().x;
                        int y = event.getLocation().y;
                        TreePath tp = this.getPathForLocation(x, y);
                        if (tp != null) {
                            DAVTreeNode node = (DAVTreeNode)tp.getLastPathComponent();
                            List fileList = (List)transferable.getTransferData(dataFlavor);
                            for (int j = 0; j < fileList.size(); ++j) {
                                File f = (File)fileList.get(j);
                                String newUrl = Utils.addSegment(node.fullName, f.getName());
                                DAVResource r = DAVTree.this.getDAVResource(newUrl);
                                if (!f.isDirectory()) {
                                    r.setContents(new FileInputStream(f));
                                    if (r.SUCCEEDED()) continue;
                                    int sc = r.getStatusCode();
                                    String msg = "Warning " + sc;
                                    System.out.println(msg);
                                    DAVTree.this.status.setText(msg);
                                    continue;
                                }
                                DAVTree.this.copySubTree(f, r);
                            }
                            node.populated = false;
                            node.removeAllChildren();
                            if (node.populateCollections(DAVTree.this, true)) {
                                ((DefaultTreeModel)DAVTree.this.jTree.getModel()).nodeStructureChanged(node);
                            }
                        }
                        event.dropComplete(true);
                        return;
                    }
                    if (!"DAVTree.Resource".equals(dataFlavor.getHumanPresentableName())) continue;
                    DAVTreeNode source = (DAVTreeNode)transferable.getTransferData(dataFlavor);
                    String s = source.fullName;
                    int x = event.getLocation().x;
                    int y = event.getLocation().y;
                    TreePath tp = this.getPathForLocation(x, y);
                    if (tp != null) {
                        URL _url;
                        DAVTreeNode node = (DAVTreeNode)tp.getLastPathComponent();
                        try {
                            _url = new URL(node.fullName);
                        }
                        catch (MalformedURLException e) {
                            _url = null;
                        }
                        if (_url != null) {
                            DAVResource r = DAVTree.this.getDAVResource(s);
                            if (s.endsWith("/")) {
                                s = s.substring(0, s.length() - 1);
                            }
                            if ((event.getDropAction() & 2) != 0) {
                                r.move(Utils.addSegment(_url.getPath(), s.substring(s.lastIndexOf("/"))));
                                if (r.SUCCEEDED()) {
                                    source.removeFromParent();
                                }
                            } else if ((event.getDropAction() & 1) != 0) {
                                r.copy(Utils.addSegment(_url.getPath(), s.substring(s.lastIndexOf("/"))));
                            }
                        }
                        node.populated = false;
                        node.removeAllChildren();
                        if (node.populateCollections(DAVTree.this, true)) {
                            ((DefaultTreeModel)DAVTree.this.jTree.getModel()).nodeStructureChanged(node);
                        }
                    }
                    event.dropComplete(true);
                    return;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    event.dropComplete(false);
                    return;
                }
                finally {
                    this.setCursor(Cursor.getDefaultCursor());
                }
            }
            event.dropComplete(false);
        }

        protected boolean itemCanBeDroppedOn(Object ob) {
            return true;
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent event) {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent event) {
            TreePath treepath = this.getSelectionPath();
            if (treepath != null) {
                Object o = treepath.getLastPathComponent();
                WebDAVTransferable wt = new WebDAVTransferable((DAVTreeNode)o);
                this.m_dragSource.startDrag(event, null, wt, this);
            }
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent event) {
            DAVTree.this.dndFile = null;
            DAVTree.this.dndString = null;
            DAVTree.this.inDragDrop = false;
            if (event.getDropSuccess()) {
                // empty if block
            }
            DAVTree.this.inDragDrop = false;
        }

        @Override
        public void dragEnter(DragSourceDragEvent event) {
        }

        @Override
        public void dragExit(DragSourceEvent event) {
        }

        @Override
        public void dragOver(DragSourceDragEvent event) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent event) {
        }
    }

    public class PropertyPanel
    extends JPanel {
        private static final long serialVersionUID = 3256441421597979188L;
        JScrollPane propPane;
        JPanel propPanel;
        GridBagLayout gbl;
        Map _propertyMap;
        Vector labels = new Vector(25);
        Vector textfields = new Vector(25);
        private JButton newpropButton = new JButton(RB.getStringResource("DAVTree.newprop.txt"));

        public PropertyPanel(Map propertyMap) {
            this._propertyMap = propertyMap;
            this.propPanel = new JPanel();
            this.propPane = new JScrollPane(this.propPanel, 22, 32);
            this.propPane.setSize(100, 100);
            this.gbl = new GridBagLayout();
            this.propPanel.setLayout(this.gbl);
            this.setLayout(new BorderLayout());
            this.add((Component)this.newpropButton, "North");
            this.add((Component)this.propPane, "Center");
            for (Map.Entry me : this._propertyMap.entrySet()) {
                this.addProperty((String)me.getKey(), (String)me.getValue(), false);
            }
            this.newpropButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PropertyPanel.this.addProperty("", "", true);
                    PropertyPanel.this.propPanel.doLayout();
                    PropertyPanel.this.propPane.doLayout();
                    if (PropertyPanel.this.getParent() != null) {
                        PropertyPanel.this.getParent().doLayout();
                    }
                }
            });
        }

        public Map getSetUpdates() {
            HashMap<String, String> setUpdates = new HashMap<String, String>();
            for (int i = 0; i < this.labels.size(); ++i) {
                String label = ((JTextField)this.labels.get(i)).getText();
                String text = ((JTextField)this.textfields.get(i)).getText();
                if (label.length() == 0 || this._propertyMap.containsKey(label) && text.equals(this._propertyMap.get(label)) || text.length() <= 0) continue;
                setUpdates.put(label, text);
            }
            return setUpdates;
        }

        public Vector<String> getDelUpdates() {
            Vector<String> delUpdates = new Vector<String>(5);
            for (int i = 0; i < this.labels.size(); ++i) {
                String label = ((JTextField)this.labels.get(i)).getText();
                String text = ((JTextField)this.textfields.get(i)).getText();
                if (text.length() != 0) continue;
                delUpdates.add(label);
            }
            return delUpdates;
        }

        public void addProperty(String propName, String propVal, boolean nameEditable) {
            JTextField value = new JTextField(propVal, 30);
            JTextField name = new JTextField(propName, 20);
            name.setEditable(nameEditable);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.anchor = 17;
            gbc.gridwidth = -1;
            name.setSize(50, 21);
            this.propPanel.add((Component)name, gbc);
            gbc.gridwidth = 0;
            gbc.weightx = 1.0;
            value.setSize(80, 21);
            this.propPanel.add((Component)value, gbc);
            this.labels.add(name);
            this.textfields.add(value);
        }
    }
}

