/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.webdav;

import EDU.oswego.cs.dl.util.concurrent.Mutex;
import com.sas.codepolicy.SASScope;
import com.sas.services.webdav.Collection;
import com.sas.services.webdav.CollectionInterface;
import com.sas.services.webdav.ConnectionInfo;
import com.sas.services.webdav.DAVException;
import com.sas.services.webdav.DAVResource;
import com.sas.services.webdav.DAVResourceInterface;
import com.sas.services.webdav.PropertyMap;
import com.sas.services.webdav.RemoteCollection;
import com.sas.services.webdav.RemoteResource;
import com.sas.services.webdav.Resource;
import com.sas.services.webdav.ResourceFactory;
import com.sas.services.webdav.ResourceInterface;
import com.sas.services.webdav.SharedResourceInterface;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;

@SASScope
public class SharedResource
extends UnicastRemoteObject
implements SharedResourceInterface {
    private static final long serialVersionUID = -5357211225395811178L;
    private Mutex _resourceMutex = new Mutex();
    private DAVResourceInterface resource;

    public SharedResource(ConnectionInfo c) throws RemoteException {
        try {
            this.resource = new DAVResource(c);
        }
        catch (DAVException e) {
            e.printStackTrace();
        }
    }

    public SharedResource(DAVResourceInterface r) throws RemoteException {
        this.resource = r;
    }

    @Override
    public DAVResourceInterface getConnection() throws RemoteException {
        boolean success = false;
        try {
            success = this._resourceMutex.attempt(90000L);
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
        if (!success) {
            return null;
        }
        return this.resource;
    }

    @Override
    public void releaseConnection(DAVResourceInterface r) throws RemoteException {
        this._resourceMutex.release();
    }

    @Override
    public void releaseConnection() throws RemoteException {
        this._resourceMutex.release();
    }

    @Override
    public void close() throws RemoteException {
        try {
            this.resource.close();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    @Override
    public CollectionInterface createCollection(CollectionInterface model, String name) throws RemoteException {
        try {
            CollectionInterface o = Collection.createCollection(this, model, name);
            RemoteCollection c = new RemoteCollection((Collection)o);
            return c;
        }
        catch (DAVException e) {
            return null;
        }
    }

    @Override
    public ResourceInterface createResource(CollectionInterface model, String name) throws RemoteException {
        try {
            ResourceInterface o = Collection.createResource(this, model, name);
            RemoteResource r = new RemoteResource((Resource)o);
            return r;
        }
        catch (DAVException e) {
            return null;
        }
    }

    @Override
    public CollectionInterface createCollectionRF(ResourceInterface model, String urlString) throws RemoteException {
        try {
            CollectionInterface o = ResourceFactory.createCollection(this, urlString);
            RemoteCollection c = new RemoteCollection((Collection)o);
            return c;
        }
        catch (DAVException e) {
            return null;
        }
    }

    @Override
    public ResourceInterface bindResource(String path) throws RemoteException {
        try {
            ResourceInterface o = ResourceFactory.bindResource(this, path);
            RemoteResource ri = o instanceof CollectionInterface ? new RemoteCollection((Collection)o) : new RemoteResource((Resource)o);
            return ri;
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RemoteException("DAVException: " + e.getMessage(), e);
        }
    }

    @Override
    public ResourceInterface bindResource(String path, PropertyMap p) throws RemoteException {
        try {
            ResourceInterface o = ResourceFactory.bindResource(this, path, p);
            RemoteResource ri = o instanceof CollectionInterface ? new RemoteCollection((Collection)o) : new RemoteResource((Resource)o);
            return ri;
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RemoteException("DAVException: " + e.getMessage(), e);
        }
    }
}

