/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.webdav;

import com.sas.codepolicy.SASScope;
import com.sas.services.webdav.Collection;
import com.sas.services.webdav.CollectionInterface;
import com.sas.services.webdav.ConnectionInfo;
import com.sas.services.webdav.DAVException;
import com.sas.services.webdav.DAVResource;
import com.sas.services.webdav.DAVResourceInterface;
import com.sas.services.webdav.DavPropertyResult;
import com.sas.services.webdav.PropertyMap;
import com.sas.services.webdav.RB;
import com.sas.services.webdav.Resource;
import com.sas.services.webdav.ResourceInterface;
import com.sas.services.webdav.SharedResource;
import com.sas.services.webdav.SharedResourceInterface;
import com.sas.services.webdav.XMLUtil;
import com.sas.text.Message;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.rmi.RemoteException;
import java.util.ResourceBundle;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.search.SearchInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@SASScope
public class ResourceFactory {
    private static final Logger LOGGER = LogManager.getLogger(ResourceFactory.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DavPropertyResult doSearch(ConnectionInfo cInfo, String searchString) throws DAVException, RemoteException {
        DavPropertyResult davPropertyResult = new DavPropertyResult();
        DAVResource r = null;
        try {
            try {
                new URL(cInfo.getUrl());
            }
            catch (MalformedURLException e) {
                LOGGER.error(Message.format((ResourceBundle)RB.getResources(), (String)"ResourceFactory.invalidurl.fmt.txt", (Object)cInfo.getUrl()));
                DavPropertyResult davPropertyResult2 = null;
                if (null != r) {
                    r.close();
                }
                return davPropertyResult2;
            }
            r = new DAVResource(cInfo);
            r.doOptions();
            boolean searchOk = false;
            for (String method : r.getAllowedMethods()) {
                if (!"SEARCH".equalsIgnoreCase(method)) continue;
                searchOk = true;
                break;
            }
            if (!searchOk) {
                LOGGER.debug(RB.getStringResource("ResourceFactory.nosearch.txt"));
                DavPropertyResult davPropertyResult2 = davPropertyResult;
                return davPropertyResult2;
            }
            try {
                Document document = XMLUtil.convertStringToDocument(searchString);
                SearchInfo searchInfo = SearchInfo.createFromXml((Element)document.getDocumentElement());
                davPropertyResult = r.doSearch(searchInfo);
            }
            catch (IOException iOException) {
                throw new DAVException(RB.getStringResource("ResourceFactory.searchioerr.ex.txt"), iOException);
            }
            catch (DavException davException) {
                throw new DAVException(RB.getStringResource("XMLUtil.unableToCreateInitDataDocumentBecause.ex.fmt.txt"), (Exception)((Object)davException));
            }
        }
        finally {
            if (null != r) {
                r.close();
            }
        }
        return davPropertyResult;
    }

    public static ResourceInterface bindResource(String url) throws DAVException, RemoteException {
        return ResourceFactory.bindResource(new ConnectionInfo(url));
    }

    public static ResourceInterface bindResource(String url, String user, String password) throws DAVException, RemoteException {
        return ResourceFactory.bindResource(new ConnectionInfo(url, user, password));
    }

    public static ResourceInterface bindResource(ConnectionInfo cInfo) throws DAVException, RemoteException {
        DAVResource r = new DAVResource(cInfo);
        if (r.SUCCEEDED() || r.getStatusCode() == 404) {
            if (r.isCollection()) {
                return new Collection(r);
            }
            return new Resource(r);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceInterface bindResource(ResourceInterface model, String path) throws DAVException, RemoteException {
        block18: {
            if (model.isSharedResource()) {
                SharedResourceInterface sr = model.getSharedResource();
                if (sr instanceof SharedResource) {
                    DAVResourceInterface r = null;
                    String urlStr = null;
                    try {
                        r = sr.getConnection();
                        r.setPath(path);
                        urlStr = r.getURL().toString();
                        try {
                            urlStr = URLDecoder.decode(urlStr, StandardCharsets.UTF_8.name());
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new DAVException("Unsupported encoding: " + e.getMessage());
                        }
                        if (r.SUCCEEDED() || r.getStatusCode() == 404) {
                            if (r.isCollection()) {
                                Collection collection = new Collection(sr, urlStr);
                                return collection;
                            }
                            Resource resource = new Resource(sr, urlStr);
                            return resource;
                        }
                        break block18;
                    }
                    finally {
                        sr.releaseConnection(r);
                        r = null;
                    }
                }
                return model.getSharedResource().bindResource(path);
            }
            DAVResource r = null;
            if (model instanceof Collection) {
                r = ((Collection)model)._resource;
            } else if (model instanceof Resource) {
                r = ((Resource)model)._resource;
            }
            DAVResource dAVResource = r;
            synchronized (dAVResource) {
                r.setPath(path);
                if (r.SUCCEEDED() || r.getStatusCode() == 404) {
                    if (r.isCollection()) {
                        return new Collection(r);
                    }
                    return new Resource(r);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceInterface bindResource(ResourceInterface model, String path, PropertyMap p) throws DAVException, RemoteException {
        String collection = (String)p.get("{DAV:}resourcetype");
        if (model.isSharedResource()) {
            SharedResourceInterface sr = model.getSharedResource();
            if (sr instanceof SharedResource) {
                DAVResourceInterface r = null;
                String urlStr = null;
                try {
                    r = sr.getConnection();
                    r.setPath(path);
                    urlStr = r.getURL().toString();
                    try {
                        urlStr = URLDecoder.decode(urlStr, StandardCharsets.UTF_8.name());
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new DAVException("Unsupported encoding: " + e.getMessage());
                    }
                }
                finally {
                    sr.releaseConnection(r);
                    r = null;
                }
                if ("COLLECTION".equals(collection)) {
                    return new Collection(sr, urlStr);
                }
                return new Resource(sr, urlStr);
            }
            return model.getSharedResource().bindResource(path, p);
        }
        DAVResource r = null;
        if (model instanceof Collection) {
            r = ((Collection)model)._resource;
            r.setPath(path);
        } else if (model instanceof Resource) {
            r = ((Resource)model)._resource;
            r.setPath(path);
        }
        if ("COLLECTION".equals(collection)) {
            return new Collection(r);
        }
        return new Resource(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceInterface bindResource(SharedResourceInterface sr, String path) throws DAVException, RemoteException {
        if (sr instanceof SharedResource) {
            DAVResourceInterface r = null;
            try {
                r = sr.getConnection();
                r.setPath(path);
                String urlStr = r.getURL().toString();
                try {
                    urlStr = URLDecoder.decode(urlStr, StandardCharsets.UTF_8.name());
                }
                catch (UnsupportedEncodingException e) {
                    throw new DAVException("Unsupported encoding: " + e.getMessage());
                }
                if (r.SUCCEEDED() || r.getStatusCode() == 404) {
                    if (r.isCollection()) {
                        Collection collection = new Collection(sr, urlStr);
                        return collection;
                    }
                    Resource resource = new Resource(sr, urlStr);
                    return resource;
                }
                ResourceInterface resourceInterface = null;
                return resourceInterface;
            }
            finally {
                sr.releaseConnection(r);
                r = null;
            }
        }
        return sr.bindResource(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceInterface bindResource(SharedResourceInterface sr, String path, PropertyMap p) throws DAVException, RemoteException {
        if (sr instanceof SharedResource) {
            DAVResourceInterface r = null;
            try {
                r = sr.getConnection();
                r.setPath(path);
                String urlStr = r.getURL().toString();
                try {
                    urlStr = URLDecoder.decode(urlStr, StandardCharsets.UTF_8.name());
                }
                catch (UnsupportedEncodingException e) {
                    throw new DAVException("Unsupported encoding: " + e.getMessage());
                }
                if (r.SUCCEEDED() || r.getStatusCode() == 404) {
                    if (r.isCollection()) {
                        Collection collection = new Collection(sr, urlStr);
                        return collection;
                    }
                    Resource resource = new Resource(sr, urlStr);
                    return resource;
                }
                ResourceInterface resourceInterface = null;
                return resourceInterface;
            }
            finally {
                sr.releaseConnection(r);
                r = null;
            }
        }
        return sr.bindResource(path, p);
    }

    public static CollectionInterface createCollection(String url) throws DAVException, RemoteException {
        return ResourceFactory.createCollection(new ConnectionInfo(url));
    }

    public static CollectionInterface createCollection(String url, String user, String password) throws DAVException, RemoteException {
        return ResourceFactory.createCollection(new ConnectionInfo(url, user, password));
    }

    public static CollectionInterface createCollection(ConnectionInfo cInfo) throws DAVException, RemoteException {
        DAVResource r = new DAVResource(cInfo);
        r.makeCollection();
        if (r.getStatusCode() == 405) {
            r.delete();
            r.makeCollection();
        }
        if (r.SUCCEEDED()) {
            return new Collection(r);
        }
        throw new DAVException(Message.format((ResourceBundle)RB.getResources(), (String)"ResourceFactory.mkcolerr.ex.fmt.txt", (Object)String.valueOf(r.getStatusCode()), (Object)cInfo.getUrl()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CollectionInterface createCollection(ResourceInterface model, String urlString) throws DAVException, RemoteException {
        int sc;
        String path = ResourceFactory.getPath(urlString);
        if (model.isSharedResource()) {
            SharedResourceInterface sr = model.getSharedResource();
            if (sr instanceof SharedResource) {
                int sc2;
                DAVResourceInterface r = null;
                try {
                    r = sr.getConnection();
                    r.setPath(path);
                    r.makeCollection();
                    if (r.getStatusCode() == 405) {
                        r.delete();
                        r.makeCollection();
                    }
                    sc2 = r.getStatusCode();
                }
                finally {
                    sr.releaseConnection(r);
                    r = null;
                }
                if (DAVResource.SUCCEEDED(sc2)) {
                    return new Collection(sr);
                }
                throw new DAVException(Message.format((ResourceBundle)RB.getResources(), (String)"ResourceFactory.mkcolerr.ex.fmt.txt", (Object)String.valueOf(sc2), (Object)urlString));
            }
            return sr.createCollectionRF(model, urlString);
        }
        DAVResource r = null;
        if (model instanceof Collection) {
            r = ((Collection)model)._resource;
        } else if (model instanceof Resource) {
            r = ((Resource)model)._resource;
        }
        DAVResource dAVResource = r;
        synchronized (dAVResource) {
            r.setPath(path);
            r.makeCollection();
            if (r.getStatusCode() == 405) {
                r.delete();
                r.makeCollection();
            }
            sc = r.getStatusCode();
        }
        if (DAVResource.SUCCEEDED(sc)) {
            return new Collection(r);
        }
        throw new DAVException(Message.format((ResourceBundle)RB.getResources(), (String)"ResourceFactory.mkcolerr.ex.fmt.txt", (Object)String.valueOf(sc), (Object)urlString));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CollectionInterface createCollection(SharedResourceInterface sr, String urlString) throws DAVException, RemoteException {
        int sc;
        String path = ResourceFactory.getPath(urlString);
        DAVResourceInterface r = null;
        try {
            r = sr.getConnection();
            r.setPath(path);
            r.makeCollection();
            if (r.getStatusCode() == 405) {
                r.delete();
                r.makeCollection();
            }
            sc = r.getStatusCode();
        }
        finally {
            sr.releaseConnection(r);
            r = null;
        }
        if (DAVResource.SUCCEEDED(sc)) {
            return new Collection(sr);
        }
        throw new DAVException(Message.format((ResourceBundle)RB.getResources(), (String)"ResourceFactory.mkcolerr.ex.fmt.txt", (Object)String.valueOf(sc), (Object)urlString));
    }

    private static String getPath(String urlStr) {
        String path = null;
        int p = urlStr.indexOf("://");
        if (p > 0) {
            path = (p = urlStr.indexOf("/", p + 3)) > 0 ? urlStr.substring(p) : "";
        }
        return path;
    }
}

