/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.webdav;

import com.sas.codepolicy.SASScope;
import java.util.ArrayList;
import java.util.StringTokenizer;

@SASScope
public class Privilege {
    private String name;
    private boolean isAbstract = false;
    private String description = "";
    public static final Privilege PRIV_READ = new Privilege("{DAV:}read");
    public static final Privilege PRIV_WRITE = new Privilege("{DAV:}write");
    public static final Privilege PRIV_WRITE_PROPERTIES = new Privilege("{DAV:}write-properties");
    public static final Privilege PRIV_WRITE_CONTENT = new Privilege("{DAV:}write-content");
    public static final Privilege PRIV_UNLOCK = new Privilege("{DAV:}unlock");
    public static final Privilege PRIV_READ_ACL = new Privilege("{DAV:}read-acl");
    public static final Privilege PRIV_READ_CURRPRIVSET = new Privilege("{DAV:}read-current-user-privilege-set");
    public static final Privilege PRIV_WRITE_ACL = new Privilege("{DAV:}write-acl");
    public static final Privilege PRIV_BIND = new Privilege("{DAV:}bind");
    public static final Privilege PRIV_UNBIND = new Privilege("{DAV:}unbind");
    public static final Privilege PRIV_ALL = new Privilege("{DAV:}all");
    public static final Privilege PRIV_XYTHOS_WRITE = new Privilege("{http://www.xythos.com/namespaces/StorageServer/acl/}write");
    public static final Privilege PRIV_XYTHOS_DELETE = new Privilege("{http://www.xythos.com/namespaces/StorageServer/acl/}delete");
    public static final Privilege PRIV_XYTHOS_PERMISSIONS = new Privilege("{http://www.xythos.com/namespaces/StorageServer/acl/}permissions");
    public static final Privilege PRIV_XYTHOS_IHERIT_READ = new Privilege("{http://www.xythos.com/namespaces/StorageServer/acl/}inherit-read");
    public static final Privilege PRIV_XYTHOS_IHERIT_WRITE = new Privilege("{http://www.xythos.com/namespaces/StorageServer/acl/}inherit-write");
    public static final Privilege PRIV_XYTHOS_IHERIT_DELETE = new Privilege("{http://www.xythos.com/namespaces/StorageServer/acl/}inherit-delete");
    public static final Privilege PRIV_XYTHOS_IHERIT_PERMISSIONS = new Privilege("{http://www.xythos.com/namespaces/StorageServer/acl/}inherit-permissions");
    public static final Privilege PRIV_SCS_READ = new Privilege("{http://sas.com/XmlNamespaces/DAV}read");
    public static final Privilege PRIV_SCS_WRITE = new Privilege("{http://sas.com/XmlNamespaces/DAV}write");
    public static final Privilege PRIV_SCS_DELETE = new Privilege("{http://sas.com/XmlNamespaces/DAV}delete");
    public static final Privilege PRIV_SCS_ADMIN = new Privilege("{http://sas.com/XmlNamespaces/DAV}admin");
    public static final Privilege PRIV_SCS_INHERIT_READ = new Privilege("{http://sas.com/XmlNamespaces/DAV}inherit-read");
    public static final Privilege PRIV_SCS_INHERIT_WRITE = new Privilege("{http://sas.com/XmlNamespaces/DAV}inherit-write");
    public static final Privilege PRIV_SCS_INHERIT_DELETE = new Privilege("{http://sas.com/XmlNamespaces/DAV}inherit-delete");
    public static final Privilege PRIV_SCS_INHERIT_ADMIN = new Privilege("{http://sas.com/XmlNamespaces/DAV}inherit-admin");

    public static Privilege[] getPrivilegesFromString(String privsString) {
        StringTokenizer st = new StringTokenizer(privsString);
        ArrayList<Privilege> list = new ArrayList<Privilege>();
        while (st.hasMoreTokens()) {
            list.add(new Privilege(Privilege.getNSPrivilege(st.nextToken())));
        }
        return list.toArray(new Privilege[0]);
    }

    public static String getStringFromPrivileges(Privilege[] privs) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < privs.length; ++i) {
            sb.append(privs[i].getName());
            if (i <= 0) continue;
            sb.append(12);
        }
        return sb.toString();
    }

    public Privilege(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setIsAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public static String getDumpForm(Privilege priv) {
        System.out.println("*** " + priv.getName());
        if (PRIV_READ.equals(priv) || PRIV_SCS_READ.equals(priv)) {
            return "READ";
        }
        if (PRIV_XYTHOS_WRITE.equals(priv) || PRIV_SCS_WRITE.equals(priv) || PRIV_WRITE.equals(priv)) {
            return "WRITE";
        }
        if (PRIV_XYTHOS_DELETE.equals(priv) || PRIV_SCS_DELETE.equals(priv)) {
            return "DELETE";
        }
        if (PRIV_XYTHOS_PERMISSIONS.equals(priv) || PRIV_SCS_ADMIN.equals(priv)) {
            return "PERMISSIONS";
        }
        if (PRIV_XYTHOS_IHERIT_READ.equals(priv) || PRIV_SCS_INHERIT_READ.equals(priv)) {
            return "IREAD";
        }
        if (PRIV_XYTHOS_IHERIT_WRITE.equals(priv) || PRIV_SCS_INHERIT_WRITE.equals(priv)) {
            return "IWRITE";
        }
        if (PRIV_XYTHOS_IHERIT_DELETE.equals(priv) || PRIV_SCS_INHERIT_DELETE.equals(priv)) {
            return "IDELETE";
        }
        if (PRIV_XYTHOS_IHERIT_PERMISSIONS.equals(priv) || PRIV_SCS_INHERIT_ADMIN.equals(priv)) {
            return "IPERMISSIONS";
        }
        return priv.getName();
    }

    public static String getNSPrivilege(String privString) {
        if ("READ".equals(privString)) {
            return "{DAV:}read";
        }
        if ("WRITE".equals(privString)) {
            return PRIV_SCS_WRITE.getName();
        }
        if ("DELETE".equals(privString)) {
            return PRIV_SCS_DELETE.getName();
        }
        if ("PERMISSIONS".equals(privString)) {
            return PRIV_SCS_ADMIN.getName();
        }
        if ("IREAD".equals(privString)) {
            return PRIV_SCS_INHERIT_READ.getName();
        }
        if ("IWRITE".equals(privString)) {
            return PRIV_SCS_INHERIT_WRITE.getName();
        }
        if ("IDELETE".equals(privString)) {
            return PRIV_SCS_INHERIT_DELETE.getName();
        }
        if ("IPERMISSIONS".equals(privString)) {
            return PRIV_SCS_INHERIT_ADMIN.getName();
        }
        return "{DAV:}none";
    }

    public boolean equals(Object obj) {
        if (obj instanceof Privilege) {
            return this.name.equals(((Privilege)obj).getName());
        }
        return false;
    }
}

