/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.webdav;

import com.sas.codepolicy.SASScope;
import com.sas.io.util.FileCleanupInterface;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

@SASScope
public class FileCleanup {
    private static FileCleanupInterface _instance = null;

    public static synchronized FileCleanupInterface getInstance() {
        if (_instance == null) {
            _instance = new FileCleanupImpl();
        }
        return _instance;
    }

    public static synchronized void registerImplementation(FileCleanupInterface instance) {
        if (instance == null) {
            throw new NullPointerException();
        }
        FileCleanupInterface oldInstance = _instance;
        _instance = instance;
        if (oldInstance != null) {
            oldInstance.deleteAllFilesNow();
        }
    }

    @SASScope
    private static class FileCleanupImpl
    implements FileCleanupInterface {
        private long _cleanupRetentionShort;
        private long _cleanupRetentionMedium;
        private long _cleanupRetentionLong;
        private long _cleanupThreadWakeupInterval;
        private File _tmpFileDirectory;
        private SortedMap<Date, List<File>> _cleanupMap;
        private Map<File, Date> _filesToCleanup;
        private StoppableThread _cleanupThread;

        private FileCleanupImpl() {
            long msPerSec = 1000L;
            long secPerMin = 60L;
            long msPerMin = msPerSec * secPerMin;
            long minPerHour = 60L;
            this._cleanupRetentionShort = msPerMin * Math.max(1L, FileCleanupImpl.getPropertyAsLong("sas.filecleanup.short.retention.minutes", 15L));
            this._cleanupRetentionMedium = msPerMin * Math.max(1L, FileCleanupImpl.getPropertyAsLong("sas.filecleanup.medium.retention.minutes", 2L * minPerHour));
            this._cleanupRetentionLong = msPerMin * Math.max(1L, FileCleanupImpl.getPropertyAsLong("sas.filecleanup.long.retention.minutes", 12L * minPerHour));
            this._cleanupThreadWakeupInterval = msPerMin * Math.max(1L, FileCleanupImpl.getPropertyAsLong("sas.filecleanup.thread.sleep.minutes", 5L));
            String property = FileCleanupImpl.getProperty("sas.filecleanup.temp.directory", null);
            this._tmpFileDirectory = property == null ? new File(System.getProperty("java.io.tmpdir")) : new File(property);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    this.deleteAllFilesNow();
                }
            });
            try {
                this._cleanupMap = new TreeMap<Date, List<File>>();
                this._filesToCleanup = new HashMap<File, Date>();
                this._cleanupThread = this.createCleanupThread();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void registerFileForDeletion(File file) {
            this.registerFileForDeletion(file, 1);
        }

        public void registerFileForDeletion(File file, int retentionPeriod) {
            try {
                if (file == null) {
                    return;
                }
                long interval = this._cleanupRetentionMedium;
                if (retentionPeriod <= 0) {
                    interval = this._cleanupRetentionShort;
                } else if (retentionPeriod >= 2) {
                    interval = this._cleanupRetentionLong;
                }
                this.setUpFileForDeletion(file, interval);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }

        public File newTemporaryFile() {
            return this.newTemporaryFile(1);
        }

        public File newTemporaryFile(int retentionPeriod) {
            return this.newTemporaryFile(retentionPeriod, "tmp", "file");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public File newTemporaryFile(int retentionPeriod, String prefix, String suffix) {
            File temp = null;
            try {
                File file = this._tmpFileDirectory;
                synchronized (file) {
                    if (!this._tmpFileDirectory.exists()) {
                        this._tmpFileDirectory.mkdirs();
                    }
                    if (prefix == null || prefix.length() < 3) {
                        prefix = "tmp";
                    }
                    temp = File.createTempFile(prefix, suffix, this._tmpFileDirectory);
                }
            }
            catch (IOException e) {
                System.err.println("Error creating new temporary file (prefix = \"" + prefix + "\" suffix=\"" + suffix + "\" directory = \"" + this._tmpFileDirectory + "\") in com.sas.services.webdav.FileCleanup");
                e.printStackTrace();
                throw new IllegalArgumentException(e.getMessage(), e);
            }
            this.registerFileForDeletion(temp, retentionPeriod);
            return temp;
        }

        public void deleteSoon(File file) {
            try {
                if (file == null) {
                    return;
                }
                long interval = 1L;
                this.setUpFileForDeletion(file, interval);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setUpFileForDeletion(File file, long interval) {
            SortedMap<Date, List<File>> sortedMap = this._cleanupMap;
            synchronized (sortedMap) {
                Date termination;
                ArrayList<File> list;
                Date oldTermination = this.getTerminationDate(file);
                if (oldTermination != null) {
                    List oldList = (List)this._cleanupMap.get(oldTermination);
                    if (oldList != null) {
                        oldList.remove(file);
                    }
                    this._filesToCleanup.remove(file);
                }
                if ((list = (ArrayList<File>)this._cleanupMap.get(termination = new Date(this.calculateTermination(new Date().getTime(), interval)))) == null) {
                    list = new ArrayList<File>();
                    this._cleanupMap.put(termination, list);
                }
                list.add(file);
                this._filesToCleanup.put(file, termination);
            }
        }

        public void deleteNow(File file) {
            if (file != null) {
                try {
                    if (!this.prune(file) && file.exists()) {
                        this.registerFileForDeletion(file, 0);
                    }
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deleteAllFilesNow() {
            try {
                SortedMap<Date, List<File>> sortedMap = this._cleanupMap;
                synchronized (sortedMap) {
                    for (File file : this._filesToCleanup.keySet()) {
                        if (!file.exists()) continue;
                        this.prune(file);
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }

        private static long getPropertyAsLong(String propertyName, long defaultValue) {
            long rval = defaultValue;
            try {
                rval = Long.parseLong(System.getProperty(propertyName).trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return rval;
        }

        private static String getProperty(String propertyName, String defaultValue) {
            String rval = null;
            try {
                rval = System.getProperty(propertyName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (rval == null || rval.trim().length() == 0) {
                rval = defaultValue;
            }
            return rval;
        }

        private StoppableThread createCleanupThread() {
            StoppableThread rval = new StoppableThread("sas.filecleanup.default.implementation");
            rval.setDaemon(true);
            rval.start();
            return rval;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Date getTerminationDate(File file) {
            Date result = null;
            SortedMap<Date, List<File>> sortedMap = this._cleanupMap;
            synchronized (sortedMap) {
                result = this._filesToCleanup.get(file);
            }
            return result;
        }

        private long calculateTermination(long currentTime, long delay) {
            return currentTime + delay;
        }

        private boolean prune(File file) {
            String[] contents;
            if (file.isDirectory() && (contents = file.list()) != null) {
                for (int k = 0; k < contents.length; ++k) {
                    this.prune(new File(file, contents[k]));
                }
            }
            return file.delete();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void executeCleanup() {
            if (this._cleanupMap.size() > 0) {
                ArrayList eligible_files = new ArrayList();
                Date now = new Date();
                SortedMap<Date, List<File>> sortedMap = this._cleanupMap;
                synchronized (sortedMap) {
                    Date then;
                    Iterator<Date> iter = this._cleanupMap.keySet().iterator();
                    while (iter.hasNext() && now.after(then = iter.next())) {
                        List files = (List)this._cleanupMap.get(then);
                        eligible_files.addAll(files);
                        iter.remove();
                    }
                    this._filesToCleanup.keySet().removeAll(eligible_files);
                }
                if (!eligible_files.isEmpty()) {
                    for (File f : eligible_files) {
                        boolean status = this.prune(f);
                        if (!status) {
                            boolean bl = status = !f.exists();
                        }
                        if (status) continue;
                        this.registerFileForDeletion(f, 0);
                    }
                }
            }
        }

        @SASScope
        private class StoppableThread
        extends Thread {
            private boolean _stopRequested;

            StoppableThread(String name) {
                super(name);
                this._stopRequested = false;
            }

            @Override
            public void run() {
                while (!this.stopRequested()) {
                    try {
                        Thread.sleep(FileCleanupImpl.this._cleanupThreadWakeupInterval);
                        if (this.stopRequested()) continue;
                        FileCleanupImpl.this.executeCleanup();
                    }
                    catch (Exception exception) {}
                }
            }

            public synchronized void requestStop() {
                this._stopRequested = true;
                this.interrupt();
            }

            private synchronized boolean stopRequested() {
                return this._stopRequested;
            }
        }
    }
}

