/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.webdav;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.webdav.Acl;
import com.sas.services.webdav.DAVException;
import com.sas.services.webdav.DAVResource;
import com.sas.services.webdav.DavPropertyResult;
import com.sas.services.webdav.PropertyName;
import com.sas.services.webdav.Version;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.List;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.entity.ContentType;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.search.SearchInfo;
import org.apache.jackrabbit.webdav.version.report.ReportInfo;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public interface DAVResourceInterface
extends Remote {
    public void delete() throws DAVException, RemoteException;

    public void getContents(File var1) throws DAVException, RemoteException;

    public byte[] getContents() throws DAVException, RemoteException;

    public String getContentsAsString() throws DAVException, RemoteException;

    public String getContentType() throws DAVException, RemoteException;

    public ContentType contentType() throws DAVException, RemoteException;

    public InputStream getContentsInputStream() throws DAVException, RemoteException;

    public int getStatusCode() throws DAVException, RemoteException;

    public String getStatusMessage() throws DAVException, RemoteException;

    public URL getURL() throws DAVException, RemoteException;

    public boolean isCollection() throws DAVException, RemoteException;

    public boolean isLocked() throws DAVException, RemoteException;

    public String lock() throws DAVException, RemoteException;

    public DAVResource move(String var1) throws DAVException, RemoteException;

    public void removeProperties(PropertyName[] var1) throws DAVException, RemoteException;

    public void removeProperties(Element[] var1) throws DAVException, RemoteException;

    public void removeProperty(Element var1) throws DAVException, RemoteException;

    public void removeProperty(String var1) throws DAVException, RemoteException;

    public void removeProperty(PropertyName var1) throws DAVException, RemoteException;

    public void setContents(byte[] var1) throws DAVException, RemoteException;

    public void setContents(URL var1) throws DAVException, RemoteException;

    public void setContents(String var1) throws DAVException, RemoteException;

    public void setContents(InputStream var1) throws DAVException, RemoteException;

    public void setContentType(String var1) throws DAVException, RemoteException;

    public void setProperties(Element[] var1) throws DAVException, RemoteException;

    public void setProperties(PropertyName[] var1, String[] var2) throws DAVException, RemoteException;

    public void setProperties(DocumentFragment var1) throws DAVException, RemoteException;

    public void setProperty(PropertyName var1, String var2) throws DAVException, RemoteException;

    public void setProperty(Element var1) throws DAVException, RemoteException;

    public void unlock() throws DAVException, RemoteException;

    public void unlock(String var1) throws DAVException, RemoteException;

    public boolean getOverwrite() throws DAVException, RemoteException;

    public void setOverwrite(boolean var1) throws DAVException, RemoteException;

    public void setDepth(int var1) throws DAVException, RemoteException;

    public int getDepth() throws DAVException, RemoteException;

    public void close() throws RemoteException;

    public void setTempDir(String var1) throws RemoteException;

    public String getTempDir() throws RemoteException;

    public boolean exists() throws RemoteException;

    public String getACL() throws DAVException, RemoteException;

    public String setACL(String var1) throws DAVException, RemoteException;

    public String getPath() throws RemoteException;

    public void setPath(String var1) throws RemoteException;

    public boolean makeCollection() throws DAVException, RemoteException;

    public boolean SUCCEEDED() throws RemoteException;

    public DAVResource copy(String var1) throws DAVException, RemoteException;

    public void doControl() throws DAVException, RemoteException;

    public void doLabel(int var1, String var2) throws DAVException, RemoteException;

    public void doLabel(int var1, String var2, int var3) throws DAVException, RemoteException;

    public List getPreviousVersionNames() throws DAVException, RemoteException;

    public void doCheckout() throws DAVException, RemoteException;

    public void doCheckin() throws DAVException, RemoteException;

    public void doUncheckout() throws DAVException, RemoteException;

    public Version getVersion(String var1) throws DAVException, RemoteException;

    public Version getCheckedIn() throws DAVException, RemoteException;

    public Version getCheckedOut() throws DAVException, RemoteException;

    public void setExistsRequirement(int var1) throws RemoteException;

    public int getExistsRequirement() throws RemoteException;

    public Acl getAcl() throws DAVException, RemoteException;

    public String setAcl(Acl var1) throws DAVException, RemoteException;

    public List getChildrenList(String var1) throws DAVException, RemoteException;

    public void setCredentialsProvider(CredentialsProvider var1);

    public DavPropertyResult getDavProperties() throws DAVException, RemoteException;

    public DavPropertyResult getDavProperties(int var1) throws DAVException, RemoteException;

    public DavPropertyResult getDavProperties(DavPropertyNameSet var1, int var2) throws DAVException, RemoteException;

    public DavPropertyResult getDavProperties(PropertyName[] var1) throws DAVException, RemoteException;

    public DavPropertyResult getDavProperties(PropertyName[] var1, int var2) throws DAVException, RemoteException;

    public DavPropertyResult getDavPropertyNames() throws DAVException, RemoteException;

    public DavPropertyResult getDavPropertyNames(int var1) throws DAVException, RemoteException;

    public DavPropertyResult doReport(ReportInfo var1) throws DAVException, RemoteException;

    public DavPropertyResult doSearch(SearchInfo var1) throws DAVException, RemoteException;
}

