/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.webdav;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.io.InputStreamAdapter;
import com.sas.services.webdav.Acl;
import com.sas.services.webdav.ConnectionInfo;
import com.sas.services.webdav.DAVException;
import com.sas.services.webdav.DAVResourceInterface;
import com.sas.services.webdav.DavPropertyItem;
import com.sas.services.webdav.DavPropertyResult;
import com.sas.services.webdav.FileCleanup;
import com.sas.services.webdav.LockManager;
import com.sas.services.webdav.MultiStatusHolder;
import com.sas.services.webdav.PropertyMap;
import com.sas.services.webdav.PropertyName;
import com.sas.services.webdav.RB;
import com.sas.services.webdav.Utils;
import com.sas.services.webdav.Version;
import com.sas.services.webdav.WebDAVStatus;
import com.sas.services.webdav.XMLUtil;
import com.sas.text.Message;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.rmi.RemoteException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.AbstractHttpMessage;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.MultiStatus;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.Status;
import org.apache.jackrabbit.webdav.client.methods.BaseDavRequest;
import org.apache.jackrabbit.webdav.client.methods.HttpAcl;
import org.apache.jackrabbit.webdav.client.methods.HttpCheckin;
import org.apache.jackrabbit.webdav.client.methods.HttpCheckout;
import org.apache.jackrabbit.webdav.client.methods.HttpCopy;
import org.apache.jackrabbit.webdav.client.methods.HttpDelete;
import org.apache.jackrabbit.webdav.client.methods.HttpLabel;
import org.apache.jackrabbit.webdav.client.methods.HttpLock;
import org.apache.jackrabbit.webdav.client.methods.HttpMkcol;
import org.apache.jackrabbit.webdav.client.methods.HttpMove;
import org.apache.jackrabbit.webdav.client.methods.HttpOptions;
import org.apache.jackrabbit.webdav.client.methods.HttpPropfind;
import org.apache.jackrabbit.webdav.client.methods.HttpProppatch;
import org.apache.jackrabbit.webdav.client.methods.HttpReport;
import org.apache.jackrabbit.webdav.client.methods.HttpSearch;
import org.apache.jackrabbit.webdav.client.methods.HttpUncheckout;
import org.apache.jackrabbit.webdav.client.methods.HttpUnlock;
import org.apache.jackrabbit.webdav.client.methods.HttpVersionControl;
import org.apache.jackrabbit.webdav.lock.ActiveLock;
import org.apache.jackrabbit.webdav.lock.LockDiscovery;
import org.apache.jackrabbit.webdav.lock.LockInfo;
import org.apache.jackrabbit.webdav.lock.Scope;
import org.apache.jackrabbit.webdav.lock.Type;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.property.DefaultDavProperty;
import org.apache.jackrabbit.webdav.property.ProppatchInfo;
import org.apache.jackrabbit.webdav.search.SearchInfo;
import org.apache.jackrabbit.webdav.security.AclProperty;
import org.apache.jackrabbit.webdav.version.LabelInfo;
import org.apache.jackrabbit.webdav.version.report.ReportInfo;
import org.apache.jackrabbit.webdav.version.report.ReportType;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class DAVResource
implements DAVResourceInterface {
    public static final int HTTP_DEFAULT_PORT = 80;
    private static final int HTTPS_DEFAULT_PORT = 443;
    private static final String DEFAULT_USER_NAME = "sas/webdav";
    private URI _httpURI;
    private final HttpHost _httpHost;
    private CloseableHttpClient _httpClient;
    private boolean overwrite;
    private int depth;
    private int debug;
    private boolean doneInitialPropfind;
    private String _contentType;
    private boolean _isCollection;
    private boolean exists;
    private LockDiscovery _lockDiscovery;
    private final LockManager _lockManager;
    @SASScope
    protected String userName;
    @SASScope
    protected String password;
    private int status;
    private String[] allowedMethods;
    private String[] davCapabilities;
    private boolean authReqd;
    private static final Logger LOGGER = LogManager.getLogger(DAVResource.class);
    private static final Logger PERF_LOGGER = LogManager.getLogger((String)(DAVResource.class.getName() + ".perf"));
    private Map _multiStatus;
    private static String DEBUG_OPT = System.getProperty("com.sas.services.webdav.debug");
    @SASScope
    protected String proxyHost;
    @SASScope
    protected int proxyPort;
    protected ConnectionInfo _connectionInfo;
    private static File tempFileDir;
    private static final String CONTENTTYPE = "Content-Type";
    private static final String CONTENTLENGTH = "Content-Length";
    private static final String UTF8 = "UTF-8";
    private static final DavPropertyNameSet DAV_PROPERTY_NAME_SET;
    public static final int DONT_CARE = 0;
    public static final int MUST_EXIST = 1;
    public static final int MUST_NOT_EXIST = 2;
    private int existsRequirement;

    public DAVResource(String url) throws DAVException {
        this(new ConnectionInfo(url));
    }

    public DAVResource(String url, String userName, String password) throws DAVException {
        this(new ConnectionInfo(url, userName, password));
    }

    public DAVResource(URL url) throws DAVException {
        this(new ConnectionInfo(url.toString()));
    }

    public DAVResource(String url, boolean createCollection) throws DAVException {
        this(new ConnectionInfo(url), createCollection);
    }

    public DAVResource(ConnectionInfo cInfo) throws DAVException {
        this(cInfo, false);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DAVResource(ConnectionInfo cInfo, boolean createCollection) throws DAVException {
        CloseableHttpResponse httpResponse;
        block34: {
            this.depth = 0;
            this._lockManager = new LockManager();
            this._multiStatus = new HashMap();
            this.proxyPort = -1;
            this.existsRequirement = 0;
            long start = System.currentTimeMillis();
            this._connectionInfo = cInfo;
            String url = cInfo.getUrl();
            this.userName = cInfo.getUser();
            this.password = cInfo.getPW();
            this.proxyHost = cInfo.getProxyHost();
            this.proxyPort = cInfo.getProxyPort();
            if (LOGGER.isDebugEnabled()) {
                this.debug = 10;
                if (this.userName != null && !"".equals(url)) {
                    this.logDebug(Message.format((ResourceBundle)RB.getResources(), (String)"DAVResource.constructor.fmt.txt", (Object)url, (Object)this.userName));
                } else {
                    this.logDebug(Message.format((ResourceBundle)RB.getResources(), (String)"DAVResource.constructornouser.fmt.txt", (Object)url));
                }
            }
            URL _url = null;
            String testUrl = url;
            try {
                _url = new URL(testUrl);
            }
            catch (MalformedURLException e) {
                throw new DAVException(Message.format((ResourceBundle)RB.getResources(), (String)"DAVResource.invalidhttpurl.ex.fmt.txt", (Object)url), e);
            }
            String userinfo = _url.getUserInfo();
            String user = null;
            String pw = null;
            int ptr = 0;
            if (userinfo != null && (ptr = userinfo.indexOf(58)) > 0 && ptr < userinfo.length() - 1) {
                user = userinfo.substring(0, ptr);
                pw = userinfo.substring(ptr + 1);
                if (this.userName == null) {
                    this.userName = user;
                }
                if (this.password == null) {
                    this.password = pw;
                }
            }
            int port = _url.getPort();
            String path = _url.getPath();
            if (_url.getQuery() != null) {
                path = path + '?' + _url.getQuery();
            }
            if (_url.getRef() != null) {
                path = path + '#' + _url.getRef();
            }
            String uriUserInfo = null;
            String uriQuery = null;
            String uriFragment = null;
            String uriPath = '/' + Utils.stripLeadingSlashes(path);
            if ("http".equalsIgnoreCase(_url.getProtocol())) {
                if (port == -1) {
                    port = 80;
                }
                try {
                    this._httpURI = new URI("http", uriUserInfo, _url.getHost(), port, uriPath, uriQuery, uriFragment);
                }
                catch (URISyntaxException e) {
                    throw new DAVException(e.getMessage(), e);
                }
            }
            if ("https".equalsIgnoreCase(_url.getProtocol())) {
                if (port == -1) {
                    port = 443;
                }
                try {
                    this._httpURI = new URI("https", uriUserInfo, _url.getHost(), port, uriPath, uriQuery, uriFragment);
                }
                catch (URISyntaxException e) {
                    throw new DAVException(e.getMessage(), e);
                }
            }
            if (this.proxyHost == null) {
                ProxySelector ps = ProxySelector.getDefault();
                try {
                    Proxy proxy;
                    URI uri = new URI(_url.getProtocol(), null, _url.getHost(), port, null, null, null);
                    List<Proxy> proxyList = ps.select(uri);
                    if (proxyList.size() > 0 && (proxy = proxyList.get(0)).type() == Proxy.Type.HTTP) {
                        InetSocketAddress addr = (InetSocketAddress)proxy.address();
                        this.proxyHost = addr.getHostName();
                        this.proxyPort = addr.getPort();
                    }
                }
                catch (URISyntaxException e) {
                    LOGGER.error((Object)e);
                }
            }
            if (this.proxyHost != null) {
                String proxyUser = System.getProperty("http.proxyUser");
                String proxyPass = System.getProperty("http.proxyPassword");
                if (proxyUser == null) {
                    proxyUser = System.getProperty("https.proxyUser");
                    if (proxyPass == null) {
                        proxyPass = System.getProperty("https.proxyPassword");
                    }
                }
            }
            this._httpHost = new HttpHost(_url.getHost(), port, _url.getProtocol());
            this._httpClient = this.newHttpClient(this._httpHost, false);
            this.getBasicProperties(this._httpClient);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.log(Level.DEBUG, Message.format((ResourceBundle)RB.getResources(), (String)"DAVResource.constructorstatus.fmt.txt", (Object)new String(this._httpURI.getRawPath()), (Object)Integer.toString(this.status)));
            }
            this.logTime(start, System.currentTimeMillis(), "DAVResource");
            if (this._httpURI == null) return;
            if (!createCollection) return;
            httpResponse = null;
            try {
                long t0 = System.currentTimeMillis();
                HttpMkcol httpMkcol = new HttpMkcol(this._httpURI);
                httpResponse = this._httpClient.execute((HttpUriRequest)httpMkcol);
                try {
                    httpMkcol.checkSuccess((HttpResponse)httpResponse);
                    StatusLine statusLine = httpResponse.getStatusLine();
                    this.status = statusLine.getStatusCode();
                    this.logTime(t0, System.currentTimeMillis(), "MKCOL");
                }
                catch (DavException e) {
                    if (this.status != 405) {
                        this.logMethodMessage("MKCOL", this.status, Level.WARN);
                        break block34;
                    }
                    this.logMethodMessage("MKCOL", this.status, Level.DEBUG);
                    this.processError(this.status, "MKCOL", this._httpURI.toString());
                }
            }
            catch (ClientProtocolException e) {
                try {
                    throw new DAVException(e.getMessage(), (Exception)((Object)e));
                    catch (IOException e2) {
                        throw new DAVException(e2.getMessage(), e2);
                    }
                }
                catch (Throwable throwable) {
                    DAVResource.closeHttpResponse(httpResponse);
                    throw throwable;
                }
            }
        }
        DAVResource.closeHttpResponse(httpResponse);
    }

    @Override
    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        if (null != this._connectionInfo) {
            this._connectionInfo.setCredentialsProvider(credentialsProvider);
        }
    }

    private final CloseableHttpClient newHttpClient(HttpHost httpHost, boolean isDecodePassword) {
        CloseableHttpClient httpClient = null;
        HttpClientBuilder httpClientBuilder = HttpClients.custom();
        CredentialsProvider credentialsProvider = null == this._connectionInfo ? null : this._connectionInfo.getCredentialsProvider();
        BasicCredentialsProvider basicCredentialsProvider = new BasicCredentialsProvider();
        if (null != this.userName) {
            if (isDecodePassword) {
                try {
                    String pw = SasPasswordString.decode((String)this.password);
                    if (!this.password.equals(pw)) {
                        this.password = pw;
                    }
                }
                catch (SasPasswordEncodingException pw) {
                    // empty catch block
                }
            }
            basicCredentialsProvider.setCredentials(new AuthScope(httpHost), (Credentials)new UsernamePasswordCredentials(this.userName, this.password));
            if (null != this.proxyHost) {
                String proxyUser = System.getProperty("http.proxyUser");
                String proxyPass = System.getProperty("http.proxyPassword");
                if (proxyUser == null) {
                    proxyUser = System.getProperty("https.proxyUser");
                    if (proxyPass == null) {
                        proxyPass = System.getProperty("https.proxyPassword");
                    }
                }
                if (null != proxyUser) {
                    String proxyRealm = System.getProperty("http.proxyRealm");
                    String proxyScheme = System.getProperty("http.proxyScheme");
                    String proxyUserPassword = proxyPass;
                    if (isDecodePassword) {
                        try {
                            String pw = SasPasswordString.decode((String)proxyUserPassword);
                            if (!proxyUserPassword.equals(pw)) {
                                proxyUserPassword = pw;
                            }
                        }
                        catch (SasPasswordEncodingException sasPasswordEncodingException) {
                            // empty catch block
                        }
                    }
                    basicCredentialsProvider.setCredentials(new AuthScope(AuthScope.ANY_HOST, -1, proxyRealm, proxyScheme), (Credentials)new UsernamePasswordCredentials(proxyUser, proxyUserPassword));
                }
            }
        }
        if (null == credentialsProvider) {
            credentialsProvider = basicCredentialsProvider;
        }
        if (null != this.proxyHost) {
            httpClientBuilder.setProxy(new HttpHost(this.proxyHost, this.proxyPort));
        }
        httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
        httpClient = httpClientBuilder.build();
        return httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean makeCollection() throws DAVException {
        CloseableHttpResponse httpResponse;
        boolean isSuccess;
        block10: {
            isSuccess = false;
            httpResponse = null;
            try {
                long t0 = System.currentTimeMillis();
                try {
                    HttpMkcol httpMkcol = new HttpMkcol(this._httpURI);
                    httpResponse = this._httpClient.execute((HttpUriRequest)httpMkcol);
                    try {
                        StatusLine statusLine = httpResponse.getStatusLine();
                        this.status = statusLine.getStatusCode();
                        httpMkcol.checkSuccess((HttpResponse)httpResponse);
                        isSuccess = true;
                    }
                    catch (DavException e) {
                        if (this.status == 405) {
                            this.logMethodMessage("MKCOL", this.status, Level.DEBUG);
                            break block10;
                        }
                        this.logMethodMessage("MKCOL", this.status, Level.WARN);
                        this.processError(this.status, "MKCOL", this._httpURI.toString());
                    }
                }
                finally {
                    this.logTime(t0, System.currentTimeMillis(), "MKCOL");
                }
            }
            catch (IOException e) {
                try {
                    throw new DAVException(e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    DAVResource.closeHttpResponse(httpResponse);
                    throw throwable;
                }
            }
        }
        DAVResource.closeHttpResponse(httpResponse);
        return isSuccess;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DAVResource copy(String targetPath) throws DAVException, RemoteException {
        DAVResource copiedDAVResource = null;
        long t0 = System.currentTimeMillis();
        if (null == this._httpURI) return copiedDAVResource;
        CloseableHttpResponse httpResponse = null;
        try {
            URI newHttpURI = null;
            try {
                newHttpURI = new URI(this._httpURI.getScheme(), this._httpURI.getUserInfo(), this._httpURI.getHost(), this._httpURI.getPort(), targetPath, this._httpURI.getQuery(), this._httpURI.getFragment());
            }
            catch (URISyntaxException e) {
                throw new DAVException(e.getMessage(), e);
            }
            boolean shallow = false;
            HttpCopy httpCopy = new HttpCopy(this._httpURI, newHttpURI, this.overwrite, shallow);
            httpResponse = this._httpClient.execute((HttpUriRequest)httpCopy);
            this.status = httpResponse.getStatusLine().getStatusCode();
            if (!httpCopy.succeeded((HttpResponse)httpResponse)) {
                this.logMethodMessage("COPY", this.status, Level.WARN);
                this.processError(this.status, "COPY", this._httpURI.getRawPath());
            } else {
                URL newEncodedURL = newHttpURI.toURL();
                URL newRawURL = new URL(newEncodedURL.getProtocol(), newEncodedURL.getHost(), newEncodedURL.getPort(), targetPath);
                String newURL = newRawURL.toString();
                ConnectionInfo connectionInfo = null;
                connectionInfo = null == this.userName ? new ConnectionInfo(newURL) : new ConnectionInfo(newURL, this.userName, this.password);
                if (null != this._connectionInfo) {
                    connectionInfo.setAuthScope(this._connectionInfo.getAuthScope());
                    connectionInfo.setCredentialsProvider(this._connectionInfo.getCredentialsProvider());
                    if (null != connectionInfo.getCredentialsProvider()) {
                        Credentials credentials = connectionInfo.getCredentialsProvider().getCredentials(connectionInfo.getAuthScope());
                        connectionInfo.setPW(credentials.getPassword());
                    }
                }
                copiedDAVResource = new DAVResource(connectionInfo, false);
            }
        }
        catch (ClientProtocolException e) {
            try {
                throw new DAVException(e.getMessage(), (Exception)((Object)e));
                catch (IOException e2) {
                    throw new DAVException(e2.getMessage(), e2);
                }
            }
            catch (Throwable throwable) {
                DAVResource.closeHttpResponse(httpResponse);
                this.logTime(t0, System.currentTimeMillis(), "COPY");
                throw throwable;
            }
        }
        DAVResource.closeHttpResponse(httpResponse);
        this.logTime(t0, System.currentTimeMillis(), "COPY");
        return copiedDAVResource;
    }

    @Override
    public void delete() throws DAVException, RemoteException {
        CloseableHttpResponse httpResponse = null;
        if (null != this._httpURI) {
            long t0 = System.currentTimeMillis();
            try {
                HttpDelete httpDelete = new HttpDelete(this._httpURI);
                this.generateIfHeader((AbstractHttpMessage)httpDelete, this._httpURI);
                httpResponse = this._httpClient.execute((HttpUriRequest)httpDelete);
                boolean isSuccess = httpDelete.succeeded((HttpResponse)httpResponse);
                StatusLine statusLine = httpResponse.getStatusLine();
                this.status = statusLine.getStatusCode();
                if (!isSuccess) {
                    this.logMethodMessage("DELETE", this.status, Level.WARN);
                    this.processError(this.status, "DELETE", this._httpURI.getRawPath());
                }
                this.logTime(t0, System.currentTimeMillis(), "DELETE");
            }
            catch (IOException e) {
                try {
                    throw new DAVException(e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    this.logTime(t0, System.currentTimeMillis(), "DELETE");
                    DAVResource.closeHttpResponse(httpResponse);
                    throw throwable;
                }
            }
            DAVResource.closeHttpResponse(httpResponse);
        }
    }

    public String getLock(String userName) throws DAVException {
        return this._lockManager.getLock(this._httpURI.getPath(), userName);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] getContents() throws DAVException, RemoteException {
        byte[] contentBytes = null;
        if (null == this._httpURI) return contentBytes;
        CloseableHttpResponse httpResponse = null;
        long t0 = System.currentTimeMillis();
        try {
            HttpGet httpGet = new HttpGet(this._httpURI);
            httpResponse = this._httpClient.execute((HttpUriRequest)httpGet);
            this.status = httpResponse.getStatusLine().getStatusCode();
            if (!DAVResource.SUCCEEDED(this.status)) {
                if (404 == this.status) {
                    this.logMethodMessage("GET", this.status, Level.DEBUG);
                } else {
                    this.logMethodMessage("GET", this.status, Level.WARN);
                    this.processError(this.status, "GET", this._httpURI.getRawPath());
                }
                contentBytes = new byte[]{};
            } else {
                try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                    HttpEntity httpEntity = httpResponse.getEntity();
                    try (InputStream contents = httpEntity.getContent();){
                        byte[] buffer = new byte[4096];
                        int nb = 0;
                        while (-1 != (nb = contents.read(buffer))) {
                            os.write(buffer, 0, nb);
                        }
                    }
                    contentBytes = os.toByteArray();
                }
            }
            this.logTime(t0, System.currentTimeMillis(), "GET");
        }
        catch (ClientProtocolException e) {
            try {
                throw new DAVException(e.getMessage(), (Exception)((Object)e));
                catch (IOException e2) {
                    throw new DAVException(e2.getMessage(), e2);
                }
            }
            catch (Throwable throwable) {
                this.logTime(t0, System.currentTimeMillis(), "GET");
                DAVResource.closeHttpResponse(httpResponse);
                throw throwable;
            }
        }
        DAVResource.closeHttpResponse(httpResponse);
        return contentBytes;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getContentsAsString() throws DAVException, RemoteException {
        long t0;
        CloseableHttpResponse httpResponse;
        String contents;
        block26: {
            contents = null;
            if (null == this._httpURI) return contents;
            httpResponse = null;
            t0 = System.currentTimeMillis();
            HttpGet httpGet = new HttpGet(this._httpURI);
            httpResponse = this._httpClient.execute((HttpUriRequest)httpGet);
            this.status = httpResponse.getStatusLine().getStatusCode();
            if (DAVResource.SUCCEEDED(this.status)) break block26;
            if (this.status == 404) {
                this.logMethodMessage("GET", this.status, Level.DEBUG);
            } else {
                this.logMethodMessage("GET", this.status, Level.WARN);
                this.processError(this.status, "GET", this._httpURI.getRawPath());
            }
            String string = "";
            this.logTime(t0, System.currentTimeMillis(), "GET");
            DAVResource.closeHttpResponse(httpResponse);
            return string;
        }
        try {
            Charset charSet;
            HttpEntity httpEntity = httpResponse.getEntity();
            String charset = "ISO-8859-1";
            ContentType contentType = ContentType.get((HttpEntity)httpEntity);
            if (null != contentType && null != (charSet = contentType.getCharset())) {
                charset = charSet.toString();
            }
            try (InputStream inputStream = httpEntity.getContent();
                 ByteArrayOutputStream os = new ByteArrayOutputStream();){
                byte[] buffer = new byte[4096];
                int nb = 0;
                while ((nb = inputStream.read(buffer)) != -1) {
                    os.write(buffer, 0, nb);
                }
                byte[] content = os.toByteArray();
                try {
                    contents = new String(content, charset);
                }
                catch (UnsupportedEncodingException e) {
                    this.logWarn(Message.format((ResourceBundle)RB.getResources(), (String)"DAVResource.unsuppcharencoding.fmt.txt", (Object)charset));
                    if ("ISO-8859-1".equals(charset)) {
                        throw e;
                    }
                    try {
                        contents = new String(content, "ISO-8859-1");
                    }
                    catch (UnsupportedEncodingException e2) {
                        this.logWarn(Message.format((ResourceBundle)RB.getResources(), (String)"DAVResource.unsuppcharencoding.fmt.txt", (Object)"ISO-8859-1"));
                        contents = new String(content);
                    }
                }
            }
            this.logTime(t0, System.currentTimeMillis(), "GET");
        }
        catch (ClientProtocolException e) {
            try {
                throw new DAVException(e.getMessage(), (Exception)((Object)e));
                catch (IOException e2) {
                    throw new DAVException(e2.getMessage(), e2);
                }
            }
            catch (Throwable throwable) {
                this.logTime(t0, System.currentTimeMillis(), "GET");
                DAVResource.closeHttpResponse(httpResponse);
                throw throwable;
            }
        }
        DAVResource.closeHttpResponse(httpResponse);
        return contents;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void getContents(File fileData) throws DAVException, RemoteException {
        if (null == this._httpURI) return;
        CloseableHttpResponse httpResponse = null;
        long t0 = System.currentTimeMillis();
        try {
            block27: {
                HttpGet httpGet = new HttpGet(this._httpURI);
                httpResponse = this._httpClient.execute((HttpUriRequest)httpGet);
                this.status = httpResponse.getStatusLine().getStatusCode();
                if (!DAVResource.SUCCEEDED(this.status)) {
                    if (this.status == 404) {
                        this.logMethodMessage("GET", this.status, Level.DEBUG);
                    } else {
                        this.logMethodMessage("GET", this.status, Level.WARN);
                        this.processError(this.status, "GET", this._httpURI.getRawPath());
                    }
                    try (FileOutputStream fout = new FileOutputStream(fileData);){
                        fout.write(new byte[0]);
                        break block27;
                    }
                    catch (IOException e) {
                        throw new DAVException(e.getMessage(), e);
                    }
                }
                try (FileOutputStream fout = new FileOutputStream(fileData);){
                    HttpEntity httpEntity = httpResponse.getEntity();
                    try (InputStream in = httpEntity.getContent();){
                        int len;
                        byte[] buffer = new byte[2048];
                        while ((len = in.read(buffer)) != -1) {
                            fout.write(buffer, 0, len);
                        }
                    }
                }
            }
            this.logTime(t0, System.currentTimeMillis(), "GET");
        }
        catch (ClientProtocolException e) {
            try {
                throw new DAVException(e.getMessage(), (Exception)((Object)e));
                catch (IOException e2) {
                    throw new DAVException(e2.getMessage(), e2);
                }
            }
            catch (Throwable throwable) {
                this.logTime(t0, System.currentTimeMillis(), "GET");
                DAVResource.closeHttpResponse(httpResponse);
                throw throwable;
            }
        }
        DAVResource.closeHttpResponse(httpResponse);
    }

    @Override
    public InputStream getContentsInputStream() throws DAVException, RemoteException {
        ReadOnceFileInputStream rspStream = null;
        if (null != this._httpURI) {
            try {
                File fileData = FileCleanup.getInstance().newTemporaryFile(0);
                this.getContents(fileData);
                rspStream = new ReadOnceFileInputStream(fileData);
            }
            catch (IOException e) {
                throw new DAVException(e.getMessage(), e);
            }
        }
        return new InputStreamAdapter(rspStream);
    }

    @Override
    public String getContentType() {
        return this._contentType;
    }

    @Override
    public ContentType contentType() {
        ContentType contentType = null;
        String mimeType = null;
        String charset = null;
        String davResourceContentType = this.getContentType();
        if (null != davResourceContentType) {
            int index = (davResourceContentType = davResourceContentType.trim()).indexOf(59);
            if (0 < index) {
                String value = davResourceContentType.substring(0, index);
                mimeType = value.endsWith(";") ? value.substring(0, value.length() - 1) : value;
                if (0 < (value = davResourceContentType.substring(++index).trim()).length()) {
                    String charsetToken = "charset=";
                    index = value.indexOf("charset=");
                    if (0 <= index) {
                        int startIndex = index + "charset=".length();
                        int endIndex = value.indexOf(" ", startIndex);
                        if (-1 == endIndex) {
                            endIndex = value.length();
                        }
                        charset = value.substring(startIndex, endIndex);
                    }
                }
            } else {
                mimeType = davResourceContentType;
            }
        }
        if (null != mimeType) {
            contentType = ContentType.create(mimeType, charset);
        }
        return contentType;
    }

    @Override
    public DavPropertyResult getDavProperties() throws DAVException, RemoteException {
        return this.getDavProperties(this.depth);
    }

    @Override
    public DavPropertyResult getDavProperties(int depth) throws DAVException, RemoteException {
        DavPropertyResult davPropertyResult = new DavPropertyResult();
        CloseableHttpResponse httpResponse = null;
        long t0 = System.currentTimeMillis();
        try {
            HttpPropfind httpPropfind = new HttpPropfind(this._httpURI, 1, depth);
            httpResponse = this._httpClient.execute((HttpUriRequest)httpPropfind);
            this.status = httpResponse.getStatusLine().getStatusCode();
            MultiStatusHolder multiStatusHolder = this.processMultiStatus((BaseDavRequest)httpPropfind, httpResponse);
            davPropertyResult = multiStatusHolder.getDavPropertyResult();
            int sc = multiStatusHolder.getHTTPStatusCode();
            if (sc > -1) {
                this.status = sc;
            }
            if (!httpPropfind.succeeded((HttpResponse)httpResponse)) {
                if (404 != this.status) {
                    this.logMethodMessage("PROPFIND", this.status, Level.WARN);
                    this.processError(this.status, "PROPFIND", this._httpURI.getPath());
                } else {
                    this.logMethodMessage("PROPFIND", this.status, Level.DEBUG);
                }
            }
            this.logTime(t0, System.currentTimeMillis(), "PROPFIND");
        }
        catch (IOException e) {
            try {
                throw new DAVException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                this.logTime(t0, System.currentTimeMillis(), "PROPFIND");
                DAVResource.closeHttpResponse(httpResponse);
                throw throwable;
            }
        }
        DAVResource.closeHttpResponse(httpResponse);
        return davPropertyResult;
    }

    @Override
    public DavPropertyResult getDavProperties(PropertyName[] propertyNames) throws DAVException, RemoteException {
        return this.getDavProperties(propertyNames, this.depth);
    }

    @Override
    public DavPropertyResult getDavProperties(PropertyName[] propertyNames, int depth) throws DAVException, RemoteException {
        DavPropertyNameSet davPropertyNameSet = DAVResource.toDavPropertyNameSet(propertyNames);
        return this.getDavProperties(davPropertyNameSet, depth);
    }

    @Override
    public DavPropertyResult getDavProperties(DavPropertyNameSet davPropertyNameSet, int depth) throws DAVException, RemoteException {
        DavPropertyResult davPropertyResult = new DavPropertyResult();
        CloseableHttpResponse httpResponse = null;
        long t0 = System.currentTimeMillis();
        try {
            HttpPropfind httpPropfind = new HttpPropfind(this._httpURI, davPropertyNameSet, depth);
            httpResponse = this._httpClient.execute((HttpUriRequest)httpPropfind);
            this.status = httpResponse.getStatusLine().getStatusCode();
            MultiStatusHolder multiStatusHolder = this.processMultiStatus((BaseDavRequest)httpPropfind, httpResponse);
            davPropertyResult = multiStatusHolder.getDavPropertyResult();
            int sc = multiStatusHolder.getHTTPStatusCode();
            if (-1 < sc) {
                this.status = sc;
            }
            if (!httpPropfind.succeeded((HttpResponse)httpResponse)) {
                if (404 != this.status) {
                    this.logMethodMessage("PROPFIND", this.status, Level.WARN);
                    this.processError(this.status, "PROPFIND", this._httpURI.getRawPath());
                } else {
                    this.logMethodMessage("PROPFIND", this.status, Level.DEBUG);
                }
            }
            this.logTime(t0, System.currentTimeMillis(), "PROPFIND");
        }
        catch (IOException e) {
            try {
                throw new DAVException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                this.logTime(t0, System.currentTimeMillis(), "PROPFIND");
                DAVResource.closeHttpResponse(httpResponse);
                throw throwable;
            }
        }
        DAVResource.closeHttpResponse(httpResponse);
        return davPropertyResult;
    }

    @Override
    public DavPropertyResult getDavPropertyNames() throws DAVException, RemoteException {
        return this.getDavPropertyNames(this.depth);
    }

    @Override
    public DavPropertyResult getDavPropertyNames(int depth) throws DAVException, RemoteException {
        DavPropertyResult davPropertyResult = new DavPropertyResult();
        CloseableHttpResponse httpResponse = null;
        long t0 = System.currentTimeMillis();
        try {
            HttpPropfind httpPropfind = new HttpPropfind(this._httpURI, 2, depth);
            httpResponse = this._httpClient.execute((HttpUriRequest)httpPropfind);
            this.status = httpResponse.getStatusLine().getStatusCode();
            MultiStatusHolder multiStatusHolder = this.processMultiStatus((BaseDavRequest)httpPropfind, httpResponse);
            davPropertyResult = multiStatusHolder.getDavPropertyResult();
            int sc = multiStatusHolder.getHTTPStatusCode();
            if (-1 < sc) {
                this.status = sc;
            }
            if (!httpPropfind.succeeded((HttpResponse)httpResponse)) {
                if (404 != this.status) {
                    this.logMethodMessage("PROPFIND", this.status, Level.WARN);
                    this.processError(this.status, "PROPFIND", this._httpURI.getRawPath());
                } else {
                    this.logMethodMessage("PROPFIND", this.status, Level.DEBUG);
                }
            }
            this.logTime(t0, System.currentTimeMillis(), "PROPFIND");
        }
        catch (IOException e) {
            try {
                throw new DAVException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                this.logTime(t0, System.currentTimeMillis(), "PROPFIND");
                DAVResource.closeHttpResponse(httpResponse);
                throw throwable;
            }
        }
        DAVResource.closeHttpResponse(httpResponse);
        return davPropertyResult;
    }

    @Override
    public int getStatusCode() throws DAVException, RemoteException {
        if (this._httpClient != null && this.status == -1) {
            this.getBasicProperties(this._httpClient);
            this.doneInitialPropfind = true;
        }
        return this.status;
    }

    /*
     * Exception decompiling
     */
    private final int getBasicProperties(CloseableHttpClient httpClient) throws DAVException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 16[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean useCredentials() {
        return this.userName != null && this.userName.length() > 0 && this.password != null && this.password.length() > 0;
    }

    @Override
    public String getStatusMessage() {
        String msg = WebDAVStatus.getStatusText(this.status);
        if (null == msg) {
            msg = Message.format((ResourceBundle)RB.getResources(), (String)"DAVResource.cantgetstatusmessage.fmt.txt", (Object)this.status);
        }
        return msg;
    }

    @Override
    public URL getURL() throws DAVException, RemoteException {
        URL url = null;
        if (null != this._httpURI) {
            try {
                url = this._httpURI.toURL();
            }
            catch (MalformedURLException e) {
                url = null;
            }
            catch (Exception e) {
                url = null;
            }
        }
        return url;
    }

    @Override
    public boolean isCollection() throws DAVException, RemoteException {
        boolean isCollection = false;
        if (null != this._httpClient) {
            if (!this.doneInitialPropfind) {
                this.getBasicProperties(this._httpClient);
                this.doneInitialPropfind = true;
            }
            isCollection = this._isCollection;
        }
        return isCollection;
    }

    @Override
    public boolean isLocked() throws DAVException, RemoteException {
        boolean isLocked = false;
        if (null != this._httpClient) {
            String lock;
            if (!this.doneInitialPropfind) {
                this.getBasicProperties(this._httpClient);
                this.doneInitialPropfind = true;
            }
            isLocked = (lock = this._lockManager.getLock(this._httpURI.getPath(), this.getUserName())) != null;
        }
        return isLocked;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String lock() throws DAVException, RemoteException {
        String lockToken = null;
        CloseableHttpResponse httpResponse = null;
        long t0 = System.currentTimeMillis();
        try {
            long timeoutSeconds = 120L;
            int depth = this.getDepth();
            boolean isDeep = depth != 0 && depth != 2;
            LockInfo lockInfo = new LockInfo(Scope.EXCLUSIVE, Type.WRITE, this.getUserName(), 120L, isDeep);
            HttpLock httpLock = new HttpLock(this._httpURI, lockInfo);
            httpResponse = this._httpClient.execute((HttpUriRequest)httpLock);
            this.status = httpResponse.getStatusLine().getStatusCode();
            if (httpLock.succeeded((HttpResponse)httpResponse)) {
                this._lockDiscovery = httpLock.getResponseBodyAsLockDiscovery((HttpResponse)httpResponse);
                for (ActiveLock activeLock : this._lockDiscovery.getValue()) {
                    String activeLockToken = activeLock.getToken();
                    String owner = activeLock.getOwner();
                    if (null == activeLockToken) continue;
                    this._lockManager.addLock(this._httpURI.getPath(), owner, activeLockToken);
                    lockToken = activeLockToken;
                }
            } else {
                this.logMethodMessage("LOCK", this.status, Level.WARN);
                this.processError(this.status, "LOCK", this._httpURI.getRawPath());
            }
        }
        catch (IOException e) {
            try {
                throw new DAVException(e.getMessage(), e);
                catch (DavException e2) {
                    throw new DAVException(e2.getMessage(), (Exception)((Object)e2));
                }
            }
            catch (Throwable throwable) {
                DAVResource.closeHttpResponse(httpResponse);
                this.logTime(t0, System.currentTimeMillis(), "LOCK");
                throw throwable;
            }
        }
        DAVResource.closeHttpResponse(httpResponse);
        this.logTime(t0, System.currentTimeMillis(), "LOCK");
        return lockToken;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DAVResource move(String targetPath) throws DAVException, RemoteException {
        DAVResource movedDAVResource = null;
        if (null == this._httpURI) return movedDAVResource;
        CloseableHttpResponse httpResponse = null;
        long t0 = System.currentTimeMillis();
        try {
            URI newHttpURI = null;
            try {
                newHttpURI = new URI(this._httpURI.getScheme(), this._httpURI.getUserInfo(), this._httpURI.getHost(), this._httpURI.getPort(), targetPath, this._httpURI.getQuery(), this._httpURI.getFragment());
            }
            catch (URISyntaxException e) {
                throw new DAVException(e.getMessage(), e);
            }
            HttpMove httpMove = new HttpMove(this._httpURI, newHttpURI, this.overwrite);
            httpResponse = this._httpClient.execute((HttpUriRequest)httpMove);
            this.status = httpResponse.getStatusLine().getStatusCode();
            if (!httpMove.succeeded((HttpResponse)httpResponse)) {
                this.logMethodMessage("MOVE", this.status, Level.WARN);
                this.processError(this.status, "MOVE", this._httpURI.getRawPath());
            } else {
                URL newEncodedURL = newHttpURI.toURL();
                URL newRawURL = new URL(newEncodedURL.getProtocol(), newEncodedURL.getHost(), newEncodedURL.getPort(), targetPath);
                String newURL = newRawURL.toString();
                ConnectionInfo connectionInfo = null;
                connectionInfo = null == this.userName ? new ConnectionInfo(newURL) : new ConnectionInfo(newURL, this.userName, this.password);
                if (null != this._connectionInfo) {
                    connectionInfo.setAuthScope(this._connectionInfo.getAuthScope());
                    connectionInfo.setCredentialsProvider(this._connectionInfo.getCredentialsProvider());
                    if (null != connectionInfo.getCredentialsProvider()) {
                        Credentials credentials = connectionInfo.getCredentialsProvider().getCredentials(connectionInfo.getAuthScope());
                        connectionInfo.setPW(credentials.getPassword());
                    }
                }
                movedDAVResource = new DAVResource(connectionInfo, false);
            }
        }
        catch (ClientProtocolException e) {
            try {
                throw new DAVException(e.getMessage(), (Exception)((Object)e));
                catch (IOException e2) {
                    throw new DAVException(e2.getMessage(), e2);
                }
            }
            catch (Throwable throwable) {
                DAVResource.closeHttpResponse(httpResponse);
                this.logTime(t0, System.currentTimeMillis(), "MOVE");
                throw throwable;
            }
        }
        DAVResource.closeHttpResponse(httpResponse);
        this.logTime(t0, System.currentTimeMillis(), "MOVE");
        return movedDAVResource;
    }

    @Override
    public void removeProperties(PropertyName[] propertyNames) throws DAVException, RemoteException {
        DavPropertyNameSet removeDavPropertyNameSet = new DavPropertyNameSet();
        for (PropertyName propertyName : propertyNames) {
            Namespace namespace = Namespace.getNamespace((String)propertyName.getNamespaceURI());
            removeDavPropertyNameSet.add(DavPropertyName.create((String)propertyName.getLocalName(), (Namespace)namespace));
        }
        ProppatchInfo propPatchInfo = new ProppatchInfo(new DavPropertySet(), removeDavPropertyNameSet);
        this.propPatch(propPatchInfo);
    }

    @Override
    public void removeProperties(Element[] propNames) throws DAVException, RemoteException {
        DavPropertyNameSet removeDavPropertyNameSet = new DavPropertyNameSet();
        for (Element element : propNames) {
            Namespace namespace = Namespace.getNamespace((String)element.getNamespaceURI());
            removeDavPropertyNameSet.add(DavPropertyName.create((String)element.getLocalName(), (Namespace)namespace));
        }
        ProppatchInfo propPatchInfo = new ProppatchInfo(new DavPropertySet(), removeDavPropertyNameSet);
        this.propPatch(propPatchInfo);
    }

    @Override
    public void removeProperty(Element propName) throws DAVException, RemoteException {
        DavPropertyNameSet removeDavPropertyNameSet = new DavPropertyNameSet();
        Namespace namespace = Namespace.getNamespace((String)propName.getNamespaceURI());
        removeDavPropertyNameSet.add(DavPropertyName.create((String)propName.getLocalName(), (Namespace)namespace));
        ProppatchInfo propPatchInfo = new ProppatchInfo(new DavPropertySet(), removeDavPropertyNameSet);
        this.propPatch(propPatchInfo);
    }

    @Override
    public void removeProperty(String propName) throws DAVException, RemoteException {
        DavPropertyNameSet removeDavPropertyNameSet = new DavPropertyNameSet();
        removeDavPropertyNameSet.add(DavPropertyName.create((String)propName, null));
        ProppatchInfo propPatchInfo = new ProppatchInfo(new DavPropertySet(), removeDavPropertyNameSet);
        this.propPatch(propPatchInfo);
    }

    @Override
    public void removeProperty(PropertyName propName) throws DAVException, RemoteException {
        DavPropertyNameSet removeDavPropertyNameSet = new DavPropertyNameSet();
        Namespace namespace = Namespace.getNamespace((String)propName.getNamespaceURI());
        removeDavPropertyNameSet.add(DavPropertyName.create((String)propName.getLocalName(), (Namespace)namespace));
        ProppatchInfo propPatchInfo = new ProppatchInfo(new DavPropertySet(), removeDavPropertyNameSet);
        this.propPatch(propPatchInfo);
    }

    @Override
    public DavPropertyResult doSearch(SearchInfo searchInfo) throws DAVException, RemoteException {
        DavPropertyResult davPropertyResult = new DavPropertyResult();
        CloseableHttpResponse httpResponse = null;
        long t0 = System.currentTimeMillis();
        try {
            HttpSearch httpSearch = new HttpSearch(this._httpURI, searchInfo);
            httpResponse = this._httpClient.execute((HttpUriRequest)httpSearch);
            this.status = httpResponse.getStatusLine().getStatusCode();
            if (!httpSearch.succeeded((HttpResponse)httpResponse)) {
                this.logMethodMessage("SEARCH", this.status, Level.WARN);
                this.processError(this.status, "SEARCH", this._httpURI.getRawPath());
            }
            MultiStatusHolder multiStatusHolder = this.processMultiStatus((BaseDavRequest)httpSearch, httpResponse);
            davPropertyResult = multiStatusHolder.getDavPropertyResult();
        }
        catch (IOException e) {
            try {
                throw new DAVException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                DAVResource.closeHttpResponse(httpResponse);
                this.logTime(t0, System.currentTimeMillis(), "SEARCH");
                throw throwable;
            }
        }
        DAVResource.closeHttpResponse(httpResponse);
        this.logTime(t0, System.currentTimeMillis(), "SEARCH");
        return davPropertyResult;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setContents(byte[] contents) throws DAVException, RemoteException {
        if (null == this._httpURI) return;
        CloseableHttpResponse httpResponse = null;
        long t0 = System.currentTimeMillis();
        try {
            HttpPut httpPut = new HttpPut(this._httpURI);
            this.generateIfHeader((AbstractHttpMessage)httpPut, this._httpURI);
            String contentType = this.getContentType();
            if (null != contentType && !contentType.isEmpty()) {
                httpPut.addHeader(CONTENTTYPE, contentType);
            }
            httpPut.setEntity((HttpEntity)new ByteArrayEntity(contents));
            httpResponse = this._httpClient.execute((HttpUriRequest)httpPut);
            this.status = httpResponse.getStatusLine().getStatusCode();
            if (!DAVResource.SUCCEEDED(this.status)) {
                this.logMethodMessage("PUT", this.status, Level.WARN);
                this.processError(this.status, "PUT", this._httpURI.getRawPath());
            }
        }
        catch (ClientProtocolException e) {
            try {
                throw new DAVException(e.getMessage(), (Exception)((Object)e));
                catch (IOException e2) {
                    throw new DAVException(e2.getMessage(), e2);
                }
            }
            catch (Throwable throwable) {
                DAVResource.closeHttpResponse(httpResponse);
                this.logTime(t0, System.currentTimeMillis(), "PUT");
                throw throwable;
            }
        }
        DAVResource.closeHttpResponse(httpResponse);
        this.logTime(t0, System.currentTimeMillis(), "PUT");
    }

    private void logMethodMessage(String method, int status, Level level) {
        if (LOGGER == null) {
            return;
        }
        switch (level.toString()) {
            case "DEBUG": {
                if (!LOGGER.isDebugEnabled()) {
                    return;
                }
                this.logDebug(Message.format((ResourceBundle)RB.getResources(), (String)"DAVResource.methoderror.fmt.txt", (Object)method, (Object)Integer.toString(status), (Object)WebDAVStatus.getStatusText(status), (Object)new String(this._httpURI.getRawPath())));
                break;
            }
            case "WARN": {
                if (status == 404) {
                    this.logInfo(Message.format((ResourceBundle)RB.getResources(), (String)"DAVResource.methodwarn.fmt.txt", (Object)method, (Object)Integer.toString(status), (Object)WebDAVStatus.getStatusText(status), (Object)new String(this._httpURI.getRawPath())));
                    break;
                }
                this.logWarn(Message.format((ResourceBundle)RB.getResources(), (String)"DAVResource.methodwarn.fmt.txt", (Object)method, (Object)Integer.toString(status), (Object)WebDAVStatus.getStatusText(status), (Object)new String(this._httpURI.getRawPath())));
                break;
            }
        }
    }

    private HttpPut newHttpPutNoExpectContinue(URI uri) {
        return new HttpPut(uri){

            public boolean expectContinue() {
                return false;
            }
        };
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setContents(URL url) throws DAVException, RemoteException {
        if (null == this._httpURI) return;
        CloseableHttpResponse httpResponse = null;
        long t0 = System.currentTimeMillis();
        try {
            HttpPut httpPut = new HttpPut(this._httpURI);
            this.generateIfHeader((AbstractHttpMessage)httpPut, this._httpURI);
            String contentType = this.getContentType();
            if (null != contentType && !contentType.isEmpty()) {
                httpPut.addHeader(CONTENTTYPE, contentType);
            }
            try (InputStream is = url.openConnection().getInputStream();
                 ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                byte[] buffer = new byte[4096];
                while (is.read(buffer) != -1) {
                    baos.write(buffer);
                }
                httpPut.setEntity((HttpEntity)new ByteArrayEntity(baos.toByteArray()));
                httpPut.addHeader(CONTENTLENGTH, String.valueOf(baos.size()));
            }
            httpResponse = this._httpClient.execute((HttpUriRequest)httpPut);
            this.status = httpResponse.getStatusLine().getStatusCode();
            if (!DAVResource.SUCCEEDED(this.status)) {
                this.logMethodMessage("PUT", this.status, Level.WARN);
                this.processError(this.status, "PUT", this._httpURI.getRawPath());
            }
        }
        catch (ClientProtocolException e) {
            try {
                throw new DAVException(e.getMessage(), (Exception)((Object)e));
                catch (IOException e2) {
                    throw new DAVException(e2.getMessage(), e2);
                }
            }
            catch (Throwable throwable) {
                DAVResource.closeHttpResponse(httpResponse);
                this.logTime(t0, System.currentTimeMillis(), "PUT");
                throw throwable;
            }
        }
        DAVResource.closeHttpResponse(httpResponse);
        this.logTime(t0, System.currentTimeMillis(), "PUT");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setContents(String content) throws DAVException, RemoteException {
        if (null == this._httpURI) return;
        CloseableHttpResponse httpResponse = null;
        long t0 = System.currentTimeMillis();
        try {
            int ptr;
            HttpPut httpPut = new HttpPut(this._httpURI);
            this.generateIfHeader((AbstractHttpMessage)httpPut, this._httpURI);
            String contentType = this.getContentType();
            String charset = null;
            if (null != contentType && 0 < (ptr = contentType.indexOf("charset="))) {
                charset = contentType.substring(ptr + "charset=".length());
            }
            if (null != contentType && !contentType.isEmpty()) {
                httpPut.addHeader(CONTENTTYPE, contentType);
            }
            byte[] contents = null != charset ? content.getBytes(charset) : content.getBytes("ISO-8859-1");
            httpPut.setEntity((HttpEntity)new ByteArrayEntity(contents));
            httpResponse = this._httpClient.execute((HttpUriRequest)httpPut);
            this.status = httpResponse.getStatusLine().getStatusCode();
            if (!DAVResource.SUCCEEDED(this.status)) {
                this.logMethodMessage("PUT", this.status, Level.WARN);
                this.processError(this.status, "PUT", this._httpURI.getRawPath());
            }
        }
        catch (ClientProtocolException e) {
            try {
                throw new DAVException(e.getMessage(), (Exception)((Object)e));
                catch (IOException e2) {
                    throw new DAVException(e2.getMessage(), e2);
                }
            }
            catch (Throwable throwable) {
                DAVResource.closeHttpResponse(httpResponse);
                this.logTime(t0, System.currentTimeMillis(), "PUT");
                throw throwable;
            }
        }
        DAVResource.closeHttpResponse(httpResponse);
        this.logTime(t0, System.currentTimeMillis(), "PUT");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setContents(InputStream is) throws DAVException, RemoteException {
        File fileData;
        long t0;
        CloseableHttpResponse httpResponse;
        block21: {
            if (null == this._httpURI) return;
            httpResponse = null;
            t0 = System.currentTimeMillis();
            fileData = null;
            fileData = FileCleanup.getInstance().newTemporaryFile(0);
            int streamSize = 0;
            byte[] buffer = new byte[4096];
            int nb = 0;
            try (FileOutputStream fStream = new FileOutputStream(fileData);){
                while ((nb = is.read(buffer)) != -1) {
                    fStream.write(buffer, 0, nb);
                    streamSize += nb;
                }
            }
            catch (IOException e) {
                throw new DAVException(e.getMessage(), e);
            }
            HttpPut httpPut = new HttpPut(this._httpURI);
            this.generateIfHeader((AbstractHttpMessage)httpPut, this._httpURI);
            if ("true".equalsIgnoreCase(System.getProperty("com.sas.services.webdav.use.expect.continue"))) {
                RequestConfig.Builder builder = RequestConfig.custom().setExpectContinueEnabled(true);
                if (null != this._httpHost) {
                    builder.setProxy(this._httpHost);
                }
                RequestConfig requestConfig = builder.build();
                httpPut.setConfig(requestConfig);
            }
            ContentType contentType = this.contentType();
            FileEntity fileEntity = new FileEntity(fileData, contentType);
            fileEntity.setChunked(true);
            httpPut.setEntity((HttpEntity)fileEntity);
            httpResponse = this._httpClient.execute((HttpUriRequest)httpPut);
            this.status = httpResponse.getStatusLine().getStatusCode();
            if (417 == this.status) {
                DAVResource.closeHttpResponse(httpResponse);
                this.logTime(t0, System.currentTimeMillis(), "PUT");
                this.logMethodMessage("PUT", this.status, Level.WARN);
                HttpPut httpPutNoExpectContinue = this.newHttpPutNoExpectContinue(this._httpURI);
                this.generateIfHeader((AbstractHttpMessage)httpPutNoExpectContinue, this._httpURI);
                httpPutNoExpectContinue.addHeader(CONTENTLENGTH, String.valueOf(streamSize));
                httpPutNoExpectContinue.setEntity((HttpEntity)new FileEntity(fileData, contentType));
                t0 = System.currentTimeMillis();
                httpResponse = this._httpClient.execute((HttpUriRequest)httpPutNoExpectContinue);
                this.status = httpResponse.getStatusLine().getStatusCode();
            }
            if (DAVResource.SUCCEEDED(this.status)) break block21;
            this.logMethodMessage("PUT", this.status, Level.WARN);
            this.processError(this.status, "PUT", this._httpURI.getRawPath());
        }
        DAVResource.closeHttpResponse(httpResponse);
        this.logTime(t0, System.currentTimeMillis(), "PUT");
        try {
            fileData.delete();
            return;
        }
        catch (SecurityException e) {
            throw new DAVException(e.getMessage(), e);
        }
        catch (ClientProtocolException e) {
            try {
                throw new DAVException(e.getMessage(), (Exception)((Object)e));
                catch (IOException e2) {
                    throw new DAVException(e2.getMessage(), e2);
                }
            }
            catch (Throwable throwable) {
                DAVResource.closeHttpResponse(httpResponse);
                this.logTime(t0, System.currentTimeMillis(), "PUT");
                try {
                    fileData.delete();
                    throw throwable;
                }
                catch (SecurityException e3) {
                    throw new DAVException(e3.getMessage(), e3);
                }
            }
        }
    }

    @Override
    public void setContentType(String contentType) throws DAVException, RemoteException {
        this._contentType = contentType;
    }

    @Override
    public void setProperties(Element[] elems) throws DAVException, RemoteException {
        DavPropertySet davPropertySet = new DavPropertySet();
        for (Element element : elems) {
            Namespace namespace = Namespace.getNamespace((String)element.getPrefix(), (String)element.getNamespaceURI());
            DavPropertyName davPropertyName = DavPropertyName.create((String)element.getLocalName(), (Namespace)namespace);
            DefaultDavProperty davProperty = new DefaultDavProperty(davPropertyName, (Object)DAVResource.elementToPropertyValue(element));
            davPropertySet.add((DavProperty)davProperty);
        }
        ProppatchInfo propPatchInfo = new ProppatchInfo(davPropertySet, new DavPropertyNameSet());
        this.propPatch(propPatchInfo);
    }

    @Override
    public void setProperties(PropertyName[] propNames, String[] propValues) throws DAVException, RemoteException {
        int numPropValues;
        int numPropNames = null == propNames ? 0 : propNames.length;
        int n = numPropValues = null == propValues ? 0 : propValues.length;
        if (numPropNames != numPropValues) {
            throw new IllegalArgumentException("The number of property names must match the number of property values.");
        }
        if (0 < numPropNames) {
            DavPropertySet davPropertySet = new DavPropertySet();
            HashMap<String, String> prefixMap = new HashMap<String, String>(numPropNames);
            for (int i = 0; i < numPropNames; ++i) {
                PropertyName propertyName = propNames[i];
                String propertyValue = propValues[i];
                String namespaceURI = propertyName.getNamespaceURI();
                String prefix = propertyName.getPrefix();
                if (prefixMap.containsKey(prefix)) {
                    String _usedNS = (String)prefixMap.get(prefix);
                    if (!_usedNS.equals(namespaceURI)) {
                        prefix = "nsZ" + i;
                        prefixMap.put(prefix, namespaceURI);
                    }
                } else {
                    prefixMap.put(prefix, namespaceURI);
                }
                Namespace namespace = Namespace.getNamespace((String)prefix, (String)propertyName.getNamespaceURI());
                DavPropertyName davPropertyName = DavPropertyName.create((String)propertyName.getLocalName(), (Namespace)namespace);
                DefaultDavProperty davProperty = new DefaultDavProperty(davPropertyName, (Object)Utils.XMLESCAPE(propertyValue));
                davPropertySet.add((DavProperty)davProperty);
            }
            ProppatchInfo propPatchInfo = new ProppatchInfo(davPropertySet, new DavPropertyNameSet());
            this.propPatch(propPatchInfo);
        }
    }

    @Override
    public void setProperties(DocumentFragment props) throws DAVException, RemoteException {
        DavPropertySet davPropertySet = new DavPropertySet();
        NodeList nodeList = props.getChildNodes();
        int numNodes = nodeList.getLength();
        for (int i = 0; i < numNodes; ++i) {
            Node node = nodeList.item(i);
            if (node instanceof Element) {
                Element element = (Element)node;
                Namespace namespace = Namespace.getNamespace((String)element.getPrefix(), (String)element.getNamespaceURI());
                DavPropertyName davPropertyName = DavPropertyName.create((String)element.getLocalName(), (Namespace)namespace);
                DefaultDavProperty davProperty = new DefaultDavProperty(davPropertyName, (Object)DAVResource.elementToPropertyValue(element));
                davPropertySet.add((DavProperty)davProperty);
                continue;
            }
            if (!LOGGER.isDebugEnabled()) continue;
            this.logDebug(Message.format((ResourceBundle)RB.getResources(), (String)"DAVResource.wrongnodetype.fmt.txt", (Object)Integer.toString(node.getNodeType())));
        }
        ProppatchInfo propPatchInfo = new ProppatchInfo(davPropertySet, new DavPropertyNameSet());
        this.propPatch(propPatchInfo);
    }

    @Override
    public void setProperty(PropertyName propName, String propValue) throws DAVException, RemoteException {
        Namespace namespace = Namespace.getNamespace((String)propName.getPrefix(), (String)propName.getNamespaceURI());
        DavPropertyName davPropertyName = DavPropertyName.create((String)propName.getLocalName(), (Namespace)namespace);
        DefaultDavProperty davProperty = new DefaultDavProperty(davPropertyName, (Object)Utils.XMLESCAPE(propValue));
        DavPropertySet davPropertySet = new DavPropertySet();
        davPropertySet.add((DavProperty)davProperty);
        ProppatchInfo propPatchInfo = new ProppatchInfo(davPropertySet, new DavPropertyNameSet());
        this.propPatch(propPatchInfo);
    }

    @Override
    public void setProperty(Element prop) throws DAVException, RemoteException {
        DavPropertyName davPropertyName = DavPropertyName.createFromXml((Element)prop);
        DefaultDavProperty davProperty = new DefaultDavProperty(davPropertyName, (Object)DAVResource.elementToPropertyValue(prop));
        DavPropertySet davPropertySet = new DavPropertySet();
        davPropertySet.add((DavProperty)davProperty);
        ProppatchInfo propPatchInfo = new ProppatchInfo(davPropertySet, new DavPropertyNameSet());
        this.propPatch(propPatchInfo);
    }

    @Override
    public void unlock() throws DAVException, RemoteException {
        CloseableHttpResponse httpResponse = null;
        long t0 = System.currentTimeMillis();
        try {
            String owner = this.getUserName();
            String lockToken = this._lockManager.getLock(this._httpURI.getPath(), owner);
            if (null != lockToken && !lockToken.isEmpty()) {
                HttpUnlock httpUnlock = new HttpUnlock(this._httpURI, lockToken);
                this.generateIfHeader((AbstractHttpMessage)httpUnlock, this._httpURI);
                httpResponse = this._httpClient.execute((HttpUriRequest)httpUnlock);
                this.status = httpResponse.getStatusLine().getStatusCode();
                if (httpUnlock.succeeded((HttpResponse)httpResponse)) {
                    this._lockManager.removeLock(this._httpURI.getPath(), owner);
                } else {
                    this.logMethodMessage("UNLOCK", this.status, Level.WARN);
                    this.processError(this.status, "UNLOCK", this._httpURI.getRawPath());
                }
            }
        }
        catch (IOException e) {
            throw new DAVException(e.getMessage(), e);
        }
        finally {
            DAVResource.closeHttpResponse(httpResponse);
            this.logTime(t0, System.currentTimeMillis(), "UNLOCK");
        }
    }

    @Override
    public void unlock(String lockToken) throws DAVException, RemoteException {
        CloseableHttpResponse httpResponse = null;
        long t0 = System.currentTimeMillis();
        try {
            HttpUnlock httpUnlock = new HttpUnlock(this._httpURI, lockToken);
            this.generateIfHeader((AbstractHttpMessage)httpUnlock, this._httpURI);
            httpResponse = this._httpClient.execute((HttpUriRequest)httpUnlock);
            this.status = httpResponse.getStatusLine().getStatusCode();
            if (httpUnlock.succeeded((HttpResponse)httpResponse)) {
                String owner = this.getUserName();
                this._lockManager.removeLock(this._httpURI.getPath(), owner);
            } else {
                this.logMethodMessage("UNLOCK", this.status, Level.WARN);
                this.processError(this.status, "UNLOCK", this._httpURI.getRawPath());
            }
            this.logTime(t0, System.currentTimeMillis(), "UNLOCK");
        }
        catch (IOException e) {
            try {
                throw new DAVException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                this.logTime(t0, System.currentTimeMillis(), "UNLOCK");
                DAVResource.closeHttpResponse(httpResponse);
                throw throwable;
            }
        }
        DAVResource.closeHttpResponse(httpResponse);
    }

    @Override
    public boolean getOverwrite() {
        return this.overwrite;
    }

    @Override
    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    @Override
    public void setDepth(int depth) throws DAVException, RemoteException {
        this.depth = depth;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    public Properties doOptions() throws DAVException, RemoteException {
        Properties headers = new Properties();
        CloseableHttpResponse httpResponse = null;
        long t0 = System.currentTimeMillis();
        try {
            Header[] responseHeaders;
            HttpOptions httpOptions = new HttpOptions(this._httpURI);
            httpResponse = this._httpClient.execute((HttpUriRequest)httpOptions);
            this.status = httpResponse.getStatusLine().getStatusCode();
            if (!DAVResource.SUCCEEDED(this.status)) {
                this.logMethodMessage("OPTIONS", this.status, Level.WARN);
                this.processError(this.status, "OPTIONS", this._httpURI.getRawPath());
            }
            for (Header header : responseHeaders = httpResponse.getAllHeaders()) {
                headers.put(header.getName(), header.getValue());
            }
            Set allowedMethodsSet = httpOptions.getAllowedMethods((HttpResponse)httpResponse);
            this.allowedMethods = allowedMethodsSet.toArray(new String[allowedMethodsSet.size()]);
            Set davComplianceClasses = httpOptions.getDavComplianceClasses((HttpResponse)httpResponse);
            this.davCapabilities = davComplianceClasses.toArray(new String[davComplianceClasses.size()]);
            this.logTime(t0, System.currentTimeMillis(), "OPTIONS");
        }
        catch (IOException e) {
            try {
                throw new DAVException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                this.logTime(t0, System.currentTimeMillis(), "OPTIONS");
                DAVResource.closeHttpResponse(httpResponse);
                throw throwable;
            }
        }
        DAVResource.closeHttpResponse(httpResponse);
        return null != headers ? headers : new Properties();
    }

    public String[] getAllowedMethods() {
        return this.allowedMethods;
    }

    public String[] getDavCapabilities() {
        return this.davCapabilities;
    }

    protected boolean isAuthReqd() {
        return this.authReqd;
    }

    private MultiStatusHolder processMultiStatus(BaseDavRequest baseDavRequest, CloseableHttpResponse httpResponse) {
        MultiStatusHolder multiStatusHolder = new MultiStatusHolder();
        int accSC = -1;
        DavPropertyResult davPropertyResult = multiStatusHolder.getDavPropertyResult();
        if (null != baseDavRequest && null != httpResponse && 207 == httpResponse.getStatusLine().getStatusCode()) {
            block17: {
                try {
                    MultiStatus multiStatus = baseDavRequest.getResponseBodyAsMultiStatus((HttpResponse)httpResponse);
                    if (null != multiStatus) {
                        this._multiStatus.clear();
                        Map<String, Map<String, String>> hrefToHttpStatusMap = multiStatusHolder.getHrefToHttpStatusMap();
                        HashMap<String, String> propStat = new HashMap<String, String>();
                        for (MultiStatusResponse multiStatusResponse : multiStatus.getResponses()) {
                            String href = multiStatusResponse.getHref();
                            for (Status status : multiStatusResponse.getStatus()) {
                                int statusCode = status.getStatusCode();
                                DavPropertySet davPropertySet = multiStatusResponse.getProperties(statusCode);
                                switch (statusCode) {
                                    case 507: {
                                        this.logWarn(Message.format((ResourceBundle)RB.getResources(), (String)"DAVResource.getProperties.insufficientstorage.ex.fmt.txt", (Object)href));
                                    }
                                }
                                for (DavProperty davProperty : davPropertySet) {
                                    davPropertyResult.addDavPropertyItem(new DavPropertyItem(davProperty, statusCode, href));
                                }
                                for (DavPropertyName davPropertyName : davPropertySet.getPropertyNames()) {
                                    Namespace namespace = davPropertyName.getNamespace();
                                    String name = davPropertyName.getName();
                                    if (null != namespace) {
                                        name = '{' + namespace.getURI() + '}' + name;
                                    }
                                    propStat.put(name, Integer.toString(statusCode));
                                    if (!DAVResource.SUCCEEDED(statusCode) && statusCode != 404 && LOGGER.isDebugEnabled()) {
                                        this.logMethodMessage(baseDavRequest.getMethod() + " - " + name, statusCode, Level.DEBUG);
                                    }
                                    if (accSC == -1) {
                                        accSC = statusCode;
                                    } else if (accSC != statusCode) {
                                        accSC = 0;
                                    }
                                    hrefToHttpStatusMap.put(href, propStat);
                                }
                            }
                        }
                        this._multiStatus.putAll(hrefToHttpStatusMap);
                    }
                }
                catch (Exception e) {
                    if (!LOGGER.isDebugEnabled()) break block17;
                    this.logDebug(RB.getStringResource("DAVResource.multistatus.err.txt"));
                }
            }
            if (200 < accSC) {
                multiStatusHolder.setHTTPStatusCode(accSC);
            }
        }
        return multiStatusHolder;
    }

    @Override
    public boolean SUCCEEDED() throws RemoteException {
        try {
            return this.getStatusCode() >= 200 && this.getStatusCode() < 300;
        }
        catch (DAVException dAVException) {
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return false;
    }

    protected static boolean SUCCEEDED(int statusCode) {
        return statusCode >= 200 && statusCode < 300;
    }

    public Map getMultiStatus() {
        return this._multiStatus;
    }

    @Override
    public void close() throws RemoteException {
        if (null != this._httpClient) {
            try {
                this._httpClient.close();
            }
            catch (IOException e) {
                LOGGER.error("An exception was encountered attempting to close the HTTP client.", (Throwable)e);
            }
        }
    }

    @Override
    public void setTempDir(String tempDir) throws RemoteException {
        tempFileDir = new File(tempDir);
    }

    @Override
    public String getTempDir() throws RemoteException {
        return tempFileDir != null ? tempFileDir.getAbsolutePath() : null;
    }

    @Override
    public boolean exists() throws RemoteException {
        if (null == this._httpClient) {
            this.exists = false;
        }
        if (!this.doneInitialPropfind) {
            try {
                this.status = this.getBasicProperties(this._httpClient);
            }
            catch (DAVException e) {
                this.exists = false;
            }
        }
        return this.exists;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DavPropertyResult doReport(ReportInfo reportInfo) throws DAVException {
        DavPropertyResult davPropertyResult = new DavPropertyResult();
        CloseableHttpResponse httpResponse = null;
        long t0 = System.currentTimeMillis();
        try {
            HttpReport httpReport = new HttpReport(this._httpURI, reportInfo);
            httpResponse = this._httpClient.execute((HttpUriRequest)httpReport);
            this.status = httpResponse.getStatusLine().getStatusCode();
            if (!httpReport.succeeded((HttpResponse)httpResponse)) {
                this.logMethodMessage("REPORT", this.status, Level.WARN);
                this.processError(this.status, "REPORT", this._httpURI.getRawPath());
            }
            MultiStatusHolder multiStatusHolder = this.processMultiStatus((BaseDavRequest)httpReport, httpResponse);
            davPropertyResult = multiStatusHolder.getDavPropertyResult();
        }
        catch (ClientProtocolException e) {
            try {
                LOGGER.error(Message.format((ResourceBundle)RB.getResources(), (String)e.getMessage(), (Object)this._httpURI.toString()), (Throwable)e);
                throw new DAVException(e.getMessage(), (Exception)((Object)e));
                catch (IOException e2) {
                    LOGGER.error(Message.format((ResourceBundle)RB.getResources(), (String)e2.getMessage(), (Object)this._httpURI.toString()), (Throwable)e2);
                    throw new DAVException(e2.getMessage(), e2);
                }
            }
            catch (Throwable throwable) {
                DAVResource.closeHttpResponse(httpResponse);
                this.logTime(t0, System.currentTimeMillis(), "REPORT");
                throw throwable;
            }
        }
        DAVResource.closeHttpResponse(httpResponse);
        this.logTime(t0, System.currentTimeMillis(), "REPORT");
        return davPropertyResult;
    }

    @Override
    public String getACL() throws DAVException, RemoteException {
        String multiStatusResponseXML = null;
        CloseableHttpResponse httpResponse = null;
        long t0 = System.currentTimeMillis();
        try {
            HttpEntity httpEntity;
            DavPropertyNameSet davPropertyNameSet = new DavPropertyNameSet();
            DavPropertyName davPropertyName = DavPropertyName.create((String)"acl");
            davPropertyNameSet.add(davPropertyName);
            HttpPropfind httpPropfind = new HttpPropfind(this._httpURI, davPropertyNameSet, 0);
            httpResponse = this._httpClient.execute((HttpUriRequest)httpPropfind);
            this.status = httpResponse.getStatusLine().getStatusCode();
            if (!httpPropfind.succeeded((HttpResponse)httpResponse)) {
                if (404 != this.status) {
                    this.logMethodMessage("PROPFIND", this.status, Level.WARN);
                    this.processError(this.status, "PROPFIND", this._httpURI.getRawPath());
                } else {
                    this.logMethodMessage("PROPFIND", this.status, Level.DEBUG);
                }
            }
            if (null != (httpEntity = httpResponse.getEntity())) {
                multiStatusResponseXML = XMLUtil.node2String(httpPropfind.getResponseBodyAsDocument(httpEntity));
            }
            this.logTime(t0, System.currentTimeMillis(), "PROPFIND");
        }
        catch (IOException e) {
            try {
                throw new DAVException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                this.logTime(t0, System.currentTimeMillis(), "PROPFIND");
                DAVResource.closeHttpResponse(httpResponse);
                throw throwable;
            }
        }
        DAVResource.closeHttpResponse(httpResponse);
        return multiStatusResponseXML;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Acl getAcl() throws DAVException, RemoteException {
        Acl acl = null;
        CloseableHttpResponse httpResponse = null;
        long t0 = System.currentTimeMillis();
        try {
            Element aclElement;
            Document document;
            HttpEntity httpEntity;
            DavPropertyNameSet davPropertyNameSet = new DavPropertyNameSet();
            davPropertyNameSet.add(DavPropertyName.create((String)"acl"));
            HttpPropfind httpPropfind = new HttpPropfind(this._httpURI, davPropertyNameSet, 0);
            httpResponse = this._httpClient.execute((HttpUriRequest)httpPropfind);
            this.status = httpResponse.getStatusLine().getStatusCode();
            if (!httpPropfind.succeeded((HttpResponse)httpResponse)) {
                if (404 != this.status) {
                    this.logMethodMessage("PROPFIND", this.status, Level.WARN);
                    this.processError(this.status, "PROPFIND", this._httpURI.getPath());
                } else {
                    this.logMethodMessage("PROPFIND", this.status, Level.DEBUG);
                }
            }
            if (null != (httpEntity = httpResponse.getEntity()) && null != (document = httpPropfind.getResponseBodyAsDocument(httpEntity)) && null != (aclElement = document.getDocumentElement())) {
                acl = Acl.extractAclFromResponse(aclElement);
            }
            this.logTime(t0, System.currentTimeMillis(), "PROPFIND");
        }
        catch (ClientProtocolException e) {
            try {
                throw new DAVException(e.getMessage(), (Exception)((Object)e));
                catch (IOException e2) {
                    throw new DAVException(e2.getMessage(), e2);
                }
            }
            catch (Throwable throwable) {
                this.logTime(t0, System.currentTimeMillis(), "PROPFIND");
                DAVResource.closeHttpResponse(httpResponse);
                throw throwable;
            }
        }
        DAVResource.closeHttpResponse(httpResponse);
        return acl;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String setACL(String acl) throws DAVException, RemoteException {
        String aclDocumentXML = null;
        CloseableHttpResponse httpResponse = null;
        long t0 = System.currentTimeMillis();
        try {
            Document doc;
            HttpEntity httpEntity;
            Document document = Acl.toDocument(acl);
            Element aclElement = document.getDocumentElement();
            AclProperty aclProperty = AclProperty.createFromXml((Element)aclElement);
            HttpAcl httpAcl = new HttpAcl(this._httpURI, aclProperty);
            this.generateIfHeader((AbstractHttpMessage)httpAcl, this._httpURI);
            httpResponse = this._httpClient.execute((HttpUriRequest)httpAcl);
            this.status = httpResponse.getStatusLine().getStatusCode();
            if (!httpAcl.succeeded((HttpResponse)httpResponse)) {
                this.logMethodMessage("ACL", this.status, Level.WARN);
                this.processError(this.status, "ACL", this._httpURI.getRawPath());
            }
            if (null != (httpEntity = httpResponse.getEntity()) && httpEntity.getContentLength() > 0L && null != (doc = httpAcl.getResponseBodyAsDocument(httpEntity))) {
                aclDocumentXML = XMLUtil.node2String(doc);
            }
        }
        catch (ClientProtocolException e) {
            try {
                throw new DAVException(e.getMessage(), (Exception)((Object)e));
                catch (IOException e2) {
                    throw new DAVException(e2.getMessage(), e2);
                }
                catch (DavException e3) {
                    throw new DAVException(e3.getMessage(), (Exception)((Object)e3));
                }
            }
            catch (Throwable throwable) {
                DAVResource.closeHttpResponse(httpResponse);
                this.logTime(t0, System.currentTimeMillis(), "ACL");
                throw throwable;
            }
        }
        DAVResource.closeHttpResponse(httpResponse);
        this.logTime(t0, System.currentTimeMillis(), "ACL");
        return aclDocumentXML;
    }

    @Override
    public String setAcl(Acl acl) throws DAVException, RemoteException {
        String aclRv = null;
        CloseableHttpResponse httpResponse = null;
        long t0 = System.currentTimeMillis();
        try {
            Document aclDoc = acl.getUpdateableAclDocument();
            if (null != aclDoc) {
                Document doc;
                HttpEntity httpEntity;
                AclProperty aclProperty = AclProperty.createFromXml((Element)aclDoc.getDocumentElement());
                HttpAcl httpAcl = new HttpAcl(this._httpURI, aclProperty);
                this.generateIfHeader((AbstractHttpMessage)httpAcl, this._httpURI);
                httpResponse = this._httpClient.execute((HttpUriRequest)httpAcl);
                this.status = httpResponse.getStatusLine().getStatusCode();
                if (!httpAcl.succeeded((HttpResponse)httpResponse)) {
                    this.logMethodMessage("ACL", this.status, Level.WARN);
                    this.processError(this.status, "ACL", this._httpURI.getPath());
                }
                if (null != (httpEntity = httpResponse.getEntity()) && httpEntity.getContentLength() > 0L && null != (doc = httpAcl.getResponseBodyAsDocument(httpEntity))) {
                    aclRv = XMLUtil.node2String(doc);
                }
            }
        }
        catch (ClientProtocolException e) {
            throw new DAVException(e.getMessage(), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new DAVException(e.getMessage(), e);
        }
        catch (DavException e) {
            throw new DAVException(e.getMessage(), (Exception)((Object)e));
        }
        finally {
            this.logTime(t0, System.currentTimeMillis(), "ACL");
            DAVResource.closeHttpResponse(httpResponse);
        }
        return aclRv;
    }

    private void logTime(long t0, long t1, String text) {
        if (PERF_LOGGER.isDebugEnabled()) {
            PERF_LOGGER.debug(Thread.currentThread().getName() + ',' + text + ',' + NumberFormat.getInstance().format((double)(t1 - t0) / 1000.0));
        } else if (DEBUG_OPT != null && DEBUG_OPT.equalsIgnoreCase("true")) {
            System.err.println(Thread.currentThread().getName() + ',' + text + ',' + NumberFormat.getInstance().format((double)(t1 - t0) / 1000.0));
        }
    }

    @Override
    public void setPath(String path) {
        String davResourceURI = null != this._httpURI ? this._httpURI.toString() : "";
        try {
            if (null != this._httpURI && path != this._httpURI.getPath()) {
                this._httpURI = new URI(this._httpURI.getScheme(), this._httpURI.getUserInfo(), this._httpURI.getHost(), this._httpURI.getPort(), path, this._httpURI.getQuery(), this._httpURI.getFragment());
            }
            this.doneInitialPropfind = false;
            this.exists = false;
            this.status = -1;
        }
        catch (URISyntaxException e) {
            LOGGER.error(Message.format((ResourceBundle)RB.getResources(), (String)"DAVResource.setpath.ex.fmt.txt", (Object)davResourceURI, (Object)path), (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public String getPath() {
        String path = this._httpURI == null ? null : this._httpURI.getPath();
        return path;
    }

    private void generateIfHeader(AbstractHttpMessage abstractHttpMessage, URI uri) {
        if (null == this._httpClient) {
            return;
        }
        if (null == abstractHttpMessage) {
            return;
        }
        if (null == uri) {
            return;
        }
        String lockToken = this._lockManager.getLock(uri.getPath(), this.getUserName());
        if (lockToken != null && !lockToken.isEmpty()) {
            abstractHttpMessage.addHeader("If", String.format("(<%s>) ", lockToken));
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void doControl() throws DAVException, RemoteException {
        CloseableHttpResponse httpResponse = null;
        long t0 = System.currentTimeMillis();
        try {
            HttpVersionControl httpVersionControl = new HttpVersionControl(this._httpURI);
            this.generateIfHeader((AbstractHttpMessage)httpVersionControl, this._httpURI);
            httpResponse = this._httpClient.execute((HttpUriRequest)httpVersionControl);
            this.status = httpResponse.getStatusLine().getStatusCode();
            MultiStatusHolder multiStatusHolder = this.processMultiStatus((BaseDavRequest)httpVersionControl, httpResponse);
            int statusCode = multiStatusHolder.getHTTPStatusCode();
            if (-1 < statusCode) {
                this.status = statusCode;
            }
            if (!httpVersionControl.succeeded((HttpResponse)httpResponse)) {
                this.logMethodMessage("VERSION-CONTROL", this.status, Level.WARN);
                this.processError(this.status, "VERSION-CONTROL", this._httpURI.getRawPath());
            }
        }
        catch (ClientProtocolException e) {
            try {
                throw new DAVException(e.getMessage(), (Exception)((Object)e));
                catch (IOException e2) {
                    throw new DAVException(e2.getMessage(), e2);
                }
            }
            catch (Throwable throwable) {
                DAVResource.closeHttpResponse(httpResponse);
                this.logTime(t0, System.currentTimeMillis(), "VERSION-CONTROL");
                throw throwable;
            }
        }
        DAVResource.closeHttpResponse(httpResponse);
        this.logTime(t0, System.currentTimeMillis(), "VERSION-CONTROL");
    }

    @Override
    public List getPreviousVersionNames() throws DAVException, RemoteException {
        Version[] versions = this.getVersions();
        ArrayList<String> names = new ArrayList<String>(versions.length);
        for (Version version : versions) {
            String name = version.getName();
            if ("jcr:rootVersion".equals(name)) continue;
            names.add(version.getName());
        }
        return names;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void doCheckout() throws DAVException, RemoteException {
        CloseableHttpResponse httpResponse = null;
        long t0 = System.currentTimeMillis();
        try {
            HttpCheckout httpCheckout = new HttpCheckout(this._httpURI);
            this.generateIfHeader((AbstractHttpMessage)httpCheckout, this._httpURI);
            httpResponse = this._httpClient.execute((HttpUriRequest)httpCheckout);
            this.status = httpResponse.getStatusLine().getStatusCode();
            MultiStatusHolder multiStatusHolder = this.processMultiStatus((BaseDavRequest)httpCheckout, httpResponse);
            int statusCode = multiStatusHolder.getHTTPStatusCode();
            if (-1 < statusCode) {
                this.status = statusCode;
            }
            if (!httpCheckout.succeeded((HttpResponse)httpResponse)) {
                this.logMethodMessage("CHECKOUT", this.status, Level.WARN);
                this.processError(this.status, "CHECKOUT", this._httpURI.getRawPath());
            }
        }
        catch (ClientProtocolException e) {
            try {
                throw new DAVException(e.getMessage(), (Exception)((Object)e));
                catch (IOException e2) {
                    throw new DAVException(e2.getMessage(), e2);
                }
            }
            catch (Throwable throwable) {
                DAVResource.closeHttpResponse(httpResponse);
                this.logTime(t0, System.currentTimeMillis(), "CHECKOUT");
                throw throwable;
            }
        }
        DAVResource.closeHttpResponse(httpResponse);
        this.logTime(t0, System.currentTimeMillis(), "CHECKOUT");
    }

    @Override
    public void doLabel(int labelAction, String label) throws DAVException, RemoteException {
        this.doLabel(labelAction, label, 0);
    }

    @Override
    public void doLabel(int labelAction, String label, int depth) throws DAVException, RemoteException {
        CloseableHttpResponse httpResponse = null;
        long t0 = System.currentTimeMillis();
        try {
            LabelInfo labelInfo = new LabelInfo(label, labelAction, depth);
            HttpLabel httpLabel = new HttpLabel(this._httpURI, labelInfo);
            this.generateIfHeader((AbstractHttpMessage)httpLabel, this._httpURI);
            httpResponse = this._httpClient.execute((HttpUriRequest)httpLabel);
            this.status = httpResponse.getStatusLine().getStatusCode();
            MultiStatusHolder multiStatusHolder = this.processMultiStatus((BaseDavRequest)httpLabel, httpResponse);
            int sc = multiStatusHolder.getHTTPStatusCode();
            if (-1 < sc) {
                this.status = sc;
            }
            if (!httpLabel.succeeded((HttpResponse)httpResponse)) {
                this.logMethodMessage("LABEL", this.status, Level.WARN);
                this.processError(this.status, "LABEL", this._httpURI.getRawPath());
            }
        }
        catch (IOException e) {
            try {
                throw new DAVException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                DAVResource.closeHttpResponse(httpResponse);
                this.logTime(t0, System.currentTimeMillis(), "LABEL");
                throw throwable;
            }
        }
        DAVResource.closeHttpResponse(httpResponse);
        this.logTime(t0, System.currentTimeMillis(), "LABEL");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void doCheckin() throws DAVException, RemoteException {
        CloseableHttpResponse httpResponse = null;
        long t0 = System.currentTimeMillis();
        try {
            HttpCheckin httpCheckin = new HttpCheckin(this._httpURI);
            this.generateIfHeader((AbstractHttpMessage)httpCheckin, this._httpURI);
            httpResponse = this._httpClient.execute((HttpUriRequest)httpCheckin);
            this.status = httpResponse.getStatusLine().getStatusCode();
            MultiStatusHolder multiStatusHolder = this.processMultiStatus((BaseDavRequest)httpCheckin, httpResponse);
            int statusCode = multiStatusHolder.getHTTPStatusCode();
            if (-1 < statusCode) {
                this.status = statusCode;
            }
            if (!httpCheckin.succeeded((HttpResponse)httpResponse)) {
                this.logMethodMessage("CHECKIN", this.status, Level.WARN);
                this.processError(this.status, "CHECKIN", this._httpURI.getRawPath());
            }
        }
        catch (ClientProtocolException e) {
            try {
                throw new DAVException(e.getMessage(), (Exception)((Object)e));
                catch (IOException e2) {
                    throw new DAVException(e2.getMessage(), e2);
                }
            }
            catch (Throwable throwable) {
                DAVResource.closeHttpResponse(httpResponse);
                this.logTime(t0, System.currentTimeMillis(), "CHECKIN");
                throw throwable;
            }
        }
        DAVResource.closeHttpResponse(httpResponse);
        this.logTime(t0, System.currentTimeMillis(), "CHECKIN");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void doUncheckout() throws DAVException, RemoteException {
        CloseableHttpResponse httpResponse = null;
        long t0 = System.currentTimeMillis();
        try {
            HttpUncheckout httpUncheckout = new HttpUncheckout(this._httpURI);
            this.generateIfHeader((AbstractHttpMessage)httpUncheckout, this._httpURI);
            httpResponse = this._httpClient.execute((HttpUriRequest)httpUncheckout);
            StatusLine statusLine = httpResponse.getStatusLine();
            this.status = statusLine.getStatusCode();
            MultiStatusHolder multiStatusHolder = this.processMultiStatus((BaseDavRequest)httpUncheckout, httpResponse);
            int statusCode = multiStatusHolder.getHTTPStatusCode();
            if (-1 < statusCode) {
                this.status = statusCode;
            }
            if (!httpUncheckout.succeeded((HttpResponse)httpResponse)) {
                this.logMethodMessage("UNCHECKOUT", this.status, Level.WARN);
                this.processError(this.status, "UNCHECKOUT", this._httpURI.getRawPath());
            }
        }
        catch (ClientProtocolException e) {
            try {
                throw new DAVException(e.getMessage(), (Exception)((Object)e));
                catch (IOException e2) {
                    throw new DAVException(e2.getMessage(), e2);
                }
            }
            catch (Throwable throwable) {
                DAVResource.closeHttpResponse(httpResponse);
                this.logTime(t0, System.currentTimeMillis(), "UNCHECKOUT");
                throw throwable;
            }
        }
        DAVResource.closeHttpResponse(httpResponse);
        this.logTime(t0, System.currentTimeMillis(), "UNCHECKOUT");
    }

    @Override
    public Version getCheckedIn() throws DAVException, RemoteException {
        return null;
    }

    @Override
    public Version getCheckedOut() throws DAVException, RemoteException {
        return null;
    }

    @Override
    public Version getVersion(String versionName) throws DAVException {
        Version version = null;
        for (Version v : this.getVersions()) {
            if (!versionName.equalsIgnoreCase(v.getName())) continue;
            version = v;
            break;
        }
        return version;
    }

    private String getUserName() {
        return null != this.userName ? this.userName : DEFAULT_USER_NAME;
    }

    private Version[] getVersions() throws DAVException {
        Namespace davNamespace = Namespace.getNamespace((String)"DAV:");
        DavPropertyNameSet davPropertyNameSet = new DavPropertyNameSet();
        davPropertyNameSet.add("checked-in", davNamespace);
        davPropertyNameSet.add("checked-out", davNamespace);
        davPropertyNameSet.add("checkout-set", davNamespace);
        davPropertyNameSet.add("comment", davNamespace);
        davPropertyNameSet.add(DavPropertyName.CREATIONDATE);
        davPropertyNameSet.add("creator-displayname", davNamespace);
        davPropertyNameSet.add(DavPropertyName.GETLASTMODIFIED);
        davPropertyNameSet.add("predecessor-set", davNamespace);
        davPropertyNameSet.add(DavPropertyName.RESOURCETYPE);
        davPropertyNameSet.add("successor-set", davNamespace);
        davPropertyNameSet.add("version-history", davNamespace);
        davPropertyNameSet.add("version-name", davNamespace);
        ReportInfo reportInfo = new ReportInfo(ReportType.VERSION_TREE, 0, davPropertyNameSet);
        DavPropertyResult davPropertyResult = this.doReport(reportInfo);
        List<DavPropertyItem> davPropertyItems = davPropertyResult.getDavProperties();
        HashMap<String, Version> hrefToVersionMap = new HashMap<String, Version>();
        for (DavPropertyItem davPropertyItem : davPropertyItems) {
            String propertyName;
            DavProperty<?> davProperty;
            DavPropertyName davPropertyName;
            Namespace propertyNamespace;
            String href = davPropertyItem.getDavResourceHref();
            Version version = (Version)hrefToVersionMap.get(href);
            if (null == version) {
                version = new Version();
                version.setHref(href);
                hrefToVersionMap.put(href, version);
            }
            if (!"DAV:".equals((propertyNamespace = (davPropertyName = (davProperty = davPropertyItem.getDavProperty()).getName()).getNamespace()).getURI())) continue;
            String davPropertyValue = "";
            if (null != davProperty.getValue()) {
                davPropertyValue = davProperty.getValue().toString();
            }
            switch (propertyName = davPropertyName.getName()) {
                case "comment": {
                    version.setComment(davPropertyValue);
                    break;
                }
                case "creationdate": {
                    version.setCreationDate(davPropertyValue);
                    break;
                }
                case "creator-displayname": {
                    version.setCreatorDisplayName(davPropertyValue);
                    break;
                }
                case "getlastmodified": {
                    version.setLastModifiedDate(davPropertyValue);
                    break;
                }
                case "href": {
                    version.setHref(davPropertyValue);
                    break;
                }
                case "version-name": {
                    version.setName(davPropertyValue);
                    break;
                }
            }
        }
        return hrefToVersionMap.values().toArray(new Version[hrefToVersionMap.size()]);
    }

    @Override
    public void setExistsRequirement(int requirement) {
        this.existsRequirement = requirement >= 0 && requirement < 3 ? requirement : 0;
    }

    @Override
    public int getExistsRequirement() {
        return this.existsRequirement;
    }

    private void processError(int status, String method, String path) throws DAVException {
        if (status == 403 || status == 409 || status == 400 || status == 423 || status == 422 || status / 100 == 5) {
            String msg = status + " during " + method + " on " + path;
            throw new DAVException(msg, status);
        }
    }

    private void logDebug(String message) {
        this.logMessage(Level.DEBUG, message);
    }

    private void logWarn(String message) {
        this.logMessage(Level.WARN, message);
    }

    private void logInfo(String message) {
        this.logMessage(Level.INFO, message);
    }

    private void logMessage(Level level, String message) {
        ThreadContext.push((String)this.getContextString());
        LOGGER.log(level, message);
        ThreadContext.pop();
    }

    private String getContextString() {
        String sessionString = "NoSessionAvailable";
        String contextInfo = sessionString + " " + this.userName;
        return contextInfo;
    }

    @Override
    public List<String> getChildrenList(String path) {
        ArrayList<String> members = null;
        try {
            this.setPath(path);
            PropertyName propertyName = new PropertyName("{DAV:}resourcetype");
            DavPropertyResult davPropertyResult = this.getDavProperties(new PropertyName[]{propertyName}, 1);
            List<DavPropertyItem> davPropertyItems = davPropertyResult.getDavProperties();
            members = new ArrayList(davPropertyItems.size());
            for (DavPropertyItem davPropertyItem : davPropertyItems) {
                try {
                    URI uri = new URI(davPropertyItem.getDavResourceHref());
                    String uriPath = uri.getPath();
                    if (path.equals(uriPath)) continue;
                    members.add(uriPath);
                }
                catch (URISyntaxException e) {
                    LOGGER.error((Object)e);
                }
            }
        }
        catch (DAVException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return null == members ? new ArrayList<String>(0) : members;
    }

    public Map<String, PropertyMap> getChildrenProperties(PropertyName[] properties) throws DAVException, RemoteException {
        PropertyMap currentPropertyMap = null;
        List<DavPropertyItem> davPropertyItems = this.getDavProperties(properties, 1).getDavProperties();
        if (!this.SUCCEEDED()) {
            throw new DAVException(Message.format((ResourceBundle)RB.getResources(), (String)"Collection.getprop.ex.fmt.txt", (Object)this.getStatusMessage()));
        }
        String hostport = this.getURL().toString();
        int ptr = hostport.indexOf("://");
        if (ptr != -1) {
            int index = hostport.indexOf("/", ptr + 3);
            hostport = index == -1 ? hostport : hostport.substring(0, index);
        }
        HashMap<String, PropertyMap> membersMap = new HashMap<String, PropertyMap>();
        for (DavPropertyItem davPropertyItem : davPropertyItems) {
            try {
                URI uri = new URI(davPropertyItem.getDavResourceHref());
                if (this.getPath().equals(uri.getPath())) continue;
                String url = hostport + uri.getPath();
                currentPropertyMap = membersMap.get(url);
                if (currentPropertyMap == null) {
                    currentPropertyMap = new PropertyMap();
                    membersMap.put(url, currentPropertyMap);
                }
                String namespaceURI = davPropertyItem.getDavProperty().getName().getNamespace().getURI();
                Element davPropertyXML = davPropertyItem.getDavProperty().toXml(XMLUtil.newDocument());
                if (namespaceURI != null) {
                    currentPropertyMap.put('{' + namespaceURI + '}' + XMLUtil.getElementLocalName(davPropertyXML), XMLUtil.getPropertyAsString(davPropertyItem));
                    continue;
                }
                currentPropertyMap.put("{}" + XMLUtil.getElementLocalName(davPropertyXML), XMLUtil.getPropertyAsString(davPropertyItem));
            }
            catch (URISyntaxException e) {
                LOGGER.error((Object)e);
            }
            catch (ParserConfigurationException e) {
                throw new DAVException(e.getMessage(), e);
            }
        }
        return membersMap;
    }

    public static String extractPath(String url) {
        int p2;
        int p1 = url.indexOf("://");
        String path = p1 != -1 ? ((p2 = url.indexOf("/", p1 + 3)) != -1 ? url.substring(p2) : "/") : url;
        return path;
    }

    public static String unencodePath(String path) {
        try {
            URI uri = new URI(path);
            return uri.getPath();
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public PropertyMap getPropertyMap() throws RemoteException, DAVException {
        DavPropertyResult davPropertyResult = this.getDavProperties(0);
        if (!this.SUCCEEDED()) {
            throw new DAVException(Message.format((ResourceBundle)RB.getResources(), (String)"Resource.getprop.ex.fmt.txt", (Object)this.getStatusMessage()));
        }
        PropertyMap propertyMap = null;
        try {
            propertyMap = Utils.convertDavPropertyArray(davPropertyResult.getDavProperties());
        }
        catch (ParserConfigurationException e) {
            throw new DAVException(e.getMessage(), e);
        }
        return propertyMap;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void propPatch(ProppatchInfo propPatchInfo) throws DAVException, RemoteException {
        CloseableHttpResponse httpResponse = null;
        long t0 = System.currentTimeMillis();
        try {
            HttpProppatch httpPropPatch = new HttpProppatch(this._httpURI, propPatchInfo);
            this.generateIfHeader((AbstractHttpMessage)httpPropPatch, this._httpURI);
            httpResponse = this._httpClient.execute((HttpUriRequest)httpPropPatch);
            this.status = httpResponse.getStatusLine().getStatusCode();
            MultiStatusHolder multiStatusHolder = this.processMultiStatus((BaseDavRequest)httpPropPatch, httpResponse);
            int statusCode = multiStatusHolder.getHTTPStatusCode();
            if (-1 < statusCode) {
                this.status = statusCode;
            }
            if (!httpPropPatch.succeeded((HttpResponse)httpResponse)) {
                this.logMethodMessage("PROPPATCH", this.status, Level.WARN);
                this.processError(this.status, "PROPPATCH", this._httpURI.getRawPath());
            }
        }
        catch (ClientProtocolException e) {
            try {
                throw new DAVException(e.getMessage(), (Exception)((Object)e));
                catch (IOException e2) {
                    throw new DAVException(e2.getMessage(), e2);
                }
            }
            catch (Throwable throwable) {
                DAVResource.closeHttpResponse(httpResponse);
                this.logTime(t0, System.currentTimeMillis(), "PROPPATCH");
                throw throwable;
            }
        }
        DAVResource.closeHttpResponse(httpResponse);
        this.logTime(t0, System.currentTimeMillis(), "PROPPATCH");
    }

    private static final void closeHttpResponse(CloseableHttpResponse httpResponse) {
        if (null != httpResponse) {
            try {
                httpResponse.close();
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private static final String getTargetAuthStateRealm(HttpClientContext httpClientContext) {
        AuthScheme authScheme;
        AuthState targetAuthState;
        String realm = null;
        if (null != httpClientContext && null != (targetAuthState = httpClientContext.getTargetAuthState()) && null != (authScheme = targetAuthState.getAuthScheme())) {
            realm = authScheme.getRealm();
        }
        return realm == null ? "" : realm;
    }

    private static DavPropertyNameSet toDavPropertyNameSet(PropertyName[] propertyNames) {
        DavPropertyNameSet davPropertyNameSet = new DavPropertyNameSet();
        for (PropertyName propertyName : propertyNames) {
            Namespace namespace = Namespace.getNamespace((String)propertyName.getNamespaceURI());
            davPropertyNameSet.add(propertyName.getLocalName(), namespace);
        }
        return davPropertyNameSet;
    }

    private static String elementToPropertyValue(Element element) {
        int endPtr;
        String propAsString = XMLUtil.convertNodeToString((Node)element, true);
        int beginPtr = propAsString.indexOf(62);
        if (beginPtr < (endPtr = propAsString.lastIndexOf(60)) && beginPtr > 0 && endPtr > 0) {
            propAsString = propAsString.substring(beginPtr + 1, endPtr);
        }
        return Utils.XMLESCAPE(propAsString);
    }

    private void setHttpStatusCode(int httpStatusCode, boolean isSetMultiStatusToOK) {
        this.status = isSetMultiStatusToOK && 207 == httpStatusCode ? 200 : httpStatusCode;
    }

    static {
        DAV_PROPERTY_NAME_SET = new DavPropertyNameSet();
        DAV_PROPERTY_NAME_SET.add(DavPropertyName.create((String)"resourcetype"));
        DAV_PROPERTY_NAME_SET.add(DavPropertyName.create((String)"lockdiscovery"));
        try {
            System.setProperty("httpclient.useragent", "sas/http");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    @SASScope
    private class ReadOnceFileInputStream
    extends FileInputStream {
        private File _fileData;

        public ReadOnceFileInputStream(File fileData) throws FileNotFoundException {
            super(fileData);
            this._fileData = fileData;
        }

        @Override
        public void close() throws IOException {
            try {
                super.close();
            }
            finally {
                this._fileData.delete();
            }
        }
    }
}

