/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.templates.ant;

import com.sas.util.templates.TemplateUtil;
import com.sas.util.templates.ant.Context;
import com.sas.util.templates.ant.Macro;
import com.sas.util.templates.ant.TemplateFileSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class MergeTemplateTask
extends Task {
    private ArrayList contextChain = null;
    private File contextFile = null;
    private ArrayList macroChain = null;
    private TemplateFileSet templateFileSet = null;
    private File toDir = null;
    private String extension = null;
    private File templateFile = null;
    private File toFile = null;

    public void execute() throws BuildException {
        this.validate();
        if (this.templateFile != null) {
            TemplateUtil.mergeTemplate(this.templateFile, this.getContextChain(), this.getMacroChain(), this.toFile);
        } else if (this.templateFileSet != null) {
            TemplateUtil.mergeTemplates(this.getFilesInSet(this.templateFileSet), this.getContextChain(), this.getMacroChain(), this.toDir, this.extension);
        }
    }

    protected File[] getContextChain() throws BuildException {
        File[] contextFiles = null;
        if (this.contextFile != null) {
            contextFiles = new File[]{this.contextFile};
        } else if (this.contextChain != null) {
            contextFiles = new File[this.contextChain.size()];
            Iterator iter = this.contextChain.iterator();
            int i = 0;
            while (iter.hasNext()) {
                Context context = (Context)((Object)iter.next());
                contextFiles[i] = context.getFile();
                ++i;
            }
        }
        return contextFiles;
    }

    protected File[] getMacroChain() throws BuildException {
        File[] macroFiles = null;
        if (this.macroChain != null) {
            macroFiles = new File[this.macroChain.size()];
            Iterator iter = this.macroChain.iterator();
            int i = 0;
            while (iter.hasNext()) {
                Macro macro = (Macro)((Object)iter.next());
                macroFiles[i] = macro.getFile();
                ++i;
            }
        }
        return macroFiles;
    }

    protected File[] getFilesInSet(FileSet set) {
        DirectoryScanner ds = set.getDirectoryScanner(this.getProject());
        File dir = ds.getBasedir();
        String[] filesInSet = ds.getIncludedFiles();
        File[] files = new File[filesInSet.length];
        for (int j = 0; j < filesInSet.length; ++j) {
            files[j] = new File(dir, filesInSet[j]);
        }
        return files;
    }

    protected void validate() throws BuildException {
        if (this.templateFileSet == null && this.templateFile == null) {
            throw new BuildException("You must provide either a Template attribute or a nested TemplateFileSet element", this.getLocation());
        }
        if (this.contextChain == null && this.contextFile == null) {
            throw new BuildException("You must provide either a Context attribute or nested Context element(s)", this.getLocation());
        }
        if (this.templateFileSet != null && this.templateFile != null) {
            throw new BuildException("You cannot specify a Template attribute and a nested TemplateFileSet element at the same time", this.getLocation());
        }
        if (this.contextChain != null && this.contextFile != null) {
            throw new BuildException("You cannot specify a context attribute and nested context element(s) at the same time", this.getLocation());
        }
        if (this.templateFile != null && this.toFile == null) {
            throw new BuildException("You did not specify where to put the results via the toFile attribute", this.getLocation());
        }
        if (this.templateFileSet != null) {
            if (this.toDir == null) {
                throw new BuildException("You must provide a toDir attribute when using a nested TemplateFileSet element", this.getLocation());
            }
            if (this.extension == null) {
                this.log("Warning:  No extension attribute provided.  This attribute is used as the file extension when saving resolved templates");
            }
        }
    }

    public void setToFile(File toFile) {
        this.toFile = toFile;
    }

    public File getToFile() {
        return this.toFile;
    }

    public void setTemplate(File template) {
        this.templateFile = template;
    }

    public File getTemplate() {
        return this.templateFile;
    }

    public void setContext(File context) {
        this.contextFile = context;
    }

    public File getContext() {
        return this.contextFile;
    }

    public void addTemplateFileset(TemplateFileSet set) {
        this.templateFileSet = set;
    }

    public void addContext(Context contextFile) {
        if (this.contextChain == null) {
            this.contextChain = new ArrayList();
        }
        this.contextChain.add(contextFile);
    }

    public void addMacro(Macro macroFile) {
        if (this.macroChain == null) {
            this.macroChain = new ArrayList();
        }
        this.macroChain.add(macroFile);
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public File getToDir() {
        return this.toDir;
    }

    public void setToDir(File toDir) {
        this.toDir = toDir;
    }
}

