/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.config.dao;

import com.sas.framework.config.Application;
import com.sas.framework.config.ApplicationConfiguration;
import com.sas.framework.config.ApplicationRegistration;
import com.sas.framework.config.dao.ApplicationDAOInterface;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;

@Deprecated
public class PropertiesApplicationDAO
implements ApplicationDAOInterface {
    public static final String SITE_CONFIGURATION_PROPERTY = "application.dao";
    private static final String APPLICATION_NAMES = "application.names";
    private static final String DESCRIPTION = ".description";
    private static final String VENDOR = ".vendor";
    private static final String VENDOR_ID = ".vendor.id";
    private static final String PRODUCT_NAME = ".product.name";
    private static final String PRODUCT_ID = ".product.id";
    private static final String SPEC_VENDOR = ".spec.vendor";
    private static final String SPEC_VERSION = ".spec.version";
    private static final String HISTORY_ID = ".history.id";
    private static final String DEFAULT_INSTANCE = ".defaultInstance";
    private static final String ASSOCIATED_APPLICATIONS = ".associatedApplications";
    private static final String SOFTWARE_VERSION = ".softwareVersion";
    private static final String SETTINGS = ".settings";
    private static final String PROTOCOL = ".protocol";
    private static final String HOST = ".host";
    private static final String PORT = ".port";
    private static final String CONTEXT = ".context";
    private Properties props;

    public void setProperties(Properties p) {
        this.props = p;
    }

    @Override
    public void reload() {
    }

    @Override
    public Application getApplication(String name) {
        Application a = new Application();
        a.setName(name);
        ApplicationConfiguration ac = new ApplicationConfiguration();
        ac.setName(name);
        ac.setDescription(this.props.getProperty(name + DESCRIPTION));
        ac.setVendor(this.props.getProperty(name + VENDOR));
        ac.setVendorId(this.props.getProperty(name + VENDOR_ID));
        ac.setProductName(this.props.getProperty(name + PRODUCT_NAME));
        ac.setProductId(this.props.getProperty(name + PRODUCT_ID));
        ac.setSpecVendor(this.props.getProperty(name + SPEC_VENDOR));
        ac.setSpecVersion(this.props.getProperty(name + SPEC_VERSION));
        ac.setHistoryId(this.props.getProperty(name + HISTORY_ID));
        ac.setSoftwareVersion(this.props.getProperty(name + SOFTWARE_VERSION));
        String di = this.props.getProperty(name + DEFAULT_INSTANCE);
        if (null == di) {
            ac.setDefaultInstance(Boolean.FALSE);
        } else if (di.equalsIgnoreCase("true")) {
            ac.setDefaultInstance(Boolean.TRUE);
        } else {
            ac.setDefaultInstance(Boolean.FALSE);
        }
        String aa = this.props.getProperty(name + ASSOCIATED_APPLICATIONS);
        if (null == aa) {
            aa = "";
        }
        ac.setAssociatedApplications(aa);
        a.setConfiguration(ac);
        ApplicationRegistration r = new ApplicationRegistration();
        r.setName(name);
        r.setProtocol(this.props.getProperty(name + PROTOCOL));
        r.setHost(this.props.getProperty(name + HOST));
        String portString = this.props.getProperty(name + PORT);
        int port = null == portString ? 80 : Integer.parseInt(portString);
        r.setPort(port);
        r.setContext(this.props.getProperty(name + CONTEXT));
        a.setRegistration(r);
        Properties settings = new Properties();
        String appSettings = this.props.getProperty(name + SETTINGS);
        if (StringUtils.isNotEmpty((CharSequence)appSettings)) {
            StringTokenizer tokens = new StringTokenizer(appSettings, ",");
            while (tokens.hasMoreTokens()) {
                String curTok = tokens.nextToken();
                String property = name + "." + curTok;
                String value = this.props.getProperty(property);
                settings.setProperty(curTok, value);
            }
        }
        a.setSettings(settings);
        return a;
    }

    @Override
    public List getAll() {
        ArrayList<Application> list = new ArrayList<Application>();
        String[] tokens = this.props.getProperty(APPLICATION_NAMES).split(",");
        for (int idx = 0; idx < tokens.length; ++idx) {
            list.add(this.getApplication(tokens[idx]));
        }
        return list;
    }
}

