/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.commons.util;

import java.security.AccessController;
import java.security.PrivilegedAction;

public enum SystemProperty {
    SAS_CONTAINER_IDENTIFIER("sas.container.identifier"),
    SAS_BIND_MARKER_OBJECT("sas.bind.marker.object", "true"),
    JMS_AUTHENTICATION_ENABLED("sas.jms.authentication.decorator", "false");

    private final String name;
    private final String defaultValue;

    private SystemProperty(String name) {
        this(name, null);
    }

    private SystemProperty(String name, String defaultValue) {
        this.name = name;
        this.defaultValue = defaultValue;
    }

    public String get() {
        String val = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(SystemProperty.this.getName());
            }
        });
        return val != null ? val : this.getDefaultValue();
    }

    public boolean getBoolean() {
        String val = this.get();
        return val == null ? Boolean.FALSE : Boolean.parseBoolean(val);
    }

    public String getName() {
        return this.name;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }
}

