/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.commons.util;

import com.sas.framework.commons.util.ArrayUtil;

public final class StringUtil {
    public static final String[] EMPTY_ARRAY = new String[0];
    public static final char DEFAULT_DELIMITER = ',';
    private static final byte BYTE_DELIMITER = 44;
    private static final byte BYTE_ZERO = 48;
    private static final byte BYTE_NINE = 57;

    private StringUtil() {
    }

    public static void append(StringBuffer sb, Object o, int count) {
        while (count-- > 0) {
            sb.append(o);
        }
    }

    public static int[] stringToIntArray(String s) {
        return StringUtil.stringToIntArray(s, (byte)44);
    }

    public static int[] stringToIntArray(String s, char delimiterChar) {
        return StringUtil.stringToIntArray(s, (byte)delimiterChar);
    }

    private static int[] stringToIntArray(String s, byte delimiter) {
        if (null == s || 0 == s.length()) {
            return ArrayUtil.EMPTY_INT_ARRAY;
        }
        int delimiterCount = 0;
        byte[] bv = s.getBytes();
        for (int i = 0; i < bv.length; ++i) {
            byte b = bv[i];
            if (b == delimiter) {
                ++delimiterCount;
                continue;
            }
            if (b >= 48 && b <= 57) continue;
            throw new NumberFormatException(s);
        }
        int val = 0;
        int[] returnArray = new int[delimiterCount + 1];
        int currentVal = 0;
        for (int i = 0; i < bv.length; ++i) {
            byte b = bv[i];
            if (b == delimiter) {
                returnArray[currentVal++] = val;
                val = 0;
                continue;
            }
            val = 10 * val + b - 48;
        }
        returnArray[currentVal] = val;
        return returnArray;
    }

    public static String intArrayToString(int[] array) {
        return StringUtil.intArrayToString(array, ',');
    }

    public static String intArrayToString(int[] array, char delimiter) {
        if (null == array || 0 == array.length) {
            return null;
        }
        StringBuffer buff = new StringBuffer(array.length * 5);
        for (int i = 0; i < array.length - 1; ++i) {
            buff.append(array[i]);
            buff.append(delimiter);
        }
        buff.append(array[array.length - 1]);
        return buff.toString();
    }
}

