/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.commons.util;

import com.sas.framework.commons.i18n.LegalRB;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

@Deprecated
public class SASLegalNotices {
    public static final String MYSQL = "SASLegalNotices.Acknowledgement.MySQL.txt";
    public static final String APACHE = "SASLegalNotices.Acknowledgement.Apache.txt";
    private static Pattern COPYRIGHT = Pattern.compile("\\(c\\)");
    private static Pattern NEWLINE = Pattern.compile("\n");

    public static final String getLegalStatement(String copyrightYear, String thirdPartyInfo) {
        return SASLegalNotices.getLegalStatement(copyrightYear, null, thirdPartyInfo, false, Locale.getDefault());
    }

    public static final String getLegalStatement(String copyrightYear, String thirdPartyInfo, Locale locale) {
        return SASLegalNotices.getLegalStatement(copyrightYear, null, thirdPartyInfo, false, locale);
    }

    public static final String getLegalStatement(String copyrightYear, String copyrightLastYear, String thirdPartyInfo) {
        return SASLegalNotices.getLegalStatement(copyrightYear, copyrightLastYear, thirdPartyInfo, false, Locale.getDefault());
    }

    public static final String getLegalStatement(String copyrightYear, String copyrightLastYear, String thirdPartyInfo, Locale locale) {
        return SASLegalNotices.getLegalStatement(copyrightYear, copyrightLastYear, thirdPartyInfo, false, locale);
    }

    public static final String getLegalStatement(String copyrightFirstYear, String copyrightLastYear, String thirdPartyInfo, boolean formatForHTML) {
        return SASLegalNotices.getLegalStatement(copyrightFirstYear, copyrightLastYear, thirdPartyInfo, formatForHTML, Locale.getDefault());
    }

    public static final String getLegalStatement(String copyrightFirstYear, String copyrightLastYear, String thirdPartyInfo, boolean formatForHTML, Locale locale) {
        String msg;
        String copyright;
        Object[] args;
        String msg2;
        if (null == copyrightLastYear || StringUtils.equals((CharSequence)copyrightFirstYear, (CharSequence)copyrightLastYear)) {
            msg2 = LegalRB.getString("SASLegalNotices.Copyright.MultiLine.SingleYear.fmt.txt", locale);
            args = new Object[]{copyrightFirstYear, LegalRB.getString("SASLegalNotices.AllRightsReserved.txt", locale)};
            copyright = MessageFormat.format(msg2, args);
        } else {
            msg2 = LegalRB.getString("SASLegalNotices.Copyright.MultiLine.RangeOfYears.fmt.txt", locale);
            args = new Object[]{copyrightFirstYear, copyrightLastYear, LegalRB.getString("SASLegalNotices.AllRightsReserved.txt", locale)};
            copyright = MessageFormat.format(msg2, args);
        }
        String statement = null;
        if (null == thirdPartyInfo) {
            msg = LegalRB.getString("SASLegalNotices.LegalStatement.NoThirdParty.fmt.txt", locale);
            Object[] args2 = new Object[]{copyright, LegalRB.getString("SASLegalNotices.GeneralProtection.txt", locale), LegalRB.getString("SASLegalNotices.GovtRestrictedRights.Title.txt", locale), LegalRB.getString("SASLegalNotices.GovtRestrictedRights.Desc.txt", locale)};
            statement = MessageFormat.format(msg, args2);
        } else {
            msg = LegalRB.getString("SASLegalNotices.LegalStatement.ThirdParty.fmt.txt", locale);
            Object[] args3 = new Object[]{copyright, LegalRB.getString("SASLegalNotices.GeneralProtection.txt", locale), LegalRB.getString("SASLegalNotices.GovtRestrictedRights.Title.txt", locale), LegalRB.getString("SASLegalNotices.GovtRestrictedRights.Desc.txt", locale), thirdPartyInfo};
            statement = MessageFormat.format(msg, args3);
        }
        if (formatForHTML) {
            return SASLegalNotices.formatForHTML(statement);
        }
        return statement;
    }

    public static final String getSingleLineCopyright(String copyrightFirstYear, String copyrightLastYear) {
        return SASLegalNotices.getSingleLineCopyright(copyrightFirstYear, copyrightLastYear, false, Locale.getDefault());
    }

    public static final String getSingleLineCopyright(String copyrightFirstYear, String copyrightLastYear, Locale locale) {
        return SASLegalNotices.getSingleLineCopyright(copyrightFirstYear, copyrightLastYear, false, locale);
    }

    public static final String getSingleLineCopyright(String copyrightFirstYear, String copyrightLastYear, boolean formatForHTML) {
        return SASLegalNotices.getSingleLineCopyright(copyrightFirstYear, copyrightLastYear, formatForHTML, Locale.getDefault());
    }

    public static final String getSingleLineCopyright(String copyrightFirstYear, String copyrightLastYear, boolean formatForHTML, Locale locale) {
        String copyright;
        if (null == copyrightLastYear || StringUtils.equals((CharSequence)copyrightFirstYear, (CharSequence)copyrightLastYear)) {
            Object[] args = new Object[]{copyrightFirstYear, LegalRB.getString("SASLegalNotices.AllRightsReserved.txt", locale)};
            copyright = LegalRB.formatString("SASLegalNotices.Copyright.SingleLine.SingleYear.fmt.txt", locale, args);
        } else {
            Object[] args = new Object[]{copyrightFirstYear, copyrightLastYear, LegalRB.getString("SASLegalNotices.AllRightsReserved.txt", locale)};
            copyright = LegalRB.formatString("SASLegalNotices.Copyright.SingleLine.RangeOfYears.fmt.txt", locale, args);
        }
        if (formatForHTML) {
            return SASLegalNotices.formatForHTML(copyright);
        }
        return copyright;
    }

    public static final String getAcknowledgement(String ackKey) {
        return SASLegalNotices.getAcknowledgement(ackKey, null, false);
    }

    public static final String getAcknowledgement(String ackKey, boolean formatForHTML) {
        return SASLegalNotices.getAcknowledgement(ackKey, null, formatForHTML);
    }

    public static final String getAcknowledgement(String ackKey, Locale locale) {
        return SASLegalNotices.getAcknowledgement(ackKey, locale, false);
    }

    public static final String getAcknowledgement(String ackKey, Locale locale, boolean formatForHTML) {
        String notice = null;
        try {
            notice = null == locale ? LegalRB.getString(ackKey) : LegalRB.getString(ackKey, locale);
        }
        catch (MissingResourceException mre) {
            System.err.println(mre);
        }
        if (formatForHTML) {
            return SASLegalNotices.formatForHTML(notice);
        }
        return notice;
    }

    private static final String formatForHTML(String legalstr) {
        legalstr = StringEscapeUtils.escapeHtml4((String)legalstr);
        legalstr = COPYRIGHT.matcher(legalstr).replaceAll("&copy;");
        legalstr = NEWLINE.matcher(legalstr).replaceAll("<br/>");
        return legalstr;
    }
}

