/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.commons.util;

import com.sas.framework.commons.util.ArrayUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public final class ObjectUtil {
    public static final Object nonNull = new Object(){

        public boolean equals(Object that) {
            return null != that;
        }
    };

    @Deprecated
    public static void touch(Object o) {
        o = null == o ? o : o;
    }

    @Deprecated
    public static void touch(int x) {
        x = 0 == x ? 0 : 0;
    }

    @Deprecated
    public static void touch(short x) {
        x = (short)((0 == x ? false : false) ? 1 : 0);
    }

    @Deprecated
    public static void touch(double x) {
        x = (double)(0.0 == x ? false : false);
    }

    @Deprecated
    public static void touch(long x) {
        x = 0L == x ? 0L : 0L;
    }

    @Deprecated
    public static void touch(boolean x) {
        x = x ? false : false;
    }

    public static StringBuffer dump(Object o) {
        return ObjectUtil.dump(o, null, false, null);
    }

    public static StringBuffer dump(Object o, String[] order) {
        return ObjectUtil.dump(o, order, false, null);
    }

    public static StringBuffer dump(Object o, String[] order, boolean includeStatics, StringBuffer sb) {
        int i;
        if (null == sb) {
            sb = new StringBuffer();
        }
        if (null == o) {
            sb.append(o);
            return sb;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Class<?> clazz = o.getClass(); null != clazz; clazz = clazz.getSuperclass()) {
            Field[] fields = clazz.getDeclaredFields();
            for (i = 0; i < fields.length; ++i) {
                Object val;
                Field f = fields[i];
                if (Modifier.isStatic(f.getModifiers()) && !includeStatics) continue;
                String key = f.getName();
                try {
                    f.setAccessible(true);
                    val = f.get(o);
                }
                catch (Exception x) {
                    val = "<reflection error!>";
                }
                map.put(key, val);
            }
        }
        boolean delimit = false;
        if (null != order) {
            for (i = 0; i < order.length; ++i) {
                Object val = map.remove(order[i]);
                if (null == val) continue;
                delimit = ObjectUtil.delimit(delimit, sb);
                ObjectUtil.append(order[i], val, sb);
            }
        }
        for (Map.Entry e : map.entrySet()) {
            delimit = ObjectUtil.delimit(delimit, sb);
            ObjectUtil.append(e.getKey(), e.getValue(), sb);
        }
        return sb;
    }

    private static boolean delimit(boolean delimit, StringBuffer sb) {
        if (delimit) {
            sb.append(", ");
        }
        return true;
    }

    private static void append(Object o, StringBuffer sb) {
        if (o instanceof Number) {
            sb.append(o);
        } else {
            sb.append('\"').append(o).append('\"');
        }
    }

    private static void append(Object key, Object val, StringBuffer sb) {
        sb.append(key).append('=');
        ObjectUtil.append(val, sb);
    }

    public static void affirmNotNull(String name, Object o) {
        if (null == o) {
            if (null == name) {
                throw new IllegalArgumentException("null value");
            }
            throw new IllegalArgumentException(name + " is null");
        }
    }

    public static void affirmNotZero(String name, long x) {
        if (0L == x) {
            if (null == name) {
                throw new IllegalArgumentException("0L value");
            }
            throw new IllegalArgumentException(name + " is 0L");
        }
    }

    public static void affirmNotZero(long x) {
        ObjectUtil.affirmNotZero(null, x);
    }

    public static void affirmNotZero(String name, int x) {
        if (0 == x) {
            if (null == name) {
                throw new IllegalArgumentException("0 value");
            }
            throw new IllegalArgumentException(name + " is 0");
        }
    }

    public static void affirmNotZero(int x) {
        ObjectUtil.affirmNotZero(null, x);
    }

    public static void affirmNotNull(Object o) {
        ObjectUtil.affirmNotNull(null, o);
    }

    public static String toString(Object o) {
        StringBuffer sb = new StringBuffer();
        ObjectUtil.toString(sb, o);
        return sb.toString();
    }

    public static void toString(StringBuffer sb, Object o) {
        if (null == o) {
            sb.append(o);
        } else {
            Class<?> c = o.getClass();
            if (c.isArray()) {
                sb.append('[');
                if (Object[].class.isAssignableFrom(c)) {
                    ArrayUtil.toString(sb, (Object[])o, ", ");
                } else if (int[].class.isAssignableFrom(c)) {
                    ArrayUtil.toString(sb, (int[])o, ", ");
                } else {
                    throw new UnsupportedOperationException("please add support for this array type");
                }
                sb.append(']');
            } else {
                sb.append(o);
            }
        }
    }

    public static boolean equals(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (null != a) {
            return a.equals(b);
        }
        return null == b;
    }

    public static int size(Object o) {
        if (null == o) {
            return 1;
        }
        if (o instanceof Collection) {
            return ((Collection)o).size();
        }
        Class<?> c = o.getClass();
        if (!c.isArray()) {
            return 1;
        }
        if (Object.class.isAssignableFrom(c = c.getComponentType())) {
            return ((Object[])o).length;
        }
        if (Integer.TYPE.isAssignableFrom(c)) {
            return ((int[])o).length;
        }
        if (Double.TYPE.isAssignableFrom(c)) {
            return ((double[])o).length;
        }
        throw new UnsupportedOperationException("please add support for arrays of type: " + c);
    }

    private ObjectUtil() {
    }
}

