/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.commons.util;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.StringUtils;

public class HttpClientUtil {
    private static final Logger _logger = LogManager.getLogger(HttpClientUtil.class);
    private ConcurrentMap<Proxy, HttpHost> proxyToHostMap = new ConcurrentHashMap<Proxy, HttpHost>(2);
    private ProxySelector _proxySelector = ProxySelector.getDefault();
    private CredentialsProvider provider;

    public HttpClientUtil() {
        if (StringUtils.hasText((String)System.getProperty("http.proxyHost")) || StringUtils.hasText((String)System.getProperty("https.proxyHost"))) {
            String proxyUser = System.getProperty("http.proxyUser");
            String proxyPass = System.getProperty("http.proxyPassword");
            String proxyRealm = System.getProperty("http.proxyRealm");
            String proxyScheme = System.getProperty("http.proxyScheme");
            if (proxyUser == null) {
                proxyUser = System.getProperty("https.proxyUser");
                if (proxyPass != null) {
                    proxyPass = System.getProperty("https.proxyPassword");
                }
            }
            if (StringUtils.hasText((String)proxyUser)) {
                AuthScope authscope = new AuthScope(AuthScope.ANY_HOST, -1, proxyRealm, proxyScheme);
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(proxyUser, proxyPass);
                this.provider = new BasicCredentialsProvider();
                this.provider.setCredentials(authscope, (Credentials)credentials);
            }
        }
    }

    public CredentialsProvider getProvider() {
        return this.provider;
    }

    public HttpHost getHttpHost(URL url) {
        return this.getHttpHost(url.toString());
    }

    public HttpHost getHttpHost(String url) {
        List<Proxy> proxies;
        try {
            URI uri = new URI(url);
            proxies = this._proxySelector.select(uri);
        }
        catch (URISyntaxException e) {
            _logger.error("", (Throwable)e);
            throw new IllegalArgumentException("Invalid uri syntax: " + url, e);
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("Proxy selector returned " + proxies.size() + " potential proxies for " + url);
        }
        HttpHost httpHost = null;
        for (Proxy proxy : proxies) {
            if (_logger.isDebugEnabled()) {
                _logger.debug("Processing potential proxy " + proxy.toString() + " for " + url);
            }
            if (!Proxy.Type.HTTP.equals((Object)proxy.type()) || !(proxy.address() instanceof InetSocketAddress)) continue;
            if (_logger.isDebugEnabled()) {
                _logger.debug("Found proxy match for " + url);
            }
            if (null != (httpHost = (HttpHost)this.proxyToHostMap.get(proxy))) break;
            String proxyHost = ((InetSocketAddress)proxy.address()).getHostName();
            int proxyPort = ((InetSocketAddress)proxy.address()).getPort();
            httpHost = new HttpHost(proxyHost, proxyPort, proxy.type().name());
            this.proxyToHostMap.putIfAbsent(proxy, httpHost);
            if (!_logger.isDebugEnabled()) break;
            _logger.debug("Constructed new host configuration with proxy address " + proxyHost + " and port " + proxyPort);
            break;
        }
        return httpHost;
    }

    public ProxySelector getProxySelector() {
        return this._proxySelector;
    }

    public void setProxySelector(ProxySelector proxySelector) {
        this._proxySelector = proxySelector;
    }
}

