/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.commons.util;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BuildInfo {
    private static final String DEFAULT_BUILDINFO_FILE = "buildinfo.xml";
    private static final Logger logger = LogManager.getLogger(BuildInfo.class);
    private Document buildInfo;
    private String buildInfoVersion;
    private Date buildTimeStamp;
    private String buildId;
    private String branch;
    private String hotfix;
    private Date gmtDate;
    private Node applicationData;

    public BuildInfo() {
        this(BuildInfo.class.getClassLoader());
    }

    public BuildInfo(ClassLoader loader) {
        this(loader, DEFAULT_BUILDINFO_FILE);
    }

    public BuildInfo(ClassLoader loader, String path) {
        InputStream is = loader.getResourceAsStream(path);
        if (null == is) {
            throw new IllegalStateException("Unable to find resource: " + path + ", in class loader: " + loader);
        }
        this.parseInputStream(is);
    }

    public BuildInfo(InputStream is) {
        this.parseInputStream(is);
    }

    public BuildInfo(String document) {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(document.getBytes("UTF-8"));
            this.parseInputStream(is);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public String getBuildInfoVersion() {
        return this.buildInfoVersion;
    }

    public String getFormattedBuildTimeStamp(Locale locale) {
        return this.getFormattedDate(locale, this.buildTimeStamp);
    }

    public Date getBuildTimeStamp() {
        return this.buildTimeStamp;
    }

    public String getFormattedGMTDate(Locale locale) {
        return this.getFormattedDate(locale, this.gmtDate);
    }

    private String getFormattedDate(Locale locale, Date date) {
        if (null == locale) {
            locale = Locale.getDefault();
        }
        DateFormat format = DateFormat.getDateTimeInstance((int)1, (int)1, (Locale)locale);
        return format.format(date);
    }

    public Date getGMTDate() {
        return this.gmtDate;
    }

    public String getBuildId() {
        return this.buildId;
    }

    public String getBranch() {
        return this.branch;
    }

    public String getHotfix() {
        return this.hotfix;
    }

    public String getApplicationDataValue(String name) {
        if (null == this.applicationData) {
            return null;
        }
        return this.getAttribute(this.applicationData, name);
    }

    private void parseApplicationData(Node applicationDataNode) {
        this.applicationData = applicationDataNode;
    }

    private String getAttribute(Node node, String name) {
        Node n;
        NamedNodeMap attributes = node.getAttributes();
        if (null != attributes && null != (n = attributes.getNamedItem(name))) {
            return n.getNodeValue();
        }
        return null;
    }

    private String getRequiredAttribute(Node node, String name) {
        String value = this.getAttribute(node, name);
        if (null == value) {
            throw new IllegalStateException("Found no value for required attribute: " + name);
        }
        return value;
    }

    protected void parseInputStream(InputStream is) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(is);
            this.setBuildInfo(doc);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Received exception parsing build information stream", e);
        }
    }

    private void setBuildInfo(Document buildInfo) {
        this.buildInfo = buildInfo;
        this.parse();
    }

    private void parse() {
        NodeList buildInfoElements = this.buildInfo.getElementsByTagName("BuildInfo");
        if (buildInfoElements.getLength() <= 0) {
            throw new IllegalStateException("BuildInfo element is required...");
        }
        if (buildInfoElements.getLength() > 1) {
            logger.info("More than one BuildInfo element in document, using the first one");
        }
        Node buildInfoElement = buildInfoElements.item(0);
        this.parseBuildInfo(buildInfoElement);
        NodeList applicationDataElements = this.buildInfo.getElementsByTagName("ApplicationData");
        if (applicationDataElements.getLength() > 0) {
            if (applicationDataElements.getLength() > 1) {
                logger.info("More than one BuildInfo element in document, using the first one");
            }
            this.parseApplicationData(applicationDataElements.item(0));
        }
    }

    private void parseBuildInfo(Node buildInfoElement) {
        this.buildInfoVersion = this.getRequiredAttribute(buildInfoElement, "version");
        String buildStamp = this.getRequiredAttribute(buildInfoElement, "buildstamp");
        this.buildId = this.getRequiredAttribute(buildInfoElement, "buildID");
        this.branch = this.getRequiredAttribute(buildInfoElement, "branch");
        String gmtDateString = this.getRequiredAttribute(buildInfoElement, "GMTdate");
        String gmtTimeString = this.getRequiredAttribute(buildInfoElement, "GMTtime");
        this.hotfix = this.getAttribute(buildInfoElement, "hotfix");
        SimpleDateFormat buildStampFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
        try {
            this.buildTimeStamp = buildStampFormat.parse(buildStamp);
        }
        catch (ParseException e) {
            logger.warn("Received parse exception for buildStamp: " + buildStamp);
        }
        SimpleDateFormat gmtDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        try {
            this.gmtDate = gmtDateFormat.parse(gmtDateString + gmtTimeString);
        }
        catch (ParseException e) {
            logger.warn("Received parse exception for buildStamp: " + buildStamp);
        }
    }
}

