/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.commons.i18n;

import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class RBBase {
    private ResourceBundle resourceBundle;
    private Hashtable<Locale, ResourceBundle> localeBundles;
    private String resourceBundleName;

    protected RBBase(String resourceBundleName) {
        this.resourceBundleName = resourceBundleName;
    }

    protected final String _getStringResource(String key) {
        return this._getStringResource(key, Locale.getDefault());
    }

    protected final String _getStringResource(String key, Locale locale) {
        try {
            return this._getResources(locale).getString(key);
        }
        catch (MissingResourceException r) {
            throw r;
        }
        catch (Exception e) {
            throw new MissingResourceException(e.getMessage(), this.resourceName(), key);
        }
    }

    protected final ResourceBundle _getResources() {
        return this._getResources(Locale.getDefault());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final ResourceBundle _getResources(Locale locale) {
        try {
            if (locale == null) {
                locale = Locale.getDefault();
            }
            if (locale.equals(Locale.getDefault())) {
                RBBase rBBase = this;
                synchronized (rBBase) {
                    if (this.resourceBundle == null || !this.resourceBundle.getLocale().equals(locale)) {
                        this.resourceBundle = ResourceBundle.getBundle(this.resourceName(), locale, this.getClass().getClassLoader());
                    }
                }
                return this.resourceBundle;
            }
            ResourceBundle localeBundle = null;
            if (this.localeBundles == null) {
                this.localeBundles = new Hashtable();
            } else {
                localeBundle = this.localeBundles.get(locale);
            }
            if (localeBundle != null) {
                return localeBundle;
            }
            RBBase rBBase = this;
            synchronized (rBBase) {
                localeBundle = ResourceBundle.getBundle(this.resourceName(), locale, this.getClass().getClassLoader());
                this.localeBundles.put(locale, localeBundle);
            }
            return localeBundle;
        }
        catch (MissingResourceException r) {
            System.out.println("Missing resource bundle " + this.resourceName() + " for locale " + locale);
            throw r;
        }
    }

    private String resourceName() {
        String className = this.getClass().getName();
        int dot = className.lastIndexOf(46);
        return dot == -1 ? this.resourceBundleName : className.substring(0, dot) + "." + this.resourceBundleName;
    }
}

