/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.commons.holders;

import com.sas.framework.commons.TenantIdentifier;
import com.sas.framework.commons.holders.HolderStrategy;
import com.sas.framework.commons.holders.HolderStrategyFactory;

public class TenantHolder {
    private static final String DEFAULT_STRATEGY = System.getProperty("sas.tenant.holder.strategy", null);
    private static HolderStrategy<TenantIdentifier> strategy;

    private TenantHolder() {
    }

    public static void setStrategyName(String name) {
        strategy = HolderStrategyFactory.getStrategy(TenantIdentifier.class, name);
    }

    public static void set(TenantIdentifier s) {
        strategy.set(s);
    }

    public static TenantIdentifier get() {
        TenantIdentifier tenant = strategy.get();
        return tenant == null ? TenantIdentifier.DEFAULT : tenant;
    }

    public static void clear() {
        strategy.clear();
    }

    static {
        TenantHolder.setStrategyName(DEFAULT_STRATEGY);
    }
}

