/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.commons;

import java.io.Serializable;
import java.util.Locale;
import java.util.ResourceBundle;

public abstract class AbstractEnum
implements Serializable {
    private static final String LABEL = "";
    private static final String ABBREV = ".abbrev";
    private static final String DESCR = ".descr";
    private String _key;
    protected String _bundle;

    public static AbstractEnum getInstance(String key, AbstractEnum[] values) {
        if (null == key) {
            return null;
        }
        for (int i = 0; i < values.length; ++i) {
            if (!key.equalsIgnoreCase(values[i].getKey())) continue;
            return values[i];
        }
        return null;
    }

    protected void setBundle(String bundle) {
        this._bundle = bundle;
    }

    protected AbstractEnum(String key) {
        this._key = key;
    }

    public final String getKey() {
        return this._key;
    }

    public final String getTypeLabel() {
        return this.getTypeLabel(Locale.getDefault());
    }

    public String getTypeLabel(Locale locale) {
        return this.getStringResource(locale, this.getResourceKey());
    }

    public final String getLabel() {
        return this.getLabel(Locale.getDefault());
    }

    public String getLabel(Locale locale) {
        return this.getStringResource(locale, this.getResourceKey(LABEL, this.getLabelSuffix()));
    }

    public final String getAbbreviation() {
        return this.getAbbreviation(Locale.getDefault());
    }

    public String getAbbreviation(Locale locale) {
        return this.getStringResource(locale, this.getResourceKey(ABBREV));
    }

    public final String getDescription() {
        return this.getDescription(Locale.getDefault());
    }

    public String getDescription(Locale locale) {
        return this.getStringResource(locale, this.getResourceKey(DESCR));
    }

    protected ResourceBundle getResources(Locale locale) {
        return ResourceBundle.getBundle(this._bundle, locale);
    }

    protected final String getStringResource(Locale locale, String key) {
        return this.getResources(locale).getString(key);
    }

    protected String getLabelSuffix() {
        return ".txt";
    }

    private String getTypeKey() {
        String name = this.getClass().getName();
        int lastDot = name.lastIndexOf(".");
        return name.substring(lastDot + 1);
    }

    private String getResourceKey() {
        StringBuffer b = new StringBuffer(10);
        b.append("Enum.").append(this.getTypeKey()).append(".txt");
        return b.toString();
    }

    private String getResourceKey(String resourceType) {
        return this.getResourceKey(resourceType, ".txt");
    }

    private String getResourceKey(String resourceType, String suffix) {
        StringBuffer b = new StringBuffer(20);
        b.append("Enum.").append(this.getTypeKey()).append(".").append(this.getKey()).append(resourceType).append(suffix);
        return b.toString();
    }

    public String toString() {
        return this._key;
    }
}

