/*
 * Decompiled with CFR 0.152.
 */
package com.sas.publicobjects.etl.util.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.sas.publicobjects.etl.util.model.Attribute;
import com.sas.publicobjects.etl.util.model.AttributeContainer;
import com.sas.publicobjects.etl.util.model.JsonDateDeserializer;
import com.sas.publicobjects.etl.util.model.Link;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Attributes {
    private AttributeContainer attributes;
    private List<Link> links;
    private String contentType = "";
    private String contentVersion = "";
    private String createdBy = "";
    private String creationDate = "";
    private String description = "";
    private String id = "";
    private String internalVersion = "";
    private String modifiedBy = "";
    private String modifiedDate = "";
    private String name = "";
    private String objectType = "";
    private String objectTypeName = "";
    private String path = "";
    private String version = "";

    public Map<String, String> getAttributeMap() {
        HashMap<String, String> returnValue = new HashMap<String, String>();
        returnValue.put("contentType", this.contentType);
        returnValue.put("contentVersion", this.contentVersion);
        returnValue.put("creationDate", this.creationDate);
        returnValue.put("description", this.description);
        returnValue.put("id", this.id);
        returnValue.put("internalVersion", this.internalVersion);
        returnValue.put("modifiedBy", this.modifiedBy);
        returnValue.put("modifiedDate", this.modifiedDate);
        returnValue.put("name", this.name);
        returnValue.put("objectType", this.objectType);
        returnValue.put("objectTypeName", this.objectTypeName);
        returnValue.put("path", this.path);
        returnValue.put("version", this.version);
        if (this.links != null && this.links.size() >= 1) {
            returnValue.put("link", this.links.get(0).getHref());
        }
        if (this.attributes != null) {
            List<Attribute> attrs = this.attributes.getAttributes();
            for (Attribute attr : attrs) {
                String key = attr.getQname().getLocalPart();
                if (returnValue.containsKey(key)) continue;
                returnValue.put(key, attr.getValue());
            }
        }
        return returnValue;
    }

    public AttributeContainer getAttributes() {
        return this.attributes;
    }

    public void setAttributes(AttributeContainer attributes) {
        this.attributes = attributes;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentVersion() {
        return this.contentVersion;
    }

    public void setContentVersion(String contentVersion) {
        this.contentVersion = contentVersion;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(String creationDate) {
        this.creationDate = creationDate;
    }

    @JsonDeserialize(using=JsonDateDeserializer.class)
    @JsonProperty(value="creationDate")
    public void setCreationDate(Date modifiedDate) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mmZ");
        this.creationDate = df.format(modifiedDate);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getInternalVersion() {
        return this.internalVersion;
    }

    public void setInternalVersion(String internalVersion) {
        this.internalVersion = internalVersion;
    }

    public String getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(String modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public String getModifiedDate() {
        return this.modifiedDate;
    }

    public void setModifiedDate(String modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    @JsonDeserialize(using=JsonDateDeserializer.class)
    @JsonProperty(value="modifiedDate")
    public void setModifiedDate(Date modifiedDate) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mmZ");
        this.modifiedDate = df.format(modifiedDate);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public void setObjectType(String objectType) {
        this.objectType = objectType;
    }

    public String getObjectTypeName() {
        return this.objectTypeName;
    }

    public void setObjectTypeName(String objectTypeName) {
        this.objectTypeName = objectTypeName;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public List<Link> getLinks() {
        return this.links;
    }

    public void setLinks(List<Link> links) {
        this.links = links;
    }

    public String toString() {
        return super.toString();
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }
}

