/*
 * Decompiled with CFR 0.152.
 */
package com.sas.publicobjects.etl.util;

import com.sas.publicobjects.etl.util.RestSession;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterComponent;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.services.information.browse.BrowseMetadataUtil;
import com.sas.services.user.UserIdentityInterface;
import java.net.URI;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class RestApplicationUtil {
    public static final String DATA_LOADER_CLASSIDENTIFIER = "dmddmid";
    public static final String VISUAL_PROFILER_CLASSIDENTIFIER = "dmddmid.webprofile";
    public static final String SAS_DATALOADER_SOFTWARECOMPONENT_XMLSELECT = "<XMLSelect search=\"SoftwareComponent[@PublicType = 'Application' and @ClassIdentifier = 'dmddmid']\"/>";
    public static final String SAS_LOGON_SOFTWARECOMPONENT_XMLSELECT = "<XMLSelect search=\"SoftwareComponent[@PublicType = 'Application' and @Name = 'Logon Manager 9.4']\"/>";
    public static final String SAS_VISUAL_PROFILER_SOFTWARECOMPONENT_XMLSELECT = "<XMLSelect search=\"SoftwareComponent[@PublicType = 'Application' and @ClassIdentifier = 'dmddmid.webprofile']\"/>";
    public static final String SOFTWARE_COMPONENT_TEMPLATE = "<Templates><SoftwareComponent Name=\"\" ClassIdentifier=\"\" SoftwareVersion=\"\" PublicType=\"\" ProductName=\"\"><DeployedComponents/><Trees/><PropertySets/></SoftwareComponent><Tree Name=\"\" PublicType=\"\"><ParentTree/><SoftwareComponents/></Tree><DeployedComponent Name=\"\" ClassIdentifier=\"\" SoftwareVersion=\"\" PublicType=\"\" ><SourceConnections/><Properties/></DeployedComponent><TCPIPConnection Name=\"\" CommunicationProtocol=\"\" Hostname=\"\" Port=\"\" Service=\"\"/><Property PropertyName=\"\" DefaultValue=\"\" SQLType=\"\"/></Templates>";
    public static final String DIRECTIVE_OMR_QUERY_TEMPLATE = "<Templates><Transformation><ExternalIdentities/><Extensions/><Trees/></Transformation><Tree><ParentTree/><SoftwareComponents/></Tree></Templates>";
    public static final String DIRECTIVE_EXECUTION_QUERY_PARAM_DIRECTIVE = "directive";
    public static final String DIRECTIVE_EXECUTION_QUERY_PARAM_DIRECTIVEPATH = "directivePath";
    public static final String REGISTERED_SAS_APPLICATION = "Registered SAS Application";
    public static final String CONNECTION_URI = "Connection URI";
    public static final String SAS_DATA_LOADER_REST = "DataLoader REST";
    public static final String SAS_LOGON_REST = "LogonTicketService REST";
    public static final String PATH = "Path";
    public static final String REPORT_PATH_ELEMENT = "jobid=";
    public static final String PROFILEREPORT_PATH_ELEMENT = "/profile.jsp";
    Logger _logger = LogManager.getLogger(RestApplicationUtil.class);
    private RepositoryInterface _repos;

    public RestApplicationUtil(RepositoryInterface repos) {
        this._repos = repos;
    }

    public UserIdentityInterface getCredentials() throws ServiceException, RemoteException {
        UserIdentityInterface returnValue = null;
        if (null != this._repos) {
            String domain = this._repos.getServer().getUserContext().getAuthServer().getDomain();
            returnValue = this._repos.getServer().getUserContext().getIdentityByDomain(domain);
        }
        return returnValue;
    }

    public RestSession getRestSession() throws ServiceException, RemoteException {
        URI logon = this.getSASLogonRESTURI();
        RestSession returnValue = new RestSession(logon, this.getCredentials());
        return returnValue;
    }

    public String getDirectiveContentFromREST(String directiveId) throws ServiceException, RemoteException {
        RestSession session;
        URI logonURI;
        String returnValue = null;
        URI exportURI = this.getDataLoaderExportDirectiveURI(directiveId);
        if (null != exportURI && null != (logonURI = this.getSASLogonRESTURI()) && null != (session = new RestSession(logonURI, this.getCredentials()))) {
            String serviceURIwSGTStr = session.getServiceURI(exportURI.toString());
            RestTemplate template = new RestTemplate();
            HttpHeaders headers = new HttpHeaders();
            headers.add("Accept", "application/json");
            HttpEntity requestEntity = new HttpEntity((Object)"", (MultiValueMap)headers);
            this._logger.debug("Making service REST call: " + serviceURIwSGTStr);
            session.getRestUtility().logHeaders((HttpEntity<String>)requestEntity);
            ResponseEntity objectFetchResult = template.exchange(serviceURIwSGTStr, HttpMethod.GET, requestEntity, String.class, new Object[0]);
            session.getRestUtility().logHeaders((ResponseEntity<String>)objectFetchResult);
            if (objectFetchResult.getStatusCode() != HttpStatus.OK) {
                this._logger.error("Error fetching object: " + objectFetchResult.getStatusCode() + ", " + exportURI);
            }
            this._logger.debug("Received Object: " + (String)objectFetchResult.getBody());
            if (objectFetchResult.hasBody()) {
                returnValue = (String)objectFetchResult.getBody();
            }
        }
        return returnValue;
    }

    public boolean putDirectiveContentFromREST(String directiveContent) throws ServiceException, RemoteException {
        RestSession session;
        URI logonURI;
        boolean returnValue = false;
        URI importURI = this.getDataLoaderImportDirectiveURI();
        if (null != importURI && null != (logonURI = this.getSASLogonRESTURI()) && null != (session = new RestSession(logonURI, this.getCredentials()))) {
            String serviceURIwSGTStr = session.getServiceURI(importURI.toString());
            RestTemplate template = new RestTemplate();
            HttpHeaders headers = new HttpHeaders();
            headers.add("Accept", "application/json");
            HttpEntity requestEntity = new HttpEntity((Object)"", (MultiValueMap)headers);
            this._logger.debug("Making service REST call: " + serviceURIwSGTStr);
            session.getRestUtility().logHeaders((HttpEntity<String>)requestEntity);
            ResponseEntity objectFetchResult = template.exchange(serviceURIwSGTStr, HttpMethod.PUT, requestEntity, String.class, new Object[0]);
            session.getRestUtility().logHeaders((ResponseEntity<String>)objectFetchResult);
            if (objectFetchResult.getStatusCode() != HttpStatus.OK) {
                this._logger.error("Error updating object: " + objectFetchResult.getStatusCode() + ", " + importURI);
            }
        }
        return returnValue;
    }

    public BrowseMetadataInterface getDirectiveByInternalId(String id) throws RemoteException, ServiceException {
        BrowseMetadataInterface returnValue = null;
        String xmlSelect = "<XMLSelect search=\"Transformation[@TransformRole = 'Directive'][ExternalIdentities/ExternalIdentity[@Context = 'GUID' and @Identifier = '" + id + "']]\"/>";
        List<BrowseMetadataInterface> objects = this.searchForObject(this._repos, 8, xmlSelect + DIRECTIVE_OMR_QUERY_TEMPLATE, "Transformation", null);
        if (null == objects || objects.size() <= 0) {
            this._logger.error("Unable to find directive by id=" + id);
            return returnValue;
        }
        returnValue = objects.get(0);
        return returnValue;
    }

    public String getDirectivePath(String directiveInternalId) throws RemoteException, ServiceException {
        BrowseMetadataInterface browse = this.getDirectiveByInternalId(directiveInternalId);
        if (null != browse) {
            return BrowseMetadataUtil.getDisplayPath((BrowseMetadataInterface)browse);
        }
        return "";
    }

    protected List<BrowseMetadataInterface> searchForObject(RepositoryInterface server, int omrFlags, String template, String objectType, FilterComponent filterComponent) throws RemoteException, ServiceException {
        ArrayList<BrowseMetadataInterface> browseObjects = new ArrayList<BrowseMetadataInterface>();
        if (server == null) {
            throw new IllegalArgumentException("Server was null, unable to execute search.");
        }
        Filter filter = new Filter();
        filter.setOMRFlags(omrFlags | 4 | 0x80 | 0x100 | 0x2000);
        filter.setOMRTemplate(template);
        filter.setType(objectType);
        if (filterComponent != null) {
            filter.setFilterComponent(filterComponent);
        }
        this._logger.debug("Executing search with filter: " + filter);
        List objects = server.browseSearch((FilterInterface)filter);
        for (Object bi : objects) {
            if (!(bi instanceof BrowseMetadataInterface)) continue;
            browseObjects.add((BrowseMetadataInterface)bi);
        }
        return browseObjects;
    }

    public URI getDataLoaderRootURI() throws ServiceException, RemoteException {
        URIAttributes attrs;
        URI returnValue = null;
        BrowseMetadataInterface sc = this.getBrowseMetadataDataLoaderSoftwareComponent();
        if (this.populateURIAttributesFromDataLoaderSoftwareComponents(sc, attrs = new URIAttributes())) {
            returnValue = attrs.port > 0 ? UriComponentsBuilder.newInstance().host(attrs.hostName).port(attrs.port).scheme(attrs.protocol).path(attrs.serviceEndpoint).build().toUri() : UriComponentsBuilder.newInstance().host(attrs.hostName).scheme(attrs.protocol).path(attrs.serviceEndpoint).build().toUri();
        } else {
            this._logger.error("Unable to build URI for SAS Data Loader software component");
        }
        return returnValue;
    }

    public URI getSASLogonRESTURI() throws ServiceException, RemoteException {
        URIAttributes attrs;
        URI returnValue = null;
        BrowseMetadataInterface sc = this.getBrowseMetadataSASLogonSoftwareComponent();
        if (this.populateURIAttributesFromSASLogonSoftwareComponents(sc, attrs = new URIAttributes())) {
            returnValue = attrs.port > 0 ? UriComponentsBuilder.newInstance().host(attrs.hostName).port(attrs.port).scheme(attrs.protocol).path(attrs.serviceEndpoint).build().toUri() : UriComponentsBuilder.newInstance().host(attrs.hostName).scheme(attrs.protocol).path(attrs.serviceEndpoint).build().toUri();
        } else {
            this._logger.error("Unable to build URI for SAS Logon 9.4 software component");
        }
        return returnValue;
    }

    public URI getDataLoaderExportDirectiveURI(String directiveId) throws ServiceException, RemoteException {
        URIAttributes attrs;
        String ROOT_UI_ENDPOINT = "/DataLoader";
        String EXPORT_DIRECTIVE_ENDPOINT = ROOT_UI_ENDPOINT + "/directives/exported/" + directiveId;
        URI returnValue = null;
        BrowseMetadataInterface sc = this.getBrowseMetadataDataLoaderSoftwareComponent();
        if (this.populateURIAttributesFromDataLoaderSoftwareComponents(sc, attrs = new URIAttributes())) {
            returnValue = attrs.port > 0 ? UriComponentsBuilder.newInstance().host(attrs.hostName).port(attrs.port).scheme(attrs.protocol).path(attrs.serviceEndpoint + EXPORT_DIRECTIVE_ENDPOINT).build().toUri() : UriComponentsBuilder.newInstance().host(attrs.hostName).scheme(attrs.protocol).path(attrs.serviceEndpoint + EXPORT_DIRECTIVE_ENDPOINT).build().toUri();
        } else {
            this._logger.error("Unable to build URI for SAS Data Loader export directive REST endpoint");
        }
        return returnValue;
    }

    public URI getDataLoaderImportDirectiveURI() throws ServiceException, RemoteException {
        URIAttributes attrs;
        String ROOT_UI_ENDPOINT = "/DataLoader";
        String IMPORT_DIRECTIVE_ENDPOINT = ROOT_UI_ENDPOINT + "/directives/imported";
        URI returnValue = null;
        BrowseMetadataInterface sc = this.getBrowseMetadataDataLoaderSoftwareComponent();
        if (this.populateURIAttributesFromDataLoaderSoftwareComponents(sc, attrs = new URIAttributes())) {
            returnValue = attrs.port > 0 ? UriComponentsBuilder.newInstance().host(attrs.hostName).port(attrs.port).scheme(attrs.protocol).path(attrs.serviceEndpoint + IMPORT_DIRECTIVE_ENDPOINT).build().toUri() : UriComponentsBuilder.newInstance().host(attrs.hostName).scheme(attrs.protocol).path(attrs.serviceEndpoint + IMPORT_DIRECTIVE_ENDPOINT).build().toUri();
        } else {
            this._logger.error("Unable to build URI for SAS Data Loader export directive REST endpoint");
        }
        return returnValue;
    }

    public URI getDataLoaderViewDirectiveURI(String directiveId) throws ServiceException, RemoteException {
        URIAttributes attrs;
        URI returnValue = null;
        BrowseMetadataInterface sc = this.getBrowseMetadataDataLoaderSoftwareComponent();
        if (this.populateURIAttributesFromDataLoaderSoftwareComponents(sc, attrs = new URIAttributes())) {
            returnValue = attrs.port > 0 ? UriComponentsBuilder.newInstance().host(attrs.hostName).port(attrs.port).scheme(attrs.protocol).fragment("directive=" + directiveId).path(attrs.serviceEndpoint).build().toUri() : UriComponentsBuilder.newInstance().host(attrs.hostName).scheme(attrs.protocol).path(attrs.serviceEndpoint).build().toUri();
        } else {
            this._logger.error("Unable to build URI for SAS Data Loader software component");
        }
        return returnValue;
    }

    public URI getDataLoaderViewDirectiveByPathURI(String directivePath) throws ServiceException, RemoteException {
        URIAttributes attrs;
        URI returnValue = null;
        BrowseMetadataInterface sc = this.getBrowseMetadataDataLoaderSoftwareComponent();
        if (this.populateURIAttributesFromDataLoaderSoftwareComponents(sc, attrs = new URIAttributes())) {
            returnValue = attrs.port > 0 ? UriComponentsBuilder.newInstance().host(attrs.hostName).port(attrs.port).scheme(attrs.protocol).fragment("directivePath=" + directivePath).path(attrs.serviceEndpoint).build().toUri() : UriComponentsBuilder.newInstance().host(attrs.hostName).scheme(attrs.protocol).path(attrs.serviceEndpoint).build().toUri();
        } else {
            this._logger.error("Unable to build URI for SAS Data Loader software component");
        }
        return returnValue;
    }

    public URI getDataLoaderRESTURI() throws ServiceException, RemoteException {
        URIAttributes attrs;
        URI returnValue = null;
        BrowseMetadataInterface sc = this.getBrowseMetadataDataLoaderSoftwareComponent();
        if (this.populateURIAttributesFromDataLoaderSoftwareComponents(sc, attrs = new URIAttributes())) {
            returnValue = attrs.port > 0 ? UriComponentsBuilder.newInstance().host(attrs.hostName).port(attrs.port).scheme(attrs.protocol).path(attrs.getRESTPath()).build().toUri() : UriComponentsBuilder.newInstance().host(attrs.hostName).scheme(attrs.protocol).path(attrs.getRESTPath()).build().toUri();
        } else {
            this._logger.error("Unable to build URI for SAS Data Loader software component");
        }
        return returnValue;
    }

    public URI getDataLoaderDirectiveExecutionURI(String directiveId) throws ServiceException, RemoteException {
        URIAttributes attrs;
        URI returnValue = null;
        BrowseMetadataInterface sc = this.getBrowseMetadataDataLoaderSoftwareComponent();
        if (this.populateURIAttributesFromDataLoaderSoftwareComponents(sc, attrs = new URIAttributes())) {
            String queryParam = DIRECTIVE_EXECUTION_QUERY_PARAM_DIRECTIVE;
            String queryValue = directiveId;
            returnValue = attrs.port > 0 ? UriComponentsBuilder.newInstance().host(attrs.hostName).port(attrs.port).scheme(attrs.protocol).queryParam(queryParam, new Object[]{queryValue}).path(attrs.getExecutionPath()).build().toUri() : UriComponentsBuilder.newInstance().host(attrs.hostName).scheme(attrs.protocol).queryParam(queryParam, new Object[]{queryValue}).path(attrs.getExecutionPath()).build().toUri();
        } else {
            this._logger.error("Unable to build URI for SAS Data Loader software component");
        }
        return returnValue;
    }

    public URI getDataLoaderDirectiveExecutionByPathURI(String directivePath) throws ServiceException, RemoteException {
        URIAttributes attrs;
        URI returnValue = null;
        BrowseMetadataInterface sc = this.getBrowseMetadataDataLoaderSoftwareComponent();
        if (this.populateURIAttributesFromDataLoaderSoftwareComponents(sc, attrs = new URIAttributes())) {
            String queryParam = DIRECTIVE_EXECUTION_QUERY_PARAM_DIRECTIVEPATH;
            String queryValue = directivePath;
            returnValue = attrs.port > 0 ? UriComponentsBuilder.newInstance().host(attrs.hostName).port(attrs.port).scheme(attrs.protocol).queryParam(queryParam, new Object[]{queryValue}).path(attrs.getExecutionPath()).build().toUri() : UriComponentsBuilder.newInstance().host(attrs.hostName).scheme(attrs.protocol).queryParam(queryParam, new Object[]{queryValue}).path(attrs.getExecutionPath()).build().toUri();
        } else {
            this._logger.error("Unable to build URI for SAS Data Loader software component");
        }
        return returnValue;
    }

    private BrowseMetadataInterface getBrowseMetadataDataLoaderSoftwareComponent() throws RemoteException, ServiceException {
        List<BrowseMetadataInterface> browseObjects = null;
        browseObjects = this.searchForObject(this._repos.getServer().getFoundationRepository(), 0, "<XMLSelect search=\"SoftwareComponent[@PublicType = 'Application' and @ClassIdentifier = 'dmddmid']\"/><Templates><SoftwareComponent Name=\"\" ClassIdentifier=\"\" SoftwareVersion=\"\" PublicType=\"\" ProductName=\"\"><DeployedComponents/><Trees/><PropertySets/></SoftwareComponent><Tree Name=\"\" PublicType=\"\"><ParentTree/><SoftwareComponents/></Tree><DeployedComponent Name=\"\" ClassIdentifier=\"\" SoftwareVersion=\"\" PublicType=\"\" ><SourceConnections/><Properties/></DeployedComponent><TCPIPConnection Name=\"\" CommunicationProtocol=\"\" Hostname=\"\" Port=\"\" Service=\"\"/><Property PropertyName=\"\" DefaultValue=\"\" SQLType=\"\"/></Templates>", "SoftwareComponent", null);
        if (null == browseObjects || browseObjects.size() == 0) {
            throw new ServiceException("No software components found for = dmddmid");
        }
        BrowseMetadataInterface sc = browseObjects.get(0);
        if (browseObjects.size() > 1) {
            this._logger.warn("Expected 1 software component, but found: " + browseObjects.size());
        }
        return sc;
    }

    private BrowseMetadataInterface getBrowseMetadataSASLogonSoftwareComponent() throws RemoteException, ServiceException {
        List<BrowseMetadataInterface> browseObjects = null;
        browseObjects = this.searchForObject(this._repos.getServer().getFoundationRepository(), 0, "<XMLSelect search=\"SoftwareComponent[@PublicType = 'Application' and @Name = 'Logon Manager 9.4']\"/><Templates><SoftwareComponent Name=\"\" ClassIdentifier=\"\" SoftwareVersion=\"\" PublicType=\"\" ProductName=\"\"><DeployedComponents/><Trees/><PropertySets/></SoftwareComponent><Tree Name=\"\" PublicType=\"\"><ParentTree/><SoftwareComponents/></Tree><DeployedComponent Name=\"\" ClassIdentifier=\"\" SoftwareVersion=\"\" PublicType=\"\" ><SourceConnections/><Properties/></DeployedComponent><TCPIPConnection Name=\"\" CommunicationProtocol=\"\" Hostname=\"\" Port=\"\" Service=\"\"/><Property PropertyName=\"\" DefaultValue=\"\" SQLType=\"\"/></Templates>", "SoftwareComponent", null);
        if (null == browseObjects || browseObjects.size() == 0) {
            throw new ServiceException("No software components found for = Logon Manager 9.4");
        }
        BrowseMetadataInterface sc = browseObjects.get(0);
        if (browseObjects.size() > 1) {
            this._logger.warn("Expected 1 software component, but found: " + browseObjects.size());
        }
        return sc;
    }

    private BrowseMetadataInterface getBrowseMetadataVisualDataProfilerSoftwareComponent() throws RemoteException, ServiceException {
        List<BrowseMetadataInterface> browseObjects = null;
        browseObjects = this.searchForObject(this._repos.getServer().getFoundationRepository(), 0, "<XMLSelect search=\"SoftwareComponent[@PublicType = 'Application' and @ClassIdentifier = 'dmddmid.webprofile']\"/><Templates><SoftwareComponent Name=\"\" ClassIdentifier=\"\" SoftwareVersion=\"\" PublicType=\"\" ProductName=\"\"><DeployedComponents/><Trees/><PropertySets/></SoftwareComponent><Tree Name=\"\" PublicType=\"\"><ParentTree/><SoftwareComponents/></Tree><DeployedComponent Name=\"\" ClassIdentifier=\"\" SoftwareVersion=\"\" PublicType=\"\" ><SourceConnections/><Properties/></DeployedComponent><TCPIPConnection Name=\"\" CommunicationProtocol=\"\" Hostname=\"\" Port=\"\" Service=\"\"/><Property PropertyName=\"\" DefaultValue=\"\" SQLType=\"\"/></Templates>", "SoftwareComponent", null);
        if (null == browseObjects || browseObjects.size() == 0) {
            throw new ServiceException("No software components found for = dmddmid.webprofile");
        }
        BrowseMetadataInterface sc = browseObjects.get(0);
        if (browseObjects.size() > 1) {
            this._logger.warn("Expected 1 software component, but found: " + browseObjects.size());
        }
        return sc;
    }

    private boolean populateURIAttributesFromDataLoaderSoftwareComponents(BrowseMetadataInterface sc, URIAttributes attrs) {
        return this.populateURIAttributesFromSoftwareComponents(sc, attrs, SAS_DATA_LOADER_REST);
    }

    private boolean populateURIAttributesFromSASLogonSoftwareComponents(BrowseMetadataInterface sc, URIAttributes attrs) {
        return this.populateURIAttributesFromSoftwareComponents(sc, attrs, SAS_LOGON_REST);
    }

    private boolean populateURIAttributesFromVisualDataProfilerSoftwareComponents(BrowseMetadataInterface sc, URIAttributes attrs) {
        return this.populateURIAttributesFromSoftwareComponents(sc, attrs, SAS_DATA_LOADER_REST);
    }

    private boolean populateURIAttributesFromSoftwareComponents(BrowseMetadataInterface sc, URIAttributes attrs, String appDeployedComponentClassId) {
        List deployedComponents;
        Object assnObject;
        boolean returnValue = false;
        if (null != sc && null != (assnObject = sc.get("DeployedComponents")) && assnObject instanceof List && (deployedComponents = (List)assnObject).size() > 0) {
            for (BrowseMetadataInterface dc : deployedComponents) {
                Object props;
                if (REGISTERED_SAS_APPLICATION.equals(dc.getName())) {
                    Object srcConns = dc.get("SourceConnections");
                    if (null == srcConns || !(srcConns instanceof List)) continue;
                    List srcConnections = (List)srcConns;
                    for (BrowseMetadataInterface srcConn : srcConnections) {
                        if (!CONNECTION_URI.equals(srcConn.getName())) continue;
                        returnValue = true;
                        attrs.protocol = (String)srcConn.get("CommunicationProtocol");
                        attrs.hostName = (String)srcConn.get("HostName");
                        attrs.setPort((String)srcConn.get("Port"));
                        attrs.serviceEndpoint = (String)srcConn.get("Service");
                    }
                    continue;
                }
                if (!appDeployedComponentClassId.equals(dc.get("ClassIdentifier")) || null == (props = dc.get("Properties")) || !(props instanceof List)) continue;
                List properties = (List)props;
                for (BrowseMetadataInterface prop : properties) {
                    if (!PATH.equals(prop.get("PropertyName"))) continue;
                    attrs.restEndpoint = (String)prop.get("DefaultValue");
                }
            }
        }
        return returnValue;
    }

    public URI getProfileReportOpenURI(String profileReportId) throws RemoteException, ServiceException {
        URIAttributes attrs;
        URI returnValue = null;
        BrowseMetadataInterface sc = this.getBrowseMetadataVisualDataProfilerSoftwareComponent();
        if (this.populateURIAttributesFromVisualDataProfilerSoftwareComponents(sc, attrs = new URIAttributes())) {
            returnValue = attrs.port > 0 ? UriComponentsBuilder.newInstance().host(attrs.hostName).port(attrs.port).scheme(attrs.protocol).path(attrs.serviceEndpoint + PROFILEREPORT_PATH_ELEMENT).query(REPORT_PATH_ELEMENT + profileReportId).build().toUri() : UriComponentsBuilder.newInstance().host(attrs.hostName).scheme(attrs.protocol).path(attrs.serviceEndpoint).build().toUri();
        } else {
            this._logger.error("Unable to build URI for SAS Visual Data Profiler software component");
        }
        return returnValue;
    }

    private class URIAttributes {
        private static final String PROTOCOL_HTTPS = "https";
        private static final String PROTOCOL_HTTP = "http";
        public static final String REST_DIRECTIVE_EXECUTION_JOBS = "/jobs";
        String hostName;
        int port;
        String serviceEndpoint;
        String protocol;
        String restEndpoint;

        private URIAttributes() {
        }

        public void setPort(String inPort) {
            int p = Integer.parseInt(inPort);
            this.port = null != this.protocol && this.protocol.length() > 0 ? (this.protocol.equalsIgnoreCase(PROTOCOL_HTTP) && p != 80 ? p : (this.protocol.equalsIgnoreCase(PROTOCOL_HTTPS) && p != 443 ? p : p)) : Integer.parseInt(inPort);
        }

        public String getExecutionPath() {
            return this.getRESTPath() + REST_DIRECTIVE_EXECUTION_JOBS;
        }

        public String getRESTPath() {
            return "" + this.serviceEndpoint + this.restEndpoint;
        }
    }
}

