/*
 * Decompiled with CFR 0.152.
 */
package com.sas.publicobjects.etl;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.impl.PrototypeImpl;
import com.sas.metadata.remote.impl.PrototypeImpl_Stub;
import com.sas.prompts.definitions.BaseFileDefinition;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.publicobjects.etl.RB;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.FolderUtil;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.OMRPrototype;
import com.sas.services.information.metadata.etl.GeneratedTransformInterface;
import com.sas.services.information.metadata.prompt.BaseOMRPromptInterface;
import com.sas.services.information.metadata.prompt.OMRPromptDefinitionInterface;
import com.sas.services.information.metadata.prompt.OMRPromptGroupInterface;
import com.sas.services.information.metadata.prompt.PromptsPersistUtil;
import com.sas.services.user.UserContextInterface;
import com.sas.services.util.ProcessStatus;
import com.sas.services.util.UpgradeInterface;
import com.sas.storage.editableproperties.MultiLocaleProperties;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.editableproperties.SubstitutionProperties;
import com.sas.storage.editableproperties.UnexpectedLocalizationException;
import com.sas.text.Message;
import com.sas.util.UsageVersion;
import com.sas.wadmin.prompts.conversion.DISEntityConverter;
import com.sas.workspace.metadata.GeneratedTransformationUtilities;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.prefs.BackingStoreException;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;

public class GeneratedTransform
extends OMRPrototype
implements GeneratedTransformInterface,
SubstitutionProperties,
MultiLocaleProperties,
UpgradeInterface {
    private static final long serialVersionUID = 145464487682922127L;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);
    public static final UsageVersion FAILED_UPGRADE_VERSION = new UsageVersion(0, 5);
    private boolean isLocalizationActive = false;

    public GeneratedTransform() throws RemoteException {
    }

    public GeneratedTransform(Class o) throws RemoteException {
        super(o);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public GeneratedTransform(Prototype o) throws RemoteException {
        super(o);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public GeneratedTransform(PrototypeImpl o) throws RemoteException {
        super(o);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public GeneratedTransform(PrototypeImpl_Stub o) throws RemoteException {
        super(o);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public GeneratedTransform(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        if (repos == null || name == null || parent == null) {
            throw new IllegalArgumentException();
        }
        OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
        try {
            Prototype genXForm = (Prototype)omirepository.createMetadata(name, "Prototype");
            genXForm.setPublicType("GeneratedTransform");
            genXForm.setUsageVersion(CURRENT_VERSION.encode());
            this._isCompatible = true;
            this._isReadCompatible = true;
            this._repositoryObject = genXForm;
            this._repositoryFlag = 2;
            this.setRepository(repos);
            try {
                parent.addItem((MetadataInterface)this);
            }
            catch (ServiceException serviceException) {}
        }
        catch (ServiceException ex) {
            this.logThrowable(Level.WARN, ex.getMessage(), "com.sas.services.information.metadata.Metadata", ex);
        }
    }

    public String getType() throws RemoteException {
        if (this._repositoryObject != null) {
            PrimaryType pt = (PrimaryType)this._repositoryObject;
            return pt.getPublicType();
        }
        return "GeneratedTransform";
    }

    public PropertyList getLocalizableProperties() throws UnexpectedLocalizationException {
        PropertyList list = new PropertyList();
        try {
            list.addComment("Object names should be localized with care.  Changing the name may affect");
            list.addComment("other objects that refer to this object by name.");
            list.addProperty("Name", this.getName());
            list.addProperty("Description", this.getDescription());
            if (this._repositoryObject != null && this._repositoryObject instanceof Prototype) {
                Prototype smartTransform = (Prototype)this._repositoryObject;
                String processTreePath = GeneratedTransformationUtilities.getProcessTreePath((Root)smartTransform);
                list.addProperty("ProcessTreePath", processTreePath);
            }
            list.addBlankLine();
            MultiLocaleProperties prompt = this.getPromptGroupForLocalization();
            if (prompt != null) {
                list.addProperty("Prompts", prompt.getLocalizableProperties());
            }
        }
        catch (RemoteException ex) {
            try {
                this.logMessage(Level.ERROR, "Error getting localizable properties", ((Object)((Object)this)).getClass().getName(), ex);
            }
            catch (RemoteException remoteException) {}
        }
        catch (MdException e) {
            try {
                this.logMessage(Level.ERROR, "Error getting localizable properties", ((Object)((Object)this)).getClass().getName(), e);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            throw new UnexpectedLocalizationException((Throwable)e);
        }
        return list;
    }

    public PropertyList getLocalizableProperties(Locale locale) throws UnexpectedLocalizationException {
        PropertyList list = new PropertyList();
        MultiLocaleProperties prompt = this.getPromptGroupForLocalization();
        if (prompt != null) {
            list.addProperty("Prompts", prompt.getLocalizableProperties(locale));
        }
        return list;
    }

    private MultiLocaleProperties getPromptGroupForLocalization() {
        MultiLocaleProperties returnPromptGroup = null;
        try {
            List prompts = this.getPrompts();
            for (BaseOMRPromptInterface prompt : prompts) {
                OMRPromptGroupInterface promptGroup;
                PromptGroupInterface promptGroupI;
                if (!(prompt instanceof OMRPromptGroupInterface) || !((promptGroupI = (promptGroup = (OMRPromptGroupInterface)prompt).getPromptGroup()) instanceof MultiLocaleProperties)) continue;
                returnPromptGroup = (MultiLocaleProperties)promptGroup;
            }
        }
        catch (ServiceException e) {
            try {
                this.logMessage(Level.ERROR, "Error getting prompt information", ((Object)((Object)this)).getClass().getName(), e);
            }
            catch (RemoteException remoteException) {}
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return returnPromptGroup;
    }

    public Collection getLocales() throws UnexpectedLocalizationException {
        Collection returnValue = null;
        MultiLocaleProperties prompt = this.getPromptGroupForLocalization();
        if (prompt != null) {
            returnValue = prompt.getLocales();
        }
        return returnValue;
    }

    public void beginLocalization() throws UnexpectedLocalizationException {
        this.isLocalizationActive = true;
        MultiLocaleProperties prompt = this.getPromptGroupForLocalization();
        if (prompt != null) {
            prompt.beginLocalization();
        }
    }

    public void setLocalizableProperties(PropertyMap map) throws UnexpectedLocalizationException {
        try {
            MultiLocaleProperties prompt;
            if (map.containsProperty("Name")) {
                this.setName(map.getProperty("Name"));
            }
            if (map.containsProperty("Description")) {
                this.setDescription(map.getProperty("Description"));
            }
            if (map.containsProperty("ProcessTreePath")) {
                String processTreePath = map.getProperty("ProcessTreePath");
                if (this._repositoryObject != null && this._repositoryObject instanceof Prototype) {
                    Prototype smartTransform = (Prototype)this._repositoryObject;
                    GeneratedTransformationUtilities.setProcessTreePath((Root)smartTransform, (String)processTreePath);
                }
            }
            if (map.containsNestedProperty("Prompts") && (prompt = this.getPromptGroupForLocalization()) != null) {
                prompt.setLocalizableProperties(map.getNestedProperties("Prompts"));
            }
        }
        catch (RemoteException ex) {
            try {
                this.logMessage(Level.ERROR, "Error setting localizable properties", ((Object)((Object)this)).getClass().getName(), ex);
            }
            catch (RemoteException remoteException) {}
        }
        catch (MdException e) {
            try {
                this.logMessage(Level.ERROR, "Error setting localizable properties", ((Object)((Object)this)).getClass().getName(), e);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            throw new UnexpectedLocalizationException((Throwable)e);
        }
        if (!this.isLocalizationActive) {
            this.endLocalization();
        }
    }

    public void setLocalizableProperties(Locale locale, PropertyMap map) throws UnexpectedLocalizationException {
        MultiLocaleProperties prompt;
        if (map.containsNestedProperty("Prompts") && (prompt = this.getPromptGroupForLocalization()) != null) {
            prompt.setLocalizableProperties(locale, map.getNestedProperties("Prompts"));
        }
        if (!this.isLocalizationActive) {
            this.endLocalization();
        }
    }

    public void endLocalization() throws UnexpectedLocalizationException {
        MultiLocaleProperties prompt = this.getPromptGroupForLocalization();
        if (prompt != null) {
            prompt.endLocalization();
        }
        this.isLocalizationActive = false;
    }

    public void upgradeFromPreviousVersion() throws ServiceException, RemoteException {
        if (this._repositoryObject != null && this._repositoryObject instanceof Prototype) {
            Prototype smartTransform = (Prototype)this._repositoryObject;
            ProcessStatus status = new ProcessStatus(LogManager.getLogger((String)"com.sas.publicobjects.etl"), ProcessStatus.generateLoggingName((CMetadata)smartTransform));
            this.prepareExternalFileUpgrade(smartTransform);
            this.ensureFolder();
            try {
                String publicType;
                MdObjectStore mdStore = (MdObjectStore)smartTransform.getObjectStore();
                DISEntityConverter converter = new DISEntityConverter(mdStore, (Root)smartTransform, this.getRepository().getUserContext());
                PromptGroupInterface prompt = converter.convert2Prompt(false, true);
                if (prompt != null) {
                    String message = Message.format((String)RB.getStringResource("GeneratedTransform.CreatedNewPrompt.fmt.txt"), (Object[])new Object[]{prompt, this.getName()});
                    this.logMessage(Level.INFO, message);
                    status.addInfo(message);
                }
                if ((publicType = smartTransform.getPublicType()) != null && "GeneratedTransform".equals(publicType)) {
                    if (smartTransform.getUsageVersion() != CURRENT_VERSION.encode()) {
                        smartTransform.setUsageVersion(CURRENT_VERSION.encode());
                    }
                } else if (publicType == null || publicType.length() == 0) {
                    smartTransform.setPublicType("GeneratedTransform");
                    smartTransform.setUsageVersion(CURRENT_VERSION.encode());
                }
                smartTransform.updateMetadataAll();
            }
            catch (MdException e) {
                this.logThrowable(Level.ERROR, e.getMessage(), ((Object)((Object)this)).getClass().getName(), e);
                throw new ServiceException((Throwable)e, e.getLocalizedMessage());
            }
            catch (BackingStoreException e) {
                this.logThrowable(Level.ERROR, e.getMessage(), ((Object)((Object)this)).getClass().getName(), e);
                throw new ServiceException((Throwable)e, e.getLocalizedMessage());
            }
            finally {
                ProcessStatus globalStatus = ProcessStatus.getGlobalStatus();
                if (globalStatus != null) {
                    globalStatus.addStatus(status);
                } else {
                    status.logStatus();
                }
            }
        }
    }

    private void ensureFolder() throws ServiceException, RemoteException {
        String folderName;
        FolderInterface sharedData;
        FolderInterface targetFolder = this.getParent();
        if (targetFolder == null && (targetFolder = (sharedData = FolderUtil.makeSharedDataFolder((MetadataInterface)this)).getSubfolder(folderName = RB.getStringResource("GeneratedTransform.OrphanGeneratedTransformFolderName.txt"))) == null) {
            targetFolder = sharedData.makeSubfolder(folderName);
        }
        this.validateNameAndFolder(targetFolder);
        this.update();
    }

    private void prepareExternalFileUpgrade(Prototype smartTransform) throws RemoteException, ServiceException {
        try {
            if (!smartTransform.getPublicType().equals("GeneratedTransform")) {
                smartTransform.setPublicType("GeneratedTransform");
            }
            if (this.getUsageVersion().compareTo((Object)FAILED_UPGRADE_VERSION) < 0) {
                smartTransform.setUsageVersion(FAILED_UPGRADE_VERSION.encode());
            }
            smartTransform.updateMetadataAll();
        }
        catch (MdException e) {
            this.logThrowable(Level.ERROR, e.getMessage(), ((Object)((Object)this)).getClass().getName(), e);
            throw new ServiceException((Throwable)e, e.getLocalizedMessage());
        }
    }

    public PropertyList getSubstitutionProperties() {
        PropertyList props = new PropertyList();
        try {
            List prompts = this.getPrompts();
            for (BaseOMRPromptInterface prompt : prompts) {
                OMRPromptDefinitionInterface smartPromptDef;
                PromptDefinitionInterface promptDef;
                if (prompt instanceof OMRPromptDefinitionInterface && (promptDef = (smartPromptDef = (OMRPromptDefinitionInterface)prompt).getPromptDefinition()) instanceof BaseFileDefinition) {
                    BaseFileDefinition promptFileDef = (BaseFileDefinition)promptDef;
                    PropertyList pdefProps = promptFileDef.getSubstitutionProperties();
                    props.addProperty(promptFileDef.getPromptName(), pdefProps);
                }
                if (!(prompt instanceof OMRPromptGroupInterface)) continue;
                OMRPromptGroupInterface promptGroup = (OMRPromptGroupInterface)prompt;
                PromptGroupInterface promptGroupI = promptGroup.getPromptGroup();
                List promptDefs = promptGroupI.getPromptDefinitions(true);
                for (PromptDefinitionInterface promptDef2 : promptDefs) {
                    if (!(promptDef2 instanceof SubstitutionProperties)) continue;
                    SubstitutionProperties promptFileDef = (SubstitutionProperties)promptDef2;
                    PropertyList pdefProps = promptFileDef.getSubstitutionProperties();
                    props.addProperty(promptDef2.getPromptName(), pdefProps);
                }
            }
        }
        catch (ServiceException e) {
            try {
                this.logMessage(Level.ERROR, "Error getting prompt substitution information", ((Object)((Object)this)).getClass().getName(), e);
            }
            catch (RemoteException remoteException) {}
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return props;
    }

    public void setSubstitutionProperties(PropertyMap map) {
        try {
            List prompts = this.getPrompts();
            for (BaseOMRPromptInterface prompt : prompts) {
                OMRPromptDefinitionInterface smartPromptDef;
                PromptDefinitionInterface promptDef;
                if (prompt instanceof OMRPromptDefinitionInterface && (promptDef = (smartPromptDef = (OMRPromptDefinitionInterface)prompt).getPromptDefinition()) instanceof SubstitutionProperties) {
                    SubstitutionProperties promptFileDef = (SubstitutionProperties)promptDef;
                    promptFileDef.setSubstitutionProperties(map);
                    prompt.update();
                }
                if (!(prompt instanceof OMRPromptGroupInterface)) continue;
                OMRPromptGroupInterface promptGroup = (OMRPromptGroupInterface)prompt;
                PromptGroupInterface promptGroupI = promptGroup.getPromptGroup();
                List promptDefs = promptGroupI.getPromptDefinitions(true);
                for (PromptDefinitionInterface promptDef2 : promptDefs) {
                    if (!(promptDef2 instanceof SubstitutionProperties)) continue;
                    SubstitutionProperties promptFileDef = (SubstitutionProperties)promptDef2;
                    promptFileDef.setSubstitutionProperties(map.getNestedProperties(promptDef2.getPromptName()));
                }
                PromptsPersistUtil.updateGroupSmartObject((PromptGroupInterface)promptGroupI, (UserContextInterface)this.getRepository().getUserContext(), (OMRPromptGroupInterface)promptGroup, null);
                promptGroup.update();
            }
        }
        catch (ServiceException e) {
            try {
                this.logMessage(Level.ERROR, "Error setting prompt substitution information", ((Object)((Object)this)).getClass().getName(), e);
            }
            catch (RemoteException remoteException) {}
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }
}

