/*
 * Decompiled with CFR 0.152.
 */
package com.sas.publicobjects.etl;

import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.impl.TransformationImpl;
import com.sas.metadata.remote.impl.TransformationImpl_Stub;
import com.sas.publicobjects.etl.util.RestApplicationUtil;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.OMRTransformation;
import com.sas.services.information.metadata.etl.DirectiveInterface;
import com.sas.util.UsageVersion;
import java.net.URI;
import java.rmi.RemoteException;
import org.apache.logging.log4j.Level;

public class Directive
extends OMRTransformation
implements DirectiveInterface {
    private static final long serialVersionUID = 7881463870995586781L;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(1, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);
    public static final String IS_TEMPLATE = "isTemplate";
    public static final String METADATA_TYPE = "Transformation";

    public Directive() throws RemoteException {
    }

    public Directive(Class theClass) throws RemoteException {
        super(theClass);
    }

    public Directive(Object o) throws RemoteException {
        super(o);
    }

    public Directive(Object o, Class theClass) throws RemoteException {
        super(o, theClass);
    }

    public Directive(Transformation o) throws RemoteException {
        super((Object)o);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public Directive(TransformationImpl o) throws RemoteException {
        super((Object)o);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public Directive(TransformationImpl_Stub o) throws RemoteException {
        super((Object)o);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public Directive(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        if (repos == null || name == null || parent == null) {
            throw new IllegalArgumentException();
        }
        OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
        try {
            Transformation genXForm = (Transformation)omirepository.createMetadata(name, METADATA_TYPE);
            genXForm.setPublicType("Directive.DL");
            genXForm.setUsageVersion(CURRENT_VERSION.encode());
            this._isCompatible = true;
            this._isReadCompatible = true;
            this._repositoryObject = genXForm;
            this._repositoryFlag = 2;
            genXForm.setTransformRole("Directive");
            this.setRepository(repos);
            try {
                parent.addItem((MetadataInterface)this);
            }
            catch (ServiceException serviceException) {}
        }
        catch (ServiceException ex) {
            this.logThrowable(Level.WARN, ex.getMessage(), "com.sas.services.information.metadata.Metadata", ex);
        }
    }

    public Directive(MetadataInterface mi) throws RemoteException, ServiceException {
        this._isCompatible = mi.isCompatible();
        this._isReadCompatible = mi.isReadCompatible();
        this._repositoryObject = mi.getRepositoryEntity();
        this._repositoryFlag = 2;
        this.setRepository(mi.getRepository());
    }

    public boolean isTemplate() throws RemoteException, ServiceException {
        boolean returnValue = false;
        Transformation omrObject = (Transformation)this._repositoryObject;
        if (null != omrObject && "Directive.Template".equals(omrObject.getTransformRole())) {
            returnValue = true;
        }
        return returnValue;
    }

    public void setTemplate(boolean bIsTemplate) throws RemoteException, ServiceException {
        Transformation omrObject = (Transformation)this._repositoryObject;
        if (bIsTemplate) {
            if (null != omrObject) {
                omrObject.setTransformRole("Directive.Template");
            }
        } else if (null != omrObject) {
            omrObject.setTransformRole("Directive");
        }
    }

    public String getInternalIdentity() throws RemoteException, ServiceException {
        return this.getGUID();
    }

    public void setInternalIdentity(String internalId) throws RemoteException, ServiceException {
        if (null == internalId) {
            return;
        }
        this.setGUID(internalId);
    }

    public URI getExecutionURIById() throws RemoteException, ServiceException {
        URI returnValue = null;
        String id = this.getInternalIdentity();
        RestApplicationUtil util = new RestApplicationUtil(this._repository);
        returnValue = util.getDataLoaderDirectiveExecutionURI(id);
        return returnValue;
    }

    public URI getExecutionURIByPath() throws RemoteException, ServiceException {
        URI returnValue = null;
        String id = this.getInternalIdentity();
        RestApplicationUtil util = new RestApplicationUtil(this._repository);
        String directivePath = util.getDirectivePath(id);
        returnValue = util.getDataLoaderDirectiveExecutionByPathURI(directivePath);
        return returnValue;
    }

    public URI getApplicationRestURI() throws RemoteException, ServiceException {
        URI returnValue = null;
        RestApplicationUtil util = new RestApplicationUtil(this._repository);
        returnValue = util.getDataLoaderRESTURI();
        return returnValue;
    }

    public URI getApplicationOpenURI() throws RemoteException, ServiceException {
        URI returnValue = null;
        String id = this.getInternalIdentity();
        RestApplicationUtil util = new RestApplicationUtil(this._repository);
        String directivePath = util.getDirectivePath(id);
        returnValue = util.getDataLoaderViewDirectiveByPathURI(directivePath);
        return returnValue;
    }
}

