/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.logging.log4j.internal.impl;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.geode.internal.logging.ManagerLogWriter;
import org.apache.geode.internal.logging.ManagerLogWriterFactory;
import org.apache.geode.internal.statistics.StatisticsConfig;
import org.apache.geode.logging.internal.LoggingSessionRegistryProvider;
import org.apache.geode.logging.internal.spi.LogConfig;
import org.apache.geode.logging.internal.spi.LogConfigListener;
import org.apache.geode.logging.internal.spi.LogConfigSupplier;
import org.apache.geode.logging.internal.spi.LogFile;
import org.apache.geode.logging.internal.spi.LogFileDetails;
import org.apache.geode.logging.internal.spi.LoggingSessionListener;
import org.apache.geode.logging.internal.spi.LoggingSessionRegistry;
import org.apache.geode.logging.internal.spi.SessionContext;
import org.apache.geode.logging.log4j.internal.impl.DebuggableAppender;
import org.apache.geode.logging.log4j.internal.impl.MemberNamePatternConverter;
import org.apache.geode.logging.log4j.internal.impl.MemberNameSupplier;
import org.apache.geode.logging.log4j.internal.impl.NullLogWriter;
import org.apache.geode.logging.log4j.internal.impl.PausableAppender;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;

@Plugin(name="GeodeLogWriter", category="Core", elementType="appender", printObject=true)
public class LogWriterAppender
extends AbstractAppender
implements PausableAppender,
DebuggableAppender,
LoggingSessionListener,
LogConfigListener {
    public static final String PLUGIN_NAME = "GeodeLogWriter";
    private static final boolean START_PAUSED_BY_DEFAULT = true;
    private static final ThreadLocal<Boolean> APPENDING = ThreadLocal.withInitial(() -> Boolean.FALSE);
    private final String eagerMemberName;
    private volatile String lazyMemberName;
    private final MemberNameSupplier memberNameSupplier;
    private final boolean appendLog;
    private final boolean security;
    private final boolean debug;
    private final List<LogEvent> events;
    private final LoggingSessionRegistry loggingSessionRegistry;
    private volatile ManagerLogWriter logWriter;
    private volatile LogConfigSupplier logConfigSupplier;
    private volatile ManagerLogWriterFactory.LogFileRolloverDetails logFileRolloverDetails;
    private volatile boolean paused;

    protected LogWriterAppender(String name, Layout<? extends Serializable> layout, Filter filter, ManagerLogWriter logWriter) {
        this(name, layout, filter, MemberNamePatternConverter.INSTANCE.getMemberNameSupplier(), null, true, false, true, false, (LoggingSessionRegistry)LoggingSessionRegistryProvider.get());
    }

    protected LogWriterAppender(String name, Layout<? extends Serializable> layout, Filter filter, MemberNameSupplier memberNameSupplier, String eagerMemberName, boolean appendLog, boolean security, boolean startPaused, boolean debug, LoggingSessionRegistry loggingSessionRegistry) {
        super(name, filter, layout, true, Property.EMPTY_ARRAY);
        this.memberNameSupplier = memberNameSupplier;
        if (eagerMemberName != null) {
            memberNameSupplier.set(eagerMemberName);
        }
        this.eagerMemberName = eagerMemberName;
        this.appendLog = appendLog;
        this.security = security;
        this.debug = debug;
        this.events = debug ? Collections.synchronizedList(new ArrayList()) : Collections.emptyList();
        this.loggingSessionRegistry = loggingSessionRegistry;
        this.paused = startPaused;
    }

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Builder)new Builder().asBuilder());
    }

    @Override
    public void append(LogEvent event) {
        if (this.isPaused()) {
            return;
        }
        this.doAppendIfNotAppending(event);
    }

    @Override
    public void start() {
        LOGGER.info("Starting {}.", (Object)this);
        LOGGER.debug("Adding {} to {}.", (Object)this, (Object)this.loggingSessionRegistry);
        this.loggingSessionRegistry.addLoggingSessionListener((LoggingSessionListener)this);
        super.start();
    }

    @Override
    public void stop() {
        LOGGER.info("Stopping {}.", (Object)this);
        super.stop();
        this.loggingSessionRegistry.removeLoggingSessionListener((LoggingSessionListener)this);
        this.stopSession();
        LOGGER.info("{} has stopped.", (Object)this);
    }

    @Override
    public void pause() {
        LOGGER.debug("Pausing {}.", (Object)this);
        this.paused = true;
    }

    @Override
    public void resume() {
        LOGGER.debug("Resuming {}.", (Object)this);
        this.paused = false;
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public void clearLogEvents() {
        this.events.clear();
    }

    @Override
    public List<LogEvent> getLogEvents() {
        return this.events;
    }

    public synchronized void createSession(SessionContext sessionContext) {
        this.logConfigSupplier = sessionContext.getLogConfigSupplier();
        LOGGER.info("Creating session in {} with {}.", (Object)this, (Object)this.logConfigSupplier);
        this.logConfigSupplier.addLogConfigListener((LogConfigListener)this);
        LogConfig logConfig = this.logConfigSupplier.getLogConfig();
        if (this.eagerMemberName == null && this.lazyMemberName == null) {
            String memberName = logConfig.getName();
            this.memberNameSupplier.set(memberName);
            this.lazyMemberName = memberName;
        }
        StatisticsConfig statisticsConfig = this.logConfigSupplier.getStatisticsConfig();
        ManagerLogWriterFactory managerLogWriterFactory = new ManagerLogWriterFactory().setSecurity(this.security).setAppendLog(this.appendLog);
        this.logWriter = managerLogWriterFactory.create(logConfig, statisticsConfig);
        if (this.logWriter == null) {
            this.logWriter = new NullLogWriter();
        }
        this.logFileRolloverDetails = managerLogWriterFactory.getLogFileRolloverDetails();
    }

    public synchronized void startSession() {
        LOGGER.info("Starting session in {}.", (Object)this);
        this.logWriter.startupComplete();
        this.resume();
        this.logRolloverDetails(this.logFileRolloverDetails);
        this.logFileRolloverDetails = null;
        this.logConfigSupplier = null;
    }

    public synchronized void stopSession() {
        LOGGER.info("Stopping session in {}.", (Object)this);
        this.logWriter.shuttingDown();
        this.pause();
        this.logWriter.closingLogFile();
    }

    public Optional<LogFile> getLogFile() {
        return Optional.of(new LogFile((LogFileDetails)this.logWriter));
    }

    public void configChanged() {
        this.logWriter.configChanged();
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode()) + ":" + this.getName() + " {eagerMemberName=" + this.eagerMemberName + ", lazyMemberName=" + this.lazyMemberName + "appendLog=" + this.appendLog + ", security=" + this.security + ", paused=" + this.paused + ", loggingSessionRegistry=" + String.valueOf(this.loggingSessionRegistry) + ", logWriter=" + String.valueOf(this.logWriter) + ", debug=" + this.debug + "}";
    }

    ManagerLogWriter getLogWriter() {
        return this.logWriter;
    }

    private void doAppendIfNotAppending(LogEvent event) {
        if (APPENDING.get().booleanValue()) {
            return;
        }
        APPENDING.set(Boolean.TRUE);
        try {
            ManagerLogWriter currentLogWriter = this.logWriter;
            if (currentLogWriter == null || currentLogWriter instanceof NullLogWriter) {
                return;
            }
            this.doAppendToLogWriter(currentLogWriter, event);
        }
        finally {
            APPENDING.set(Boolean.FALSE);
        }
    }

    private void doAppendToLogWriter(ManagerLogWriter logWriter, LogEvent event) {
        byte[] bytes = this.getLayout().toByteArray(event);
        if (bytes != null && bytes.length > 0) {
            logWriter.writeFormattedMessage(new String(bytes, Charset.defaultCharset()));
        }
        if (this.debug) {
            this.events.add(event);
        }
    }

    private void logRolloverDetails(ManagerLogWriterFactory.LogFileRolloverDetails logFileRolloverDetails) {
        if (logFileRolloverDetails.exists()) {
            if (logFileRolloverDetails.isWarning()) {
                LogManager.getLogger().warn(logFileRolloverDetails.getMessage());
            } else {
                LogManager.getLogger().info(logFileRolloverDetails.getMessage());
            }
        }
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractAppender.Builder<B>
    implements org.apache.logging.log4j.core.util.Builder<LogWriterAppender> {
        @PluginBuilderAttribute
        private String memberName;
        @PluginBuilderAttribute
        private boolean security;
        @PluginBuilderAttribute
        private boolean appendLog = true;
        @PluginBuilderAttribute
        private boolean startPaused = true;
        @PluginBuilderAttribute
        private boolean debug;

        public B withMemberName(String memberName) {
            this.memberName = memberName;
            return (B)((Builder)this.asBuilder());
        }

        public String getMemberName() {
            return this.memberName;
        }

        public B setSecurity(boolean security) {
            this.security = security;
            return (B)((Builder)this.asBuilder());
        }

        public boolean isSecurity() {
            return this.security;
        }

        public B setAppendLog(boolean shouldAppendLog) {
            this.appendLog = shouldAppendLog;
            return (B)((Builder)this.asBuilder());
        }

        public boolean isAppendLog() {
            return this.appendLog;
        }

        public B setStartPaused(boolean shouldStartPaused) {
            this.startPaused = shouldStartPaused;
            return (B)((Builder)this.asBuilder());
        }

        public boolean isStartPaused() {
            return this.debug;
        }

        public B setDebug(boolean shouldDebug) {
            this.debug = shouldDebug;
            return (B)((Builder)this.asBuilder());
        }

        public boolean isDebug() {
            return this.debug;
        }

        @Override
        public LogWriterAppender build() {
            Layout<Serializable> layout = this.getOrCreateLayout();
            return new LogWriterAppender(this.getName(), layout, this.getFilter(), MemberNamePatternConverter.INSTANCE.getMemberNameSupplier(), this.memberName, this.appendLog, this.security, this.startPaused, this.debug, (LoggingSessionRegistry)LoggingSessionRegistryProvider.get());
        }
    }
}

