/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.service.standard;

import com.sas.dpro.common.ContainerContext;
import com.sas.dpro.common.FileList;
import com.sas.dpro.common.FileListImpl;
import com.sas.dpro.common.Mapper;
import com.sas.dpro.common.MapperUtil;
import com.sas.dpro.common.ServiceFailedException;
import com.sas.dpro.service.AbstractInternalService;
import com.sas.dpro.service.ServiceResults;
import com.sas.dpro.service.ServiceResultsImpl;
import com.sas.dpro.service.standard.Copy;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class Zip
extends AbstractInternalService {
    public static final String SERVICE_NAME = "Zip";
    public static final String PARAM_APPEND = "append";
    public static final String PARAM_DESTFILE = "destFile";
    public static final String PARAM_DIR = "dir";
    public static final String PARAM_DIRS = "_dirs";
    public static final String PARAM_DIRS_DIR_IN_ENTRIES = "_dirsDirInEntries";
    public static final String PARAM_DIRS_PREFIXES = "_dirsPrefixes";
    public static final String PARAM_FILE_LIST_REF = "fileListRef";
    public static final String PARAM_FILE_LISTS = "_fileLists";
    public static final String PARAM_FILE_LISTS_PREFIXES = "_fileListPrefixes";
    public static final String PARAM_FILE_SET_REF = "fileSetRef";
    public static final String PARAM_FILES_ONLY = "filesOnly";
    public static final String PARAM_MAPPERS = "mappers";
    public static final String PARAM_PREFIX = "prefix";
    private static final int DEFAULT_BUF_SIZE = 8192;
    private static final boolean DEFAULT_DIRS_DIR_IN_ENTRIES = true;
    private static final String MSG = "com.sas.dpro.service.standard.Zip";
    private static final ResourceBundle msg = ResourceBundle.getBundle("com.sas.dpro.service.standard.Zip");

    public Zip() {
        super(SERVICE_NAME);
    }

    protected void addDir(ContainerContext container, ZipOutputStream out, String dir, boolean dirInEntry, boolean filesOnly, String prefix, Mapper[] mappers, byte[] buf, List entryList) throws IOException, ServiceFailedException {
        File temp = Zip.getAbsoluteFile(container, dir);
        String root = temp.getAbsolutePath();
        if (dirInEntry) {
            prefix = prefix == null ? Zip.ensureEndsWithSlash(dir) : prefix + Zip.ensureEndsWithSlash(dir);
        }
        root = Zip.ensureEndsWithSlash(root);
        if (!temp.isDirectory()) {
            String desc = msg.getString("Error.InvalidDirectory.fmt.txt");
            desc = MessageFormat.format(desc, this.getName(), root);
            throw new IOException(desc);
        }
        this.handleAddDir(out, temp, root, filesOnly, prefix, mappers, buf, entryList);
    }

    protected void addFileList(ContainerContext container, ZipOutputStream out, FileList fileList, boolean filesOnly, String prefix, Mapper[] mappers, byte[] buf, List entryList) throws IOException, ServiceFailedException {
        int count = fileList.getSize();
        for (int i = 0; i < count; ++i) {
            File file;
            String name = fileList.get(i);
            if (prefix != null) {
                name = prefix + name;
            }
            String parentDir = name.substring(0, name.length() - fileList.getName(i).length());
            if (!filesOnly) {
                this.ensureDirZipEntriesExist(parentDir, out, entryList);
            }
            if (!(file = new File(fileList.getAbsolute(i))).isFile()) {
                String desc = msg.getString("Error.InvalidFile.fmt.txt");
                desc = MessageFormat.format(desc, this.getName(), file.getAbsolutePath());
                throw new IOException(desc);
            }
            this.handleAddFile(out, file, name, filesOnly, mappers, buf, entryList);
        }
    }

    protected String applyMappers(String fileName, Mapper[] mappers) throws ServiceFailedException {
        try {
            return MapperUtil.applyMappers(fileName, mappers);
        }
        catch (Exception e) {
            String desc = msg.getString("Error.ErrorApplyingMappers.fmt.txt");
            String text = e.getMessage();
            if (text == null) {
                text = e.toString();
            }
            desc = MessageFormat.format(desc, this.getName(), fileName, text);
            throw new ServiceFailedException(desc, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyInto(ZipFile zipFile, ZipOutputStream out, byte[] buf, List entryList) throws IOException {
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            out.putNextEntry(entry);
            try {
                InputStream in = zipFile.getInputStream(entry);
                int count = 0;
                while ((count = in.read(buf)) != -1) {
                    out.write(buf, 0, count);
                }
                entryList.add(entry.getName());
            }
            finally {
                out.closeEntry();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createZip(File zipFile, File rootDir, List toAdd) throws IOException {
        block11: {
            try (ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile)));){
                int count;
                int n = count = toAdd == null ? 0 : toAdd.size();
                if (count <= 0) break block11;
                byte[] buf = new byte[8192];
                for (int i = 0; i < count; ++i) {
                    String name = (String)toAdd.get(i);
                    File file = new File(rootDir, name);
                    try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
                        name = Zip.fixSlashes(name);
                        ZipEntry entry = new ZipEntry(name);
                        out.putNextEntry(entry);
                        try {
                            int count2 = 0;
                            while ((count2 = in.read(buf)) > -1) {
                                out.write(buf, 0, count2);
                            }
                            continue;
                        }
                        finally {
                            out.closeEntry();
                        }
                    }
                }
            }
        }
    }

    private static String ensureEndsWithSlash(String str) {
        if (str.endsWith("\\")) {
            str = str.substring(0, str.length() - 1) + '/';
        } else if (!str.endsWith("/")) {
            str = str + '/';
        }
        return str;
    }

    private void ensureDirZipEntriesExist(String dirStr, ZipOutputStream out, List entryList) throws IOException {
        if (dirStr != null) {
            dirStr = Zip.fixSlashes(dirStr);
            String[] pieces = dirStr.split("/");
            int pieceCount = pieces.length;
            String entry = "";
            for (int i = 0; i < pieceCount; ++i) {
                if (pieces[i].length() <= 0) continue;
                entry = entry + pieces[i];
                if (entryList.contains(entry = entry + '/')) continue;
                ZipEntry zipEntry = new ZipEntry(entry);
                out.putNextEntry(zipEntry);
                out.closeEntry();
                entryList.add(entry);
            }
        }
    }

    private static final String fixSlashes(String str) {
        if (str == null || str.indexOf(92) == -1) {
            return str;
        }
        char[] chars = str.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != '\\') continue;
            chars[i] = 47;
        }
        return new String(chars);
    }

    private void handleAddDir(ZipOutputStream out, File dir, String root, boolean filesOnly, String prefix, Mapper[] mappers, byte[] buf, List entryList) throws IOException, ServiceFailedException {
        File[] children;
        int start = root.length();
        String entry = dir.getAbsolutePath();
        if (!filesOnly && entry.length() > start) {
            entry = entry.substring(start);
            if (prefix != null) {
                entry = prefix + entry;
            }
            if (!entry.endsWith("/")) {
                entry = entry + '/';
            }
            entry = Zip.fixSlashes(entry);
            entry = this.applyMappers(entry, mappers);
            this.ensureDirZipEntriesExist(entry, out, entryList);
        }
        int count = (children = dir.listFiles()) == null ? 0 : children.length;
        for (int i = 0; i < count; ++i) {
            if (children[i].isFile()) {
                entry = children[i].getAbsolutePath();
                entry = entry.substring(start);
                if (prefix != null) {
                    entry = prefix + entry;
                }
                this.handleAddFile(out, children[i], entry, filesOnly, mappers, buf, entryList);
                continue;
            }
            this.handleAddDir(out, children[i], root, filesOnly, prefix, mappers, buf, entryList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAddFile(ZipOutputStream out, File file, String name, boolean filesOnly, Mapper[] mappers, byte[] buf, List entryList) throws IOException, ServiceFailedException {
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
            int lastSlash;
            name = Zip.fixSlashes(name);
            name = this.applyMappers(name, mappers);
            if (!filesOnly && (lastSlash = name.lastIndexOf(47)) > -1) {
                String dir = name.substring(0, lastSlash + 1);
                this.ensureDirZipEntriesExist(dir, out, entryList);
            }
            ZipEntry entry = new ZipEntry(name);
            out.putNextEntry(entry);
            try {
                int count = 0;
                while ((count = in.read(buf)) != -1) {
                    out.write(buf, 0, count);
                }
                entryList.add(name);
            }
            finally {
                out.closeEntry();
            }
        }
    }

    @Override
    protected ServiceResults runServiceImpl(ContainerContext container, Logger logger) throws ServiceFailedException {
        String zipName = (String)this.getParameter(PARAM_DESTFILE);
        boolean append = this.getBooleanParameter(PARAM_APPEND, false);
        boolean filesOnly = this.getBooleanParameter(PARAM_FILES_ONLY, false);
        String mainPrefix = (String)this.getParameter(PARAM_PREFIX);
        String[] dirs = (String[])this.getParameter(PARAM_DIRS);
        String[] dirsInEntry = (String[])this.getParameter(PARAM_DIRS_DIR_IN_ENTRIES);
        String[] dirsPrefixes = (String[])this.getParameter(PARAM_DIRS_PREFIXES);
        FileList[] fileLists = (FileList[])this.getParameter(PARAM_FILE_LISTS);
        String[] flPrefixes = (String[])this.getParameter(PARAM_FILE_LISTS_PREFIXES);
        Mapper[] mappers = (Mapper[])this.getParameter(PARAM_MAPPERS);
        ArrayList entries = new ArrayList();
        int bufSize = this.getFileIOBufferSize();
        if (bufSize == -1) {
            bufSize = 8192;
        }
        byte[] buf = new byte[bufSize];
        File zipFile = Zip.getAbsoluteFile(container, zipName);
        if (append && !zipFile.exists()) {
            append = false;
        }
        ZipOutputStream zos = null;
        File tempZipFile = null;
        try {
            tempZipFile = null;
            if (append) {
                File tempDir = new File(container.getDirectory());
                tempZipFile = File.createTempFile(zipFile.getName(), null, tempDir);
                zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(tempZipFile)));
                ZipFile zf = new ZipFile(zipFile);
                this.copyInto(zf, zos, buf, entries);
                zf.close();
            } else {
                zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile)));
            }
            if (dirs != null) {
                for (int i = 0; i < dirs.length; ++i) {
                    boolean dirInEntry = true;
                    if (dirsInEntry != null && dirsInEntry.length > i) {
                        dirInEntry = Boolean.parseBoolean(dirsInEntry[i]);
                    }
                    String prefix = mainPrefix;
                    if (dirsPrefixes != null && dirsPrefixes.length > i) {
                        if (prefix == null) {
                            prefix = dirsPrefixes[i];
                        } else if (dirsPrefixes[i] != null) {
                            prefix = prefix + dirsPrefixes[i];
                        }
                    }
                    this.addDir(container, zos, dirs[i], dirInEntry, filesOnly, prefix, mappers, buf, entries);
                }
            }
            if (fileLists != null) {
                for (int i = 0; i < fileLists.length; ++i) {
                    String prefix = mainPrefix;
                    if (flPrefixes != null && flPrefixes.length > i) {
                        if (prefix == null) {
                            prefix = flPrefixes[i];
                        } else if (flPrefixes[i] != null) {
                            prefix = prefix + flPrefixes[i];
                        }
                    }
                    this.addFileList(container, zos, fileLists[i], filesOnly, prefix, mappers, buf, entries);
                }
            }
        }
        catch (IOException ioe) {
            String text = ioe.getMessage();
            if (text == null) {
                text = ioe.toString();
            }
            throw new ServiceFailedException(text, ioe);
        }
        finally {
            if (zos != null) {
                try {
                    zos.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
        if (append) {
            try {
                Copy.copyLocal(zipFile, tempZipFile, true);
            }
            catch (IOException ioe) {
                throw new ServiceFailedException(ioe);
            }
        }
        String parentDir = zipFile.getParentFile().getAbsolutePath();
        FileListImpl outputFiles = new FileListImpl(parentDir, this.getHost(), null);
        outputFiles.add(zipFile.getName());
        ServiceResultsImpl results = new ServiceResultsImpl(this.createServiceInfo(), container, 0);
        results.setOutputFiles(outputFiles);
        return results;
    }
}

