/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.service.standard;

import com.sas.dpro.common.ContainerContext;
import com.sas.dpro.common.DProUtil;
import com.sas.dpro.common.FileList;
import com.sas.dpro.common.FileListImpl;
import com.sas.dpro.common.FileSet;
import com.sas.dpro.common.SerializableHashMap;
import com.sas.dpro.common.SerializableMap;
import com.sas.dpro.common.ServiceFailedException;
import com.sas.dpro.provider.Provider;
import com.sas.dpro.provider.ProviderFactory;
import com.sas.dpro.provider.ServiceRequestParmsImpl;
import com.sas.dpro.service.AbstractInternalService;
import com.sas.dpro.service.ServiceParmsImpl;
import com.sas.dpro.service.ServiceResults;
import com.sas.dpro.service.ServiceResultsImpl;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class Xslt
extends AbstractInternalService {
    public static final String SERVICE_NAME = "Xslt";
    public static final String PARAM_EXTENSION = "extension";
    public static final String PARAM_INPUT_FROM_DIRS = "_inputFromDirs";
    public static final String PARAM_INPUT_FROM_FILES = "_inputFromFiles";
    public static final String PARAM_INPUT_FROM_FILE_LISTS = "_inputFromFileLists";
    public static final String PARAM_INPUT_FROM_FILE_SETS = "_inputFromFileSets";
    public static final String PARAM_INPUT_ORDER_ARRAY = "_inputOrderArray";
    public static final String PARAM_OUTPUT_ENCODING = "outputEncoding";
    public static final String PARAM_PARAM = "param";
    public static final String PARAM_PARAM_LIST = "paramList";
    public static final String PARAM_TO_DIR = "toDir";
    public static final String PARAM_TO_FILE = "toFile";
    public static final String PARAM_XSLT = "xslt";
    public static final int ORDER_FROM_DIR = 0;
    public static final int ORDER_FROM_FILE = 1;
    public static final int ORDER_FROM_FILE_LIST = 2;
    public static final int ORDER_FROM_FILE_SET = 3;
    private static final String DEFAULT_EXTENSION = ".html";
    private static final String PROPERTY_DEBUG = "com.sas.dpro.service.standard.Xslt.debug";
    private static final String BUNDLE = "com.sas.dpro.service.standard.Xslt";
    private static final ResourceBundle msg = ResourceBundle.getBundle("com.sas.dpro.service.standard.Xslt");

    public Xslt() {
        super(SERVICE_NAME);
    }

    private DocumentBuilder createDocumentBuilder() throws ServiceFailedException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            String key = "Error.CreatingDocBuilder.fmt.txt";
            String desc = DProUtil.formatString(msg, key, this.getName(), pce.toString());
            throw new ServiceFailedException(desc, pce);
        }
        return builder;
    }

    private static final FileFilter createFileFilter() {
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getName().toLowerCase().endsWith(".xml");
            }
        };
    }

    private final String createToFileName(String fromFile, String extension) {
        int dot;
        if (extension == null) {
            extension = DEFAULT_EXTENSION;
        }
        if ((dot = fromFile.lastIndexOf(46)) != -1) {
            fromFile = fromFile.substring(0, dot);
        }
        fromFile = fromFile + extension;
        return fromFile;
    }

    private void debugMsg(String msg) {
        if (Boolean.getBoolean(PROPERTY_DEBUG)) {
            System.err.println("[Xslt DEBUG]: " + msg);
        }
    }

    private String[] getAllDirContents(ContainerContext cc, String[] dirs) throws ServiceFailedException {
        if (dirs == null || dirs.length == 0) {
            return null;
        }
        FileFilter filter = Xslt.createFileFilter();
        ArrayList fileList = new ArrayList();
        for (int i = 0; i < dirs.length; ++i) {
            String dir = dirs[i];
            this.getDirContentsImpl(cc, dir, filter, fileList);
        }
        String[] files = null;
        if (!fileList.isEmpty()) {
            files = new String[fileList.size()];
            files = fileList.toArray(files);
        }
        return files;
    }

    private String[] getDirContents(ContainerContext cc, String dir) throws ServiceFailedException {
        return dir == null ? null : this.getAllDirContents(cc, new String[]{dir});
    }

    private int getDirContentsImpl(ContainerContext cc, String dir, FileFilter filter, List fileList) throws ServiceFailedException {
        File dirFile;
        if (dir == null) {
            return 0;
        }
        int addedCount = 0;
        if (dir.endsWith("/") || dir.endsWith("\\")) {
            dir = dir.substring(0, dir.length() - 1);
        }
        if (!(dirFile = Xslt.getAbsoluteFile(cc, dir)).exists()) {
            String key = "Error.DirDoesNotExist.fmt.txt";
            String desc = DProUtil.formatString(msg, key, this.getName(), dirFile.getAbsolutePath());
            throw new ServiceFailedException(desc);
        }
        if (!dirFile.isDirectory()) {
            String key = "Error.NotADirectory.fmt.txt";
            String desc = DProUtil.formatString(msg, key, this.getName(), dirFile.getAbsolutePath());
            throw new ServiceFailedException(desc);
        }
        File[] children = dirFile.listFiles(filter);
        int count = children == null ? 0 : children.length;
        for (int j = 0; j < count; ++j) {
            String name = dir + '/' + children[j].getName();
            if (children[j].isFile()) {
                fileList.add(name);
                ++addedCount;
                continue;
            }
            if (!children[j].isDirectory()) continue;
            addedCount += this.getDirContentsImpl(cc, name, filter, fileList);
        }
        return addedCount;
    }

    private int getFileCount(FileList[] fileLists) {
        int count = 0;
        if (fileLists != null) {
            for (int i = 0; i < fileLists.length; ++i) {
                count += fileLists[i].getSize();
            }
        }
        return count;
    }

    private FileList[] getFileLists(FileSet[] fileSets) throws Exception {
        if (fileSets == null || fileSets.length == 0) {
            return null;
        }
        int count = fileSets.length;
        FileList[] fileLists = new FileList[count];
        for (int i = 0; i < count; ++i) {
            FileList temp;
            fileLists[i] = temp = fileSets[i].getMatchingFiles();
        }
        return fileLists;
    }

    private String getFirstFile(FileList[] fileLists) {
        String file = null;
        if (fileLists != null) {
            for (int i = 0; i < fileLists.length && (file = fileLists[i].get(0)) == null; ++i) {
            }
        }
        return file;
    }

    @Override
    protected ServiceResults runServiceImpl(ContainerContext container, Logger logger) throws ServiceFailedException {
        String key;
        this.debugMsg("Xslt.runServiceImpl: Starting");
        FileListImpl outputFiles = null;
        SerializableMap params = this.getParameters();
        String toDir = (String)params.get(PARAM_TO_DIR);
        String toFile = (String)params.get(PARAM_TO_FILE);
        String[] fromDirs = (String[])params.get(PARAM_INPUT_FROM_DIRS);
        String[] fromFiles = (String[])params.get(PARAM_INPUT_FROM_FILES);
        FileList[] fromFileLists = (FileList[])params.get(PARAM_INPUT_FROM_FILE_LISTS);
        FileSet[] fromFileSets = (FileSet[])params.get(PARAM_INPUT_FROM_FILE_SETS);
        int[] orderArray = (int[])params.get(PARAM_INPUT_ORDER_ARRAY);
        String xslt = (String)params.get(PARAM_XSLT);
        String[] paramMap = (String[])params.get(PARAM_PARAM_LIST);
        String extension = (String)params.get(PARAM_EXTENSION);
        String outputEncoding = (String)params.get(PARAM_OUTPUT_ENCODING);
        if (toDir != null && toFile != null) {
            String key2 = "Error.CannotSpecifyBoth.fmt.txt";
            String desc = DProUtil.formatString(msg, key2, this.getName(), PARAM_TO_FILE, PARAM_TO_DIR);
            this.debugMsg("Xslt.runServiceImpl: " + desc);
            throw new ServiceFailedException(desc);
        }
        if (xslt == null) {
            String key3 = "Error.ParamNotSpecified.fmt.txt";
            String desc = DProUtil.formatString(msg, key3, this.getName(), PARAM_XSLT);
            this.debugMsg("Xslt.runServiceImpl: " + desc);
            throw new ServiceFailedException(desc);
        }
        File xsltFile = Xslt.getAbsoluteFile(container, xslt);
        if (!xsltFile.isFile()) {
            String key4 = "Error.XSLTNotFound.fmt.txt";
            String desc = DProUtil.formatString(msg, key4, this.getName(), xsltFile.getAbsolutePath());
            this.debugMsg("Xslt.runServiceImpl: " + desc);
            throw new ServiceFailedException(desc);
        }
        if (fromDirs != null) {
            Xslt.removeTrailingSlashes(fromDirs);
        }
        DocumentBuilder builder = this.createDocumentBuilder();
        TransformerFactory tFactory = TransformerFactory.newInstance();
        StreamSource styleSource = new StreamSource(xsltFile);
        Transformer transformer = null;
        try {
            transformer = tFactory.newTransformer(styleSource);
            transformer.setOutputProperty("indent", "yes");
            if (outputEncoding != null) {
                transformer.setOutputProperty("encoding", outputEncoding);
            }
        }
        catch (TransformerConfigurationException tce) {
            String key5 = "Error.CreatingTransformer.fmt.txt";
            Throwable t = tce;
            if (tce.getException() != null) {
                t = tce.getException();
            }
            String desc = DProUtil.formatString(msg, key5, this.getName(), t.toString());
            throw new ServiceFailedException(desc, t);
        }
        if (paramMap != null && paramMap.length > 0) {
            if ((paramMap.length & 1) == 1) {
                String key6 = "Error.Internal.InvalidParamMap.fmt.txt";
                String desc = DProUtil.formatString(msg, key6, this.getName(), "" + paramMap.length);
                throw new ServiceFailedException(desc);
            }
            int i = 0;
            while (i < paramMap.length) {
                key = paramMap[i++];
                String value = paramMap[i++];
                transformer.setParameter(key, value);
            }
        }
        if (toFile != null) {
            this.debugMsg("Xslt.runServiceImpl: Destination is single file.");
            String toRoot = Xslt.getAbsoluteFile(container, toFile).getParentFile().getAbsolutePath();
            outputFiles = new FileListImpl(toRoot, this.getHost(), null);
            int fileCount = fromFiles != null ? fromFiles.length : 0;
            String[] dirContents = this.getAllDirContents(container, fromDirs);
            fileCount += dirContents == null ? 0 : dirContents.length;
            fileCount += this.getFileCount(fromFileLists);
            FileList[] fromFileLists2 = null;
            try {
                fromFileLists2 = this.getFileLists(fromFileSets);
            }
            catch (Exception e) {
                String text = e.getMessage();
                if (text == null) {
                    text = e.toString();
                }
                String key7 = "Error.EvaluatingFileSets.fmt.txt";
                String desc = DProUtil.formatString(msg, key7, this.getName(), text);
                throw new ServiceFailedException(desc);
            }
            this.debugMsg("Xslt.runServiceImpl: File count: " + (fileCount += this.getFileCount(fromFileLists2)));
            String fromFile = null;
            switch (fileCount) {
                case 0: {
                    String key8 = "Error.NoFromFileSpecified.fmt.txt";
                    String desc = DProUtil.formatString(msg, key8, this.getName());
                    this.debugMsg("Xslt.runServiceImpl: " + desc);
                    throw new ServiceFailedException(desc);
                }
                case 1: {
                    if (fromFiles != null) {
                        fromFile = fromFiles[0];
                        break;
                    }
                    if (fromDirs != null) {
                        fromFile = dirContents[0];
                        break;
                    }
                    if (fromFileLists != null) {
                        fromFile = this.getFirstFile(fromFileLists);
                        break;
                    }
                    if (fromFileLists2 == null) break;
                    fromFile = this.getFirstFile(fromFileLists2);
                    break;
                }
                default: {
                    String key9 = "Error.TooManyFromFiles.fmt.txt";
                    String desc = DProUtil.formatString(msg, key9, this.getName(), "" + fileCount);
                    this.debugMsg("Xslt.runServiceImpl: " + desc);
                    throw new ServiceFailedException(desc);
                }
            }
            if (fromFile == null) {
                String key10 = "Error.Internal.NoFromFile.fmt.txt";
                String desc = DProUtil.formatString(msg, key10, this.getName());
                this.debugMsg("Xslt.runServiceImpl: " + desc);
                throw new ServiceFailedException(desc);
            }
            this.debugMsg("Xslt.runServiceImpl: Transforming " + fromFile + " to " + toFile);
            this.transformFile(container, fromFile, transformer, null, toFile, outputFiles, builder, outputEncoding);
        } else if (toDir != null) {
            int fromFileListCount2;
            this.debugMsg("Xslt.runServiceImpl: Destination is a directory");
            File toDirDir = Xslt.getAbsoluteFile(container, toDir);
            if (!toDirDir.isDirectory() && !toDirDir.mkdirs()) {
                key = "Error.ToDirNotDirectory.fmt.txt";
                String desc = DProUtil.formatString(msg, key, this.getName(), toDirDir.getAbsolutePath());
                this.debugMsg("Xslt.runServiceImpl: " + desc);
                throw new ServiceFailedException(desc);
            }
            outputFiles = new FileListImpl(toDirDir.getAbsolutePath(), this.getHost(), null);
            int fromDirCount = fromDirs == null ? 0 : fromDirs.length;
            int fromFileCount = fromFiles == null ? 0 : fromFiles.length;
            int fromFileListCount = fromFileLists == null ? 0 : fromFileLists.length;
            FileList[] fromFileLists2 = null;
            try {
                fromFileLists2 = this.getFileLists(fromFileSets);
            }
            catch (Exception e) {
                String text = e.getMessage();
                if (text == null) {
                    text = e.toString();
                }
                String key11 = "Error.EvaluatingFileSets.fmt.txt";
                String desc = DProUtil.formatString(msg, key11, this.getName(), text);
                throw new ServiceFailedException(desc);
            }
            int n = fromFileListCount2 = fromFileLists2 == null ? 0 : fromFileLists2.length;
            if (orderArray == null) {
                orderArray = new int[fromFileCount];
                for (int i = 0; i < fromFileCount; ++i) {
                    orderArray[i] = 1;
                }
                this.debugMsg("Xslt.runServiceImpl: null orderArray (client bug?); just transforming 'fromFile' params");
            } else {
                int totalCount = fromDirCount + fromFileCount + fromFileListCount + fromFileListCount2;
                this.debugMsg("Xslt.runServiceImpl: from*Count=" + totalCount + ", orderArray length=" + orderArray.length);
                if (orderArray.length != totalCount) {
                    String key12 = "Error.Internal.OrderArraySizeWrong.fmt.txt";
                    String desc = DProUtil.formatString(msg, key12, this.getName(), "" + orderArray.length, "" + totalCount);
                    this.debugMsg("Xslt.runServiceImpl: " + desc);
                    throw new ServiceFailedException(desc);
                }
            }
            int dirPos = 0;
            int filePos = 0;
            int fileListPos = 0;
            int fileSetPos = 0;
            block18: for (int i = 0; i < orderArray.length; ++i) {
                int source = orderArray[i];
                switch (source) {
                    case 0: {
                        if (dirPos == fromDirCount) {
                            String key13 = "Error.Internal.InvalidOrderArrayElem2.fmt.txt";
                            String desc = DProUtil.formatString(msg, key13, this.getName(), "" + source, "" + dirPos);
                            this.debugMsg("Xslt.runServiceImpl: " + desc);
                            throw new ServiceFailedException(desc);
                        }
                        String dir = fromDirs[dirPos++];
                        boolean prependDirName = false;
                        this.transformFilesInDir(container, dir, transformer, toDir, extension, outputFiles, builder, prependDirName, outputEncoding);
                        continue block18;
                    }
                    case 1: {
                        if (filePos == fromFileCount) {
                            String key14 = "Error.Internal.InvalidOrderArrayElem2.fmt.txt";
                            String desc = DProUtil.formatString(msg, key14, this.getName(), "" + source, "" + filePos);
                            this.debugMsg("Xslt.runServiceImpl: " + desc);
                            throw new ServiceFailedException(desc);
                        }
                        String file = fromFiles[filePos++];
                        toFile = this.createToFileName(file, extension);
                        this.transformFile(container, file, transformer, toDir, toFile, outputFiles, builder, outputEncoding);
                        continue block18;
                    }
                    case 2: {
                        if (fileListPos == fromFileListCount) {
                            String key15 = "Error.Internal.InvalidOrderArrayElem2.fmt.txt";
                            String desc = DProUtil.formatString(msg, key15, this.getName(), "" + source, "" + fileListPos);
                            this.debugMsg("Xslt.runServiceImpl: " + desc);
                            throw new ServiceFailedException(desc);
                        }
                        FileList fl = fromFileLists[fileListPos++];
                        this.transformFileList(container, fl, transformer, toDir, extension, outputFiles, builder, outputEncoding);
                        continue block18;
                    }
                    case 3: {
                        if (fileSetPos == fromFileListCount2) {
                            String key16 = "Error.Internal.InvalidOrderArrayElem2.fmt.txt";
                            String desc = DProUtil.formatString(msg, key16, this.getName(), "" + source, "" + fileSetPos);
                            this.debugMsg("Xslt.runServiceImpl: " + desc);
                            throw new ServiceFailedException(desc);
                        }
                        FileList fl = fromFileLists2[fileSetPos++];
                        this.transformFileList(container, fl, transformer, toDir, extension, outputFiles, builder, outputEncoding);
                        continue block18;
                    }
                    default: {
                        String key17 = "Error.Internal.InvalidOrderArrayElem.fmt.txt";
                        String desc = DProUtil.formatString(msg, key17, this.getName(), "" + source);
                        this.debugMsg("Xslt.runServiceImpl: " + desc);
                        throw new ServiceFailedException(desc);
                    }
                }
            }
        } else {
            String key18 = "Error.ParamNotSpecified.fmt.txt";
            String desc = DProUtil.formatString(msg, key18, this.getName(), PARAM_TO_FILE);
            this.debugMsg("Xslt.runServiceImpl: " + desc);
            throw new ServiceFailedException(desc);
        }
        this.debugMsg("Xslt.runServiceImpl: Done! Output files: " + outputFiles);
        ServiceResultsImpl results = new ServiceResultsImpl(this.createServiceInfo(), container, 0);
        results.setOutputFiles(outputFiles);
        return results;
    }

    private void handleXSLTransform(Transformer transformer, File oldFile, OutputStream out, DocumentBuilder builder) throws ServiceFailedException {
        try {
            File datafile = oldFile;
            Document document = builder.parse(datafile);
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(out);
            transformer.transform(source, result);
        }
        catch (TransformerException te) {
            String temp;
            Throwable t = te;
            if (te.getException() != null) {
                t = te.getException();
            }
            if ((temp = t.getMessage()) == null) {
                temp = t.toString();
            }
            String key = "Error.ApplyingTransform.fmt.txt";
            String desc = DProUtil.formatString(msg, key, this.getName(), oldFile.getPath(), temp);
            throw new ServiceFailedException(desc, t);
        }
        catch (SAXException sxe) {
            String temp;
            Exception e = sxe;
            if (sxe.getException() != null) {
                e = sxe.getException();
            }
            if ((temp = e.getMessage()) == null) {
                temp = e.toString();
            }
            String key = "Error.ApplyingTransform.fmt.txt";
            String desc = DProUtil.formatString(msg, key, this.getName(), oldFile.getPath(), temp);
            throw new ServiceFailedException(desc, e);
        }
        catch (Exception e) {
            String temp = e.getMessage();
            if (temp == null) {
                temp = e.toString();
            }
            String key = "Error.ApplyingTransform.fmt.txt";
            String desc = DProUtil.formatString(msg, key, this.getName(), oldFile.getPath(), temp);
            throw new ServiceFailedException(desc, e);
        }
    }

    private static final void removeTrailingSlashes(String[] dirs) {
        if (dirs != null) {
            for (int i = 0; i < dirs.length; ++i) {
                char ch;
                int len = dirs[i].length();
                if (len <= 0 || (ch = dirs[i].charAt(len - 1)) != '/' && ch != '\\') continue;
                dirs[i] = dirs[i].substring(0, len - 1);
            }
        }
    }

    private DocumentBuilder resetBuilder(DocumentBuilder builder) {
        return builder;
    }

    public static String transform(ContainerContext container, String inputFile, String xslt, String outputFile, String[] params) throws ServiceFailedException {
        return Xslt.transform(container, inputFile, xslt, outputFile, null, params);
    }

    public static String transform(ContainerContext container, String inputFile, String xslt, String outputFile, String outputEncoding, String[] params) throws ServiceFailedException {
        try {
            Provider provider = ProviderFactory.getProvider(container.getProviderName());
            SerializableHashMap params2 = new SerializableHashMap();
            params2.put(PARAM_INPUT_FROM_FILES, new String[]{inputFile});
            params2.put(PARAM_XSLT, xslt);
            params2.put(PARAM_TO_FILE, outputFile);
            params2.put(PARAM_OUTPUT_ENCODING, outputEncoding);
            params2.put(PARAM_PARAM_LIST, params);
            ServiceRequestParmsImpl srp = new ServiceRequestParmsImpl();
            srp.setClientDPROVersion(DProUtil.getLocalDPROVersion());
            srp.setContainerContext(container);
            srp.setFailIfFailure(true);
            srp.setFailIfTimeout(true);
            srp.setReturnServiceResults(true);
            srp.setServiceName(SERVICE_NAME);
            ServiceParmsImpl sp = new ServiceParmsImpl();
            sp.params = params2;
            srp.setServiceParameters(sp);
            srp.setTimeout(-1L);
            ServiceResults results = provider.serviceRequest(srp);
            FileList transformedFiles = results.getOutputFiles();
            return transformedFiles.getAbsolute(0);
        }
        catch (ServiceFailedException sfe) {
            throw sfe;
        }
        catch (Exception e) {
            String text = e.getMessage();
            if (text == null) {
                text = e.toString();
            }
            String key = "Error.Transforming.fmt.txt";
            String desc = DProUtil.formatString(msg, key, SERVICE_NAME, inputFile, text);
            throw new ServiceFailedException(desc, e);
        }
    }

    private void transformFile(ContainerContext cc, String file, Transformer transformer, String toDir, String toFile, FileListImpl outputFiles, DocumentBuilder builder, String outputEncoding) throws ServiceFailedException {
        this.debugMsg("Xslt.transformFile: Started");
        this.debugMsg("Xslt.transformFile: ... cc dir=" + cc.getDirectory());
        this.debugMsg("Xslt.transformFile: ... fromFile=" + file);
        this.debugMsg("Xslt.transformFile: ... toDir=" + toDir);
        this.debugMsg("Xslt.transformFile: ... toFile=" + toFile);
        this.debugMsg("Xslt.transformFile: ... outputEncoding=" + outputEncoding);
        File fromFileFile = new File(file);
        if (!fromFileFile.isAbsolute()) {
            fromFileFile = Xslt.getAbsoluteFile(cc, file);
        }
        File toFileFile = null;
        if (toDir != null) {
            File temp = new File(toDir, toFile);
            toFileFile = Xslt.getAbsoluteFile(cc, temp.getPath());
        } else {
            toFileFile = Xslt.getAbsoluteFile(cc, toFile);
        }
        this.debugMsg("Xslt.transformFile: ... ... toFile absolute=" + toFileFile.getAbsolutePath());
        this.debugMsg("Xslt.transformFile: ... ... toFile exists=" + toFileFile.exists());
        File toFileParentDir = toFileFile.getParentFile();
        this.debugMsg("Xslt.transformFille: toFile parent dir exists=" + toFileParentDir.exists());
        if (!toFileParentDir.exists() && !toFileParentDir.mkdirs()) {
            String key = "Error.CreatingDirectory.fmt.txt";
            String desc = DProUtil.formatString(msg, key, this.getName(), toFileParentDir.getAbsolutePath());
            this.debugMsg("Xslt.transformFile: " + desc);
            throw new ServiceFailedException(desc);
        }
        try {
            BufferedOutputStream w = new BufferedOutputStream(new FileOutputStream(toFileFile));
            this.handleXSLTransform(transformer, fromFileFile, w, builder);
            w.close();
            outputFiles.add(toFile);
        }
        catch (IOException ioe) {
            String text = ioe.getMessage();
            if (text == null) {
                text = ioe.toString();
            }
            String key = "Error.Transforming.fmt.txt";
            String desc = DProUtil.formatString(msg, key, this.getName(), fromFileFile.getAbsolutePath(), text);
            this.debugMsg("Xslt.transformFile: " + desc);
            throw new ServiceFailedException(desc, ioe);
        }
        this.debugMsg("Xslt.transformFile: Success");
    }

    private void transformFileList(ContainerContext cc, FileList fl, Transformer transformer, String toDir, String extension, FileListImpl outputFiles, DocumentBuilder builder, String outputEncoding) throws ServiceFailedException {
        this.debugMsg("Xslt.transformFileList: Started");
        this.debugMsg("Xslt.transformFileList: fromFileList=" + fl);
        this.debugMsg("Xslt.transformFileList: toDir=" + toDir);
        this.debugMsg("Xslt.transformFileList: extension=" + extension);
        if (fl == null) {
            this.debugMsg("Xslt.transformFileList: Success (null fileList)");
            return;
        }
        int count = fl.getSize();
        for (int i = 0; i < count; ++i) {
            String fromFile = fl.getAbsolute(i);
            String toFile = this.createToFileName(fl.get(i), extension);
            this.transformFile(cc, fromFile, transformer, toDir, toFile, outputFiles, builder, outputEncoding);
        }
        this.debugMsg("Xslt.transformFileList: Success");
    }

    private void transformFilesInDir(ContainerContext cc, String dir, Transformer transformer, String toDir, String extension, FileListImpl outputFiles, DocumentBuilder builder, boolean prependDirName, String outputEncoding) throws ServiceFailedException {
        this.debugMsg("Xslt.transformFilesInDir: Started");
        this.debugMsg("Xslt.transformFilesInDir: fromDir=" + dir);
        this.debugMsg("Xslt.transformFilesInDir: toDir=" + toDir);
        this.debugMsg("Xslt.transformFilesInDir: extension=" + extension);
        this.debugMsg("Xslt.transformFilesInDir: prependDirName=" + prependDirName);
        String[] files = this.getDirContents(cc, dir);
        if (files == null || files.length == 0) {
            this.debugMsg("Xslt.transformFilesInDir: Success (no files in dir)");
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            String toFile = this.createToFileName(files[i], extension);
            if (!prependDirName) {
                toFile = toFile.substring(dir.length() + 1);
            }
            this.transformFile(cc, files[i], transformer, toDir, toFile, outputFiles, builder, outputEncoding);
        }
        this.debugMsg("Xslt.transformFilesInDir: Success");
    }
}

