/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.service.standard;

import com.sas.dpro.common.ContainerContext;
import com.sas.dpro.common.DProUtil;
import com.sas.dpro.common.ServiceFailedException;
import com.sas.dpro.service.AbstractInternalService;
import com.sas.dpro.service.ServiceResults;
import com.sas.dpro.service.ServiceResultsImpl;
import com.sas.iom.SAS.ILanguageService;
import com.sas.iom.SAS.ILanguageServicePackage.CarriageControlSeqHolder;
import com.sas.iom.SAS.ILanguageServicePackage.LineTypeSeqHolder;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SAS.IWorkspaceHelper;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.StringSeqHolder;
import com.sas.services.connection.BridgeServer;
import com.sas.services.connection.ConnectionFactoryConfiguration;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.connection.ConnectionFactoryInterface;
import com.sas.services.connection.ConnectionFactoryManager;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.connection.ManualConnectionFactoryConfiguration;
import com.sas.services.connection.Server;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import org.omg.CORBA.Object;

public class WorkspaceJob
extends AbstractInternalService {
    public static final String SERVICE_NAME = "WorkspaceJob";
    public static final String PARAM_HOST = "host";
    public static final String PARAM_PORT = "port";
    public static final String PARAM_USERID = "userid";
    public static final String PARAM_PW = "password";
    public static final String PARAM_POOLED = "pooled";
    public static final String PARAM_LOG = "log";
    public static final String PARAM_LST = "lst";
    public static final String PARAM_SASCODE = "sasCode";
    public static final String PARAM_SASFILE = "sasFile";
    public static final String PARAM_SASFILE_CHARSET = "sasFileCharset";
    public static final String PARAM_SASFILE_CONTAINER = "sasFileContainer";
    private static final String BUNDLE_NAME = "com.sas.dpro.service.standard.WorkspaceJob";
    private static final ResourceBundle msg = ResourceBundle.getBundle("com.sas.dpro.service.standard.WorkspaceJob");
    private static final int LINE_COUNT = 250;
    private static final String PROPERTY_DEBUG_WORKSPACE_JOB = "com.sas.dpro.service.standard.WorkspaceJob.debug";
    private static final String PROPERTY_WORKSPACE_JOB_BRIDGESERVER_CLASSID = "com.sas.dpro.service.standard.WorkspaceJob.BridgeServerClassID";

    public WorkspaceJob() {
        super(SERVICE_NAME);
    }

    private void debugPrint(String text) {
        if (Boolean.getBoolean(PROPERTY_DEBUG_WORKSPACE_JOB)) {
            text = "[DEBUG WorkspaceJob]: " + text;
            System.err.println(text);
        }
    }

    private File getFile(ContainerContext container, String param) {
        String fileName = (String)this.getParameter(param);
        return fileName == null ? null : WorkspaceJob.getAbsoluteFile(container, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getSASCode(ContainerContext container) throws ServiceFailedException {
        String sasCode = (String)this.getParameter(PARAM_SASCODE);
        if (sasCode == null) {
            String sasFile = (String)this.getParameter(PARAM_SASFILE);
            if (sasFile != null) {
                ContainerContext sasFileCont = (ContainerContext)this.getParameter(PARAM_SASFILE_CONTAINER);
                if (sasFileCont == null) {
                    sasFileCont = container;
                }
                Charset cs = this.getCharsetSpecified(PARAM_SASFILE_CHARSET);
                StringBuilder buf = new StringBuilder();
                try {
                    InputStream in = DProUtil.getFileContents(sasFileCont, sasFile);
                    try (BufferedReader r = new BufferedReader(new InputStreamReader(in, cs));){
                        while ((sasCode = r.readLine()) != null) {
                            buf.append(sasCode).append('\n');
                        }
                    }
                }
                catch (Exception e) {
                    String text = e.getMessage();
                    if (text == null) {
                        text = e.toString();
                    }
                    String key = "Error.ReadingFile.fmt.txt";
                    String desc = DProUtil.formatString(msg, key, this.getName(), text);
                    throw new ServiceFailedException(desc, e);
                }
                sasCode = buf.toString();
            } else {
                String key = "Error.NoSASCodeSpecified.fmt.txt";
                String desc = DProUtil.formatString(msg, key, this.getName());
                throw new ServiceFailedException(desc);
            }
        }
        return sasCode;
    }

    private String getStringParamChecked(String param) throws ServiceFailedException {
        String value = (String)this.getParameter(param);
        if (value == null) {
            String key = "Error.ParameterMissing.fmt.txt";
            String desc = DProUtil.formatString(msg, key, this.getName(), param);
            throw new ServiceFailedException(desc);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ServiceResults runServiceImpl(ContainerContext container, Logger logger) throws ServiceFailedException {
        this.debugPrint("runServiceImpl: Entering");
        String host = this.getStringParamChecked(PARAM_HOST);
        String port = this.getStringParamChecked(PARAM_PORT);
        String userid = this.getStringParamChecked(PARAM_USERID);
        String password = this.getStringParamChecked(PARAM_PW);
        String sasCode = this.getSASCode(container);
        boolean pooled = this.getBooleanParameter(PARAM_POOLED, false);
        this.debugPrint("... host/port: " + host + ':' + port);
        this.debugPrint("... user/pass: " + userid + '/' + password);
        int intPort = 0;
        try {
            intPort = Integer.parseInt(port);
        }
        catch (NumberFormatException nfe) {
            String key = "Error.BadPortValue.fmt.txt";
            String desc = DProUtil.formatString(msg, key, this.getName(), port);
            throw new ServiceFailedException(desc);
        }
        String classID = System.getProperty(PROPERTY_WORKSPACE_JOB_BRIDGESERVER_CLASSID);
        if (classID == null) {
            if (pooled) {
                this.debugPrint("... Using pooled classID (CLSID_POOLED_SAS)");
                classID = "620963ee-32bf-4128-bf5f-4b0df8ff90eb";
            } else {
                classID = "440196d4-90f0-11d0-9f41-00a024bb830c";
            }
        }
        this.debugPrint("... BridgeServer classID: " + classID);
        BridgeServer server = new BridgeServer(classID, host, intPort);
        ConnectionFactoryManager cxfManager = new ConnectionFactoryManager();
        ManualConnectionFactoryConfiguration cxfConfig = new ManualConnectionFactoryConfiguration((Server)server);
        ConnectionFactoryInterface cxf = null;
        ConnectionInterface cx = null;
        try {
            cxf = cxfManager.getFactory((ConnectionFactoryConfiguration)cxfConfig);
            cx = cxf.getConnection(userid, password);
        }
        catch (ConnectionFactoryException cfe) {
            String text = cfe.getMessage();
            if (text == null) {
                text = cfe.toString();
            }
            String key = "Error.CreatingConnection.fmt.txt";
            String desc = DProUtil.formatString(msg, key, this.getName(), text);
            throw new ServiceFailedException(desc, cfe);
        }
        Object obj = cx.getObject();
        IWorkspace workspace = IWorkspaceHelper.narrow((Object)obj);
        ILanguageService langService = workspace.LanguageService();
        langService.Async(false);
        ServiceResultsImpl res = new ServiceResultsImpl(this.createServiceInfo(), container, 0);
        File logFile = null;
        File lstFile = null;
        try {
            this.debugPrint("... Submitting SAS code");
            try {
                langService.Submit(sasCode);
            }
            catch (GenericError e) {
                String text = e.getMessage();
                if (text == null) {
                    text = e.toString();
                }
                String key = "Error.ErrorRunningSASCode.fmt.txt";
                String desc = DProUtil.formatString(msg, key, this.getName(), text);
                throw new ServiceFailedException(desc, e);
            }
            this.debugPrint("... writing log output to file: " + (logFile == null ? "none" : logFile.getAbsolutePath()));
            logFile = this.getFile(container, PARAM_LOG);
            if (logFile != null) {
                try {
                    this.writeFile(logFile, langService, res, true);
                }
                catch (Exception e) {
                    this.throwErrorWritingFileException(e, "log.txt");
                }
            }
            this.debugPrint("... writing lst output to file: " + (lstFile == null ? "none" : lstFile.getAbsolutePath()));
            lstFile = this.getFile(container, PARAM_LST);
            if (lstFile != null) {
                try {
                    this.writeFile(lstFile, langService, res, false);
                }
                catch (Exception e) {
                    this.throwErrorWritingFileException(e, "lst.txt");
                }
            }
        }
        finally {
            try {
                workspace.Close();
                cx.close();
                ConnectionFactoryInterface close_cxf = ConnectionFactoryManager.getConnectionFactory((ConnectionFactoryConfiguration)cxfConfig);
                close_cxf.getAdminInterface().destroy();
            }
            catch (Exception ge) {
                ge.printStackTrace();
            }
        }
        if (logFile != null) {
            res.addOutputFile(logFile.getPath());
        }
        if (lstFile != null) {
            res.addOutputFile(lstFile.getPath());
        }
        this.debugPrint("runServiceImpl: Exiting");
        return res;
    }

    private void throwErrorWritingFileException(Exception e, String fileTypeKey) throws ServiceFailedException {
        String text = e.getMessage();
        if (text == null) {
            text = e.toString();
        }
        String key = "Error.WritingFile.fmt.txt";
        String desc = DProUtil.formatString(msg, key, this.getName(), msg.getString(fileTypeKey), text);
        throw new ServiceFailedException(desc, e);
    }

    protected void writeFile(File file, ILanguageService ls, ServiceResultsImpl res, boolean log) throws IOException {
        CarriageControlSeqHolder ccsh = new CarriageControlSeqHolder();
        LineTypeSeqHolder lineTypes = new LineTypeSeqHolder();
        StringSeqHolder lines = new StringSeqHolder();
        StringBuilder sb = new StringBuilder();
        try (PrintWriter w = new PrintWriter(new BufferedWriter(new FileWriter(file)));){
            if (log) {
                ls.FlushLogLines(250, ccsh, lineTypes, lines);
                while (lines.value != null && lines.value.length > 0) {
                    for (int i = 0; i < lines.value.length; ++i) {
                        w.println(lines.value[i]);
                        sb.append(lines.value[i]).append('\n');
                    }
                    ls.FlushLogLines(250, ccsh, lineTypes, lines);
                }
                res.setStdout(sb.toString());
            } else {
                ls.FlushListLines(250, ccsh, lineTypes, lines);
                while (lines.value != null && lines.value.length > 0) {
                    for (int i = 0; i < lines.value.length; ++i) {
                        w.println(lines.value[i]);
                        sb.append(lines.value[i]).append('\n');
                    }
                    ls.FlushListLines(250, ccsh, lineTypes, lines);
                }
                res.setStderr(sb.toString());
            }
        }
    }
}

