/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.service.standard;

import com.sas.dpro.common.ContainerContext;
import com.sas.dpro.common.FileList;
import com.sas.dpro.common.FileListImpl;
import com.sas.dpro.common.Mapper;
import com.sas.dpro.common.MapperUtil;
import com.sas.dpro.common.ServiceFailedException;
import com.sas.dpro.provider.ProviderFactory;
import com.sas.dpro.service.AbstractInternalService;
import com.sas.dpro.service.ServiceResults;
import com.sas.dpro.service.ServiceResultsImpl;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Unzip
extends AbstractInternalService {
    public static final String SERVICE_NAME = "Unzip";
    public static final String PARAM_DEST = "dest";
    public static final String PARAM_MAPPERS = "mappers";
    public static final String PARAM_OVERWRITE = "overwrite";
    public static final String PARAM_SRC = "src";
    private static final int DEFAULT_BUF_SIZE = 8192;
    private static final String MSG = "com.sas.dpro.service.standard.Unzip";
    private static final ResourceBundle msg = ResourceBundle.getBundle("com.sas.dpro.service.standard.Unzip");

    public Unzip() {
        super(SERVICE_NAME);
    }

    private static String applyMappers(String fileName, Mapper[] mappers) throws IOException {
        try {
            return MapperUtil.applyMappers(fileName, mappers);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            String desc = msg.getString("Error.ErrorApplyingMappers.fmt.txt");
            String text = e.getMessage();
            if (text == null) {
                text = e.toString();
            }
            desc = MessageFormat.format(desc, SERVICE_NAME, fileName, text);
            throw new IOException(desc);
        }
    }

    protected FileList handleUnzip(File file, File dir, Mapper[] mappers, boolean overwrite) throws IOException {
        return Unzip.unzip(file, dir, mappers, overwrite);
    }

    @Override
    protected ServiceResults runServiceImpl(ContainerContext container, Logger logger) throws ServiceFailedException {
        String zipName = (String)this.getParameter(PARAM_SRC);
        String dest = (String)this.getParameter(PARAM_DEST);
        boolean overwrite = this.getBooleanParameter(PARAM_OVERWRITE, false);
        Mapper[] mappers = (Mapper[])this.getParameter(PARAM_MAPPERS);
        if (zipName == null) {
            String desc = msg.getString("Error.NoZipSpecified.fmt.txt");
            desc = MessageFormat.format(desc, this.getName());
            throw new ServiceFailedException(desc);
        }
        File zipFile = Unzip.getAbsoluteFile(container, zipName);
        if (!zipFile.isFile()) {
            String desc = msg.getString("Error.InvalidZipFile.fmt.txt");
            desc = MessageFormat.format(desc, this.getName(), zipFile.getAbsolutePath());
            throw new ServiceFailedException(desc);
        }
        if (dest == null) {
            String desc = msg.getString("Error.NoDestDirSpecified.fmt.txt");
            desc = MessageFormat.format(desc, this.getName());
            throw new ServiceFailedException(desc);
        }
        File destDir = Unzip.getAbsoluteFile(container, dest);
        if (!destDir.isDirectory()) {
            String desc = msg.getString("Error.InvalidDestDir.fmt.txt");
            desc = MessageFormat.format(desc, this.getName(), destDir.getAbsolutePath());
            throw new ServiceFailedException(desc);
        }
        FileList outputFiles = null;
        try {
            outputFiles = this.handleUnzip(zipFile, destDir, mappers, overwrite);
        }
        catch (IOException ioe) {
            String temp = ioe.getMessage();
            if (temp == null) {
                temp = ioe.toString();
            }
            String desc = msg.getString("Error.UnzippingFile.fmt.txt");
            desc = MessageFormat.format(desc, this.getName(), zipFile, temp);
            throw new ServiceFailedException(desc, ioe);
        }
        ServiceResultsImpl results = new ServiceResultsImpl(this.createServiceInfo(), container, 0);
        results.setOutputFiles(outputFiles);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileList unzip(File file, File toDir, Mapper[] mappers, boolean overwrite) throws IOException {
        String hostPort = ProviderFactory.getLocalProviderName();
        FileListImpl outputFiles = new FileListImpl(toDir.getAbsolutePath(), hostPort, null);
        ZipFile zipFile = new ZipFile(file);
        int bufSize = 8192;
        byte[] buf = new byte[bufSize];
        try {
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                String desc;
                ZipEntry entry = entries.nextElement();
                String entryName = entry.getName();
                String outputFileName = Unzip.applyMappers(entryName, mappers);
                File outFile = new File(toDir, outputFileName);
                if (entry.isDirectory()) {
                    if (outFile.isFile()) {
                        desc = msg.getString("Error.OutputLocationFile.fmt.txt");
                        desc = MessageFormat.format(desc, SERVICE_NAME, outFile.getAbsolutePath());
                        throw new IOException(desc);
                    }
                    if (outFile.isDirectory() || outFile.mkdirs()) continue;
                    desc = msg.getString("Error.CantCreateDirectory.fmt.txt");
                    desc = MessageFormat.format(desc, SERVICE_NAME, outFile.getAbsolutePath());
                    throw new IOException(desc);
                }
                if (outFile.isDirectory()) {
                    desc = msg.getString("Error.OutputLocationDirectory.fmt.txt");
                    desc = MessageFormat.format(desc, SERVICE_NAME, outFile.getAbsolutePath());
                    throw new IOException(desc);
                }
                if (outFile.exists() && !overwrite) continue;
                File parentDir = outFile.getParentFile();
                if (!parentDir.isDirectory() && !parentDir.mkdirs()) {
                    String desc2 = msg.getString("Error.CantCreateDirectory.fmt.txt");
                    desc2 = MessageFormat.format(desc2, SERVICE_NAME, parentDir.getAbsolutePath());
                    throw new IOException(desc2);
                }
                Unzip.writeFile(zipFile.getInputStream(entry), outFile, buf);
                outputFiles.add(outputFileName);
            }
        }
        finally {
            zipFile.close();
        }
        return outputFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void writeFile(InputStream in, File outFile, byte[] buf) throws IOException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outFile));
        int count = -1;
        try {
            while ((count = in.read(buf)) != -1) {
                out.write(buf, 0, count);
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (in != null) {
                in.close();
            }
        }
    }
}

