/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.service.standard;

import com.sas.dpro.common.ContainerContext;
import com.sas.dpro.common.FileListImpl;
import com.sas.dpro.common.ServiceFailedException;
import com.sas.dpro.service.AbstractInternalService;
import com.sas.dpro.service.ServiceResults;
import com.sas.dpro.service.ServiceResultsImpl;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Logger;

public class TempFile
extends AbstractInternalService {
    public static final String SERVICE_NAME = "TempFile";
    public static final String PARAM_DELETE_ON_EXIT = "deleteOnExit";
    public static final String PARAM_PREFIX = "prefix";
    public static final String PARAM_SUBDIR = "subdir";
    public static final String PARAM_SUFFIX = "suffix";
    public static final String PARAM_VARIABLE = "variable";
    private static final String MSG = "com.sas.dpro.service.standard.TempFile";

    public TempFile() {
        super(SERVICE_NAME);
    }

    protected ResourceBundle getErrorBundle() {
        return ResourceBundle.getBundle(MSG);
    }

    @Override
    protected ServiceResults runServiceImpl(ContainerContext container, Logger logger) throws ServiceFailedException {
        File directory;
        boolean deleteOnExit = this.getBooleanParameter(PARAM_DELETE_ON_EXIT, false);
        String prefix = (String)this.getParameter(PARAM_PREFIX);
        String subdir = (String)this.getParameter(PARAM_SUBDIR);
        String suffix = (String)this.getParameter(PARAM_SUFFIX);
        if (prefix == null) {
            prefix = "___";
        } else if (prefix.length() < 3) {
            while (prefix.length() < 3) {
                prefix = prefix + "_";
            }
        }
        String rootDir = container.getDirectory();
        char ch = rootDir.charAt(rootDir.length() - 1);
        if (ch == '\\' || ch == '/') {
            rootDir = rootDir.substring(0, rootDir.length() - 1);
        }
        File file = directory = subdir == null ? new File(rootDir) : new File(rootDir, subdir);
        if (!directory.isDirectory()) {
            ResourceBundle msg = this.getErrorBundle();
            String desc = msg.getString("Error.InvalidDirectory.fmt.txt");
            desc = MessageFormat.format(desc, directory.getAbsolutePath());
            throw new ServiceFailedException(desc);
        }
        File file2 = null;
        try {
            file2 = File.createTempFile(prefix, suffix, directory);
        }
        catch (IOException ioe) {
            throw new ServiceFailedException(ioe);
        }
        if (deleteOnExit) {
            file2.deleteOnExit();
        }
        FileListImpl fileList = new FileListImpl(rootDir, container.getProviderName(), null);
        String relPath = file2.getAbsolutePath().substring(rootDir.length() + 1);
        fileList.add(relPath);
        ServiceResultsImpl res = new ServiceResultsImpl(this.createServiceInfo(), container);
        res.setOutputFiles(fileList);
        return res;
    }
}

