/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.service.standard;

import com.sas.dpro.common.ContainerContext;
import com.sas.dpro.common.DProUtil;
import com.sas.dpro.common.ExternalProcessUtil;
import com.sas.dpro.common.ServiceFailedException;
import com.sas.dpro.service.ServiceResults;
import com.sas.dpro.service.ServiceResultsImpl;
import com.sas.dpro.service.standard.AbstractExternalProcessService;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import org.codehaus.groovy.control.CompilationFailedException;

public class GroovyScript
extends AbstractExternalProcessService {
    public static final String VAR_ARGS = "args";
    public static final String VAR_CONTAINER = "container";
    public static final String VAR_ENV = "env";
    public static final String VAR_OUTPUT = "dproOutput";
    public static final String VAR_STDIN = "stdin";
    private Charset cs;
    private static final String BUNDLE = "com.sas.dpro.service.standard.GroovyScript";
    private static final ResourceBundle msg = ResourceBundle.getBundle("com.sas.dpro.service.standard.GroovyScript");
    public static final String PROPERTY_DEBUG_GROOVYSCRIPT = "com.sas.dpro.service.standard.GroovyScript.debug";

    public GroovyScript(String name, String scriptFile) {
        this(name, scriptFile, null, null);
    }

    public GroovyScript(String name, String scriptFile, Charset cs, String[] defaultArgs) {
        super(name, scriptFile, defaultArgs);
        if (cs == null) {
            cs = Charset.defaultCharset();
        }
        this.cs = cs;
    }

    private final void debugPrint(String text) {
        if (Boolean.getBoolean(PROPERTY_DEBUG_GROOVYSCRIPT)) {
            text = "[DEBUG " + this.getName() + "]: " + text;
            System.err.println(text);
        }
    }

    @Override
    public final boolean isInternalService() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ServiceResults runServiceImpl(ContainerContext container, Logger logger) throws ServiceFailedException {
        ServiceResultsImpl results = new ServiceResultsImpl(this.createServiceInfo(), container);
        Process proc = null;
        String commandExecuted = null;
        PrintWriter stdoutWriter = null;
        PrintWriter stderrWriter = null;
        boolean redirectStderr = this.getBooleanParameter("redirectStderr", false);
        results.setStderrRedirected(redirectStderr);
        try {
            String captureOutputStreams;
            boolean append;
            String stdin = (String)this.getParameter(VAR_STDIN);
            String stdoutFileName = (String)this.getParameter("stdout");
            String stderrFileName = (String)this.getParameter("stderr");
            if (stdoutFileName != null) {
                append = false;
                if (stdoutFileName.startsWith(">>")) {
                    stdoutFileName = stdoutFileName.substring(2);
                    append = true;
                }
                File stdoutFile = GroovyScript.getAbsoluteFile(container, stdoutFileName);
                stdoutWriter = new PrintWriter(new BufferedWriter(new FileWriter(stdoutFile, append)));
            }
            if (stderrFileName != null) {
                append = false;
                if (stderrFileName.startsWith(">>")) {
                    stderrFileName = stderrFileName.substring(2);
                    append = true;
                }
                if (stderrFileName.equals(stdoutFileName)) {
                    stderrWriter = stdoutWriter;
                } else {
                    File stderrFile = GroovyScript.getAbsoluteFile(container, stderrFileName);
                    stderrWriter = new PrintWriter(new BufferedWriter(new FileWriter(stderrFile, append)));
                }
            }
            String[] args = (String[])this.getParameter("_CommandLineArgs");
            args = this.createCommandLineArray(args);
            commandExecuted = ExternalProcessUtil.createCommandString(args);
            results.setCommandExecuted(commandExecuted);
            String[] temp = new String[args.length - 1];
            System.arraycopy(args, 1, temp, 0, args.length - 1);
            args = temp;
            HashMap<String, String> envVars = null;
            temp = (String[])this.getParameter("_EnvironmentVars");
            if (temp != null) {
                envVars = new HashMap<String, String>();
                for (int j = 0; j < temp.length; j += 2) {
                    envVars.put(temp[j], temp[j + 1]);
                }
            }
            HashMap<String, String> allEnvVars = new HashMap<String, String>();
            boolean defaultAppend = envVars == null;
            boolean appendEnvVars = this.getBooleanParameter("_AppendEnvVars", defaultAppend);
            if (appendEnvVars) {
                Map defaults;
                if (this.getAppendDefaultEnvVars()) {
                    allEnvVars.putAll(System.getenv());
                }
                if ((defaults = this.getDefaultEnvVars()) != null) {
                    allEnvVars.putAll(defaults);
                }
            }
            if (!appendEnvVars) {
                allEnvVars.clear();
            }
            if (envVars != null) {
                allEnvVars.putAll(envVars);
            }
            if (this.getBooleanParameter("echoCommand", false)) {
                System.out.println("External process command line being executed:");
                System.out.println(results.getCommandExecuted());
            }
            if ((captureOutputStreams = (String)this.getParameter("captureOutputStreams")) == null) {
                captureOutputStreams = "false";
            }
            AbstractStringBuilder stdoutBuf = null;
            StringBuilder stderrBuf = null;
            if (Boolean.parseBoolean(captureOutputStreams)) {
                stdoutBuf = new StringBuilder();
                stderrBuf = new StringBuilder();
            } else if ("combine".equals(captureOutputStreams)) {
                stdoutBuf = new StringBuffer();
                stderrBuf = stdoutBuf;
            }
            ScriptOutput dproOutput = new ScriptOutput();
            dproOutput.stdout = stdoutBuf;
            dproOutput.stderr = stderrBuf;
            dproOutput.stdoutWriter = stdoutWriter;
            dproOutput.stderrWriter = stderrWriter;
            Binding binding = new Binding();
            binding.setVariable(VAR_CONTAINER, (Object)container);
            binding.setVariable(VAR_ARGS, (Object)args);
            binding.setVariable(VAR_STDIN, (Object)stdin);
            binding.setVariable(VAR_ENV, allEnvVars);
            binding.setVariable(VAR_OUTPUT, (Object)dproOutput);
            GroovyShell shell = new GroovyShell(binding);
            File script = new File(this.getCommand());
            Object output = null;
            try {
                String groovy = DProUtil.getLocalFileContents(script, this.cs);
                output = shell.evaluate(groovy, script.getName());
                this.debugPrint("Script output: " + output);
            }
            catch (Throwable throwable) {
                this.debugPrint("Script output: " + output);
                if (output instanceof Integer) {
                    results.setReturnCode((Integer)output);
                }
                int captured = 0;
                if (Boolean.parseBoolean(captureOutputStreams)) {
                    results.setStdout(((Object)stdoutBuf).toString());
                    results.setStderr(((Object)stderrBuf).toString());
                    captured = 1;
                } else if ("combine".equals(captureOutputStreams)) {
                    results.setStdout(((Object)stdoutBuf).toString());
                    results.setStderr(null);
                    captured = 2;
                }
                results.setOutputStreamsCaptured(captured);
                if (stdoutWriter != null) {
                    stdoutWriter.flush();
                    stdoutWriter.close();
                }
                if (stderrWriter != null && stderrWriter != stdoutWriter) {
                    stderrWriter.flush();
                    stderrWriter.close();
                }
                stderrWriter = null;
                stdoutWriter = null;
                throw throwable;
            }
            if (output instanceof Integer) {
                results.setReturnCode((Integer)output);
            }
            int captured = 0;
            if (Boolean.parseBoolean(captureOutputStreams)) {
                results.setStdout(((Object)stdoutBuf).toString());
                results.setStderr(((Object)stderrBuf).toString());
                captured = 1;
            } else if ("combine".equals(captureOutputStreams)) {
                results.setStdout(((Object)stdoutBuf).toString());
                results.setStderr(null);
                captured = 2;
            }
            results.setOutputStreamsCaptured(captured);
            if (stdoutWriter != null) {
                stdoutWriter.flush();
                stdoutWriter.close();
            }
            if (stderrWriter != null && stderrWriter != stdoutWriter) {
                stderrWriter.flush();
                stderrWriter.close();
            }
            stderrWriter = null;
            stdoutWriter = null;
        }
        catch (CompilationFailedException cfe) {
            String key = "Error.CompilationFailed.fmt.txt";
            String desc = DProUtil.formatString(msg, key, this.getName(), cfe.getMessage());
            this.debugPrint("... " + desc);
            ServiceFailedException sfe = new ServiceFailedException(desc);
            sfe.setServiceResults(results);
            throw sfe;
        }
        catch (Exception e) {
            if (proc != null) {
                proc.destroy();
            }
            if (stdoutWriter != null) {
                stdoutWriter.flush();
                stdoutWriter.close();
            }
            if (stderrWriter != null && stderrWriter != stdoutWriter) {
                stderrWriter.flush();
                stderrWriter.close();
            }
            String desc = null;
            if (e instanceof InterruptedException) {
                desc = msg.getString("Exception.ServiceFailedInterrupted.fmt.txt");
                desc = MessageFormat.format(desc, this.getName());
            } else {
                desc = msg.getString("Exception.ServiceFailedGeneric.fmt.txt");
                String param2 = e.getMessage();
                if (param2 == null) {
                    param2 = e.toString();
                }
                desc = MessageFormat.format(desc, this.getName(), param2);
            }
            ServiceFailedException sfe = new ServiceFailedException(desc);
            if (commandExecuted != null) {
                sfe.setCommandExecuted(commandExecuted);
            }
            sfe.setServiceResults(results);
            throw sfe;
        }
        return results;
    }

    public static class ScriptOutput {
        private PrintWriter stdoutWriter;
        private Appendable stdout;
        private PrintWriter stderrWriter;
        private Appendable stderr;

        public void print(CharSequence str) {
            this.stdoutPrint(str);
        }

        public void printf(CharSequence format, Object[] args) {
            this.stdoutPrintf(format, args);
        }

        public void println() {
            this.stdoutPrintln();
        }

        public void println(CharSequence str) {
            this.stdoutPrintln(str);
        }

        public void stdoutPrint(CharSequence str) {
            if (this.stdoutWriter != null) {
                this.stdoutWriter.print(str);
            }
            if (this.stdout != null) {
                try {
                    this.stdout.append(str);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }

        public void stdoutPrintf(CharSequence format, Object[] args) {
            String fmt = format.toString();
            if (this.stdoutWriter != null) {
                this.stdoutWriter.printf(fmt, args);
            }
            if (this.stdout != null) {
                try {
                    StringWriter w = new StringWriter();
                    PrintWriter pw = new PrintWriter(w);
                    pw.printf(fmt, args);
                    pw.close();
                    this.stdout.append(w.getBuffer());
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }

        public void stdoutPrintln() {
            if (this.stdoutWriter != null) {
                this.stdoutWriter.println();
            }
            if (this.stdout != null) {
                try {
                    this.stdout.append('\n');
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }

        public void stdoutPrintln(CharSequence str) {
            if (this.stdoutWriter != null) {
                this.stdoutWriter.println(str);
            }
            if (this.stdout != null) {
                try {
                    this.stdout.append(str).append('\n');
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }

        public void stderrPrint(CharSequence str) {
            if (this.stderrWriter != null) {
                this.stderrWriter.print(str);
            }
            if (this.stderr != null) {
                try {
                    this.stderr.append(str);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }

        public void stderrPrintf(CharSequence format, Object[] args) {
            String fmt = format.toString();
            if (this.stderrWriter != null) {
                this.stderrWriter.printf(fmt, args);
            }
            if (this.stderr != null) {
                try {
                    StringWriter w = new StringWriter();
                    PrintWriter pw = new PrintWriter(w);
                    pw.printf(fmt, args);
                    pw.close();
                    this.stderr.append(w.getBuffer());
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }

        public void stderrPrintln() {
            if (this.stderrWriter != null) {
                this.stderrWriter.println();
            }
            if (this.stderr != null) {
                try {
                    this.stderr.append('\n');
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }

        public void stderrPrintln(CharSequence str) {
            if (this.stderrWriter != null) {
                this.stderrWriter.println(str);
            }
            if (this.stderr != null) {
                try {
                    this.stderr.append(str).append('\n');
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
    }
}

