/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.service.standard;

import com.sas.dpro.common.ContainerContext;
import com.sas.dpro.common.DProUtil;
import com.sas.dpro.common.InvalidProviderNameException;
import com.sas.dpro.common.ServiceFailedException;
import com.sas.dpro.provider.Provider;
import com.sas.dpro.provider.ProviderFactory;
import com.sas.dpro.service.ServiceInfo;
import com.sas.dpro.service.ServiceResults;
import com.sas.dpro.service.ServiceResultsImpl;
import com.sas.dpro.service.standard.AbstractReflectionBasedInternalService;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.rmi.RemoteException;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import org.codehaus.groovy.control.CompilationFailedException;

public class Groovy
extends AbstractReflectionBasedInternalService {
    public static final String SERVICE_NAME = "Groovy";
    public static final String PARAM_INITIAL_VARS = "initialVars";
    public static final String PARAM_SAVE_OUTPUT = "_saveOutput";
    public static final String PARAM_SCRIPT = "script";
    public static final String PARAM_SCRIPT_FILE = "scriptFile";
    public static final String PARAM_SCRIPT_FILE_CHARSET = "_scriptFileCharset";
    public static final String PARAM_SCRIPT_FILE_CONTAINER = "_scriptFileContainer";
    public static final String PARAM_SCRIPT_NAME = "scriptName";
    public static final String PROPERTY_GROOVY_ENABLED = "groovyEnabled";
    private static final String MSG = "com.sas.dpro.service.standard.Groovy";
    private static ResourceBundle errorMsg;
    private static final String PROPERTY_DEBUG = "com.sas.dpro.service.standard.Groovy.debug";

    public Groovy() {
        super(SERVICE_NAME);
    }

    private static final void debugPrint(String text) {
        if (Boolean.getBoolean(PROPERTY_DEBUG)) {
            text = "[DEBUG Groovy]: " + text;
            System.err.println(text);
        }
    }

    private static synchronized ResourceBundle getErrorBundle() {
        if (errorMsg == null) {
            errorMsg = ResourceBundle.getBundle(MSG);
        }
        return errorMsg;
    }

    private String getScriptNameForFile(String file) {
        int slash = file.lastIndexOf(47);
        return (slash = Math.max(slash, file.lastIndexOf(92))) == -1 ? file : file.substring(slash + 1);
    }

    private Object getScriptObject(ContainerContext cc) throws ServiceFailedException {
        String scriptStr = (String)this.getParameter(PARAM_SCRIPT);
        if (scriptStr != null) {
            Groovy.debugPrint("... Script code is in a String");
            return scriptStr;
        }
        String fileName = (String)this.getParameter(PARAM_SCRIPT_FILE);
        if (fileName != null) {
            ContainerContext cont = (ContainerContext)this.getParameter(PARAM_SCRIPT_FILE_CONTAINER);
            if (cont == null) {
                cont = cc;
            }
            Groovy.debugPrint("... Running script file '" + cont.getDirectory() + "/" + fileName + "' on host " + cont.getProviderName());
            Charset cs = this.getCharsetSpecified(PARAM_SCRIPT_FILE_CHARSET);
            Groovy.debugPrint("... Using file encoding: " + cs.displayName());
            BufferedReader r = this.getScriptObjectFromFile(cont, fileName, cs);
            return r;
        }
        ResourceBundle msg = Groovy.getErrorBundle();
        String key = "Error.NoScriptSpecified.fmt.txt";
        String desc = DProUtil.formatString(msg, key, this.getName());
        throw new ServiceFailedException(desc);
    }

    private BufferedReader getScriptObjectFromFile(ContainerContext cc, String file, Charset cs) throws ServiceFailedException {
        BufferedReader r = null;
        try {
            InputStream in = DProUtil.getFileContents(cc, file);
            in = DProUtil.possiblyReadBOM(in, cs);
            r = new BufferedReader(new InputStreamReader(in, cs));
        }
        catch (InvalidProviderNameException ipne) {
            ResourceBundle msg = Groovy.getErrorBundle();
            String key = "Error.ReadingScriptFile.fmt.txt";
            String desc = DProUtil.formatString(msg, key, new Object[]{this.getName(), file, cc.getProviderName(), ipne.getMessage()});
            throw new ServiceFailedException(desc, ipne);
        }
        catch (IOException ioe) {
            ResourceBundle msg = Groovy.getErrorBundle();
            String key = "Error.ReadingScriptFile.fmt.txt";
            String desc = DProUtil.formatString(msg, key, new Object[]{this.getName(), file, cc.getProviderName(), ioe.getMessage()});
            throw new ServiceFailedException(desc, ioe);
        }
        return r;
    }

    public static boolean isGroovyEnabled() {
        boolean groovyEnabled = false;
        Provider p = null;
        try {
            p = ProviderFactory.getProvider("server-local");
            String temp = p.getProperty(PROPERTY_GROOVY_ENABLED);
            if (temp != null) {
                groovyEnabled = Boolean.parseBoolean(temp);
            }
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
        catch (InvalidProviderNameException ipne) {
            ipne.printStackTrace();
        }
        return groovyEnabled;
    }

    @Override
    protected ServiceResults runServiceImpl(ContainerContext container, Logger logger) throws ServiceFailedException {
        Groovy.debugPrint("Entering runServiceImpl");
        boolean groovyEnabled = Groovy.isGroovyEnabled();
        if (!groovyEnabled) {
            ResourceBundle msg = Groovy.getErrorBundle();
            String key = "Error.GroovyNotEnabled.fmt.txt";
            String localP = ProviderFactory.getLocalProviderName();
            String desc = DProUtil.formatString(msg, key, this.getName(), localP);
            throw new ServiceFailedException(desc);
        }
        ServiceInfo info = this.createServiceInfo();
        ServiceResultsImpl sri = new ServiceResultsImpl(info, container, 0);
        Binding binding = new Binding();
        binding.setVariable("container", (Object)container);
        String[] vars = (String[])this.getParameter(PARAM_INITIAL_VARS);
        int count = vars == null ? 0 : vars.length;
        for (int i = 0; i < count; i += 2) {
            String name = vars[i];
            String value = vars[i + 1];
            Groovy.debugPrint("... Adding initial var: " + name + " => " + value);
            binding.setVariable(name, (Object)value);
        }
        GroovyShell shell = new GroovyShell(binding);
        Object script = this.getScriptObject(container);
        String scriptName = null;
        Object output = null;
        try {
            if (script instanceof String) {
                scriptName = (String)this.getParameter(PARAM_SCRIPT_NAME);
                if (scriptName == null) {
                    scriptName = "inlineGroovyScript";
                }
                output = shell.evaluate((String)script, scriptName);
            } else {
                String fileName = (String)this.getParameter(PARAM_SCRIPT_FILE);
                scriptName = this.getScriptNameForFile(fileName);
                output = shell.evaluate((Reader)((BufferedReader)script), scriptName);
            }
        }
        catch (CompilationFailedException cfe) {
            ResourceBundle msg = Groovy.getErrorBundle();
            String key = "Error.CompilationFailed.fmt.txt";
            String desc = DProUtil.formatString(msg, key, this.getName(), cfe.getMessage());
            Groovy.debugPrint("... " + desc);
            throw new ServiceFailedException(desc);
        }
        catch (RuntimeException re) {
            ResourceBundle msg = Groovy.getErrorBundle();
            String key = "Error.ScriptFailed.fmt.txt";
            String text = re.getMessage();
            if (text == null) {
                text = re.toString();
            }
            String desc = DProUtil.formatString(msg, key, this.getName(), text);
            Groovy.debugPrint("... " + desc);
            throw new ServiceFailedException(desc);
        }
        finally {
            if (script instanceof InputStream) {
                Groovy.debugPrint("... Closing script input stream");
                try {
                    ((InputStream)script).close();
                }
                catch (IOException ioe) {
                    ResourceBundle msg = Groovy.getErrorBundle();
                    String key = "Error.ClosingInputStream.fmt.txt";
                    String desc = DProUtil.formatString(msg, key, this.getName());
                    throw new ServiceFailedException(desc, ioe);
                }
            }
        }
        String saveOutput = (String)this.getParameter(PARAM_SAVE_OUTPUT);
        if (saveOutput != null && Boolean.parseBoolean(saveOutput)) {
            if (output != null) {
                Groovy.debugPrint("... Saving output (\"" + output.toString() + "\")");
                sri.setStdout(output.toString());
            } else {
                Groovy.debugPrint("... saveOutput==true, but no output to save");
            }
        }
        Groovy.debugPrint("Exiting runServiceImpl");
        return sri;
    }
}

