/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.service.standard;

import com.sas.dpro.common.ContainerContext;
import com.sas.dpro.common.DProUtil;
import com.sas.dpro.common.ServiceFailedException;
import com.sas.dpro.service.AbstractInternalService;
import com.sas.dpro.service.ServiceInfo;
import com.sas.dpro.service.ServiceResults;
import com.sas.dpro.service.ServiceResultsImpl;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;

public class Ftp
extends AbstractInternalService {
    public static final String SERVICE_NAME = "Ftp";
    public static final String PARAM_HOST = "host";
    public static final String PARAM_PORT = "port";
    public static final String PARAM_USERID = "userid";
    public static final String PARAM_PASSWORD = "password";
    public static final String PARAM_PROTOCOL = "protocol";
    public static final String PARAM_COMMANDS = "commands";
    public static final int DEFAULT_FTP_PORT = 21;
    public static final String PROTOCOL_FTP = "ftp";
    public static final String PROTOCOL_FTPS = "ftps";
    private static final String PROPERTY_DEBUG = "com.sas.dpro.service.standard.Ftp.debug";
    private static final String MSG = "com.sas.dpro.service.standard.Ftp";
    private static final ResourceBundle msg = ResourceBundle.getBundle("com.sas.dpro.service.standard.Ftp");

    public Ftp() {
        super(SERVICE_NAME);
    }

    private static final void debugPrint(String text) {
        if (Boolean.getBoolean(PROPERTY_DEBUG)) {
            System.out.println("[DEBUG Ftp]: " + text);
        }
    }

    private static final String getFileName(String path) {
        int slash = path.lastIndexOf(47);
        int slash2 = path.lastIndexOf(92);
        slash = Math.max(slash, slash2);
        return path.substring(slash + 1);
    }

    public int getPortParameter() {
        int port = 21;
        Object portParam = this.getParameter(PARAM_PORT);
        if (portParam instanceof Integer) {
            port = (Integer)portParam;
        }
        return port;
    }

    private String possiblyDecrypt(String text) throws ServiceFailedException {
        String decrypted = text;
        if (decrypted != null && SasPasswordString.isEncoded((String)decrypted)) {
            try {
                decrypted = SasPasswordString.decode((String)decrypted);
            }
            catch (SasPasswordEncodingException spee) {
                String key = "Error.DecodingPassword.fmt.txt";
                String desc = spee.getMessage();
                if (desc == null) {
                    desc = spee.toString();
                }
                desc = DProUtil.formatString(msg, key, desc);
                throw new ServiceFailedException(desc);
            }
        }
        return decrypted;
    }

    @Override
    protected ServiceResults runServiceImpl(ContainerContext container, Logger logger) throws ServiceFailedException {
        String reply;
        String hostName = (String)this.getParameter(PARAM_HOST);
        int port = this.getPortParameter();
        String userid = (String)this.getParameter(PARAM_USERID);
        String password = (String)this.getParameter(PARAM_PASSWORD);
        String[] commands = (String[])this.getParameter(PARAM_COMMANDS);
        String protocol = (String)this.getParameter(PARAM_PROTOCOL);
        if (protocol == null) {
            protocol = PROTOCOL_FTP;
        }
        Ftp.debugPrint("Protocol: " + protocol);
        Ftp.debugPrint("Userid (pre-decryption):    " + userid);
        Ftp.debugPrint("Password (pre-decryption):  XXXXX");
        userid = this.possiblyDecrypt(userid);
        password = this.possiblyDecrypt(password);
        Ftp.debugPrint("Userid (post-decryption):   " + userid);
        Ftp.debugPrint("Password (post-decryption): XXXXX");
        FTPClient client = null;
        if (!PROTOCOL_FTP.equalsIgnoreCase(protocol)) {
            String key = "Error.UnsupportedProtocol.fmt.txt";
            String desc = DProUtil.formatString(msg, key, key, protocol);
            throw new ServiceFailedException(desc);
        }
        client = new FTPClient();
        StringBuilder stdout = new StringBuilder();
        try {
            Ftp.debugPrint("Connecting to " + hostName + ":" + port);
            client.connect(hostName, port);
            reply = client.getReplyString();
            Ftp.debugPrint(reply);
            stdout.append("ftp " + hostName + ":" + port).append('\n');
            stdout.append(reply);
        }
        catch (IOException ioe) {
            String key = "Error.Connecting.fmt.txt";
            String desc = DProUtil.formatString(msg, key, hostName + ":" + port);
            throw new ServiceFailedException(desc, ioe);
        }
        try {
            Ftp.debugPrint("Logging in as " + userid);
            client.login(userid, password);
            reply = client.getReplyString();
            Ftp.debugPrint(reply);
            stdout.append("user " + userid).append('\n');
            stdout.append(reply);
            int rc = client.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)rc)) {
                client.disconnect();
                throw new IOException("Credentials not accepted: " + reply);
            }
        }
        catch (IOException ioe) {
            String key = "Error.LoggingIn.fmt.txt";
            String desc = DProUtil.formatString(msg, key, hostName, userid);
            throw new ServiceFailedException(desc, ioe);
        }
        try {
            int count = commands == null ? 0 : commands.length;
            for (int i = 0; i < count; ++i) {
                boolean success;
                File file;
                String desc;
                String key;
                boolean success2;
                String path;
                int secondQuote;
                int firstQuote;
                String cmd = commands[i];
                Ftp.debugPrint("Running command: " + cmd);
                stdout.append(cmd).append('\n');
                if (cmd.startsWith("cd ")) {
                    firstQuote = cmd.indexOf(34);
                    secondQuote = cmd.indexOf(34, firstQuote + 1);
                    path = cmd.substring(firstQuote + 1, secondQuote);
                    success2 = client.changeWorkingDirectory(path);
                    reply = client.getReplyString();
                    Ftp.debugPrint(reply);
                    stdout.append(reply);
                    if (success2) continue;
                    key = "Error.ChangingDirectory.fmt.txt";
                    desc = DProUtil.formatString(msg, key, reply);
                    throw new ServiceFailedException(desc);
                }
                if ("pwd".equals(cmd)) {
                    client.printWorkingDirectory();
                    reply = client.getReplyString();
                    Ftp.debugPrint(reply);
                    stdout.append(reply);
                    continue;
                }
                if ("ls".equals(cmd)) {
                    FTPFile[] files = client.listFiles();
                    for (int j = 0; j < files.length; ++j) {
                        if (files[j] == null) continue;
                        Ftp.debugPrint(files[j].toString());
                        stdout.append(files[j].toString()).append('\n');
                    }
                    reply = client.getReplyString();
                    Ftp.debugPrint(reply);
                    stdout.append(reply);
                    continue;
                }
                if ("binary".equals(cmd)) {
                    this.setFileType(client, stdout, 2);
                    continue;
                }
                if ("ascii".equals(cmd)) {
                    this.setFileType(client, stdout, 0);
                    continue;
                }
                if ("ebcdic".equals(cmd)) {
                    this.setFileType(client, stdout, 1);
                    continue;
                }
                if (cmd.startsWith("get ")) {
                    firstQuote = cmd.indexOf(34);
                    secondQuote = cmd.indexOf(34, firstQuote + 1);
                    path = cmd.substring(firstQuote + 1, secondQuote);
                    String localName = null;
                    firstQuote = cmd.indexOf(34, secondQuote + 1);
                    if (firstQuote > -1) {
                        secondQuote = cmd.indexOf(34, firstQuote + 1);
                        localName = cmd.substring(firstQuote + 1, secondQuote);
                    } else {
                        localName = Ftp.getFileName(path);
                    }
                    file = new File(container.getDirectory(), localName);
                    try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));){
                        success = client.retrieveFile(path, (OutputStream)out);
                    }
                    reply = client.getReplyString();
                    Ftp.debugPrint(reply);
                    stdout.append(reply);
                    if (success) continue;
                    String key2 = "Error.GettingFile.fmt.txt";
                    String desc2 = DProUtil.formatString(msg, key2, reply);
                    throw new ServiceFailedException(desc2);
                }
                if (cmd.startsWith("put ")) {
                    firstQuote = cmd.indexOf(34);
                    secondQuote = cmd.indexOf(34, firstQuote + 1);
                    path = cmd.substring(firstQuote + 1, secondQuote);
                    String remoteName = null;
                    firstQuote = cmd.indexOf(34, secondQuote + 1);
                    if (firstQuote > -1) {
                        secondQuote = cmd.indexOf(34, firstQuote + 1);
                        remoteName = cmd.substring(firstQuote + 1, secondQuote);
                    } else {
                        remoteName = Ftp.getFileName(path);
                    }
                    file = new File(path);
                    if (!file.isAbsolute()) {
                        file = new File(container.getDirectory(), path);
                    }
                    if (!file.isFile()) {
                        String key3 = "Error.FileNotFound.fmt.txt";
                        String desc3 = DProUtil.formatString(msg, key3, path);
                        throw new ServiceFailedException(desc3);
                    }
                    try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
                        success = client.storeFile(remoteName, (InputStream)in);
                    }
                    reply = client.getReplyString();
                    Ftp.debugPrint(reply);
                    stdout.append(reply);
                    if (success) continue;
                    String key4 = "Error.PuttingFile.fmt.txt";
                    String desc4 = DProUtil.formatString(msg, key4, reply);
                    throw new ServiceFailedException(desc4);
                }
                if (cmd.startsWith("mkdir ")) {
                    firstQuote = cmd.indexOf(34);
                    secondQuote = cmd.indexOf(34, firstQuote + 1);
                    path = cmd.substring(firstQuote + 1, secondQuote);
                    success2 = client.makeDirectory(path);
                    reply = client.getReplyString();
                    Ftp.debugPrint(reply);
                    stdout.append(reply);
                    if (success2) continue;
                    key = "Error.MakingDirectory.fmt.txt";
                    desc = DProUtil.formatString(msg, key, reply);
                    throw new ServiceFailedException(desc);
                }
                if (!cmd.startsWith("dele ")) continue;
                firstQuote = cmd.indexOf(34);
                secondQuote = cmd.indexOf(34, firstQuote + 1);
                path = cmd.substring(firstQuote + 1, secondQuote);
                success2 = client.deleteFile(path);
                reply = client.getReplyString();
                Ftp.debugPrint(reply);
                stdout.append(reply);
                if (success2) continue;
                key = "Error.DeletingFile.fmt.txt";
                desc = DProUtil.formatString(msg, key, reply);
                throw new ServiceFailedException(desc);
            }
        }
        catch (IOException ioe) {
            String key = "Error.IOError.fmt.txt";
            String desc = ioe.getMessage();
            if (desc == null) {
                desc = ioe.toString();
            }
            desc = DProUtil.formatString(msg, key, desc);
            throw new ServiceFailedException(desc, ioe);
        }
        finally {
            try {
                client.logout();
                reply = client.getReplyString();
                Ftp.debugPrint(reply);
                stdout.append(reply);
                client.disconnect();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                throw new ServiceFailedException(ioe);
            }
        }
        ServiceInfo info = this.createServiceInfo();
        ServiceResultsImpl res = new ServiceResultsImpl(info, container, 0);
        res.setStdout(stdout.toString());
        return res;
    }

    private void setFileType(FTPClient client, StringBuilder stdout, int type) throws IOException, ServiceFailedException {
        boolean success = client.setFileType(type);
        String reply = client.getReplyString();
        Ftp.debugPrint(reply);
        stdout.append(reply);
        if (!success) {
            String key = "Error.SettingFileType.fmt.txt";
            String desc = DProUtil.formatString(msg, key, reply);
            throw new ServiceFailedException(desc);
        }
    }
}

