/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.service.standard;

import com.sas.dpro.common.ContainerContext;
import com.sas.dpro.common.ExternalProcessUtil;
import com.sas.dpro.common.ServiceFailedException;
import com.sas.dpro.service.ServiceResults;
import com.sas.dpro.service.ServiceResultsImpl;
import com.sas.dpro.service.standard.AbstractExternalProcessService;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.ResourceBundle;
import java.util.logging.Logger;

public class ExternalProcessService
extends AbstractExternalProcessService {
    public static final String PARAM_APPEND_ENV_VARS = "_AppendEnvVars";
    public static final String PARAM_CAPTURE_OUTPUT_STREAMS = "captureOutputStreams";
    public static final String PARAM_REDIRECT_STDERR = "redirectStderr";
    public static final String PARAM_COMMAND_LINE_ARGS = "_CommandLineArgs";
    public static final String PARAM_ECHO_COMMAND = "echoCommand";
    public static final String PARAM_ENVIRONMENT_VARS = "_EnvironmentVars";
    public static final String PARAM_OUTPUT_FILE_SET = "_outputFileSet";
    public static final String PARAM_STDIN = "stdin";
    public static final String PARAM_STDOUT = "stdout";
    public static final String PARAM_STDERR = "stderr";
    public static final String VALUE_CAPTURE_OUTPUT_STREAMS_COMBINE = "combine";
    private static final String BUNDLE = "com.sas.dpro.service.standard.ExternalProcessService";
    private static final ResourceBundle msg = ResourceBundle.getBundle("com.sas.dpro.service.standard.ExternalProcessService");

    public ExternalProcessService(String name, String command) {
        this(name, command, null);
    }

    public ExternalProcessService(String name, String command, String[] defaultArgs) {
        super(name, command, defaultArgs);
    }

    @Override
    public final boolean isInternalService() {
        return false;
    }

    @Override
    protected ServiceResults runServiceImpl(ContainerContext container, Logger logger) throws ServiceFailedException {
        ServiceResultsImpl results = new ServiceResultsImpl(this.createServiceInfo(), container);
        Process proc = null;
        String commandExecuted = null;
        PrintWriter stdoutWriter = null;
        PrintWriter stderrWriter = null;
        boolean redirectStderr = this.getBooleanParameter(PARAM_REDIRECT_STDERR, false);
        results.setStderrRedirected(redirectStderr);
        try {
            String captureOutputStreams;
            boolean append;
            String stdin = (String)this.getParameter(PARAM_STDIN);
            String stdoutFileName = (String)this.getParameter(PARAM_STDOUT);
            String stderrFileName = (String)this.getParameter(PARAM_STDERR);
            if (stdoutFileName != null) {
                append = false;
                if (stdoutFileName.startsWith(">>")) {
                    stdoutFileName = stdoutFileName.substring(2);
                    append = true;
                }
                File stdoutFile = ExternalProcessService.getAbsoluteFile(container, stdoutFileName);
                stdoutWriter = new PrintWriter(new BufferedWriter(new FileWriter(stdoutFile, append)));
            }
            if (stderrFileName != null) {
                append = false;
                if (stderrFileName.startsWith(">>")) {
                    stderrFileName = stderrFileName.substring(2);
                    append = true;
                }
                if (stderrFileName.equals(stdoutFileName)) {
                    stderrWriter = stdoutWriter;
                } else {
                    File stderrFile = ExternalProcessService.getAbsoluteFile(container, stderrFileName);
                    stderrWriter = new PrintWriter(new BufferedWriter(new FileWriter(stderrFile, append)));
                }
            }
            String[] cmdLineArgs = (String[])this.getParameter(PARAM_COMMAND_LINE_ARGS);
            String[] cmdLine = this.createCommandLineArray(cmdLineArgs);
            commandExecuted = ExternalProcessUtil.createCommandString(cmdLine);
            results.setCommandExecuted(commandExecuted);
            HashMap<String, String> envVars = null;
            String[] temp = (String[])this.getParameter(PARAM_ENVIRONMENT_VARS);
            if (temp != null) {
                envVars = new HashMap<String, String>();
                for (int j = 0; j < temp.length; j += 2) {
                    envVars.put(temp[j], temp[j + 1]);
                }
            }
            boolean defaultAppend = temp == null;
            boolean appendEnvVars = this.getBooleanParameter(PARAM_APPEND_ENV_VARS, defaultAppend);
            if (this.getBooleanParameter(PARAM_ECHO_COMMAND, false)) {
                System.out.println("External process command line being executed:");
                System.out.println(results.getCommandExecuted());
            }
            if ((captureOutputStreams = (String)this.getParameter(PARAM_CAPTURE_OUTPUT_STREAMS)) == null) {
                captureOutputStreams = "false";
            }
            AbstractStringBuilder stdoutBuf = null;
            StringBuilder stderrBuf = null;
            if (Boolean.parseBoolean(captureOutputStreams)) {
                stdoutBuf = new StringBuilder();
                stderrBuf = new StringBuilder();
            } else if (VALUE_CAPTURE_OUTPUT_STREAMS_COMBINE.equals(captureOutputStreams)) {
                stdoutBuf = new StringBuffer();
                stderrBuf = stdoutBuf;
            }
            File dir = new File(container.getDirectory());
            proc = this.startProcess(cmdLine, envVars, appendEnvVars, dir, redirectStderr);
            int rc = ExternalProcessUtil.waitFor(proc, stdoutWriter, stderrWriter, stdoutBuf, stderrBuf, stdin);
            results.setReturnCode(rc);
            proc = null;
            int captured = 0;
            if (Boolean.parseBoolean(captureOutputStreams)) {
                results.setStdout(((Object)stdoutBuf).toString());
                results.setStderr(((Object)stderrBuf).toString());
                captured = 1;
            } else if (VALUE_CAPTURE_OUTPUT_STREAMS_COMBINE.equals(captureOutputStreams)) {
                results.setStdout(((Object)stdoutBuf).toString());
                results.setStderr(null);
                captured = 2;
            }
            results.setOutputStreamsCaptured(captured);
            if (stdoutWriter != null) {
                stdoutWriter.flush();
                stdoutWriter.close();
            }
            if (stderrWriter != null && stderrWriter != stdoutWriter) {
                stderrWriter.flush();
                stderrWriter.close();
            }
            stderrWriter = null;
            stdoutWriter = null;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            if (proc != null) {
                proc.destroy();
            }
            if (stdoutWriter != null) {
                stdoutWriter.flush();
                stdoutWriter.close();
            }
            if (stderrWriter != null && stderrWriter != stdoutWriter) {
                stderrWriter.flush();
                stderrWriter.close();
            }
            String desc = null;
            if (e instanceof InterruptedException) {
                desc = msg.getString("Exception.ServiceFailedInterrupted.fmt.txt");
                desc = MessageFormat.format(desc, this.getName());
            } else {
                desc = msg.getString("Exception.ServiceFailedGeneric.fmt.txt");
                String param2 = e.getMessage();
                if (param2 == null) {
                    param2 = e.toString();
                }
                desc = MessageFormat.format(desc, this.getName(), param2);
            }
            ServiceFailedException sfe = new ServiceFailedException(desc, e);
            if (commandExecuted != null) {
                sfe.setCommandExecuted(commandExecuted);
            }
            throw sfe;
        }
        return results;
    }
}

