/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.service.standard;

import com.sas.dpro.common.ContainerContext;
import com.sas.dpro.common.FileList;
import com.sas.dpro.common.FileListImpl;
import com.sas.dpro.common.FileSet;
import com.sas.dpro.common.InvalidProviderNameException;
import com.sas.dpro.common.SerializableMap;
import com.sas.dpro.common.ServiceFailedException;
import com.sas.dpro.service.AbstractInternalService;
import com.sas.dpro.service.ServiceResults;
import com.sas.dpro.service.ServiceResultsImpl;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Logger;

public class Delete
extends AbstractInternalService {
    public static final String SERVICE_NAME = "Delete";
    public static final String PARAM_DIR = "dir";
    public static final String PARAM_FAIL_ON_ERROR = "failOnError";
    public static final String PARAM_FILE = "file";
    public static final String PARAM_FILELIST = "fileList";
    public static final String PARAM_FILESET = "fileSet";
    private static final String MSG = "com.sas.dpro.service.standard.Delete";
    private static final ResourceBundle msg = ResourceBundle.getBundle("com.sas.dpro.service.standard.Delete");

    public Delete() {
        super(SERVICE_NAME);
    }

    protected void deleteDirectory(ContainerContext container, List deletedFiles, String rootDir, String dirName, boolean failOnError) throws ServiceFailedException {
        File dir;
        if (".".equals(dirName)) {
            dirName = "";
        }
        if ((dir = Delete.getAbsoluteFile(container, dirName)).isFile()) {
            this.throwException("Exceptions.DirectoryIsFile.fmt.txt", dir);
        }
        if (dir.exists()) {
            File[] children = dir.listFiles();
            int count = dir == null ? 0 : children.length;
            for (int i = 0; i < count; ++i) {
                deletedFiles.addAll(this.handleDeleteFiles(children[i], rootDir, failOnError));
            }
            if (this.handleDeleteSingleFile(dir, failOnError)) {
                deletedFiles.add(Delete.getRelativePath(dir, rootDir));
            }
        } else if (failOnError) {
            this.throwException("Exceptions.DirectoryDoesNotExist.fmt.txt", dir);
        }
    }

    protected void deleteFileList(FileList fileList, List deletedFiles, String rootDir, boolean failOnError) throws ServiceFailedException {
        int count = fileList.getSize();
        for (int i = 0; i < count; ++i) {
            File file = new File(fileList.getAbsolute(i));
            if (!this.handleDeleteSingleFile(file, failOnError)) continue;
            deletedFiles.add(Delete.getRelativePath(file, rootDir));
        }
    }

    protected void deleteFileSet(FileSet fileSet, List deletedFiles, String rootDir, boolean failOnError) throws ServiceFailedException {
        try {
            this.deleteFileList(fileSet.getMatchingFiles(), deletedFiles, rootDir, failOnError);
        }
        catch (InvalidProviderNameException ipne) {
            throw new ServiceFailedException(ipne);
        }
        catch (RemoteException re) {
            throw new ServiceFailedException(re);
        }
    }

    public static final boolean deleteLocal(File path) {
        boolean success = false;
        if (path != null) {
            if (path.isDirectory()) {
                File[] children = path.listFiles();
                for (int i = 0; i < children.length; ++i) {
                    if (!(children[i].isDirectory() ? !Delete.deleteLocal(children[i]) : !(success = children[i].delete()))) continue;
                    return false;
                }
                success = path.delete();
            } else {
                success = path.exists() ? path.delete() : true;
            }
        }
        return success;
    }

    protected void deleteSingleFile(ContainerContext container, List deletedFiles, String rootDir, String fileName, boolean failOnError) throws ServiceFailedException {
        File file = Delete.getAbsoluteFile(container, fileName);
        if (file.isDirectory()) {
            this.throwException("Exceptions.FileIsDirectory.fmt.txt", file);
        }
        if (file.exists()) {
            if (this.handleDeleteSingleFile(file, failOnError)) {
                deletedFiles.add(Delete.getRelativePath(file, rootDir));
            }
        } else if (failOnError) {
            this.throwException("Exceptions.FileDoesNotExist.fmt.txt", file);
        }
    }

    private void ensureIsParentDir(String parent, String child) throws ServiceFailedException {
        try {
            parent = new File(parent).getCanonicalPath();
            child = new File(child).getCanonicalPath();
            if (child.indexOf(parent) != 0) {
                String desc = msg.getString("Exceptions.ItemNotInContainer.fmt.txt");
                desc = MessageFormat.format(desc, child, parent);
                throw new ServiceFailedException(desc);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static final String getRelativePath(File file, String root) {
        String path;
        int rootLength = root.length();
        if (rootLength == (path = file.getAbsolutePath()).length()) {
            return "";
        }
        char firstChar = path.charAt(rootLength);
        if (firstChar == '/' || firstChar == '\\') {
            ++rootLength;
        }
        return path.substring(rootLength);
    }

    protected List handleDeleteFiles(File file, String root, boolean failOnError) throws ServiceFailedException {
        ArrayList<String> deletedList = new ArrayList<String>();
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            int count = children.length;
            for (int i = 0; i < count; ++i) {
                deletedList.addAll(this.handleDeleteFiles(children[i], root, failOnError));
            }
            if (this.handleDeleteSingleFile(file, failOnError)) {
                deletedList.add(Delete.getRelativePath(file, root));
            }
        } else if (this.handleDeleteSingleFile(file, failOnError)) {
            deletedList.add(Delete.getRelativePath(file, root));
        }
        return deletedList;
    }

    private boolean handleDeleteSingleFile(File file, boolean failOnError) throws ServiceFailedException {
        boolean deleted = file.delete();
        if (!deleted && failOnError) {
            this.throwException("Exceptions.ErrorDeletingFile.fmt.txt", file);
        }
        return deleted;
    }

    @Override
    protected ServiceResults runServiceImpl(ContainerContext container, Logger logger) throws ServiceFailedException {
        SerializableMap params = this.getParameters();
        String fileName = (String)params.get(PARAM_FILE);
        String dirName = (String)params.get(PARAM_DIR);
        FileList fileList = (FileList)params.get(PARAM_FILELIST);
        FileSet fileSet = (FileSet)params.get(PARAM_FILESET);
        boolean failOnError = this.getBooleanParameter(PARAM_FAIL_ON_ERROR, true);
        ArrayList deletedFiles = new ArrayList();
        String rootDir = container.getDirectory();
        if (fileName != null) {
            fileName = Delete.getAbsoluteFile(container, fileName).getAbsolutePath();
            this.ensureIsParentDir(rootDir, fileName);
            this.deleteSingleFile(container, deletedFiles, rootDir, fileName, failOnError);
        } else if (dirName != null) {
            dirName = Delete.getAbsoluteFile(container, dirName).getAbsolutePath();
            this.ensureIsParentDir(rootDir, dirName);
            this.deleteDirectory(container, deletedFiles, rootDir, dirName, failOnError);
        } else if (fileList != null) {
            this.ensureIsParentDir(rootDir, fileList.getRoot());
            this.deleteFileList(fileList, deletedFiles, rootDir, failOnError);
        } else if (fileSet != null) {
            this.ensureIsParentDir(rootDir, fileSet.getRoot());
            this.deleteFileSet(fileSet, deletedFiles, rootDir, failOnError);
        }
        int rc = 0;
        ServiceResultsImpl results = new ServiceResultsImpl(this.createServiceInfo(), container, rc);
        FileListImpl fli = new FileListImpl(container.getDirectory(), this.getHost(), null);
        fli.add(deletedFiles);
        results.setOutputFiles(fli);
        return results;
    }

    private final void throwException(String key, File file) throws ServiceFailedException {
        String desc = msg.getString(key);
        desc = MessageFormat.format(desc, file.getAbsolutePath());
        throw new ServiceFailedException(desc);
    }
}

