/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.service.standard;

import com.sas.dpro.common.ContainerContext;
import com.sas.dpro.common.DProUtil;
import com.sas.dpro.common.FileContents;
import com.sas.dpro.common.FileContentsFactory;
import com.sas.dpro.common.FileList;
import com.sas.dpro.common.FileListImpl;
import com.sas.dpro.common.FileSet;
import com.sas.dpro.common.FileSetImpl;
import com.sas.dpro.common.FilterSet;
import com.sas.dpro.common.FilterSetUtil;
import com.sas.dpro.common.InvalidProviderNameException;
import com.sas.dpro.common.Mapper;
import com.sas.dpro.common.MapperUtil;
import com.sas.dpro.common.SerializableMap;
import com.sas.dpro.common.ServiceFailedException;
import com.sas.dpro.provider.Provider;
import com.sas.dpro.provider.ProviderFactory;
import com.sas.dpro.service.AbstractInternalService;
import com.sas.dpro.service.ServiceResults;
import com.sas.dpro.service.ServiceResultsImpl;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.channels.FileChannel;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import java.util.zip.CRC32;

public class Copy
extends AbstractInternalService {
    public static final String SERVICE_NAME = "Copy";
    public static final String PARAM_FAIL_IF_NO_EXIST = "failIfFilesDontExist";
    public static final String PARAM_FAIL_IF_NOTHING_TO_COPY = "failIfNothingToCopy";
    public static final String PARAM_FILTER_SET = "filterSet";
    public static final String PARAM_FROM_FILE = "fromFile";
    public static final String PARAM_FROM_FILELIST = "fromFileList";
    public static final String PARAM_FROM_FILESET = "fromFileSet";
    public static final String PARAM_FROM_RESULTS = "fromResults";
    public static final String PARAM_FROM_CONTAINER = "fromContainer";
    public static final String PARAM_IGNORE_PATHS = "ignorePaths";
    public static final String PARAM_MAPPERS = "mappers";
    public static final String PARAM_MOVE = "move";
    public static final String PARAM_TO_DIR = "toDir";
    public static final String PARAM_TO_FILE = "toFile";
    public static final String PARAM_TO_CONTAINER = "toContainer";
    private static final String BUNDLE = "com.sas.dpro.service.standard.Copy";
    private static final ResourceBundle msg = ResourceBundle.getBundle("com.sas.dpro.service.standard.Copy");
    private static final String PROPERTY_DEBUG = "com.sas.dpro.service.standard.Copy.debug";

    public Copy() {
        super(SERVICE_NAME);
    }

    protected String applyMappers(String fileName, Mapper[] mappers) throws ServiceFailedException {
        try {
            return MapperUtil.applyMappers(fileName, mappers);
        }
        catch (Exception e) {
            String desc = msg.getString("Error.ErrorApplyingMappers.fmt.txt");
            String text = e.getMessage();
            if (text == null) {
                text = e.toString();
            }
            desc = MessageFormat.format(desc, this.getName(), fileName, text);
            throw new ServiceFailedException(desc, e);
        }
    }

    private boolean checkExistence(boolean failIfFilesDontExist, File file) throws ServiceFailedException {
        boolean exists = file.isFile();
        if (!exists && failIfFilesDontExist) {
            String desc = msg.getString("Error.FileDoesNotExist2.fmt.txt");
            desc = MessageFormat.format(desc, this.getName(), file.getAbsolutePath());
            throw new ServiceFailedException(desc);
        }
        return exists;
    }

    public static void copyFromRemote(File toFile, Provider provider, String fromFile, boolean move) throws IOException, RemoteException {
        Copy.copyFromRemote(toFile, provider, fromFile, move, null);
    }

    public static void copyFromRemote(File toFile, Provider provider, String fromFile, boolean move, FilterSet[] filterSets) throws IOException, RemoteException {
        byte[] bytes = Copy.getRemoteFileContents(provider, fromFile, move, true);
        Copy._writeLocalFileImpl(bytes, toFile, filterSets);
    }

    public static void copyLocal(File toFile, File fromFile, boolean move) throws IOException {
        Copy.copyLocal(toFile, fromFile, move, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyLocal(File toFile, File fromFile, boolean move, FilterSet[] filterSets) throws IOException {
        if (!toFile.getCanonicalPath().equals(fromFile.getCanonicalPath())) {
            block14: {
                FileInputStream in = null;
                FileOutputStream out = null;
                int fsCount = filterSets == null ? 0 : filterSets.length;
                try {
                    if (fsCount == 0) {
                        if (!move || !fromFile.renameTo(toFile)) {
                            in = new FileInputStream(fromFile);
                            out = new FileOutputStream(toFile);
                            FileChannel inChan = in.getChannel();
                            FileChannel outChan = out.getChannel();
                            inChan.transferTo(0L, inChan.size(), outChan);
                        }
                        break block14;
                    }
                    in = new FileInputStream(fromFile);
                    out = new FileOutputStream(toFile);
                    BufferedReader r = new BufferedReader(new InputStreamReader(in));
                    PrintWriter w = new PrintWriter(new OutputStreamWriter(out));
                    try {
                        FilterSetUtil.applyFilters(r, w, filterSets);
                    }
                    finally {
                        w.close();
                        r.close();
                    }
                }
                finally {
                    if (out != null) {
                        out.close();
                    }
                    if (in != null) {
                        in.close();
                    }
                }
            }
            if (move) {
                fromFile.delete();
            }
        } else if (!fromFile.isFile()) {
            String desc = msg.getString("Error.FileDoesNotExist.fmt.txt");
            desc = MessageFormat.format(desc, fromFile.getAbsolutePath());
            throw new IOException(desc);
        }
    }

    public static int copyLocalDir(File toDir, File fromDir, boolean move, FilterSet[] filterSets) throws IOException {
        FileSetImpl fs = new FileSetImpl(fromDir.getAbsolutePath(), null);
        fs.addIncludePattern("**");
        return Copy.copyLocalDir(toDir, fs, move, filterSets);
    }

    public static int copyLocalDir(File toDir, FileSet fromFS, boolean move, FilterSet[] filterSets) throws IOException {
        if (!ProviderFactory.isLocalProvider(fromFS.getProvider())) {
            String desc = msg.getString("Error.FilesNotLocal.fmt.txt");
            desc = MessageFormat.format(desc, ProviderFactory.getLocalProviderName(), fromFS.getProvider());
            throw new IOException(desc);
        }
        FileList fl = null;
        try {
            fl = fromFS.getMatchingFiles();
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        toDir = toDir.getAbsoluteFile();
        for (int i = 0; i < fl.getSize(); ++i) {
            File toFile = new File(toDir, fl.get(i));
            File toParentDir = toFile.getParentFile();
            if (!toParentDir.isDirectory() && !toParentDir.mkdirs()) {
                String desc = msg.getString("Error.CreatingDir.fmt.txt");
                desc = MessageFormat.format(desc, toParentDir.getAbsolutePath());
                throw new IOException(desc);
            }
            File fromFile = new File(fl.getAbsolute(i));
            Copy.copyLocal(toFile, fromFile, move, filterSets);
        }
        return fl.getSize();
    }

    public static void copyToRemote(Provider provider, String toFile, File fromFile, boolean move) throws IOException, RemoteException {
        Copy.copyToRemote(provider, toFile, fromFile, move, null);
    }

    public static void copyToRemote(Provider provider, String toFile, File fromFile, boolean move, FilterSet[] filterSets) throws IOException, RemoteException {
        byte[] bytes = Copy.getLocalFileContents(fromFile);
        Copy._writeRemoteFileImpl(provider, toFile, false, fromFile.getName(), bytes, filterSets);
    }

    protected void _copySingleLocalFileImpl(File toFile, File fromFile, boolean delete, FilterSet[] filterSets) throws ServiceFailedException {
        Copy.debugPrint("... fromFile=" + fromFile.getAbsolutePath());
        Copy.debugPrint("... toFile=  " + toFile.getAbsolutePath());
        try {
            Copy.copyLocal(toFile, fromFile, delete, filterSets);
        }
        catch (IOException ioe) {
            String text = ioe.getMessage();
            if (text == null) {
                text = ioe.toString();
            }
            String key = "Error.ErrorWritingFile.fmt.txt";
            String desc = DProUtil.formatString(msg, key, this.getName(), toFile.getAbsolutePath(), text);
            throw new ServiceFailedException(desc, ioe);
        }
    }

    protected boolean _copySingleRemoteFileImpl(File toFile, Provider provider, String fromFile, boolean delete, FilterSet[] filterSets, boolean failIfFilesDontExist) throws ServiceFailedException {
        Copy.debugPrint("... fromFile=     " + fromFile);
        Copy.debugPrint("... toFile=       " + toFile.getAbsolutePath());
        byte[] fileBytes = null;
        try {
            fileBytes = Copy.getRemoteFileContents(provider, fromFile, delete, failIfFilesDontExist);
        }
        catch (RemoteException re) {
            String desc = msg.getString("Error.ErrorReadingRemoteFile.fmt.txt");
            String mess = re.getCause() != null ? re.getCause().getMessage() : re.getMessage();
            desc = MessageFormat.format(desc, this.getName(), fromFile, mess);
            throw new ServiceFailedException(desc, re.getCause());
        }
        catch (IOException ioe) {
            String desc = msg.getString("Error.ErrorReadingRemoteFile.fmt.txt");
            desc = MessageFormat.format(desc, this.getName(), fromFile, ioe.getMessage());
            throw new ServiceFailedException(desc, ioe);
        }
        if (fileBytes == null) {
            return false;
        }
        try {
            Copy._writeLocalFileImpl(fileBytes, toFile, filterSets);
        }
        catch (IOException ioe) {
            String text = ioe.getMessage();
            if (text == null) {
                text = ioe.toString();
            }
            String key = "Error.ErrorWritingFile.fmt.txt";
            String desc = DProUtil.formatString(msg, key, this.getName(), toFile.getAbsolutePath(), text);
            throw new ServiceFailedException(desc, ioe);
        }
        return true;
    }

    private static FileList _createFileList(ContainerContext container, String fromFile) throws Exception {
        FileListImpl list = new FileListImpl(container.getDirectory(), container.getProviderName(), null);
        list.add(fromFile);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _writeLocalFileImpl(byte[] fileBytes, File toFile, FilterSet[] filterSets) throws IOException {
        block10: {
            int fsCount;
            int n = fsCount = filterSets == null ? 0 : filterSets.length;
            if (fsCount > 0) {
                ByteArrayInputStream bais = new ByteArrayInputStream(fileBytes);
                InputStreamReader isr = new InputStreamReader(bais);
                try (BufferedReader r = new BufferedReader(isr);
                     PrintWriter w = new PrintWriter(new BufferedWriter(new FileWriter(toFile)));){
                    FilterSetUtil.applyFilters(r, w, filterSets);
                    break block10;
                }
            }
            try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(toFile));){
                out.write(fileBytes);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String _writeRemoteFileImpl(Provider provider, String toLoc, boolean isDirLocation, String fromFileName, byte[] fileBytes, FilterSet[] filterSets) throws IOException, RemoteException {
        int fsCount;
        int n = fsCount = filterSets == null ? 0 : filterSets.length;
        if (fsCount > 0) {
            try (BufferedReader r = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(fileBytes)));){
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try (PrintWriter w = new PrintWriter(new BufferedWriter(new OutputStreamWriter(baos)));){
                    FilterSetUtil.applyFilters(r, w, filterSets);
                    fileBytes = baos.toByteArray();
                }
            }
        }
        boolean compress = DProUtil.getShouldCompressFileOnTransfer(fromFileName, fileBytes.length);
        FileContents fc = FileContentsFactory.createFileContents(fileBytes, compress);
        String fileName = provider.putFile(toLoc, isDirLocation, fromFileName, fc);
        return fileName;
    }

    private static final void debugPrint(String text) {
        if (Boolean.getBoolean(PROPERTY_DEBUG)) {
            text = "[DEBUG Copy]: " + text;
            System.err.println(text);
        }
    }

    private FileList doLocalToLocalCopy(ContainerContext container, File toLoc, boolean isDirLocation, FileList fromFiles, boolean delete, boolean ignorePaths, FilterSet[] filterSets, Mapper[] mappers, boolean failIfFilesDontExist) throws ServiceFailedException {
        Copy.debugPrint("doLocalToLocalCopy: Entering");
        Copy.debugPrint("... toLoc=" + toLoc.getAbsolutePath());
        Copy.debugPrint("... isDirLocation=" + isDirLocation);
        Copy.debugPrint("... Files to copy: " + fromFiles.getSize());
        FileListImpl createdFiles = null;
        int fromFileCount = fromFiles.getSize();
        if (!isDirLocation) {
            createdFiles = new FileListImpl(toLoc.getParentFile().getAbsolutePath(), this.getHost(), null);
            File fromFile = new File(fromFiles.getAbsolute(0));
            if (this.checkExistence(failIfFilesDontExist, fromFile)) {
                this._copySingleLocalFileImpl(toLoc, fromFile, delete, filterSets);
                createdFiles.add(toLoc.getName());
            }
            Copy.debugPrint("doLocalToLocalCopy: Exiting");
            return createdFiles;
        }
        toLoc.mkdirs();
        createdFiles = new FileListImpl(toLoc.getAbsolutePath(), this.getHost(), null);
        boolean absolutePaths = fromFiles.getRoot() == null || ignorePaths;
        for (int i = 0; i < fromFileCount; ++i) {
            File fromFileFile = new File(fromFiles.getAbsolute(i));
            if (!this.checkExistence(failIfFilesDontExist, fromFileFile)) continue;
            String fileName = absolutePaths ? fromFiles.getName(i) : fromFiles.get(i);
            File toFile = new File(toLoc, fileName = this.applyMappers(fileName, mappers));
            File parent = toFile.getParentFile();
            if (parent != null) {
                parent.mkdirs();
            }
            this._copySingleLocalFileImpl(toFile, fromFileFile, delete, filterSets);
            createdFiles.add(fileName);
        }
        Copy.debugPrint("doLocalToLocalCopy: Exiting");
        return createdFiles;
    }

    private FileList doLocalToRemoteCopy(ContainerContext toContainer, String toLoc, boolean isDirLocation, FileList fromFiles, boolean delete, boolean ignorePaths, FilterSet[] filterSets, Mapper[] mappers, boolean failIfFilesDontExist) throws ServiceFailedException {
        Copy.debugPrint("doLocalToRemoteCopy: Entering");
        String remoteProviderName = toContainer.getProviderName();
        Provider remoteProvider = this.getProvider(remoteProviderName);
        Copy.debugPrint("... Copying to provider: " + remoteProviderName);
        Copy.debugPrint("... Copying to: " + toLoc);
        Copy.debugPrint("... Files to copy: " + fromFiles.getSize());
        FileListImpl createdFiles = null;
        try {
            toLoc = remoteProvider.getAbsoluteFilePath(toContainer, toLoc);
            int temp = Math.max(toLoc.lastIndexOf(47), toLoc.lastIndexOf(92));
            String root = toLoc.substring(0, temp);
            createdFiles = new FileListImpl(root, remoteProviderName, null);
        }
        catch (RemoteException re) {
            throw new ServiceFailedException(re);
        }
        boolean absolutePaths = fromFiles.getRoot() == null || ignorePaths;
        int fromFileCount = fromFiles.getSize();
        for (int i = 0; i < fromFileCount; ++i) {
            String oldFileName = absolutePaths ? fromFiles.getName(i) : fromFiles.get(i);
            oldFileName = this.applyMappers(oldFileName, mappers);
            File fromFile = new File(fromFiles.getAbsolute(i));
            Copy.debugPrint("... " + (i + 1) + ". Examining local file: " + fromFile.getAbsolutePath());
            if (this.checkExistence(failIfFilesDontExist, fromFile)) {
                byte[] fileBytes = null;
                try {
                    fileBytes = Copy.getLocalFileContents(fromFile);
                }
                catch (IOException ioe) {
                    String desc = msg.getString("Error.ErrorReadingFile.fmt.txt");
                    desc = MessageFormat.format(desc, this.getName(), fromFile.getAbsolutePath(), ioe.getMessage());
                    throw new ServiceFailedException(desc, ioe);
                }
                Copy.debugPrint("... ... Copying file to remote provider");
                try {
                    String fileName = Copy._writeRemoteFileImpl(remoteProvider, toLoc, isDirLocation, oldFileName, fileBytes, filterSets);
                    createdFiles.add(fileName);
                }
                catch (Exception e) {
                    throw new ServiceFailedException(e.getMessage(), e);
                }
                if (!delete) continue;
                fromFile.delete();
                continue;
            }
            Copy.debugPrint("... ... file does not exist; skipping");
        }
        Copy.debugPrint("doLocalToRemoteCopy: Exiting");
        return createdFiles;
    }

    private FileList doRemoteToLocalCopy(ContainerContext container, File toLoc, boolean isDirLocation, FileList fromFiles, boolean delete, boolean ignorePaths, FilterSet[] filterSets, Mapper[] mappers, boolean failIfFilesDontExist) throws ServiceFailedException {
        Copy.debugPrint("doRemoteToLocalCopy: Entering");
        FileListImpl createdFiles = null;
        int fromFileCount = fromFiles.getSize();
        String fromHost = fromFiles.getProvider();
        Provider provider = this.getProvider(fromHost);
        Copy.debugPrint("... fromProvider=" + fromHost);
        Copy.debugPrint("... toLoc=" + toLoc.getAbsolutePath());
        Copy.debugPrint("... isDirLocation=" + isDirLocation);
        Copy.debugPrint("... Files to copy: " + fromFiles.getSize());
        if (!isDirLocation) {
            createdFiles = new FileListImpl(toLoc.getParentFile().getAbsolutePath(), this.getHost(), null);
            boolean copied = this._copySingleRemoteFileImpl(toLoc, provider, fromFiles.getAbsolute(0), delete, filterSets, failIfFilesDontExist);
            if (copied) {
                createdFiles.add(toLoc.getName());
            }
            Copy.debugPrint("doRemoteToLocalCopy: Exiting");
            return createdFiles;
        }
        toLoc.mkdirs();
        createdFiles = new FileListImpl(toLoc.getAbsolutePath(), this.getHost(), null);
        boolean absolutePaths = fromFiles.getRoot() == null || ignorePaths;
        for (int i = 0; i < fromFileCount; ++i) {
            boolean copied;
            String fileName = absolutePaths ? fromFiles.getName(i) : fromFiles.get(i);
            File toFile = new File(toLoc, fileName = this.applyMappers(fileName, mappers));
            File parent = toFile.getParentFile();
            if (parent != null) {
                parent.mkdirs();
            }
            if (!(copied = this._copySingleRemoteFileImpl(toFile, provider, fromFiles.getAbsolute(i), delete, filterSets, failIfFilesDontExist))) continue;
            createdFiles.add(toFile.getName());
        }
        Copy.debugPrint("doRemoteToLocalCopy: Exiting");
        return createdFiles;
    }

    private static final byte[] getLocalFileContents(File file) throws IOException {
        int length = (int)file.length();
        BufferedInputStream bin = new BufferedInputStream(new FileInputStream(file));
        DataInputStream in = new DataInputStream(bin);
        byte[] bytes = new byte[length];
        in.readFully(bytes);
        in.close();
        return bytes;
    }

    private final Provider getProvider(String hostPort) throws ServiceFailedException {
        Provider provider = null;
        try {
            provider = ProviderFactory.getProvider(hostPort);
        }
        catch (InvalidProviderNameException ipne) {
            String desc = msg.getString("Error.Internal.InvalidProvider.fmt.txt");
            desc = MessageFormat.format(desc, this.getName(), ipne.toString());
            throw new ServiceFailedException(desc, ipne);
        }
        return provider;
    }

    private static final byte[] getRemoteFileContents(Provider provider, String file, boolean delete, boolean failIfFilesDontExist) throws RemoteException, IOException {
        FileContents fc = provider.getFile(file, delete, failIfFilesDontExist);
        if (fc == null) {
            return null;
        }
        byte[] contents = fc.getContents();
        if (fc.isCompressed()) {
            CRC32 crc32 = new CRC32();
            contents = FileContentsFactory.uncompressContents(contents, crc32);
            if (crc32.getValue() != fc.getUncompressedCRC32()) {
                String key = "Error.IncorrectCRC32.fmt.txt";
                String providerName = null;
                try {
                    providerName = provider.getProviderName();
                }
                catch (RemoteException re) {
                    providerName = "Unknown";
                }
                String desc = DProUtil.formatString(msg, key, new Object[]{SERVICE_NAME, file, providerName, "" + crc32.getValue(), "" + fc.getUncompressedCRC32()});
                throw new IOException(desc);
            }
        }
        return contents;
    }

    @Override
    protected ServiceResults runServiceImpl(ContainerContext container, Logger logger) throws ServiceFailedException {
        SerializableMap params = this.getParameters();
        String toDir = (String)params.get(PARAM_TO_DIR);
        String toFile = (String)params.get(PARAM_TO_FILE);
        ContainerContext toContainer = (ContainerContext)params.get(PARAM_TO_CONTAINER);
        String fromFile = (String)params.get(PARAM_FROM_FILE);
        FileList fromFileList = (FileList)params.get(PARAM_FROM_FILELIST);
        FileSet fromFileSet = (FileSet)params.get(PARAM_FROM_FILESET);
        ContainerContext fromContainer = (ContainerContext)params.get(PARAM_FROM_CONTAINER);
        boolean delete = this.getBooleanParameter(PARAM_MOVE, false);
        boolean ignorePaths = this.getBooleanParameter(PARAM_IGNORE_PATHS, false);
        FilterSet[] filterSets = (FilterSet[])params.get(PARAM_FILTER_SET);
        Mapper[] mappers = (Mapper[])params.get(PARAM_MAPPERS);
        boolean failIfFilesDontExist = this.getBooleanParameter(PARAM_FAIL_IF_NO_EXIST, true);
        boolean toLocal = toContainer == null || ProviderFactory.isLocalProvider(toContainer.getProviderName());
        boolean fromLocal = false;
        int fromFileCount = 0;
        if (fromFile != null) {
            if (fromContainer == null) {
                fromContainer = container;
            }
            try {
                fromLocal = ProviderFactory.isLocalProvider(fromContainer.getProviderName());
                fromFileList = Copy._createFileList(fromContainer, fromFile);
                fromFileCount = fromFileList.getSize();
            }
            catch (Exception e) {
                throw new ServiceFailedException(e);
            }
        }
        if (fromFileSet != null) {
            fromLocal = ProviderFactory.isLocalProvider(fromFileSet.getProvider());
            try {
                fromFileList = fromFileSet.getMatchingFiles();
            }
            catch (Exception e) {
                throw new ServiceFailedException(e);
            }
            fromFileCount = fromFileList.getSize();
            if (fromFileCount == 0 && this.getBooleanParameter(PARAM_FAIL_IF_NOTHING_TO_COPY, true)) {
                String desc = "Error.NothingToCopyFileSet.fmt.txt";
                desc = DProUtil.formatString(msg, desc, this.getName(), fromFileSet.getID());
                throw new ServiceFailedException(desc);
            }
        } else {
            fromLocal = ProviderFactory.isLocalProvider(fromFileList.getProvider());
            fromFileCount = fromFileList.getSize();
            if (fromFileCount == 0 && this.getBooleanParameter(PARAM_FAIL_IF_NOTHING_TO_COPY, true)) {
                String desc = "Error.NothingToCopyFileList.fmt.txt";
                desc = DProUtil.formatString(msg, desc, this.getName(), fromFileList.getID());
                throw new ServiceFailedException(desc);
            }
        }
        if (toFile != null && fromFileCount > 1) {
            String desc = msg.getString("Error.ToLocationNotDirectory.fmt.txt");
            desc = MessageFormat.format(desc, this.getName(), toFile);
            throw new ServiceFailedException(desc);
        }
        ServiceResultsImpl results = new ServiceResultsImpl(this.createServiceInfo(), container, 0);
        FileList outFiles = null;
        boolean isDirLocation = toDir != null;
        String toLocation = isDirLocation ? toDir : toFile;
        Copy.debugPrint("toDir:                " + toDir);
        Copy.debugPrint("toFile:               " + toFile);
        Copy.debugPrint("toContainer:          " + toContainer);
        Copy.debugPrint("fromFile:             " + fromFile);
        Copy.debugPrint("fromFileList:         " + fromFileList);
        Copy.debugPrint("fromFileSet:          " + fromFileSet);
        Copy.debugPrint("fromContainer:        " + fromContainer);
        Copy.debugPrint("delete:               " + delete);
        Copy.debugPrint("ignorePaths:          " + ignorePaths);
        Copy.debugPrint("failIfFilesDontExist: " + failIfFilesDontExist);
        Copy.debugPrint("fromLocal:            " + fromLocal);
        Copy.debugPrint("toLocal:              " + toLocal);
        Copy.debugPrint("files to copy:        " + fromFileList.getSize());
        for (int i = 0; i < fromFileList.getSize(); ++i) {
            Copy.debugPrint("... " + (i + 1) + ".                " + fromFileList.get(i));
        }
        if (toLocal) {
            File toLocationFile = Copy.getAbsoluteFile(toContainer != null ? toContainer : container, toLocation);
            outFiles = fromLocal ? this.doLocalToLocalCopy(container, toLocationFile, isDirLocation, fromFileList, delete, ignorePaths, filterSets, mappers, failIfFilesDontExist) : this.doRemoteToLocalCopy(container, toLocationFile, isDirLocation, fromFileList, delete, ignorePaths, filterSets, mappers, failIfFilesDontExist);
        } else if (fromLocal) {
            outFiles = this.doLocalToRemoteCopy(toContainer, toLocation, isDirLocation, fromFileList, delete, ignorePaths, filterSets, mappers, failIfFilesDontExist);
        } else {
            String desc = msg.getString("Error.RemoteToRemote.fmt.txt");
            desc = MessageFormat.format(desc, this.getName());
            throw new ServiceFailedException(desc);
        }
        results.setOutputFiles(outFiles);
        return results;
    }
}

