/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.service.standard;

import com.sas.dpro.common.ContainerContext;
import com.sas.dpro.common.DProUtil;
import com.sas.dpro.common.FileList;
import com.sas.dpro.common.FileSet;
import com.sas.dpro.common.ServiceFailedException;
import com.sas.dpro.service.AbstractInternalService;
import com.sas.dpro.service.ServiceResults;
import com.sas.dpro.service.ServiceResultsImpl;
import com.sas.dpro.service.standard.StandardServiceNames;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import java.util.zip.Adler32;
import java.util.zip.CRC32;

public class Checksum
extends AbstractInternalService
implements StandardServiceNames {
    public static final String SERVICE_NAME = "Checksum";
    public static final String ALGORITHM_ADLER32 = "ADLER-32";
    public static final String ALGORITHM_CRC32 = "CRC-32";
    public static final String ALGORITHM_MD2 = "MD2";
    public static final String ALGORITHM_MD5 = "MD5";
    public static final String ALGORITHM_SHA1 = "SHA-1";
    public static final String ALGORITHM_SHA256 = "SHA-256";
    public static final String ALGORITHM_SHA512 = "SHA-512";
    public static final String PARAM_ALGORITHM = "algorithm";
    public static final String PARAM_FILES = "_files";
    public static final String PARAM_FILES_MAKE_CHECKSUM_FILES = "_filesMakeChecksumFiles";
    public static final String PARAM_FILES_VAR_NAMES = "_filesVarNames";
    public static final String PARAM_FILE_LISTS = "_fileLists";
    public static final String PARAM_FILE_SETS = "_fileSets";
    public static final String PROPERTY_DEBUG_CHECKSUM = "com.sas.dpro.service.standard.Checksum.debug";
    private static final int DEFAULT_BUF_SIZE = 8192;
    private static final String MSG = "com.sas.dpro.service.standard.Checksum";
    private static ResourceBundle errorMsg;

    public Checksum() {
        super(SERVICE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDigestFile(File file, Charset cs, String digest) throws ServiceFailedException {
        PrintWriter w = null;
        try {
            w = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), cs)));
        }
        catch (IOException ioe) {
            ResourceBundle msg = Checksum.getErrorBundle();
            String key = "ErrorWritingFile.fmt.txt";
            String desc = DProUtil.formatString(msg, key, this.getName(), ioe.getMessage());
            throw new ServiceFailedException(desc);
        }
        try {
            w.println(digest);
        }
        finally {
            w.close();
        }
    }

    private static final void debugPrint(String text) {
        if (Boolean.getBoolean(PROPERTY_DEBUG_CHECKSUM)) {
            text = "[DEBUG Checksum]: " + text;
            System.err.println(text);
        }
    }

    private static synchronized ResourceBundle getErrorBundle() {
        if (errorMsg == null) {
            errorMsg = ResourceBundle.getBundle(MSG);
        }
        return errorMsg;
    }

    @Override
    protected ServiceResults runServiceImpl(ContainerContext container, Logger logger) throws ServiceFailedException {
        Checksum.debugPrint("Entering runServiceImpl");
        ServiceResultsImpl results = new ServiceResultsImpl(this.createServiceInfo(), container, 0);
        String alg = (String)this.getParameter(PARAM_ALGORITHM);
        if (alg == null) {
            ResourceBundle msg = Checksum.getErrorBundle();
            String key = "NoAlgorithmSpecified.fmt.txt";
            String desc = DProUtil.formatString(msg, key, this.getName());
            throw new ServiceFailedException(desc);
        }
        MessageDigest md = null;
        java.util.zip.Checksum checksum = null;
        if (ALGORITHM_ADLER32.equals(alg)) {
            checksum = new Adler32();
        } else if (ALGORITHM_CRC32.equals(alg)) {
            checksum = new CRC32();
        } else {
            try {
                md = MessageDigest.getInstance(alg);
            }
            catch (NoSuchAlgorithmException nsae) {
                ResourceBundle msg = Checksum.getErrorBundle();
                String key = "NoSuchAlgorithm.fmt.txt";
                String desc = DProUtil.formatString(msg, key, this.getName(), alg);
                throw new ServiceFailedException(desc);
            }
        }
        Checksum.debugPrint("Algorithm: " + alg);
        String outExt = '.' + alg;
        int bufSize = this.getFileIOBufferSize();
        if (bufSize == -1) {
            bufSize = 8192;
        }
        byte[] buf = new byte[bufSize];
        Charset cs = Charset.defaultCharset();
        StringBuilder stdout = new StringBuilder();
        String[] files = (String[])this.getParameter(PARAM_FILES);
        String[] filesMakeChecksumFiles = (String[])this.getParameter(PARAM_FILES_MAKE_CHECKSUM_FILES);
        String[] filesVarNames = (String[])this.getParameter(PARAM_FILES_VAR_NAMES);
        int count = files == null ? 0 : files.length;
        Checksum.debugPrint("Individual file count: " + count);
        for (int i = 0; i < count; ++i) {
            File f = this.getFileChecked(container, files[i]);
            Checksum.debugPrint("... " + (i + 1) + ". File: " + files[i]);
            long start = System.nanoTime();
            String digestStr = this.computeDigestString(f, checksum, md, buf);
            Checksum.debugPrint("... ... " + alg + " checksum: " + digestStr);
            long time = System.nanoTime() - start;
            Checksum.debugPrint("... ... ... time: " + DProUtil.nanosToSeconds(time));
            if (filesMakeChecksumFiles != null && filesMakeChecksumFiles.length > i && Boolean.parseBoolean(filesMakeChecksumFiles[i])) {
                String outputFileName = files[i] + outExt;
                File outFile = new File(container.getDirectory(), outputFileName);
                Checksum.debugPrint("... ... ... Creating digest file: " + outputFileName);
                this.createDigestFile(outFile, cs, digestStr);
                results.addOutputFile(outputFileName);
            }
            if (filesVarNames == null || filesVarNames.length <= i) continue;
            stdout.append(filesVarNames[i]).append('=').append(digestStr).append('\n');
        }
        FileList[] fileLists = (FileList[])this.getParameter(PARAM_FILE_LISTS);
        count = fileLists == null ? 0 : fileLists.length;
        Checksum.debugPrint("fileList count: " + count);
        for (int i = 0; i < count; ++i) {
            FileList fl = fileLists[i];
            int fileCount = fl.getSize();
            for (int j = 0; j < fileCount; ++j) {
                File f = this.getFileChecked(container, fl.get(j));
                Checksum.debugPrint("... " + (j + 1) + ". File: " + fl.get(j));
                long start = System.nanoTime();
                String digestStr = this.computeDigestString(f, checksum, md, buf);
                Checksum.debugPrint("... ... " + alg + " checksum: " + digestStr);
                long time = System.nanoTime() - start;
                Checksum.debugPrint("... ... ... time: " + DProUtil.nanosToSeconds(time));
                String outputFileName = fl.get(j) + outExt;
                File outFile = new File(container.getDirectory(), outputFileName);
                Checksum.debugPrint("... ... ... Creating digest file: " + outputFileName);
                this.createDigestFile(outFile, cs, digestStr);
                results.addOutputFile(outputFileName);
            }
        }
        FileSet[] fileSets = (FileSet[])this.getParameter(PARAM_FILE_SETS);
        count = fileSets == null ? 0 : fileSets.length;
        Checksum.debugPrint("fileSet count: " + count);
        for (int i = 0; i < count; ++i) {
            FileSet fs = fileSets[i];
            FileList fl = this.getMatchingFilesChecked(fs);
            int fileCount = fl.getSize();
            for (int j = 0; j < fileCount; ++j) {
                File f = this.getFileChecked(container, fl.get(j));
                Checksum.debugPrint("... " + (j + 1) + ". File: " + fl.get(j));
                long start = System.nanoTime();
                String digestStr = this.computeDigestString(f, checksum, md, buf);
                Checksum.debugPrint("... ... " + alg + " checksum: " + digestStr);
                long time = System.nanoTime() - start;
                Checksum.debugPrint("... ... ... time: " + DProUtil.nanosToSeconds(time));
                String outputFileName = fl.get(j) + outExt;
                File outFile = new File(container.getDirectory(), outputFileName);
                Checksum.debugPrint("... ... ... Creating digest file: " + outputFileName);
                this.createDigestFile(outFile, cs, digestStr);
                results.addOutputFile(outputFileName);
            }
        }
        Checksum.debugPrint("Exiting runServiceImpl");
        results.setStdout(stdout.toString());
        return results;
    }

    public static void computeChecksum(File f, java.util.zip.Checksum checksum) throws IOException {
        Checksum.computeChecksum(f, checksum, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void computeChecksum(File f, java.util.zip.Checksum checksum, byte[] buf) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(f));
        if (buf == null) {
            buf = new byte[8192];
        }
        try {
            int count = 0;
            while ((count = in.read(buf)) != -1) {
                checksum.update(buf, 0, count);
            }
        }
        finally {
            in.close();
        }
    }

    public static String computeChecksum(File f, MessageDigest md) throws IOException {
        return Checksum.computeChecksum(f, md, null);
    }

    public static String computeChecksum(File f, MessageDigest md, byte[] buf) throws IOException {
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(f));
        }
        catch (IOException ioe) {
            ResourceBundle msg = Checksum.getErrorBundle();
            String key = "ErrorReadingFile.fmt.txt";
            String desc = DProUtil.formatString(msg, key, SERVICE_NAME, ioe.getMessage());
            throw new IOException(desc);
        }
        if (buf == null) {
            buf = new byte[8192];
        }
        try {
            int b = 0;
            while ((b = in.read(buf)) != -1) {
                md.update(buf, 0, b);
            }
        }
        catch (IOException ioe) {
            ResourceBundle msg = Checksum.getErrorBundle();
            String key = "ErrorReadingFile.fmt.txt";
            String desc = DProUtil.formatString(msg, key, SERVICE_NAME, ioe.getMessage());
            throw new IOException(desc);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        byte[] digest = md.digest();
        StringBuilder hexString = new StringBuilder();
        for (int j = 0; j < digest.length; ++j) {
            int unsigned = 0xFF & digest[j];
            if (unsigned < 16) {
                hexString.append('0');
            }
            hexString.append(Integer.toHexString(unsigned));
        }
        return hexString.toString();
    }

    private String computeDigestString(File f, java.util.zip.Checksum checksum, MessageDigest md, byte[] buf) throws ServiceFailedException {
        String digestStr = null;
        try {
            if (checksum != null) {
                checksum.reset();
                Checksum.computeChecksum(f, checksum, buf);
                digestStr = "" + checksum.getValue();
            } else {
                md.reset();
                digestStr = Checksum.computeChecksum(f, md, buf);
            }
        }
        catch (IOException ioe) {
            throw new ServiceFailedException(ioe.getMessage());
        }
        return digestStr;
    }

    private File getFileChecked(ContainerContext cc, String fileName) throws ServiceFailedException {
        File f = new File(cc.getDirectory(), fileName);
        if (!f.isFile()) {
            ResourceBundle msg = Checksum.getErrorBundle();
            String key = "FileDoesNotExist.fmt.txt";
            String desc = DProUtil.formatString(msg, key, this.getName(), f.getAbsolutePath());
            throw new ServiceFailedException(desc);
        }
        return f;
    }

    private FileList getMatchingFilesChecked(FileSet fs) throws ServiceFailedException {
        try {
            return fs.getMatchingFiles();
        }
        catch (Exception e) {
            String text = e.getMessage();
            if (text == null) {
                text = e.toString();
            }
            ResourceBundle msg = Checksum.getErrorBundle();
            String key = "ErrorEvaluatingFileSet.fmt.txt";
            String desc = DProUtil.formatString(msg, key, this.getName(), fs.getID(), text);
            throw new ServiceFailedException(desc);
        }
    }

    public static boolean isSupportedAlgorithm(String algorithm) {
        boolean supported = false;
        if (algorithm != null) {
            if (ALGORITHM_ADLER32.equals(algorithm)) {
                supported = true;
            } else if (ALGORITHM_CRC32.equals(algorithm)) {
                supported = true;
            } else {
                try {
                    MessageDigest.getInstance(algorithm);
                    supported = true;
                }
                catch (NoSuchAlgorithmException nsae) {
                    supported = false;
                }
            }
        }
        return supported;
    }
}

