/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.service;

import com.sas.dpro.common.ContainerContext;
import com.sas.dpro.common.DirList;
import com.sas.dpro.common.FileList;
import com.sas.dpro.common.FileListImpl;
import com.sas.dpro.service.ServiceInfo;
import com.sas.dpro.service.ServiceResults;
import java.io.Serializable;

public class ServiceResultsImpl
implements ServiceResults,
Serializable {
    private int status;
    private ServiceInfo serviceInfo;
    private String commandExecuted;
    private int returnCode;
    private long time;
    private String containerContextID;
    private FileListImpl outputFiles;
    private DirList outputDirs;
    private int outputStreamsCaptured;
    private String stdout;
    private String stderr;
    private String formattedOutput;
    private String formattedResultsID;
    private boolean stderrRedirected;
    private String resultsID;
    private static final long serialVersionUID = 1L;

    public ServiceResultsImpl(ServiceInfo info, ContainerContext container) {
        this(info, container, 0);
    }

    public ServiceResultsImpl(ServiceInfo info, ContainerContext container, int rc) {
        this(info, container, null, rc);
    }

    public ServiceResultsImpl(ServiceInfo info, ContainerContext cc, FileListImpl fileList, int rc) {
        if (fileList == null) {
            fileList = new FileListImpl(cc.getDirectory(), cc.getProviderName(), null);
        }
        this.init(info, cc.getContractID(), fileList, rc);
        this.setStatus(0);
    }

    public ServiceResultsImpl(ServiceInfo info, String contID, FileListImpl fileList, int rc) {
        if (fileList == null) {
            throw new NullPointerException("fileList cannot be null");
        }
        this.init(info, contID, fileList, rc);
    }

    public void addOutputFile(String outputFile) {
        this.outputFiles.add(outputFile);
    }

    private void ensureValidStatus(int status) throws IllegalArgumentException {
        if (status != 0 && status != 1 && status != 2) {
            throw new IllegalArgumentException("" + status);
        }
    }

    @Override
    public String getCommandExecuted() {
        return this.commandExecuted;
    }

    @Override
    public String getContainerContextID() {
        return this.containerContextID;
    }

    @Override
    public String getFormattedOutput() {
        return this.formattedOutput;
    }

    @Override
    public String getFormattedResultsID() {
        return this.formattedResultsID;
    }

    @Override
    public DirList getOutputDirs() {
        return this.outputDirs;
    }

    @Override
    public FileList getOutputFiles() {
        return this.outputFiles;
    }

    @Override
    public int getOutputStreamsCaptured() {
        return this.outputStreamsCaptured;
    }

    @Override
    public String getResultsID() {
        return this.resultsID;
    }

    @Override
    public int getReturnCode() {
        return this.returnCode;
    }

    @Override
    public ServiceInfo getServiceInfo() {
        return this.serviceInfo;
    }

    @Override
    public String getServiceName() {
        return this.serviceInfo.getName();
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public String getStatusString() {
        String toReturn = null;
        switch (this.status) {
            case 0: {
                toReturn = "" + this.getReturnCode();
                break;
            }
            case 1: {
                toReturn = "failed";
                break;
            }
            case 2: {
                toReturn = "timedOut";
                break;
            }
            default: {
                throw new InternalError("Invalid status: " + this.status);
            }
        }
        return toReturn;
    }

    @Override
    public String getStderr() {
        return this.stderr;
    }

    @Override
    public boolean getStderrRedirected() {
        return this.stderrRedirected;
    }

    @Override
    public String getStdout() {
        return this.stdout;
    }

    @Override
    public long getTime() {
        return this.time;
    }

    private void init(ServiceInfo info, String contID, FileListImpl fileList, int rc) {
        this.setServiceInfo(info);
        this.setReturnCode(rc);
        this.setContainerContextID(contID);
        this.outputFiles = fileList;
        this.outputDirs = null;
        this.outputStreamsCaptured = 0;
        this.stderrRedirected = false;
    }

    public void setCommandExecuted(String command) {
        this.commandExecuted = command;
    }

    public void setContainerContextID(String id) {
        this.containerContextID = id;
    }

    public void setFormattedOutput(String output) {
        this.formattedOutput = output;
    }

    public void setFormattedResultsID(String id) {
        this.formattedResultsID = id;
    }

    public void setOutputDirs(DirList outputDirs) {
    }

    public void setOutputFiles(FileList outputFiles) {
        String id = outputFiles.getID();
        String provider = outputFiles.getProvider();
        String root = outputFiles.getRoot();
        this.outputFiles = new FileListImpl(root, provider, id);
        for (int i = 0; i < outputFiles.getSize(); ++i) {
            this.outputFiles.add(outputFiles.get(i));
        }
    }

    public void setOutputStreamsCaptured(int captured) {
        if (captured != 0 && captured != 2 && captured != 1) {
            throw new IllegalArgumentException();
        }
        this.outputStreamsCaptured = captured;
    }

    public void setResultsID(String resultsID) {
        this.resultsID = resultsID;
    }

    public void setReturnCode(int returnCode) {
        this.returnCode = returnCode;
    }

    public void setServiceInfo(ServiceInfo info) {
        if (info == null) {
            throw new NullPointerException("ServiceInfo cannot be null");
        }
        this.serviceInfo = info;
    }

    public void setStatus(int status) throws IllegalArgumentException {
        this.ensureValidStatus(status);
        this.status = status;
    }

    public void setStderr(String stderr) {
        this.stderr = stderr;
    }

    public void setStderrRedirected(boolean redirected) {
        this.stderrRedirected = redirected;
    }

    public void setStdout(String stdout) {
        this.stdout = stdout;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public String toString() {
        int outputFileCount = this.outputFiles == null ? 0 : this.outputFiles.getSize();
        int outputDirCount = this.outputDirs == null ? 0 : this.outputDirs.getSize();
        return "[ServiceResultsImpl: name=" + this.getServiceName() + "; status=" + this.getStatus() + "; resultsID=" + this.getResultsID() + "; time=" + this.getTime() + "; containerContextID=" + this.getContainerContextID() + "; outputFileCount=" + outputFileCount + "; outputDirCount=" + outputDirCount + "; outputStreamsCaptured=" + this.getOutputStreamsCaptured() + "; stdout=" + (this.getStdout() != null) + "; stderr=" + (this.getStderr() != null) + "; returnCode=" + this.getReturnCode() + "]";
    }
}

