/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.service;

import com.sas.dpro.common.DProEnvironment;
import com.sas.dpro.common.DProUtil;
import com.sas.dpro.common.FileParserBase;
import com.sas.dpro.service.ServiceFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class ServiceFileParser
extends FileParserBase {
    private ServiceFactory factory;
    private File serviceFile;
    private static final String MSG = "com.sas.dpro.service.ServiceFileParser";
    private static final String VAR_INSTALL_DIR = "${_installDir}";
    private static final String ARGS = "args";
    private static final String CHARSET = "characterSet";
    private static final String COMMAND = "command";
    private static final String DEFAULT_TIMEOUT = "defaultTimeout";
    private static final String DESCRIPTION = "description";
    private static final String ENVIRONMENT_VARS = "environmentVars";
    private static final String EXTERNAL_PROCESS_SERVICE = "ExternalProcessService";
    private static final String GROOVY_SCRIPT = "GroovyScriptService";
    private static final String KEYWORD = "keyword";
    private static final String KEYWORDS = "keywords";
    private static final String PARAM = "param";
    private static final String PARAMS = "params";
    private static final String ROOT_ELEMENT = "Services";
    private static final String SCRIPT_FILE = "scriptFile";
    private static final String PROPERTY_DEBUG = "com.sas.dpro.service.ServiceFileParser.debug";

    private ServiceFileParser(ServiceFactory factory, File serviceFile) {
        this.factory = factory;
        this.serviceFile = serviceFile;
    }

    private SAXBuilder createSAXBuilder() throws IOException {
        boolean validate = true;
        SAXBuilder builder = new SAXBuilder("org.apache.xerces.parsers.SAXParser", validate);
        if (validate) {
            builder.setFeature("http://apache.org/xml/features/validation/schema", true);
            builder.setEntityResolver((EntityResolver)new ServiceFileEntityResolver());
        }
        return builder;
    }

    private static ResourceBundle getBundle() {
        return ResourceBundle.getBundle(MSG);
    }

    @Override
    protected String getDebugHeader() {
        return "[ServiceFileParser]";
    }

    @Override
    protected String getDebugProperty() {
        return PROPERTY_DEBUG;
    }

    @Override
    protected File getXMLFile() {
        return this.serviceFile;
    }

    private void handleExternalProcessServiceNode(Element elem) throws IOException {
        String name = elem.getAttributeValue("name");
        if (!this.shouldLoad(elem, name = this.replaceVariables(name))) {
            return;
        }
        List argList = null;
        HashMap envVars = null;
        boolean appendEnvVars = true;
        HashMap params = new HashMap();
        StringBuilder keywords = new StringBuilder();
        String command = null;
        String desc = null;
        long defaultTimeout = 0L;
        Element child2 = elem.getChild(COMMAND);
        command = child2.getText();
        if (command == null || command.length() == 0 || command.startsWith("!unconfigured_") || command.startsWith("@unconfigured_")) {
            this.debugPrint("Skipping load of unconfigured service '" + name + "'");
            return;
        }
        command = ServiceFileParser.varSubstitute(command);
        command = this.replaceVariables(command);
        command = this.ensureAbsolute(command);
        for (Element child2 : elem.getChildren()) {
            String nodeName2 = child2.getName();
            if (ARGS.equals(nodeName2)) {
                argList = this.handleArgsNode(child2, command);
                continue;
            }
            if (COMMAND.equals(nodeName2)) continue;
            if (DEFAULT_TIMEOUT.equals(nodeName2)) {
                String value = child2.getText();
                if (value == null) continue;
                value = this.replaceVariables(value);
                try {
                    defaultTimeout = Long.parseLong(value);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new IOException("Invalid default timeout: " + value);
                }
            }
            if (DESCRIPTION.equals(nodeName2)) {
                desc = child2.getText();
                desc = this.replaceVariables(desc);
                continue;
            }
            if (ENVIRONMENT_VARS.equals(nodeName2)) {
                if (envVars == null) {
                    envVars = new HashMap(1);
                }
                appendEnvVars = this.handleEnvVarsNode(child2, envVars);
                continue;
            }
            if (KEYWORDS.equals(nodeName2)) {
                this.handleKeywordsNode(child2, keywords);
                continue;
            }
            if (!PARAMS.equals(nodeName2)) continue;
            this.handleParamsNode(child2, params, command);
        }
        if (name == null || command == null) {
            String temp = ServiceFileParser.getBundle().getString("Error.BadExternalProcessServiceDef.txt");
            throw new IOException(temp);
        }
        int argCount = argList == null ? 0 : argList.size();
        String[] argv = new String[argCount];
        if (argCount > 0) {
            argv = argList.toArray(argv);
        }
        if (keywords.length() > 1) {
            keywords.setLength(keywords.length() - 1);
        }
        this.debugPrint("Mapping Service '" + name + "' to '" + command + "'");
        this.factory.addServiceMapping(name, desc, false, defaultTimeout, null, new Object[]{name, command, argv}, envVars, appendEnvVars, params, keywords.toString());
    }

    private void handleGroovyServiceNode(Element elem) throws IOException {
        String name = elem.getAttributeValue("name");
        if (!this.shouldLoad(elem, name = this.replaceVariables(name))) {
            return;
        }
        List argList = null;
        HashMap envVars = null;
        boolean appendEnvVars = true;
        HashMap params = new HashMap();
        StringBuilder keywords = new StringBuilder();
        String scriptFile = null;
        String desc = null;
        long defaultTimeout = 0L;
        Element child2 = elem.getChild(SCRIPT_FILE);
        scriptFile = child2.getText();
        if (scriptFile == null || scriptFile.length() == 0 || scriptFile.startsWith("!unconfigured_") || scriptFile.startsWith("@unconfigured_")) {
            this.debugPrint("Skipping load of unconfigured service '" + name + "'");
            return;
        }
        scriptFile = ServiceFileParser.varSubstitute(scriptFile);
        scriptFile = this.replaceVariables(scriptFile);
        scriptFile = this.ensureAbsolute(scriptFile);
        String csName = child2.getAttributeValue(CHARSET);
        Charset cs = null;
        if (csName == null || "default".equals(csName)) {
            cs = Charset.defaultCharset();
        } else {
            try {
                cs = Charset.forName(csName);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IOException(e.getMessage());
            }
        }
        for (Element child2 : elem.getChildren()) {
            String nodeName2 = child2.getName();
            if (ARGS.equals(nodeName2)) {
                argList = this.handleArgsNode(child2, scriptFile);
                continue;
            }
            if (SCRIPT_FILE.equals(nodeName2)) continue;
            if (DEFAULT_TIMEOUT.equals(nodeName2)) {
                String value = child2.getText();
                if (value == null) continue;
                value = this.replaceVariables(value);
                try {
                    defaultTimeout = Long.parseLong(value);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new IOException("Invalid default timeout: " + value);
                }
            }
            if (DESCRIPTION.equals(nodeName2)) {
                desc = child2.getText();
                desc = this.replaceVariables(desc);
                continue;
            }
            if (ENVIRONMENT_VARS.equals(nodeName2)) {
                if (envVars == null) {
                    envVars = new HashMap(1);
                }
                appendEnvVars = this.handleEnvVarsNode(child2, envVars);
                continue;
            }
            if (KEYWORDS.equals(nodeName2)) {
                this.handleKeywordsNode(child2, keywords);
                continue;
            }
            if (!PARAMS.equals(nodeName2)) continue;
            this.handleParamsNode(child2, params, scriptFile);
        }
        if (name == null || scriptFile == null || cs == null) {
            String temp = ServiceFileParser.getBundle().getString("Error.BadExternalProcessServiceDef.txt");
            throw new IOException(temp);
        }
        int argCount = argList == null ? 0 : argList.size();
        String[] argv = new String[argCount];
        if (argCount > 0) {
            argv = argList.toArray(argv);
        }
        if (keywords.length() > 1) {
            keywords.setLength(keywords.length() - 1);
        }
        this.debugPrint("Mapping Service '" + name + "' to '" + scriptFile + "' (" + cs.displayName() + ")");
        this.factory.addServiceMapping(name, desc, false, defaultTimeout, "com.sas.dpro.service.standard.GroovyScript", new Object[]{name, scriptFile, cs, argv}, envVars, appendEnvVars, params, keywords.toString());
    }

    private void handleKeywordsNode(Element elem, StringBuilder keywords) {
        for (Element child : elem.getChildren()) {
            String nodeName = child.getName();
            if (!KEYWORD.equals(nodeName)) continue;
            String keyword = child.getText();
            keyword = this.replaceVariables(keyword);
            keywords.append(keyword).append(';');
        }
    }

    private void handleParamsNode(Element elem, Map params, String command) throws IOException {
        for (Element child : elem.getChildren()) {
            String childName = child.getName();
            if (!PARAM.equals(childName)) continue;
            String name = child.getAttributeValue("name");
            name = this.replaceVariables(name);
            String value = child.getText();
            value = this.replaceVariables(value);
            String type = child.getAttributeValue("type");
            if (type == null) {
                type = "text";
            }
            if ("location".equals(type = this.replaceVariables(type))) {
                String origValue = value;
                String relativeTo = child.getAttributeValue("relativeTo");
                if (relativeTo == null) {
                    relativeTo = "this";
                }
                File newParamFile = null;
                if ("this".equals(relativeTo)) {
                    File parentDir = this.getXMLFile().getParentFile();
                    newParamFile = new File(parentDir, value);
                } else if (COMMAND.equals(relativeTo)) {
                    File commandDir = new File(command).getParentFile();
                    newParamFile = new File(commandDir, value);
                } else {
                    throw new IOException("Invalid 'relativeTo' for 'param': " + relativeTo);
                }
                try {
                    value = newParamFile.getCanonicalPath();
                }
                catch (IOException ioe) {
                    value = newParamFile.getAbsolutePath();
                    value = DProUtil.fixSlashes(value);
                }
                this.debugPrint("... param (relative to: " + relativeTo + "): \"" + origValue + "\" => \"" + value + "\"");
            } else if ("text".equals(type)) {
                this.debugPrint("... param: \"" + value + "\"");
            } else {
                throw new IOException("Invalid 'type' for 'param': " + type);
            }
            params.put(name, value);
        }
    }

    static void parse(ServiceFactory factory, String serviceFile) throws IOException {
        File file = new File(serviceFile);
        ServiceFileParser parser = new ServiceFileParser(factory, file);
        parser.handleParse();
    }

    private void handleParse() throws IOException {
        SAXBuilder builder = this.createSAXBuilder();
        Document doc = null;
        try {
            doc = builder.build(this.serviceFile);
        }
        catch (JDOMException je) {
            je.printStackTrace();
            throw new IOException(je.getMessage());
        }
        Element root = doc.getRootElement();
        if (!ROOT_ELEMENT.equals(root.getName())) {
            String desc = ServiceFileParser.getBundle().getString("Error.UnknownElement.fmt.txt");
            desc = MessageFormat.format(desc, root.getName());
            throw new IOException(desc);
        }
        String version = root.getAttributeValue("version");
        if (version == null || !"1.0".equals(version)) {
            String desc = ServiceFileParser.getBundle().getString("Error.UnsupportedVersion.fmt.txt");
            desc = MessageFormat.format(desc, version);
            throw new IOException(desc);
        }
        for (Element child : root.getChildren()) {
            String nodeName = child.getName();
            if ("loadPropertiesFile".equals(nodeName)) {
                this.handlePropertiesFileNode(child);
                continue;
            }
            if (EXTERNAL_PROCESS_SERVICE.equals(nodeName)) {
                this.handleExternalProcessServiceNode(child);
                continue;
            }
            if (GROOVY_SCRIPT.equals(nodeName)) {
                this.handleGroovyServiceNode(child);
                continue;
            }
            String desc = ServiceFileParser.getBundle().getString("Error.UnknownElement.fmt.txt");
            desc = MessageFormat.format(desc, nodeName);
            throw new IOException(desc);
        }
    }

    private static final String varSubstitute(String text) {
        int i = 0;
        while ((i = text.indexOf(VAR_INSTALL_DIR)) > -1) {
            text = text.substring(0, i) + DProEnvironment.getInstallDirectory() + File.separator + text.substring(i + VAR_INSTALL_DIR.length());
            i += DProEnvironment.getInstallDirectory().length();
        }
        return text;
    }

    private static final class ServiceFileEntityResolver
    implements EntityResolver {
        private static final String SCHEMA_NAME_1_5 = "com/sas/schema/services-1.5.xsd";
        private static final String SYSTEM_ID_1_5 = "http://www.sas.com/xml/schema/dpro/services-1.5.xsd";
        private static final String SCHEMA_NAME_1_6 = "com/sas/schema/services-1.6.xsd";
        private static final String SYSTEM_ID_1_6 = "http://www.sas.com/xml/schema/dpro/services-1.6.xsd";

        private ServiceFileEntityResolver() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            InputSource retval = null;
            if (SYSTEM_ID_1_6.equals(systemId)) {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                InputStream stream = cl.getResourceAsStream(SCHEMA_NAME_1_6);
                retval = new InputSource(stream);
            } else if (SYSTEM_ID_1_5.equals(systemId)) {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                InputStream stream = cl.getResourceAsStream(SCHEMA_NAME_1_5);
                retval = new InputSource(stream);
            }
            return retval;
        }
    }
}

