/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.service;

import com.sas.dpro.common.ContainerContext;
import com.sas.dpro.common.DProUtil;
import com.sas.dpro.common.SerializableMap;
import com.sas.dpro.common.ServiceFailedException;
import com.sas.dpro.provider.ProviderFactory;
import com.sas.dpro.service.DProService;
import com.sas.dpro.service.ServiceInfo;
import com.sas.dpro.service.ServiceInfoImpl;
import com.sas.dpro.service.ServiceParms;
import com.sas.dpro.service.ServiceResults;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ResourceBundle;
import java.util.logging.Logger;

public abstract class AbstractService
implements DProService {
    private String name;
    private String description;
    private long defaultTimeout;
    private ServiceParms serviceParms;
    private String host;
    private String keywords;
    private int fileIOBufferSize;
    private static final String ERROR_MSG = "com.sas.dpro.service.AbstractService";

    public AbstractService(String name) {
        if (name == null) {
            throw new NullPointerException("Service names cannot be null");
        }
        this.name = name;
        this.serviceParms = null;
        this.setDefaultTimeout(0L);
        this.setFileIOBufferSize(-1);
    }

    @Override
    public void addParameter(Object key, Object value) {
        this.serviceParms.getParams().put(key, value);
    }

    @Override
    public ServiceInfo createServiceInfo() {
        ServiceInfoImpl info = new ServiceInfoImpl(this.getName(), this.getDescription(), this.getDefaultTimeout(), this.getHost(), this.getKeywords());
        info.setCommand(this.getCommand());
        info.setHost(ProviderFactory.getLocalProviderName());
        info.setIsInternalService(this.isInternalService());
        return info;
    }

    protected static File getAbsoluteFile(ContainerContext container, String path) {
        File temp;
        if (".".equals(path)) {
            path = "";
        }
        if (!(temp = new File(path)).isAbsolute()) {
            temp = new File(container.getDirectory(), path);
        }
        return temp;
    }

    protected boolean getBooleanParameter(String key, boolean defaultVal) {
        boolean val = defaultVal;
        String param = (String)this.getParameter(key);
        if (param != null) {
            val = (param = param.trim().toLowerCase()).equals("true") || param.equals("yes") || param.equals("t") || param.equals("y");
        }
        return val;
    }

    @Override
    public long getDefaultTimeout() {
        return this.defaultTimeout;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public int getFileIOBufferSize() {
        return this.fileIOBufferSize;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public String getKeywords() {
        return this.keywords;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object getParameter(Object key) {
        return this.serviceParms.getParams().get(key);
    }

    @Override
    public SerializableMap getParameters() {
        return this.serviceParms.getParams();
    }

    protected Charset getCharsetSpecified(String param) throws ServiceFailedException {
        String charset = (String)this.getParameter(param);
        Charset cs = null;
        if (charset != null && ("UTF-8BOM".equalsIgnoreCase(charset) || "UTF8BOM".equalsIgnoreCase(charset))) {
            charset = "UTF-8";
        }
        if (charset == null || charset.equals("default")) {
            cs = Charset.defaultCharset();
        } else {
            try {
                cs = Charset.forName(charset);
            }
            catch (IllegalCharsetNameException e) {
                ResourceBundle msg = ResourceBundle.getBundle(ERROR_MSG);
                String key = "Error.IllegalCharsetName.fmt.txt";
                String desc = DProUtil.formatString(msg, key, this.getName(), param, charset);
                throw new ServiceFailedException(desc, e);
            }
            catch (UnsupportedCharsetException uce) {
                ResourceBundle msg = ResourceBundle.getBundle(ERROR_MSG);
                String key = "Error.UnsupportedCharset.fmt.txt";
                String desc = DProUtil.formatString(msg, key, this.getName(), param, charset);
                throw new ServiceFailedException(desc, uce);
            }
        }
        return cs;
    }

    @Override
    public boolean matchesKeyword(String keyword) {
        String keywords;
        boolean found = false;
        if (keyword != null && (keywords = this.getKeywords()) != null) {
            String[] keywordArray = keywords.split(";");
            for (int i = 0; i < keywordArray.length; ++i) {
                if (!keyword.equals(keywordArray[i])) continue;
                found = true;
                break;
            }
        }
        return found;
    }

    @Override
    public ServiceResults runService(ContainerContext container, Logger logger) throws ServiceFailedException {
        try {
            return this.runServiceImpl(container, logger);
        }
        catch (ServiceFailedException e) {
            throw e;
        }
        catch (Exception e) {
            String text = e.toString();
            String key = "Error.UnhandledException.fmt.txt";
            ResourceBundle msg = ResourceBundle.getBundle(ERROR_MSG);
            String desc = DProUtil.formatString(msg, key, this.getName(), text);
            throw new ServiceFailedException(desc, e);
        }
    }

    protected abstract ServiceResults runServiceImpl(ContainerContext var1, Logger var2) throws ServiceFailedException;

    @Override
    public void setDefaultTimeout(long defaultTimeout) {
        this.defaultTimeout = defaultTimeout;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void setFileIOBufferSize(int size) {
        this.fileIOBufferSize = size < -1 ? -1 : size;
    }

    @Override
    public void setHost(String host) {
        this.host = host;
    }

    @Override
    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    @Override
    public void setParameters(ServiceParms serviceParms) {
        this.serviceParms = serviceParms;
    }

    public String toString() {
        return "[" + this.getName() + ": host=" + this.getHost() + "; command=" + this.getCommand() + "; internal=" + this.isInternalService() + "; defaultTimeout=" + this.getDefaultTimeout() + "]";
    }
}

