/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.results.testing;

import com.sas.dpro.common.DProUtil;
import com.sas.dpro.common.XmlUtil;
import com.sas.dpro.formatter.FormatterWritable;
import com.sas.dpro.results.CommandResults;
import com.sas.dpro.results.CommandResultsImpl;
import com.sas.dpro.results.InvalidResultFileException;
import com.sas.dpro.results.testing.AssociatedFile;
import com.sas.dpro.results.testing.ResultBase;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TestResult
extends ResultBase
implements FormatterWritable {
    public static final int RESULT_PASS = 0;
    public static final int RESULT_FAIL = 1;
    public static final int RESULT_ERROR = 2;
    public static final int RESULT_TIMEOUT = 3;
    public static final int RESULT_WARNING = 4;
    private int result;
    private List commands;
    private String rc;
    private String expectedRCs;
    private String warningRCs;
    private String resultDesc;
    private List associatedFiles;
    private static final String[] RESULT_STRINGS = new String[]{"pass", "fail", "error", "timeout", "warning"};
    private static final String MSG = "com.sas.dpro.results.testing.TestResult";
    private static final String COMMANDS = "commands";
    private static final String COMMAND = "command";
    private static final String ERROR_DESC = "errorDesc";
    private static final String EXPECTED = "expected";
    private static final String FILES = "files";
    private static final String ITEM = "item";
    private static final String NAME = "name";
    private static final String RC = "rc";
    private static final String RESULT = "result";
    private static final String STDERR = "stderr";
    private static final String STDOUT = "stdout";
    private static final String TEST_DESC = "testDesc";
    private static final String TEST_RESULT = "testResult";
    private static final String TIME = "time";
    private static final String VALUE = "value";
    private static final String WARNING = "warning";
    private static final long serialVersionUID = 1L;

    public TestResult(String name) {
        this.setName(name);
        this.setExpectedRCs("-");
        this.commands = new ArrayList(1);
        this.associatedFiles = new ArrayList();
    }

    public void addAssociatedFile(AssociatedFile file) {
        if (file == null) {
            throw new NullPointerException("file cannot be null");
        }
        this.associatedFiles.add(file);
    }

    public void addAssociatedFile(String type, String desc, String name) {
        this.addAssociatedFile(new AssociatedFile(type, desc, name));
    }

    public void addCommand(CommandResults cr) {
        this.commands.add(cr);
    }

    public CommandResults getCommand(int index) {
        return (CommandResults)this.commands.get(index);
    }

    public int getAssociatedFileCount() {
        return this.associatedFiles.size();
    }

    public AssociatedFile getAssociatedFile(int index) {
        return (AssociatedFile)this.associatedFiles.get(index);
    }

    public int getCommandCount() {
        return this.commands.size();
    }

    public String getExpectedRCs() {
        return this.expectedRCs;
    }

    public String getRC() {
        return this.rc;
    }

    public int getResult() {
        return this.result;
    }

    public String getResultDescription() {
        return this.resultDesc;
    }

    public String getResultString() {
        return RESULT_STRINGS[this.getResult()];
    }

    public String getWarningRCs() {
        return this.warningRCs;
    }

    @Override
    public void read(Document doc, Element elem) throws InvalidResultFileException {
        this.setName(elem.getAttribute(NAME));
        String res = elem.getAttribute(RESULT);
        if (RESULT_STRINGS[0].equals(res)) {
            this.setResult(0);
        } else if (RESULT_STRINGS[1].equals(res)) {
            this.setResult(1);
        } else if (RESULT_STRINGS[2].equals(res)) {
            this.setResult(2);
        } else if (RESULT_STRINGS[3].equals(res)) {
            this.setResult(3);
        } else if (RESULT_STRINGS[4].equals(res)) {
            this.setResult(4);
        } else {
            ResourceBundle msg = ResourceBundle.getBundle(MSG);
            String desc = msg.getString("Error.InvalidResult.fmt.txt");
            desc = MessageFormat.format(desc, res);
            throw new InvalidResultFileException(desc);
        }
        try {
            this.setTime(Long.parseLong(elem.getAttribute(TIME)));
        }
        catch (NumberFormatException msg) {
            // empty catch block
        }
        NodeList childNodes = elem.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            int j;
            Node child = childNodes.item(i);
            if (!(child instanceof Element)) continue;
            elem = (Element)child;
            String elemName = elem.getNodeName();
            if (RC.equals(elemName)) {
                this.setRC(elem.getAttribute(VALUE));
                this.setExpectedRCs(elem.getAttribute(EXPECTED));
                String warning = elem.getAttribute(WARNING);
                if (warning.length() <= 0) continue;
                this.setWarningRCs(warning);
                continue;
            }
            if (FILES.equals(elemName)) {
                NodeList fileElemList = elem.getElementsByTagName("file");
                for (j = 0; j < fileElemList.getLength(); ++j) {
                    elem = (Element)fileElemList.item(j);
                    AssociatedFile file = new AssociatedFile();
                    file.read(doc, elem);
                    this.addAssociatedFile(file);
                }
                continue;
            }
            if (TEST_DESC.equals(elemName)) {
                String testDesc = XmlUtil.getAllChildText(elem);
                this.setDescription(testDesc);
                continue;
            }
            if (COMMANDS.equals(elemName)) {
                NodeList cmdElemList = elem.getElementsByTagName(ITEM);
                for (j = 0; j < cmdElemList.getLength(); ++j) {
                    elem = (Element)cmdElemList.item(j);
                    NodeList temp = elem.getElementsByTagName(COMMAND);
                    if (temp.getLength() != 1) {
                        ResourceBundle msg = ResourceBundle.getBundle(MSG);
                        String key = "Error.CommandCount.fmt.txt";
                        String desc = DProUtil.formatString(msg, key, "" + temp.getLength());
                        throw new InvalidResultFileException(desc);
                    }
                    Element cmdElem = (Element)temp.item(0);
                    String cmd = XmlUtil.getAllChildText(cmdElem);
                    CommandResultsImpl cr = new CommandResultsImpl(cmd);
                    temp = elem.getElementsByTagName(RC);
                    if (temp.getLength() > 0) {
                        Element rcElem = (Element)temp.item(0);
                        String rc = rcElem.getAttribute(VALUE);
                        cr.setRC(rc);
                        String expectedRC = null;
                        Attr expectedAttr = rcElem.getAttributeNode(EXPECTED);
                        if (expectedAttr != null) {
                            expectedRC = expectedAttr.getValue();
                        }
                        cr.setExpectedRC(expectedRC);
                    }
                    if ((temp = elem.getElementsByTagName(TIME)).getLength() > 0) {
                        Element timeElem = (Element)temp.item(0);
                        String timeStr = XmlUtil.getAllChildText(timeElem);
                        try {
                            long time = Long.parseLong(timeStr);
                            cr.setTime(time);
                        }
                        catch (NumberFormatException nfe) {
                            ResourceBundle msg = ResourceBundle.getBundle(MSG);
                            String key = "Error.InvalidTime.fmt.txt";
                            String desc = DProUtil.formatString(msg, key, timeStr);
                            throw new InvalidResultFileException(desc);
                        }
                    }
                    this.addCommand(cr);
                }
                continue;
            }
            if (ERROR_DESC.equals(elemName)) {
                String errorDesc = XmlUtil.getAllChildText(elem);
                this.setResultDescription(errorDesc);
                continue;
            }
            if (STDOUT.equals(elemName)) {
                String stdout = XmlUtil.getAllChildText(elem);
                this.setStdout(stdout);
                continue;
            }
            if (!STDERR.equals(elemName)) continue;
            String stderr = XmlUtil.getAllChildText(elem);
            this.setStderr(stderr);
        }
    }

    public void setExpectedRCs(String expectedRC) {
        this.expectedRCs = expectedRC;
    }

    public void setRC(int rc) {
        this.setRC(Integer.toString(rc));
    }

    public void setRC(String rc) {
        this.rc = rc;
    }

    public void setResult(int result) {
        this.result = result;
    }

    public void setResultDescription(String resultDescription) {
        this.resultDesc = resultDescription;
    }

    public void setWarningRCs(String warningRCs) {
        this.warningRCs = warningRCs;
    }

    @Override
    public void write(Document doc, Element root) {
        int i;
        Element elem = doc.createElement(TEST_RESULT);
        elem.setAttribute(NAME, this.getName());
        if (this.getTime() != -1L) {
            elem.setAttribute(TIME, "" + this.getTime());
        }
        elem.setAttribute(RESULT, this.getResultString());
        Element rcElem = doc.createElement(RC);
        rcElem.setAttribute(VALUE, this.getRC());
        rcElem.setAttribute(EXPECTED, this.getExpectedRCs());
        rcElem.setAttribute(WARNING, this.getWarningRCs());
        elem.appendChild(rcElem);
        Element filesElem = doc.createElement(FILES);
        if (this.getAssociatedFileCount() > 0) {
            int count = this.getAssociatedFileCount();
            for (i = 0; i < count; ++i) {
                AssociatedFile file = this.getAssociatedFile(i);
                file.write(doc, filesElem);
            }
        }
        elem.appendChild(filesElem);
        XmlUtil.addTagWithTextContent(doc, elem, TEST_DESC, this.getDescription());
        XmlUtil.addTagWithTextContent(doc, elem, ERROR_DESC, this.getResultDescription());
        XmlUtil.addTagWithTextContent(doc, elem, STDOUT, this.getStdout());
        XmlUtil.addTagWithTextContent(doc, elem, STDERR, this.getStderr());
        Element commandsElem = doc.createElement(COMMANDS);
        for (i = 0; i < this.getCommandCount(); ++i) {
            CommandResults cr = this.getCommand(i);
            Element itemElem = doc.createElement(ITEM);
            XmlUtil.addTagWithTextContent(doc, itemElem, COMMAND, cr.getCommand());
            rcElem = doc.createElement(RC);
            rcElem.setAttribute(VALUE, cr.getRC());
            rcElem.setAttribute(EXPECTED, cr.getExpectedRC());
            itemElem.appendChild(rcElem);
            commandsElem.appendChild(itemElem);
        }
        elem.appendChild(commandsElem);
        root.appendChild(elem);
    }

    @Override
    public String getRootElementName() {
        return TEST_RESULT;
    }
}

