/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.results.testing;

import com.sas.dpro.common.XmlUtil;
import com.sas.dpro.formatter.FormatterWritable;
import com.sas.dpro.results.InvalidResultFileException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AssociatedFile
implements FormatterWritable {
    public static final String ROOT_ELEM_NAME = "file";
    private String type;
    private String desc;
    private String name;
    private boolean onlyIfInResults;
    private boolean locRelativeToResults;
    private static final String DESC = "desc";
    private static final String LOC_RELATIVE_TO_RESULTS = "locRelativeToResults";
    private static final String NAME = "name";
    private static final String ONLY_IF_IN_RESULTS = "onlyIfInResults";
    private static final String TYPE = "type";

    public AssociatedFile() {
        this(null, null, null);
    }

    public AssociatedFile(String type, String desc, String name) {
        this.type = type;
        this.desc = desc;
        this.name = name;
        this.setOnlyIfInResults(false);
    }

    public String getDescription() {
        return this.desc;
    }

    public String getName() {
        return this.name;
    }

    public boolean getOnlyIfInResults() {
        return this.onlyIfInResults;
    }

    @Override
    public String getRootElementName() {
        return ROOT_ELEM_NAME;
    }

    public String getType() {
        return this.type;
    }

    public boolean isLocationRelativeToResultsOutput() {
        return this.locRelativeToResults;
    }

    @Override
    public void read(Document doc, Element root) throws InvalidResultFileException {
        this.type = root.getAttribute(TYPE);
        this.onlyIfInResults = Boolean.parseBoolean(root.getAttribute(ONLY_IF_IN_RESULTS));
        this.desc = null;
        NodeList temp = root.getElementsByTagName(DESC);
        if (temp.getLength() > 0) {
            this.desc = XmlUtil.getAllChildText((Element)temp.item(0));
        }
        this.locRelativeToResults = false;
        temp = root.getElementsByTagName(LOC_RELATIVE_TO_RESULTS);
        if (temp.getLength() > 0) {
            this.locRelativeToResults = Boolean.parseBoolean(XmlUtil.getAllChildText((Element)temp.item(0)));
        }
        this.name = null;
        temp = root.getElementsByTagName(NAME);
        if (temp.getLength() > 0) {
            this.name = XmlUtil.getAllChildText((Element)temp.item(0));
        }
    }

    public void setLocationRelativeToResultsOutput(boolean relative) {
        this.locRelativeToResults = relative;
    }

    public void setOnlyIfInResults(boolean only) {
        this.onlyIfInResults = only;
    }

    @Override
    public void write(Document doc, Element parent) {
        Element temp = doc.createElement(ROOT_ELEM_NAME);
        if (this.getType() != null) {
            temp.setAttribute(TYPE, this.getType());
        }
        temp.setAttribute(ONLY_IF_IN_RESULTS, Boolean.toString(this.getOnlyIfInResults()));
        Element childNode = doc.createElement(DESC);
        if (this.getDescription() != null) {
            childNode.appendChild(doc.createCDATASection(this.getDescription()));
        }
        temp.appendChild(childNode);
        childNode = doc.createElement(LOC_RELATIVE_TO_RESULTS);
        String str = Boolean.toString(this.isLocationRelativeToResultsOutput());
        childNode.appendChild(doc.createTextNode(str));
        temp.appendChild(childNode);
        childNode = doc.createElement(NAME);
        if (this.getName() != null) {
            childNode.appendChild(doc.createCDATASection(this.getName()));
        }
        temp.appendChild(childNode);
        parent.appendChild(temp);
    }
}

