/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.results;

import com.sas.dpro.common.DProEnvironment;
import com.sas.dpro.common.DProUtil;
import com.sas.dpro.common.FileContents;
import com.sas.dpro.common.FileContentsFactory;
import com.sas.dpro.contract.messages.ResultsMessage;
import com.sas.dpro.results.FormattedResults;
import com.sas.dpro.results.FormattedResultsImpl;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeSet;
import java.util.zip.CRC32;

public class FormattedResultsSupport {
    private Map formattedResults;
    private final DateFormat format = new SimpleDateFormat("yyyyMMdd");
    private static final String MSG = "com.sas.dpro.results.FormattedResultsSupport";
    private static ResourceBundle errorMsg;
    private static final String PROPERTY_DEBUG_RESULTS = "com.sas.dpro.results.FormattedResultsSupport.debug";
    public static final String OUTPUT_FILE_DIR_NAME = "outputFiles";

    public FormattedResultsSupport() {
        this.formattedResults = new HashMap();
    }

    public synchronized void addToFormattedResults(ResultsMessage rm) throws IllegalArgumentException {
        ResultsMessage.OutputFile[] outputFiles;
        long sessionID = rm.getHonorContractContext().getOriginalContractSessionID();
        String resultsID = rm.getResultID();
        this.debugResultsMessage("addToFormattedResults: Adding to session " + sessionID + "'s results with ID " + resultsID);
        FormattedResults fr = this.getFormattedResultsByID(sessionID, resultsID);
        this.debugResultsMessage("... Have results already ended? - " + fr.getHasCompleted());
        this.ensureNotEnded(fr);
        String xml = rm.getResultXML();
        if (xml != null) {
            this.debugResultsMessage("... xml!=null, so appending it...");
            xml = this.getXMLContent(rm.getResultXML());
            fr.append(xml);
        }
        int outputFileCount = (outputFiles = rm.getOutputFiles()) == null ? 0 : outputFiles.length;
        this.debugResultsMessage("... output file count: " + outputFileCount);
        if (outputFileCount > 0) {
            File rootdir = this.getOutputFilesDirectory(fr);
            this.debugResultsMessage("... output file dir: " + rootdir.getAbsolutePath());
            for (int i = 0; i < outputFileCount; ++i) {
                ResultsMessage.OutputFile of = outputFiles[i];
                FileContents fc = of.getContents();
                File toFile = new File(rootdir, of.getName());
                String path = toFile.getAbsolutePath();
                this.debugResultsMessage("... ... saving output file " + (i + 1) + ": " + path);
                try {
                    this.putFileLocal(toFile, fc);
                    continue;
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private String createDateBasedDirName(String id) {
        return this.format.format(new Date());
    }

    private static final String createFRMapKey(long sessionID, String resultsID) {
        return "" + sessionID + '_' + resultsID;
    }

    protected File createResultsFile(String id, String resultsType) {
        String rootDir = DProEnvironment.getResultsDirectory();
        String dirName = this.createDateBasedDirName(id);
        File dir = new File(rootDir, dirName);
        int count = 0;
        String subDirName = id + "_results";
        File tempDir = new File(dir, subDirName);
        while (tempDir.isDirectory()) {
            subDirName = id + "_results_" + ++count;
            tempDir = new File(dir, subDirName);
        }
        File file = new File(tempDir, subDirName + ".xml");
        return file;
    }

    protected void debugResultsMessage(String msg) {
        boolean debugResults = Boolean.getBoolean(PROPERTY_DEBUG_RESULTS);
        if (debugResults) {
            msg = "[DEBUG RESULTS]: " + msg;
            System.err.println(msg);
        }
    }

    public synchronized FormattedResults endFormattedResults(ResultsMessage rm) throws IllegalArgumentException {
        long sessionID = rm.getHonorContractContext().getOriginalContractSessionID();
        String resultsID = rm.getResultID();
        this.debugResultsMessage("endFormattedResults: Ending session " + sessionID + "'s results with ID " + resultsID);
        FormattedResults fr = this.getFormattedResultsByID(sessionID, resultsID);
        this.debugResultsMessage("... Have results already ended? - " + fr.getHasCompleted());
        this.ensureNotEnded(fr);
        StringBuilder sb = new StringBuilder("<params>\n");
        sb.append("\t<param name=\"endTime\">").append(System.currentTimeMillis()).append("</param>");
        sb.append("</params>\n");
        fr.append(sb.toString());
        String xml = rm.getResultXML();
        this.debugResultsMessage("... Extra XML to add: " + xml);
        if (xml != null) {
            fr.append(xml);
        }
        fr.append("</DProResults>");
        fr.end();
        return fr;
    }

    private void ensureNotEnded(FormattedResults results) throws IllegalArgumentException {
        if (results.getHasCompleted()) {
            ResourceBundle msg = FormattedResultsSupport.getErrorBundle();
            String key = "ResultsAlreadyCompleted.fmt.txt";
            String desc = DProUtil.formatString(msg, key, results.getResultsID());
            throw new IllegalArgumentException(desc);
        }
    }

    private static synchronized ResourceBundle getErrorBundle() {
        if (errorMsg == null) {
            errorMsg = ResourceBundle.getBundle(MSG);
        }
        return errorMsg;
    }

    public synchronized FormattedResults getFormattedResultsByID(long sessionID, String resultsID) throws IllegalArgumentException {
        String key = FormattedResultsSupport.createFRMapKey(sessionID, resultsID);
        FormattedResults res = (FormattedResults)this.formattedResults.get(key);
        this.debugResultsMessage("getFormattedResultsByID: Getting results for key: " + key);
        this.debugResultsMessage("... Found: " + res);
        if (res == null) {
            ResourceBundle msg = FormattedResultsSupport.getErrorBundle();
            key = "NoSuchResults.fmt.txt";
            String desc = DProUtil.formatString(msg, key, resultsID);
            throw new IllegalArgumentException(desc);
        }
        return res;
    }

    public synchronized Iterator getFormattedResultsIDIterator() {
        TreeSet ts = new TreeSet(this.formattedResults.keySet());
        return ts.iterator();
    }

    private File getOutputFilesDirectory(FormattedResults fr) {
        return new File(fr.getDirectory(), OUTPUT_FILE_DIR_NAME);
    }

    private String getXMLContent(String xml) {
        int pos = xml.indexOf("<DProFormatterOutput");
        if (pos > -1) {
            int start = xml.indexOf(62, pos + 1) + 1;
            int end = xml.indexOf("</DProFormatterOutput>", start);
            if (end == -1) {
                throw new IllegalArgumentException("No closing formatter output tag: " + xml);
            }
            return xml.substring(start, end);
        }
        return xml;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putFileLocal(File toFile, FileContents contents) throws RemoteException, IOException {
        File parentDir = toFile.getParentFile();
        if (parentDir != null) {
            parentDir.mkdirs();
        }
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(toFile));){
            if (contents.isCompressed()) {
                CRC32 crc32 = new CRC32();
                FileContentsFactory.uncompressContents(contents.getContents(), out, crc32);
                if (crc32.getValue() != contents.getUncompressedCRC32()) {
                    String desc = "Error: Incorrect CRC32";
                    throw new IOException(desc);
                }
            } else {
                out.write(contents.getContents());
            }
        }
    }

    public synchronized void startFormattedResults(ResultsMessage rm) throws IOException {
        File outputFileDir;
        long origSessionID = rm.getHonorContractContext().getOriginalContractSessionID();
        String resultsID = rm.getResultID();
        String type = rm.getResultsType();
        String key = FormattedResultsSupport.createFRMapKey(origSessionID, resultsID);
        this.debugResultsMessage("startFormattedResults: Starting results with ID " + resultsID + " for session " + origSessionID);
        this.debugResultsMessage("... key==" + key);
        this.debugResultsMessage("... type==" + type);
        FormattedResults old = (FormattedResults)this.formattedResults.get(key);
        this.debugResultsMessage("... old: " + old);
        if (old != null && !old.getHasCompleted()) {
            this.debugResultsMessage("... ... Old results have not yet completed!");
            ResourceBundle msg = FormattedResultsSupport.getErrorBundle();
            key = "ResultsAlreadyStarted.fmt.txt";
            String desc = DProUtil.formatString(msg, key, resultsID);
            throw new IOException(desc);
        }
        File resultsFile = this.createResultsFile(resultsID, type);
        this.debugResultsMessage("... Creating results file: " + resultsFile.getAbsolutePath());
        File dir = resultsFile.getParentFile();
        if (!dir.exists()) {
            boolean created = dir.mkdirs();
            if (!created) {
                ResourceBundle msg = FormattedResultsSupport.getErrorBundle();
                key = "CannotCreateDir.fmt.txt";
                String desc = DProUtil.formatString(msg, key, dir.getAbsolutePath());
                throw new IOException(desc);
            }
        } else if (!dir.isDirectory()) {
            ResourceBundle msg = FormattedResultsSupport.getErrorBundle();
            key = "NotDirectory.fmt.txt";
            String desc = DProUtil.formatString(msg, key, dir.getAbsolutePath());
            throw new IOException(desc);
        }
        if (!(outputFileDir = new File(dir, OUTPUT_FILE_DIR_NAME)).mkdir()) {
            ResourceBundle msg = FormattedResultsSupport.getErrorBundle();
            key = "CannotCreateDir.fmt.txt";
            String desc = DProUtil.formatString(msg, key, outputFileDir.getAbsolutePath());
            throw new IOException(desc);
        }
        FormattedResultsImpl fr = new FormattedResultsImpl(resultsID, resultsFile);
        this.formattedResults.put(key, fr);
        fr.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
        fr.append("<DProResults version=\"1.0\" type=\"" + type + "\">");
        StringBuilder sb = new StringBuilder("<params>\n");
        sb.append("\t<param name=\"startTime\">").append(System.currentTimeMillis()).append("</param>\n");
        sb.append("</params>\n");
        fr.append(sb.toString());
        String xml = rm.getResultXML();
        if (xml != null) {
            fr.append(xml);
        }
    }
}

