/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.reporting;

import com.sas.dpro.common.DProEnvironment;
import com.sas.dpro.reporting.AbstractReportMaker;
import com.sas.dpro.reporting.GroovyScriptReportAdapter;
import com.sas.dpro.reporting.ReportMaker;
import com.sas.dpro.reporting.processflow.ProcessFlowTextReportMaker;
import com.sas.dpro.reporting.testing.ReportMakerFileParser;
import com.sas.dpro.reporting.testing.TestingHtmlReportMaker;
import com.sas.dpro.reporting.testing.TestingTextReportMaker;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

public class ReportMakerFactory {
    private Map resultsTypeMap = new HashMap();
    private static ReportMakerFactory INSTANCE;

    protected ReportMakerFactory() {
    }

    public void addGroovyBasedReportMaker(String resultsType, String reportType, File groovyScript, Charset cs) {
        GroovyScriptReportAdapter adapter = new GroovyScriptReportAdapter(reportType, groovyScript, cs);
        HashMap<String, GroovyScriptReportAdapter> reportTypetoReportMakerMap = (HashMap<String, GroovyScriptReportAdapter>)this.resultsTypeMap.get(resultsType);
        if (reportTypetoReportMakerMap == null) {
            reportTypetoReportMakerMap = new HashMap<String, GroovyScriptReportAdapter>();
            this.resultsTypeMap.put(resultsType, reportTypetoReportMakerMap);
        }
        reportTypetoReportMakerMap.put(reportType, adapter);
    }

    public static synchronized ReportMakerFactory getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ReportMakerFactory();
            INSTANCE.loadDefaultReportMakers();
            INSTANCE.loadCustomReportMakers();
        }
        return INSTANCE;
    }

    public ReportMaker getReportMaker(String resultsType, String reportType) {
        ReportMaker rm = null;
        Map resultTypeToMakerMap = (Map)this.resultsTypeMap.get(resultsType);
        if (resultTypeToMakerMap != null) {
            rm = (ReportMaker)resultTypeToMakerMap.get(reportType);
        }
        return rm;
    }

    protected void loadCustomReportMakers() {
        String[] files = DProEnvironment.getReportMakersFiles();
        for (int i = 0; i < files.length; ++i) {
            try {
                ReportMakerFileParser.parse(files[i]);
                continue;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    protected void loadDefaultReportMakers() {
        HashMap<String, ProcessFlowTextReportMaker> processFlowMap = new HashMap<String, ProcessFlowTextReportMaker>();
        this.resultsTypeMap.put("processFlow", processFlowMap);
        AbstractReportMaker rm = new ProcessFlowTextReportMaker();
        processFlowMap.put(rm.getReportType(), (ProcessFlowTextReportMaker)rm);
        HashMap<String, AbstractReportMaker> testingMap = new HashMap<String, AbstractReportMaker>();
        this.resultsTypeMap.put("tests", testingMap);
        rm = new TestingTextReportMaker();
        testingMap.put(rm.getReportType(), rm);
        rm = new TestingHtmlReportMaker();
        testingMap.put(rm.getReportType(), rm);
    }
}

