/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.reporting;

import com.sas.dpro.reporting.ReportInfo;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Properties;

public class ReportInfoImpl
implements ReportInfo {
    private String reportID;
    private String reportType;
    private Charset reportFileEncoding;
    private File dir;

    public ReportInfoImpl(String reportID, File dir) {
        this.setReportID(reportID);
        this.setDirectory(dir);
    }

    @Override
    public File getDirectory() {
        return this.dir;
    }

    @Override
    public Charset getReportFileEncoding() {
        return this.reportFileEncoding;
    }

    @Override
    public String getReportID() {
        return this.reportID;
    }

    @Override
    public String getReportType() {
        return this.reportType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReportInfoImpl load(String reportID, File dir) throws IOException {
        Properties props = null;
        File f = new File(dir, ".dproReport");
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(f));){
            props = new Properties();
            props.load(in);
        }
        String reportType = props.getProperty("ReportType");
        String encStr = props.getProperty("ReportFileEncoding");
        Charset cs = null;
        try {
            cs = Charset.forName(encStr);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        ReportInfoImpl ri = new ReportInfoImpl(reportID, dir);
        ri.setReportFileEncoding(cs);
        ri.setReportType(reportType);
        return ri;
    }

    public void setDirectory(File dir) {
        if (dir == null) {
            throw new NullPointerException("dir cannot be null");
        }
        this.dir = dir;
    }

    public void setReportFileEncoding(Charset encoding) {
        this.reportFileEncoding = encoding;
    }

    public void setReportID(String reportID) {
        if (reportID == null) {
            throw new NullPointerException("reportID cannot be null");
        }
        this.reportID = reportID;
    }

    public void setReportType(String type) {
        this.reportType = type;
    }

    public String toString() {
        String enc = this.reportFileEncoding == null ? "default" : this.reportFileEncoding.name();
        return "[ReportInfoImpl: reportID=" + this.getReportID() + "; fileEncoding=" + enc + "; reportType=" + this.getReportType() + "; dir=" + this.getDirectory() + "]";
    }
}

