/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.reporting;

import com.sas.dpro.common.DProUtil;
import com.sas.dpro.reporting.AbstractReportMaker;
import com.sas.dpro.reporting.ReportMakerResults;
import com.sas.dpro.reporting.ReportMakerResultsImpl;
import com.sas.dpro.results.FormattedResults;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;

public class GroovyScriptReportAdapter
extends AbstractReportMaker {
    private String reportType;
    private File groovyScript;
    private Charset groovyScriptCS;

    public GroovyScriptReportAdapter(String reportType, File groovyScript, Charset cs) {
        this.reportType = reportType;
        this.groovyScript = groovyScript;
        this.groovyScriptCS = cs;
    }

    @Override
    public ReportMakerResults createReport(FormattedResults results, File reportDir, Charset cs) throws IOException {
        this.debugPrint("GroovyScriptReportAdapter.createReport(): Entering");
        this.debugPrint("... Original report encoding: " + (cs == null ? "null" : cs.displayName()));
        cs = this.ensureValidCharset(cs);
        this.debugPrint("... Report encoding: " + cs.displayName());
        this.debugPrint("... Creating metadata file");
        this.createReportMetadataFile(reportDir, results, cs);
        this.debugPrint("... Setting up GroovyShell");
        Binding binding = new Binding();
        binding.setVariable("results", (Object)results);
        binding.setVariable("reportDir", (Object)reportDir);
        binding.setVariable("cs", (Object)cs);
        GroovyShell shell = new GroovyShell(binding);
        Object output = null;
        this.debugPrint("... Running Groovy report maker: " + this.groovyScript.getAbsolutePath());
        String groovy = DProUtil.getLocalFileContents(this.groovyScript, this.groovyScriptCS);
        output = shell.evaluate(groovy, this.groovyScript.getName());
        this.debugPrint("GroovyScriptReportAdapter.createReport(): Exiting");
        ReportMakerResults rmr = null;
        if (output instanceof ReportMakerResults) {
            rmr = (ReportMakerResults)output;
        } else {
            ReportMakerResultsImpl res = new ReportMakerResultsImpl(reportDir, this.getReportType());
            res.setDescribedResultsID(results.getResultsID());
            rmr = res;
        }
        return rmr;
    }

    @Override
    public String getReportType() {
        return this.reportType;
    }
}

