/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.reporting;

import com.sas.dpro.common.DProUtil;
import com.sas.dpro.provider.ProviderFactory;
import com.sas.dpro.reporting.ReportMaker;
import com.sas.dpro.results.FormattedResults;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

public abstract class AbstractReportMaker
implements ReportMaker {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createReportMetadataFile(File reportDir, FormattedResults results, Charset cs) throws IOException {
        File f = new File(reportDir, ".dproReport");
        Properties props = new Properties();
        props.setProperty("FileVersion", "1");
        props.setProperty("DateCreated", new SimpleDateFormat().format(new Date()));
        props.setProperty("ReportType", this.getReportType());
        props.setProperty("DProServer", ProviderFactory.getLocalProviderName());
        props.setProperty("DProVersion", DProUtil.getLocalDPROVersion());
        props.setProperty("ReportFileEncoding", cs.name());
        props.setProperty("ResultsFile", results.getFile().getAbsolutePath());
        String comments = "Metadata information about this DPRO report.  Do not edit.";
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(f));){
            props.store(out, comments);
        }
    }

    protected void debugPrint(String text) {
        if (Boolean.getBoolean("com.sas.dpro.reporting.ReportMaker.debug")) {
            text = "[DEBUG ReportMaker]: " + text;
            System.err.println(text);
        }
    }

    protected Charset ensureValidCharset(Charset cs) {
        if (cs == null) {
            cs = Charset.forName("UTF-8");
        }
        return cs;
    }

    public float millisToSeconds(long ms) {
        return Math.max((float)ms / 1000.0f, 0.0f);
    }
}

