/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.formatter.standard;

import com.sas.dpro.common.ContainerContext;
import com.sas.dpro.common.DProUtil;
import com.sas.dpro.common.FileListImpl;
import com.sas.dpro.common.ServiceFailedException;
import com.sas.dpro.formatter.FormatterWriter;
import com.sas.dpro.formatter.XmlFormatterWritable;
import com.sas.dpro.formatter.standard.DefaultResultsFormatter;
import com.sas.dpro.service.Service;
import com.sas.dpro.service.standard.Xslt;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.w3c.dom.Document;

public class XSLTResultsFormatter
extends DefaultResultsFormatter {
    public static final String PARAM_INPUT_FILE = "inputFile";
    public static final String PARAM_OUTPUT_FILE = "outputFile";
    public static final String PARAM_XSLT_FILE = "xsltFile";
    private static final String MSG = "com.sas.dpro.formatter.standard.XSLTResultsFormatter";
    private static final ResourceBundle msg = ResourceBundle.getBundle("com.sas.dpro.formatter.standard.XSLTResultsFormatter");

    private void checkForNull(String param, String paramName) throws ServiceFailedException {
        if (param == null) {
            String desc = msg.getString("Error.ParamNotSpecified.fmt.txt");
            desc = MessageFormat.format(desc, paramName);
            throw new ServiceFailedException(desc);
        }
    }

    @Override
    protected FileListImpl doFormatImpl(Service service, ContainerContext container, ContainerContext toFormat, String[] filesToFormat, List fcsToFormat, FormatterWriter writer, Map parameters) throws ServiceFailedException {
        String text;
        String inputFile = (String)parameters.get(PARAM_INPUT_FILE);
        String xsltFile = (String)parameters.get(PARAM_XSLT_FILE);
        String outputFile = (String)parameters.get(PARAM_OUTPUT_FILE);
        this.checkForNull(inputFile, PARAM_INPUT_FILE);
        this.checkForNull(xsltFile, PARAM_XSLT_FILE);
        this.checkForNull(outputFile, PARAM_OUTPUT_FILE);
        ArrayList<String> paramList = new ArrayList<String>();
        for (Map.Entry entry : parameters.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (!(value instanceof String) || PARAM_INPUT_FILE.equals(key) || PARAM_XSLT_FILE.equals(key) || PARAM_OUTPUT_FILE.equals(key)) continue;
            paramList.add(key);
            paramList.add((String)value);
        }
        String[] paramArray = null;
        if (!paramList.isEmpty()) {
            paramArray = new String[paramList.size()];
            paramArray = paramList.toArray(paramArray);
        }
        Xslt.transform(container, inputFile, xsltFile, outputFile, paramArray);
        InputStream in = null;
        try {
            in = DProUtil.getFileContents(container, outputFile);
        }
        catch (Exception e) {
            text = e.getMessage();
            if (text == null) {
                text = e.toString();
            }
            String desc = DProUtil.formatString(msg, "Error.GettingFile.fmt.txt", text);
            throw new ServiceFailedException(desc, e);
        }
        try {
            Document doc = DProUtil.streamToXMLDoc(in);
            XmlFormatterWritable writable = new XmlFormatterWritable("OQResults", doc.getDocumentElement());
            writable.setWriteRootNode(false);
            writer.write(writable);
        }
        catch (Exception e) {
            text = e.getMessage();
            if (text == null) {
                text = e.toString();
            }
            String desc = DProUtil.formatString(msg, "Error.ParsingXML.fmt.txt", text);
            throw new ServiceFailedException(desc, e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        FileListImpl fileList = new FileListImpl(container.getDirectory(), container.getProviderName(), null);
        fileList.add(outputFile);
        return fileList;
    }
}

